/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.registry.otlp;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.validate.PropertyValidator;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.validate.Validated;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.push.PushRegistryConfig;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.AggregationTemporality;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public interface OtlpConfig
extends PushRegistryConfig {
    public static final OtlpConfig DEFAULT = string -> null;

    @Override
    default public String prefix() {
        return "otlp";
    }

    default public String url() {
        return PropertyValidator.getUrlString(this, "url").orElse("http://localhost:4318/v1/metrics");
    }

    default public Map<String, String> resourceAttributes() {
        Map<String, String> map = System.getenv();
        String string2 = PropertyValidator.getString(this, "resourceAttributes").orElse(map.get("OTEL_RESOURCE_ATTRIBUTES"));
        String[] stringArray = string2 == null ? new String[]{} : string2.trim().split(",");
        Map<String, String> map2 = Arrays.stream(stringArray).map(String::trim).filter(string -> string.length() > 2 && string.indexOf(61) > 0).collect(Collectors.toMap(string -> string.substring(0, string.indexOf(61)).trim(), string -> string.substring(string.indexOf(61) + 1).trim()));
        if (map.containsKey("OTEL_SERVICE_NAME") && !map2.containsKey("service.name")) {
            map2.put("service.name", map.get("OTEL_SERVICE_NAME"));
        }
        return map2;
    }

    default public AggregationTemporality aggregationTemporality() {
        return PropertyValidator.getEnum(this, AggregationTemporality.class, "aggregationTemporality").orElse(AggregationTemporality.CUMULATIVE);
    }

    default public Map<String, String> headers() {
        String[] stringArray;
        String string3 = PropertyValidator.getString(this, "headers").orElse(null);
        if (string3 == null) {
            stringArray = System.getenv();
            string3 = stringArray.getOrDefault("OTEL_EXPORTER_OTLP_HEADERS", (String)"").trim();
            String string4 = stringArray.getOrDefault("OTEL_EXPORTER_OTLP_METRICS_HEADERS", "").trim();
            string3 = Objects.equals(string3, "") ? string4 : string3 + "," + string4;
        }
        stringArray = Objects.equals(string3, "") ? new String[]{} : string3.split(",");
        return Arrays.stream(stringArray).map(String::trim).filter(string -> string.length() > 2 && string.indexOf(61) > 0).collect(Collectors.toMap(string -> string.substring(0, string.indexOf(61)).trim(), string -> string.substring(string.indexOf(61) + 1).trim(), (string, string2) -> string2));
    }

    @Override
    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll(this, otlpConfig -> PushRegistryConfig.validate(otlpConfig), MeterRegistryConfigValidator.checkRequired("url", OtlpConfig::url), MeterRegistryConfigValidator.check("resourceAttributes", OtlpConfig::resourceAttributes), MeterRegistryConfigValidator.check("aggregationTemporality", OtlpConfig::aggregationTemporality));
    }
}

