/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.registry.otlp;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.config.NamingConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.CountAtBucket;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSupport;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.NoopHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.TimeWindowPercentileHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.ValueAtPercentile;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.push.PushMeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepFunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepFunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.MeterPartition;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.NamedThreadFactory;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import com.contrastsecurity.thirdparty.io.micrometer.core.ipc.http.HttpSender;
import com.contrastsecurity.thirdparty.io.micrometer.core.ipc.http.HttpUrlConnectionSender;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.AggregationTemporality;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpConfig;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpCumulativeCounter;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpCumulativeDistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpCumulativeFunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpCumulativeFunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpCumulativeLongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpCumulativeTimer;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpStepBucketHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpStepDistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpStepTimer;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.StartTimeAwareMeter;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.common.v1.AnyValue;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.common.v1.KeyValue;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.Gauge;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.Histogram;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.HistogramDataPoint;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.Metric;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.Sum;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.Summary;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.resource.v1.Resource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

public class OtlpMeterRegistry
extends PushMeterRegistry {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new NamedThreadFactory("otlp-metrics-publisher");
    private final InternalLogger logger = InternalLoggerFactory.getInstance(OtlpMeterRegistry.class);
    private final OtlpConfig config;
    private final HttpSender httpSender;
    private final Resource resource;
    private final com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.AggregationTemporality otlpAggregationTemporality;
    private long deltaAggregationTimeUnixNano = 0L;
    @Nullable
    private ScheduledExecutorService meterPollingService;

    public OtlpMeterRegistry() {
        this(OtlpConfig.DEFAULT, Clock.SYSTEM);
    }

    public OtlpMeterRegistry(OtlpConfig otlpConfig, Clock clock) {
        this(otlpConfig, clock, new HttpUrlConnectionSender());
    }

    private OtlpMeterRegistry(OtlpConfig otlpConfig, Clock clock, HttpSender httpSender) {
        super(otlpConfig, clock);
        this.config = otlpConfig;
        this.httpSender = httpSender;
        this.resource = Resource.newBuilder().addAllAttributes(this.getResourceAttributes()).build();
        this.otlpAggregationTemporality = AggregationTemporality.toOtlpAggregationTemporality(otlpConfig.aggregationTemporality());
        this.setDeltaAggregationTimeUnixNano();
        this.config().namingConvention(NamingConvention.dot);
        this.start(DEFAULT_THREAD_FACTORY);
    }

    @Override
    public void start(ThreadFactory threadFactory) {
        super.start(threadFactory);
        if (this.config.enabled() && this.isDelta()) {
            this.meterPollingService = Executors.newSingleThreadScheduledExecutor(threadFactory);
            this.meterPollingService.scheduleAtFixedRate(this::pollMetersToRollover, this.getInitialDelay(), this.config.step().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.meterPollingService != null) {
            this.meterPollingService.shutdown();
        }
    }

    @Override
    protected void publish() {
        if (this.isDelta()) {
            this.setDeltaAggregationTimeUnixNano();
        }
        for (List<Meter> list : MeterPartition.partition(this, this.config.batchSize())) {
            List list2 = list.stream().map(meter -> meter.match(this::writeGauge, this::writeCounter, this::writeHistogramSupport, this::writeHistogramSupport, this::writeHistogramSupport, this::writeGauge, this::writeFunctionCounter, this::writeFunctionTimer, this::writeMeter)).collect(Collectors.toList());
            try {
                ExportMetricsServiceRequest exportMetricsServiceRequest = ExportMetricsServiceRequest.newBuilder().addResourceMetrics(ResourceMetrics.newBuilder().setResource(this.resource).addScopeMetrics(ScopeMetrics.newBuilder().addAllMetrics(list2).build()).build()).build();
                HttpSender.Request.Builder builder = this.httpSender.post(this.config.url()).withContent("application/x-protobuf", exportMetricsServiceRequest.toByteArray());
                this.config.headers().forEach(builder::withHeader);
                builder.send();
            }
            catch (Throwable throwable) {
                this.logger.warn("Failed to publish metrics to OTLP receiver", throwable);
            }
        }
    }

    @Override
    protected <T> com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge newGauge(Meter.Id id, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
        return new DefaultGauge<T>(id, t2, toDoubleFunction);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        return this.isCumulative() ? new OtlpCumulativeCounter(id, this.clock) : new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return this.isCumulative() ? new OtlpCumulativeTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit()) : new OtlpStepTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis());
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double d2) {
        return this.isCumulative() ? new OtlpCumulativeDistributionSummary(id, this.clock, distributionStatisticConfig, d2, true) : new OtlpStepDistributionSummary(id, this.clock, distributionStatisticConfig, d2, this.config.step().toMillis());
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> iterable) {
        return new DefaultMeter(id, type, iterable);
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit) {
        return this.isCumulative() ? new OtlpCumulativeFunctionTimer<T>(id, t2, toLongFunction, toDoubleFunction, timeUnit, this.getBaseTimeUnit(), this.clock) : new StepFunctionTimer<T>(id, this.clock, this.config.step().toMillis(), t2, toLongFunction, toDoubleFunction, timeUnit, this.getBaseTimeUnit());
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T t2, ToDoubleFunction<T> toDoubleFunction) {
        return this.isCumulative() ? new OtlpCumulativeFunctionCounter<T>(id, t2, toDoubleFunction, this.clock) : new StepFunctionCounter<T>(id, this.clock, this.config.step().toMillis(), t2, toDoubleFunction);
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        return this.isCumulative() ? new OtlpCumulativeLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig) : new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    @Override
    public void close() {
        this.stop();
        if (!this.isPublishing() && this.isDelta()) {
            this.getMeters().forEach(this::closingRollover);
        }
        super.close();
    }

    private void closingRollover(Meter meter) {
        if (meter instanceof StepCounter) {
            ((StepCounter)meter)._closingRollover();
        }
        if (meter instanceof StepFunctionCounter) {
            ((StepFunctionCounter)meter)._closingRollover();
        }
        if (meter instanceof StepFunctionTimer) {
            ((StepFunctionTimer)meter)._closingRollover();
        }
        if (meter instanceof OtlpStepTimer) {
            ((OtlpStepTimer)meter)._closingRollover();
        }
        if (meter instanceof OtlpStepDistributionSummary) {
            ((OtlpStepDistributionSummary)meter)._closingRollover();
        }
    }

    Metric writeMeter(Meter meter) {
        return this.getMetricBuilder(meter.getId()).build();
    }

    Metric writeGauge(com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge gauge) {
        return this.getMetricBuilder(gauge.getId()).setGauge(Gauge.newBuilder().addDataPoints(NumberDataPoint.newBuilder().setTimeUnixNano(this.getTimeUnixNano()).setAsDouble(gauge.value()).addAllAttributes(this.getTagsForId(gauge.getId())).build())).build();
    }

    Metric writeCounter(Counter counter) {
        return this.writeSum(counter, counter::count);
    }

    Metric writeFunctionCounter(FunctionCounter functionCounter) {
        return this.writeSum(functionCounter, functionCounter::count);
    }

    private Metric writeSum(Meter meter, DoubleSupplier doubleSupplier) {
        return this.getMetricBuilder(meter.getId()).setSum(Sum.newBuilder().addDataPoints(NumberDataPoint.newBuilder().setStartTimeUnixNano(this.getStartTimeNanos(meter)).setTimeUnixNano(this.getTimeUnixNano()).setAsDouble(doubleSupplier.getAsDouble()).addAllAttributes(this.getTagsForId(meter.getId())).build()).setIsMonotonic(true).setAggregationTemporality(this.otlpAggregationTemporality).build()).build();
    }

    void pollMetersToRollover() {
        this.getMeters().forEach(meter2 -> meter2.match(gauge -> null, Counter::count, HistogramSupport::takeSnapshot, HistogramSupport::takeSnapshot, longTaskTimer -> null, timeGauge -> null, FunctionCounter::count, FunctionTimer::count, meter -> null));
    }

    private long getInitialDelay() {
        long l2 = this.config.step().toMillis();
        return l2 - this.clock.wallTime() % l2 + 1L;
    }

    Metric writeHistogramSupport(HistogramSupport histogramSupport) {
        Metric.Builder builder = this.getMetricBuilder(histogramSupport.getId());
        boolean bl2 = histogramSupport instanceof Timer || histogramSupport instanceof LongTaskTimer;
        HistogramSnapshot histogramSnapshot = histogramSupport.takeSnapshot();
        Iterable<? extends KeyValue> iterable = this.getTagsForId(histogramSupport.getId());
        long l2 = this.getStartTimeNanos(histogramSupport);
        double d2 = bl2 ? histogramSnapshot.total(this.getBaseTimeUnit()) : histogramSnapshot.total();
        long l3 = histogramSnapshot.count();
        if (histogramSnapshot.percentileValues().length != 0) {
            SummaryDataPoint.Builder builder2 = SummaryDataPoint.newBuilder().addAllAttributes(iterable).setStartTimeUnixNano(l2).setTimeUnixNano(this.getTimeUnixNano()).setSum(d2).setCount(l3);
            for (ValueAtPercentile valueAtPercentile : histogramSnapshot.percentileValues()) {
                builder2.addQuantileValues(SummaryDataPoint.ValueAtQuantile.newBuilder().setQuantile(valueAtPercentile.percentile()).setValue(TimeUtils.convert(valueAtPercentile.value(), TimeUnit.NANOSECONDS, this.getBaseTimeUnit())));
            }
            builder.setSummary(Summary.newBuilder().addDataPoints(builder2));
            return builder.build();
        }
        HistogramDataPoint.Builder builder3 = HistogramDataPoint.newBuilder().addAllAttributes(iterable).setStartTimeUnixNano(l2).setTimeUnixNano(this.getTimeUnixNano()).setSum(d2).setCount(l3);
        if (this.isDelta()) {
            builder3.setMax(bl2 ? histogramSnapshot.max(this.getBaseTimeUnit()) : histogramSnapshot.max());
        }
        if (histogramSnapshot.histogramCounts().length != 0) {
            for (CountAtBucket countAtBucket : histogramSnapshot.histogramCounts()) {
                builder3.addExplicitBounds(bl2 ? countAtBucket.bucket(this.getBaseTimeUnit()) : countAtBucket.bucket());
                builder3.addBucketCounts((long)countAtBucket.count());
            }
            builder.setHistogram(Histogram.newBuilder().setAggregationTemporality(this.otlpAggregationTemporality).addDataPoints(builder3));
            return builder.build();
        }
        return builder.setHistogram(Histogram.newBuilder().setAggregationTemporality(this.otlpAggregationTemporality).addDataPoints(builder3)).build();
    }

    Metric writeFunctionTimer(FunctionTimer functionTimer) {
        return this.getMetricBuilder(functionTimer.getId()).setHistogram(Histogram.newBuilder().addDataPoints(HistogramDataPoint.newBuilder().addAllAttributes(this.getTagsForId(functionTimer.getId())).setStartTimeUnixNano(this.getStartTimeNanos(functionTimer)).setTimeUnixNano(this.getTimeUnixNano()).setSum(functionTimer.totalTime(this.getBaseTimeUnit())).setCount((long)functionTimer.count())).setAggregationTemporality(this.otlpAggregationTemporality)).build();
    }

    private boolean isCumulative() {
        return this.otlpAggregationTemporality == com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE;
    }

    private boolean isDelta() {
        return this.otlpAggregationTemporality == com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA;
    }

    void setDeltaAggregationTimeUnixNano() {
        this.deltaAggregationTimeUnixNano = this.clock.wallTime() / this.config.step().toMillis() * this.config.step().toNanos();
    }

    private long getTimeUnixNano() {
        return this.isCumulative() ? TimeUnit.MILLISECONDS.toNanos(this.clock.wallTime()) : this.deltaAggregationTimeUnixNano;
    }

    private long getStartTimeNanos(Meter meter) {
        return this.isCumulative() ? ((StartTimeAwareMeter)meter).getStartTimeNanos() : this.deltaAggregationTimeUnixNano - this.config.step().toNanos();
    }

    private Metric.Builder getMetricBuilder(Meter.Id id) {
        Metric.Builder builder = Metric.newBuilder().setName(this.getConventionName(id));
        if (id.getBaseUnit() != null) {
            builder.setUnit(id.getBaseUnit());
        }
        if (id.getDescription() != null) {
            builder.setDescription(id.getDescription());
        }
        return builder;
    }

    private Iterable<? extends KeyValue> getTagsForId(Meter.Id id) {
        return id.getTags().stream().map(tag -> OtlpMeterRegistry.createKeyValue(tag.getKey(), tag.getValue())).collect(Collectors.toList());
    }

    static KeyValue createKeyValue(String string, String string2) {
        return KeyValue.newBuilder().setKey(string).setValue(AnyValue.newBuilder().setStringValue(string2)).build();
    }

    Iterable<KeyValue> getResourceAttributes() {
        boolean bl2 = false;
        ArrayList<KeyValue> arrayList = new ArrayList<KeyValue>();
        arrayList.add(OtlpMeterRegistry.createKeyValue("telemetry.sdk.name", "com.contrastsecurity.thirdparty.io.micrometer"));
        arrayList.add(OtlpMeterRegistry.createKeyValue("telemetry.sdk.language", "java"));
        String string = MeterRegistry.class.getPackage().getImplementationVersion();
        if (string != null) {
            arrayList.add(OtlpMeterRegistry.createKeyValue("telemetry.sdk.version", string));
        }
        for (Map.Entry<String, String> entry : this.config.resourceAttributes().entrySet()) {
            if ("service.name".equals(entry.getKey())) {
                bl2 = true;
            }
            arrayList.add(OtlpMeterRegistry.createKeyValue(entry.getKey(), entry.getValue()));
        }
        if (!bl2) {
            arrayList.add(OtlpMeterRegistry.createKeyValue("service.name", "unknown_service"));
        }
        return arrayList;
    }

    static com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.Histogram getHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, AggregationTemporality aggregationTemporality) {
        return OtlpMeterRegistry.getHistogram(clock, distributionStatisticConfig, aggregationTemporality, 0L);
    }

    static com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.Histogram getHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, AggregationTemporality aggregationTemporality, long l2) {
        if (distributionStatisticConfig.isPublishingHistogram()) {
            if (AggregationTemporality.isCumulative(aggregationTemporality)) {
                return new TimeWindowFixedBoundaryHistogram(clock, DistributionStatisticConfig.builder().expiry(Duration.ofDays(1825L)).percentiles(new double[0]).bufferLength(1).build().merge(distributionStatisticConfig), true, false);
            }
            if (AggregationTemporality.isDelta(aggregationTemporality) && l2 > 0L) {
                return new OtlpStepBucketHistogram(clock, l2, distributionStatisticConfig, true, false);
            }
        }
        if (distributionStatisticConfig.isPublishingPercentiles()) {
            return new TimeWindowPercentileHistogram(clock, distributionStatisticConfig, false);
        }
        return NoopHistogram.INSTANCE;
    }
}

