/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.registry.otlp;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.AggregationTemporality;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpMeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpStepBucketHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.OtlpStepTuple2;
import com.contrastsecurity.thirdparty.io.micrometer.registry.otlp.StepMax;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

class OtlpStepTimer
extends AbstractTimer {
    private final LongAdder count = new LongAdder();
    private final LongAdder total = new LongAdder();
    private final OtlpStepTuple2<Long, Long> countTotal;
    private final StepMax max;

    public OtlpStepTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit timeUnit, long l2) {
        super(id, clock, pauseDetector, timeUnit, OtlpMeterRegistry.getHistogram(clock, distributionStatisticConfig, AggregationTemporality.DELTA, l2));
        this.countTotal = new OtlpStepTuple2<Long, Long>(clock, l2, 0L, 0L, this.count::sumThenReset, this.total::sumThenReset);
        this.max = new StepMax(clock, l2);
    }

    @Override
    protected void recordNonNegative(long l2, TimeUnit timeUnit) {
        long l3 = (long)TimeUtils.convert(l2, timeUnit, TimeUnit.NANOSECONDS);
        this.count.add(1L);
        this.total.add(l3);
        this.max.record(l3);
    }

    @Override
    public long count() {
        return (Long)this.countTotal.poll1();
    }

    @Override
    public double totalTime(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit(((Long)this.countTotal.poll2()).longValue(), timeUnit);
    }

    @Override
    public double max(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit((Double)this.max.poll(), timeUnit);
    }

    void _closingRollover() {
        this.countTotal._closingRollover();
        this.max._closingRollover();
        if (this.histogram instanceof OtlpStepBucketHistogram) {
            ((OtlpStepBucketHistogram)this.histogram)._closingRollover();
        }
    }
}

