/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.propagation;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.Baggage;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.BaggageBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.BaggageEntry;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.propagation.Parser;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.PercentEscaper;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.StringUtils;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapGetter;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapPropagator;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class W3CBaggagePropagator
implements TextMapPropagator {
    private static final String FIELD = "baggage";
    private static final List<String> FIELDS = Collections.singletonList("baggage");
    private static final W3CBaggagePropagator INSTANCE = new W3CBaggagePropagator();
    private static final PercentEscaper URL_ESCAPER = PercentEscaper.create();

    public static W3CBaggagePropagator getInstance() {
        return INSTANCE;
    }

    private W3CBaggagePropagator() {
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(Context context, @Nullable C c2, TextMapSetter<C> textMapSetter) {
        if (context == null || textMapSetter == null) {
            return;
        }
        Baggage baggage = Baggage.fromContext(context);
        if (baggage.isEmpty()) {
            return;
        }
        String string = W3CBaggagePropagator.baggageToString(baggage);
        if (!string.isEmpty()) {
            textMapSetter.set(c2, FIELD, string);
        }
    }

    private static String baggageToString(Baggage baggage) {
        StringBuilder stringBuilder = new StringBuilder();
        baggage.forEach((string, baggageEntry) -> {
            if (W3CBaggagePropagator.baggageIsInvalid(string, baggageEntry)) {
                return;
            }
            stringBuilder.append((String)string).append("=").append(W3CBaggagePropagator.encodeValue(baggageEntry.getValue()));
            String string2 = baggageEntry.getMetadata().getValue();
            if (string2 != null && !string2.isEmpty()) {
                stringBuilder.append(";").append(W3CBaggagePropagator.encodeValue(string2));
            }
            stringBuilder.append(",");
        });
        if (stringBuilder.length() == 0) {
            return "";
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static String encodeValue(String string) {
        return URL_ESCAPER.escape(string);
    }

    @Override
    public <C> Context extract(Context context, @Nullable C c2, TextMapGetter<C> textMapGetter) {
        if (context == null) {
            return Context.root();
        }
        if (textMapGetter == null) {
            return context;
        }
        String string = textMapGetter.get(c2, FIELD);
        if (string == null) {
            return context;
        }
        if (string.isEmpty()) {
            return context;
        }
        BaggageBuilder baggageBuilder = Baggage.builder();
        try {
            W3CBaggagePropagator.extractEntries(string, baggageBuilder);
        }
        catch (RuntimeException runtimeException) {
            return context;
        }
        return context.with(baggageBuilder.build());
    }

    private static void extractEntries(String string, BaggageBuilder baggageBuilder) {
        new Parser(string).parseInto(baggageBuilder);
    }

    private static boolean baggageIsInvalid(String string, BaggageEntry baggageEntry) {
        return !W3CBaggagePropagator.isValidBaggageKey(string) || !W3CBaggagePropagator.isValidBaggageValue(baggageEntry.getValue());
    }

    private static boolean isValidBaggageKey(String string) {
        return string != null && !string.isEmpty() && StringUtils.isPrintableString(string);
    }

    private static boolean isValidBaggageValue(String string) {
        return string != null;
    }

    public String toString() {
        return "W3CBaggagePropagator";
    }
}

