/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jregex;

import com.contrastsecurity.thirdparty.jregex.Block;
import com.contrastsecurity.thirdparty.jregex.CharacterClass;
import com.contrastsecurity.thirdparty.jregex.Term;
import com.contrastsecurity.thirdparty.jregex.UnicodeConstants;

class Bitset
implements UnicodeConstants {
    private static final Block[][] categoryBits = new Block[32][256];
    private boolean positive = true;
    private boolean isLarge = false;
    boolean[] block0;
    private static final boolean[] emptyBlock0;
    Block[] blocks;
    private int weight;

    Bitset() {
    }

    final void reset() {
        this.positive = true;
        this.block0 = null;
        this.blocks = null;
        this.isLarge = false;
        this.weight = 0;
    }

    static final void unify(Bitset bitset, Term term) {
        if (bitset.isLarge) {
            term.type = 2;
            term.bitset2 = Block.toBitset2(bitset.blocks);
        } else {
            term.type = 1;
            term.bitset = bitset.block0 == null ? emptyBlock0 : bitset.block0;
        }
        term.inverse = !bitset.positive;
        term.weight = bitset.positive ? bitset.weight : 65536 - bitset.weight;
    }

    final void setPositive(boolean bl2) {
        this.positive = bl2;
    }

    final boolean isPositive() {
        return this.positive;
    }

    final boolean isLarge() {
        return this.isLarge;
    }

    private final void enableLargeMode() {
        if (this.isLarge) {
            return;
        }
        Block[] blockArray = new Block[256];
        this.blocks = blockArray;
        if (this.block0 != null) {
            blockArray[0] = new Block(this.block0);
        }
        this.isLarge = true;
    }

    final int getWeight() {
        return this.positive ? this.weight : 65536 - this.weight;
    }

    final void setWordChar(boolean bl2) {
        if (bl2) {
            this.setCategory(1);
            this.setCategory(2);
            this.setCategory(3);
            this.setCategory(5);
            this.setCategory(9);
            this.setChar('_');
        } else {
            this.setRange('a', 'z');
            this.setRange('A', 'Z');
            this.setRange('0', '9');
            this.setChar('_');
        }
    }

    final void setDigit(boolean bl2) {
        if (bl2) {
            this.setCategory(9);
        } else {
            this.setRange('0', '9');
        }
    }

    final void setSpace(boolean bl2) {
        if (bl2) {
            this.setCategory(12);
            this.setCategory(14);
            this.setCategory(13);
        } else {
            this.setChar(' ');
            this.setChar('\r');
            this.setChar('\n');
            this.setChar('\t');
            this.setChar('\f');
        }
    }

    final void setCategory(int n2) {
        if (!this.isLarge) {
            this.enableLargeMode();
        }
        Block[] blockArray = categoryBits[n2];
        this.weight += Block.add(this.blocks, blockArray, 0, 255, false);
    }

    final void setChars(String string) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            this.setChar(string.charAt(i2));
        }
    }

    final void setChar(char c2) {
        this.setRange(c2, c2);
    }

    final void setRange(char n2, char c2) {
        if (c2 >= '\u0100' || this.isLarge) {
            int n3 = 0;
            if (!this.isLarge) {
                this.enableLargeMode();
            }
            Block[] blockArray = this.blocks;
            for (int i2 = n2; i2 <= c2; ++i2) {
                int n4 = i2 >> 8 & 0xFF;
                int n5 = i2 & 0xFF;
                Block block = blockArray[n4];
                if (block == null) {
                    blockArray[n4] = block = new Block();
                }
                if (!block.set(n5)) continue;
                ++n3;
            }
            this.weight += n3;
        } else {
            boolean[] blArray = this.block0;
            if (blArray == null) {
                this.block0 = blArray = new boolean[256];
            }
            this.weight += Bitset.set(blArray, true, n2, c2);
        }
    }

    final void add(Bitset bitset) {
        this.add(bitset, false);
    }

    final void add(Bitset bitset, boolean bl2) {
        this.weight += Bitset.addImpl(this, bitset, !bitset.positive ^ bl2);
    }

    private static final int addImpl(Bitset bitset, Bitset bitset2, boolean bl2) {
        int n2 = 0;
        if (!(bitset.isLarge || bitset2.isLarge || bl2)) {
            if (bitset2.block0 != null) {
                boolean[] blArray = bitset.block0;
                if (blArray == null) {
                    bitset.block0 = blArray = new boolean[256];
                }
                n2 += Bitset.add(blArray, bitset2.block0, 0, 255, false);
            }
        } else {
            if (!bitset.isLarge) {
                bitset.enableLargeMode();
            }
            if (!bitset2.isLarge) {
                bitset2.enableLargeMode();
            }
            n2 += Block.add(bitset.blocks, bitset2.blocks, 0, 255, bl2);
        }
        return n2;
    }

    final void subtract(Bitset bitset) {
        this.subtract(bitset, false);
    }

    final void subtract(Bitset bitset, boolean bl2) {
        this.weight += Bitset.subtractImpl(this, bitset, !bitset.positive ^ bl2);
    }

    private static final int subtractImpl(Bitset bitset, Bitset bitset2, boolean bl2) {
        int n2 = 0;
        if (!(bitset.isLarge || bitset2.isLarge || bl2)) {
            boolean[] blArray = bitset2.block0;
            if (bitset2.block0 != null) {
                boolean[] blArray2 = bitset.block0;
                if (blArray2 == null) {
                    return 0;
                }
                n2 += Bitset.subtract(blArray2, blArray, 0, 255, false);
            }
        } else {
            if (!bitset.isLarge) {
                bitset.enableLargeMode();
            }
            if (!bitset2.isLarge) {
                bitset2.enableLargeMode();
            }
            n2 += Block.subtract(bitset.blocks, bitset2.blocks, 0, 255, bl2);
        }
        return n2;
    }

    final void intersect(Bitset bitset) {
        this.intersect(bitset, false);
    }

    final void intersect(Bitset bitset, boolean bl2) {
        this.subtract(bitset, !bl2);
    }

    static final int add(boolean[] blArray, boolean[] blArray2, int n2, int n3, boolean bl2) {
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (blArray[i2] || !(blArray2[i2] ^ bl2)) continue;
            ++n4;
            blArray[i2] = true;
        }
        return n4;
    }

    static final int subtract(boolean[] blArray, boolean[] blArray2, int n2, int n3, boolean bl2) {
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!blArray[i2] || !(blArray2[i2] ^ bl2)) continue;
            --n4;
            blArray[i2] = false;
        }
        return n4;
    }

    static final int set(boolean[] blArray, boolean bl2, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (blArray[i2] == bl2) continue;
            n4 = bl2 ? ++n4 : --n4;
            blArray[i2] = bl2;
        }
        return n4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.positive) {
            stringBuffer.append('^');
        }
        if (this.isLarge) {
            stringBuffer.append(CharacterClass.stringValue2(Block.toBitset2(this.blocks)));
        } else if (this.block0 != null) {
            stringBuffer.append(CharacterClass.stringValue0(this.block0));
        }
        stringBuffer.append('(');
        stringBuffer.append(this.getWeight());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    static {
        for (int i2 = 0; i2 <= 65535; ++i2) {
            int n2;
            int n3 = Character.getType((char)i2);
            Block block = categoryBits[n3][n2 = i2 >> 8 & 0xFF];
            if (block == null) {
                Bitset.categoryBits[n3][n2] = block = new Block();
            }
            block.set(i2 & 0xFF);
        }
        emptyBlock0 = new boolean[256];
    }
}

