/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.jregex;

import com.contrastsecurity.thirdparty.jregex.Matcher;
import com.contrastsecurity.thirdparty.jregex.Pattern;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class RETokenizer
implements Enumeration {
    private Matcher matcher;
    private boolean checked;
    private boolean hasToken;
    private String token;
    private int pos = 0;
    private boolean endReached = false;
    private boolean emptyTokensEnabnled = false;

    public RETokenizer(Pattern pattern, String string) {
        this(pattern.matcher(string), false);
    }

    public RETokenizer(Pattern pattern, char[] cArray, int n2, int n3) {
        this(pattern.matcher(cArray, n2, n3), false);
    }

    public RETokenizer(Pattern pattern, Reader reader, int n2) throws IOException {
        this(pattern.matcher(reader, n2), false);
    }

    public RETokenizer(Matcher matcher, boolean bl2) {
        this.matcher = matcher;
        this.emptyTokensEnabnled = bl2;
    }

    public void setEmptyEnabled(boolean bl2) {
        this.emptyTokensEnabnled = bl2;
    }

    public boolean isEmptyEnabled() {
        return this.emptyTokensEnabnled;
    }

    public boolean hasMore() {
        if (!this.checked) {
            this.check();
        }
        return this.hasToken;
    }

    public String nextToken() {
        if (!this.checked) {
            this.check();
        }
        if (!this.hasToken) {
            throw new NoSuchElementException();
        }
        this.checked = false;
        return this.token;
    }

    public String[] split() {
        return RETokenizer.collect(this, null, 0);
    }

    public void reset() {
        this.matcher.setPosition(0);
    }

    private static final String[] collect(RETokenizer rETokenizer, String[] stringArray, int n2) {
        if (rETokenizer.hasMore()) {
            String string = rETokenizer.nextToken();
            stringArray = RETokenizer.collect(rETokenizer, stringArray, n2 + 1);
            stringArray[n2] = string;
        } else {
            stringArray = new String[n2];
        }
        return stringArray;
    }

    private void check() {
        boolean bl2 = this.emptyTokensEnabnled;
        this.checked = true;
        if (this.endReached) {
            this.hasToken = false;
            return;
        }
        Matcher matcher = this.matcher;
        boolean bl3 = false;
        while (matcher.find()) {
            if (matcher.start() > 0) {
                bl3 = true;
                break;
            }
            if (matcher.end() <= 0) continue;
            if (bl2) {
                bl3 = true;
                break;
            }
            matcher.setTarget(matcher, -2);
        }
        if (!bl3) {
            this.endReached = true;
            if (matcher.length(-3) == 0 && !bl2) {
                this.hasToken = false;
            } else {
                this.hasToken = true;
                this.token = matcher.target();
            }
            return;
        }
        this.hasToken = true;
        this.token = matcher.prefix();
        matcher.setTarget(matcher, -2);
    }

    public boolean hasMoreElements() {
        return this.hasMore();
    }

    public Object nextElement() {
        return this.nextToken();
    }
}

