/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression;

import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.Expression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.ExpressionVisitor;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.KeepExpression;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.WindowElement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.OrderByElement;
import com.contrastsecurity.thirdparty.net.sf.jsqlparser.statement.select.PlainSelect;
import java.util.List;

public class AnalyticExpression
implements Expression {
    private ExpressionList partitionExpressionList;
    private List<OrderByElement> orderByElements;
    private String name;
    private Expression expression;
    private Expression offset;
    private Expression defaultValue;
    private boolean allColumns = false;
    private WindowElement windowElement;
    private KeepExpression keep = null;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public KeepExpression getKeep() {
        return this.keep;
    }

    public void setKeep(KeepExpression keepExpression) {
        this.keep = keepExpression;
    }

    public ExpressionList getPartitionExpressionList() {
        return this.partitionExpressionList;
    }

    public void setPartitionExpressionList(ExpressionList expressionList) {
        this.partitionExpressionList = expressionList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getOffset() {
        return this.offset;
    }

    public void setOffset(Expression expression) {
        this.offset = expression;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Expression expression) {
        this.defaultValue = expression;
    }

    public WindowElement getWindowElement() {
        return this.windowElement;
    }

    public void setWindowElement(WindowElement windowElement) {
        this.windowElement = windowElement;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append("(");
        if (this.expression != null) {
            stringBuilder.append(this.expression.toString());
            if (this.offset != null) {
                stringBuilder.append(", ").append(this.offset.toString());
                if (this.defaultValue != null) {
                    stringBuilder.append(", ").append(this.defaultValue.toString());
                }
            }
        } else if (this.isAllColumns()) {
            stringBuilder.append("*");
        }
        stringBuilder.append(") ");
        if (this.keep != null) {
            stringBuilder.append(this.keep.toString()).append(" ");
        }
        stringBuilder.append("OVER (");
        this.toStringPartitionBy(stringBuilder);
        this.toStringOrderByElements(stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean bl2) {
        this.allColumns = bl2;
    }

    private void toStringPartitionBy(StringBuilder stringBuilder) {
        if (this.partitionExpressionList != null && !this.partitionExpressionList.getExpressions().isEmpty()) {
            stringBuilder.append("PARTITION BY ");
            stringBuilder.append(PlainSelect.getStringList(this.partitionExpressionList.getExpressions(), true, false));
            stringBuilder.append(" ");
        }
    }

    private void toStringOrderByElements(StringBuilder stringBuilder) {
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            stringBuilder.append("ORDER BY ");
            for (int i2 = 0; i2 < this.orderByElements.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.orderByElements.get(i2).toString());
            }
            if (this.windowElement != null) {
                stringBuilder.append(' ');
                stringBuilder.append(this.windowElement);
            }
        }
    }
}

