/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.HdrHistogram;

import com.contrastsecurity.thirdparty.org.HdrHistogram.AbstractHistogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.AtomicHistogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.Base64Helper;
import com.contrastsecurity.thirdparty.org.HdrHistogram.DoubleAllValuesIterator;
import com.contrastsecurity.thirdparty.org.HdrHistogram.DoubleHistogramIterationValue;
import com.contrastsecurity.thirdparty.org.HdrHistogram.DoubleLinearIterator;
import com.contrastsecurity.thirdparty.org.HdrHistogram.DoubleLogarithmicIterator;
import com.contrastsecurity.thirdparty.org.HdrHistogram.DoublePercentileIterator;
import com.contrastsecurity.thirdparty.org.HdrHistogram.DoubleRecordedValuesIterator;
import com.contrastsecurity.thirdparty.org.HdrHistogram.DoubleValueRecorder;
import com.contrastsecurity.thirdparty.org.HdrHistogram.EncodableHistogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.Histogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.HistogramIterationValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.DataFormatException;

public class DoubleHistogram
extends EncodableHistogram
implements DoubleValueRecorder,
Serializable {
    private static final double highestAllowedValueEver;
    private long configuredHighestToLowestValueRatio;
    private volatile double currentLowestValueInAutoRange;
    private volatile double currentHighestValueLimitInAutoRange;
    AbstractHistogram integerValuesHistogram;
    private boolean autoResize = false;
    private static final long serialVersionUID = 42L;
    private static final int DHIST_encodingCookie = 208802382;
    private static final int DHIST_compressedEncodingCookie = 208802383;
    private static final Class[] constructorArgTypes;

    public DoubleHistogram(int n2) {
        this(2L, n2, Histogram.class, null);
        this.setAutoResize(true);
    }

    public DoubleHistogram(int n2, Class<? extends AbstractHistogram> clazz) {
        this(2L, n2, clazz, null);
        this.setAutoResize(true);
    }

    public DoubleHistogram(long l2, int n2) {
        this(l2, n2, Histogram.class);
    }

    protected DoubleHistogram(long l2, int n2, Class<? extends AbstractHistogram> clazz) {
        this(l2, n2, clazz, null);
    }

    DoubleHistogram(long l2, int n2, Class<? extends AbstractHistogram> clazz, AbstractHistogram abstractHistogram) {
        this(l2, n2, clazz, abstractHistogram, false);
    }

    private DoubleHistogram(long l2, int n2, Class<? extends AbstractHistogram> clazz, AbstractHistogram abstractHistogram, boolean bl2) {
        try {
            double d2;
            AbstractHistogram abstractHistogram2;
            if (l2 < 2L) {
                throw new IllegalArgumentException("highestToLowestValueRatio must be >= 2");
            }
            if ((double)l2 * Math.pow(10.0, n2) >= 2.305843009213694E18) {
                throw new IllegalArgumentException("highestToLowestValueRatio * (10^numberOfSignificantValueDigits) must be < (1L << 61)");
            }
            if (clazz == AtomicHistogram.class) {
                throw new IllegalArgumentException("AtomicHistogram cannot be used as an internal counts histogram (does not support shifting). Use ConcurrentHistogram instead.");
            }
            long l3 = this.deriveIntegerValueRange(l2, n2);
            if (abstractHistogram == null) {
                Constructor<? extends AbstractHistogram> constructor = clazz.getConstructor(Long.TYPE, Long.TYPE, Integer.TYPE);
                abstractHistogram2 = constructor.newInstance(1L, l3 - 1L, n2);
                d2 = Math.pow(2.0, 800.0);
            } else if (bl2) {
                Constructor<? extends AbstractHistogram> constructor = clazz.getConstructor(AbstractHistogram.class);
                abstractHistogram2 = constructor.newInstance(abstractHistogram);
                d2 = Math.pow(2.0, 800.0);
            } else {
                if (abstractHistogram.getLowestDiscernibleValue() != 1L || abstractHistogram.getHighestTrackableValue() != l3 - 1L || abstractHistogram.getNumberOfSignificantValueDigits() != n2) {
                    throw new IllegalStateException("integer values histogram does not match stated parameters.");
                }
                abstractHistogram2 = abstractHistogram;
                d2 = abstractHistogram.getIntegerToDoubleValueConversionRatio() * (double)abstractHistogram.subBucketHalfCount;
            }
            this.init(l2, d2, abstractHistogram2);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException(reflectiveOperationException);
        }
    }

    public DoubleHistogram(DoubleHistogram doubleHistogram) {
        this(doubleHistogram.configuredHighestToLowestValueRatio, doubleHistogram.getNumberOfSignificantValueDigits(), doubleHistogram.integerValuesHistogram.getClass(), doubleHistogram.integerValuesHistogram, true);
        this.autoResize = doubleHistogram.autoResize;
        this.setTrackableValueRange(doubleHistogram.currentLowestValueInAutoRange, doubleHistogram.currentHighestValueLimitInAutoRange);
    }

    private void init(long l2, double d2, AbstractHistogram abstractHistogram) {
        this.configuredHighestToLowestValueRatio = l2;
        this.integerValuesHistogram = abstractHistogram;
        long l3 = this.deriveInternalHighestToLowestValueRatio(l2);
        this.setTrackableValueRange(d2, d2 * (double)l3);
    }

    private void setTrackableValueRange(double d2, double d3) {
        this.currentLowestValueInAutoRange = d2;
        this.currentHighestValueLimitInAutoRange = d3;
        double d4 = d2 / (double)this.getLowestTrackingIntegerValue();
        this.integerValuesHistogram.setIntegerToDoubleValueConversionRatio(d4);
    }

    double getDoubleToIntegerValueConversionRatio() {
        return this.integerValuesHistogram.getDoubleToIntegerValueConversionRatio();
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean bl2) {
        this.autoResize = bl2;
    }

    @Override
    public void recordValue(double d2) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValue(d2);
    }

    @Override
    public void recordValueWithCount(double d2, long l2) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(l2, d2);
    }

    @Override
    public void recordValueWithExpectedInterval(double d2, double d3) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithCountAndExpectedInterval(d2, 1L, d3);
    }

    private void recordCountAtValue(long l2, double d2) throws ArrayIndexOutOfBoundsException {
        int n2 = 0;
        while (true) {
            if (d2 < this.currentLowestValueInAutoRange || d2 >= this.currentHighestValueLimitInAutoRange) {
                this.autoAdjustRangeForValue(d2);
            }
            try {
                this.integerValuesHistogram.recordConvertedDoubleValueWithCount(d2, l2);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (++n2 <= 64) continue;
                throw new ArrayIndexOutOfBoundsException("BUG: Unexpected non-transient AIOOB Exception caused by:\n" + arrayIndexOutOfBoundsException);
            }
            break;
        }
    }

    private void recordSingleValue(double d2) throws ArrayIndexOutOfBoundsException {
        int n2 = 0;
        while (true) {
            if (d2 < this.currentLowestValueInAutoRange || d2 >= this.currentHighestValueLimitInAutoRange) {
                this.autoAdjustRangeForValue(d2);
            }
            try {
                this.integerValuesHistogram.recordConvertedDoubleValue(d2);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (++n2 <= 64) continue;
                throw new ArrayIndexOutOfBoundsException("BUG: Unexpected non-transient AIOOB Exception caused by:\n" + arrayIndexOutOfBoundsException);
            }
            break;
        }
    }

    private void recordValueWithCountAndExpectedInterval(double d2, long l2, double d3) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(l2, d2);
        if (d3 <= 0.0) {
            return;
        }
        for (double d4 = d2 - d3; d4 >= d3; d4 -= d3) {
            this.recordCountAtValue(l2, d4);
        }
    }

    private void autoAdjustRangeForValue(double d2) {
        if (d2 == 0.0) {
            return;
        }
        this.autoAdjustRangeForValueSlowPath(d2);
    }

    private synchronized void autoAdjustRangeForValueSlowPath(double d2) {
        try {
            if (d2 < this.currentLowestValueInAutoRange) {
                if (d2 < 0.0) {
                    throw new ArrayIndexOutOfBoundsException("Negative values cannot be recorded");
                }
                do {
                    int n2 = this.findCappedContainingBinaryOrderOfMagnitude(Math.ceil(this.currentLowestValueInAutoRange / d2) - 1.0);
                    this.shiftCoveredRangeToTheRight(n2);
                } while (d2 < this.currentLowestValueInAutoRange);
            } else if (d2 >= this.currentHighestValueLimitInAutoRange) {
                if (d2 > highestAllowedValueEver) {
                    throw new ArrayIndexOutOfBoundsException("Values above " + highestAllowedValueEver + " cannot be recorded");
                }
                do {
                    int n3 = this.findCappedContainingBinaryOrderOfMagnitude(Math.ceil((d2 + Math.ulp(d2)) / this.currentHighestValueLimitInAutoRange) - 1.0);
                    this.shiftCoveredRangeToTheLeft(n3);
                } while (d2 >= this.currentHighestValueLimitInAutoRange);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("The value " + d2 + " is out of bounds for histogram, current covered range [" + this.currentLowestValueInAutoRange + ", " + this.currentHighestValueLimitInAutoRange + ") cannot be extended any further.\nCaused by: " + arrayIndexOutOfBoundsException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftCoveredRangeToTheRight(int n2) {
        double d2 = this.currentLowestValueInAutoRange;
        double d3 = this.currentHighestValueLimitInAutoRange;
        try {
            double d4 = 1.0 / (double)(1L << n2);
            this.currentHighestValueLimitInAutoRange *= d4;
            double d5 = this.getIntegerToDoubleValueConversionRatio() * d4;
            if (this.getTotalCount() > this.integerValuesHistogram.getCountAtIndex(0)) {
                try {
                    this.integerValuesHistogram.shiftValuesLeft(n2, d5);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.handleShiftValuesException(n2, arrayIndexOutOfBoundsException);
                    d3 /= d4;
                    this.integerValuesHistogram.shiftValuesLeft(n2, d5);
                }
            }
            d2 *= d4;
            d3 *= d4;
        }
        finally {
            this.setTrackableValueRange(d2, d3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftCoveredRangeToTheLeft(int n2) {
        double d2 = this.currentLowestValueInAutoRange;
        double d3 = this.currentHighestValueLimitInAutoRange;
        try {
            double d4 = 1.0 * (double)(1L << n2);
            double d5 = this.getIntegerToDoubleValueConversionRatio() * d4;
            this.currentLowestValueInAutoRange *= d4;
            if (this.getTotalCount() > this.integerValuesHistogram.getCountAtIndex(0)) {
                try {
                    this.integerValuesHistogram.shiftValuesRight(n2, d5);
                    d2 *= d4;
                    d3 *= d4;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.handleShiftValuesException(n2, arrayIndexOutOfBoundsException);
                    d2 /= d4;
                }
            }
            d2 *= d4;
            d3 *= d4;
        }
        finally {
            this.setTrackableValueRange(d2, d3);
        }
    }

    private void handleShiftValuesException(int n2, Exception exception) {
        if (!this.autoResize) {
            throw new ArrayIndexOutOfBoundsException("Value outside of histogram covered range.\nCaused by: " + exception);
        }
        long l2 = this.integerValuesHistogram.getHighestTrackableValue();
        int n3 = DoubleHistogram.findContainingBinaryOrderOfMagnitude(l2);
        int n4 = n2 + n3;
        if (n4 > 63) {
            throw new ArrayIndexOutOfBoundsException("Cannot resize histogram covered range beyond (1L << 63) / (1L << " + this.integerValuesHistogram.subBucketHalfCountMagnitude + ") - 1.\nCaused by: " + exception);
        }
        long l3 = (1L << n4) - 1L;
        this.integerValuesHistogram.resize(l3);
        this.integerValuesHistogram.highestTrackableValue = l3;
        this.configuredHighestToLowestValueRatio <<= n2;
    }

    @Override
    public void reset() {
        this.integerValuesHistogram.reset();
        double d2 = Math.pow(2.0, 800.0);
        this.init(this.configuredHighestToLowestValueRatio, d2, this.integerValuesHistogram);
    }

    public DoubleHistogram copy() {
        DoubleHistogram doubleHistogram = new DoubleHistogram(this.configuredHighestToLowestValueRatio, this.getNumberOfSignificantValueDigits());
        doubleHistogram.setTrackableValueRange(this.currentLowestValueInAutoRange, this.currentHighestValueLimitInAutoRange);
        this.integerValuesHistogram.copyInto(doubleHistogram.integerValuesHistogram);
        return doubleHistogram;
    }

    public DoubleHistogram copyCorrectedForCoordinatedOmission(double d2) {
        DoubleHistogram doubleHistogram = new DoubleHistogram(this.configuredHighestToLowestValueRatio, this.getNumberOfSignificantValueDigits());
        doubleHistogram.setTrackableValueRange(this.currentLowestValueInAutoRange, this.currentHighestValueLimitInAutoRange);
        doubleHistogram.addWhileCorrectingForCoordinatedOmission(this, d2);
        return doubleHistogram;
    }

    public void copyInto(DoubleHistogram doubleHistogram) {
        doubleHistogram.reset();
        doubleHistogram.add(this);
        doubleHistogram.setStartTimeStamp(this.integerValuesHistogram.startTimeStampMsec);
        doubleHistogram.setEndTimeStamp(this.integerValuesHistogram.endTimeStampMsec);
    }

    public void copyIntoCorrectedForCoordinatedOmission(DoubleHistogram doubleHistogram, double d2) {
        doubleHistogram.reset();
        doubleHistogram.addWhileCorrectingForCoordinatedOmission(this, d2);
        doubleHistogram.setStartTimeStamp(this.integerValuesHistogram.startTimeStampMsec);
        doubleHistogram.setEndTimeStamp(this.integerValuesHistogram.endTimeStampMsec);
    }

    public void add(DoubleHistogram doubleHistogram) throws ArrayIndexOutOfBoundsException {
        int n2 = doubleHistogram.integerValuesHistogram.countsArrayLength;
        AbstractHistogram abstractHistogram = doubleHistogram.integerValuesHistogram;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = abstractHistogram.getCountAtIndex(i2);
            if (l2 <= 0L) continue;
            this.recordValueWithCount((double)abstractHistogram.valueFromIndex(i2) * doubleHistogram.getIntegerToDoubleValueConversionRatio(), l2);
        }
    }

    public void addWhileCorrectingForCoordinatedOmission(DoubleHistogram doubleHistogram, double d2) {
        DoubleHistogram doubleHistogram2 = this;
        for (HistogramIterationValue histogramIterationValue : doubleHistogram.integerValuesHistogram.recordedValues()) {
            doubleHistogram2.recordValueWithCountAndExpectedInterval((double)histogramIterationValue.getValueIteratedTo() * this.getIntegerToDoubleValueConversionRatio(), histogramIterationValue.getCountAtValueIteratedTo(), d2);
        }
    }

    public void subtract(DoubleHistogram doubleHistogram) {
        int n2 = doubleHistogram.integerValuesHistogram.countsArrayLength;
        AbstractHistogram abstractHistogram = doubleHistogram.integerValuesHistogram;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = abstractHistogram.getCountAtIndex(i2);
            if (l2 <= 0L) continue;
            double d2 = (double)abstractHistogram.valueFromIndex(i2) * doubleHistogram.getIntegerToDoubleValueConversionRatio();
            if (this.getCountAtValue(d2) < l2) {
                throw new IllegalArgumentException("otherHistogram count (" + l2 + ") at value " + d2 + " is larger than this one's (" + this.getCountAtValue(d2) + ")");
            }
            this.recordValueWithCount(d2, -l2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DoubleHistogram)) {
            return false;
        }
        DoubleHistogram doubleHistogram = (DoubleHistogram)object;
        return this.integerValuesHistogram.equals(doubleHistogram.integerValuesHistogram);
    }

    public int hashCode() {
        return this.integerValuesHistogram.hashCode();
    }

    public long getTotalCount() {
        return this.integerValuesHistogram.getTotalCount();
    }

    double getCurrentLowestTrackableNonZeroValue() {
        return this.currentLowestValueInAutoRange;
    }

    double getCurrentHighestTrackableValue() {
        return this.currentHighestValueLimitInAutoRange;
    }

    public double getIntegerToDoubleValueConversionRatio() {
        return this.integerValuesHistogram.integerToDoubleValueConversionRatio;
    }

    public int getNumberOfSignificantValueDigits() {
        return this.integerValuesHistogram.numberOfSignificantValueDigits;
    }

    public long getHighestToLowestValueRatio() {
        return this.configuredHighestToLowestValueRatio;
    }

    public double sizeOfEquivalentValueRange(double d2) {
        return (double)this.integerValuesHistogram.sizeOfEquivalentValueRange((long)(d2 * this.getDoubleToIntegerValueConversionRatio())) * this.getIntegerToDoubleValueConversionRatio();
    }

    public double lowestEquivalentValue(double d2) {
        return (double)this.integerValuesHistogram.lowestEquivalentValue((long)(d2 * this.getDoubleToIntegerValueConversionRatio())) * this.getIntegerToDoubleValueConversionRatio();
    }

    public double highestEquivalentValue(double d2) {
        double d3 = this.nextNonEquivalentValue(d2);
        double d4 = d3 - 2.0 * Math.ulp(d3);
        while (d4 + Math.ulp(d4) < d3) {
            d4 += Math.ulp(d4);
        }
        return d4;
    }

    public double medianEquivalentValue(double d2) {
        return (double)this.integerValuesHistogram.medianEquivalentValue((long)(d2 * this.getDoubleToIntegerValueConversionRatio())) * this.getIntegerToDoubleValueConversionRatio();
    }

    public double nextNonEquivalentValue(double d2) {
        return (double)this.integerValuesHistogram.nextNonEquivalentValue((long)(d2 * this.getDoubleToIntegerValueConversionRatio())) * this.getIntegerToDoubleValueConversionRatio();
    }

    public boolean valuesAreEquivalent(double d2, double d3) {
        return this.lowestEquivalentValue(d2) == this.lowestEquivalentValue(d3);
    }

    public int getEstimatedFootprintInBytes() {
        return this.integerValuesHistogram._getEstimatedFootprintInBytes();
    }

    @Override
    public long getStartTimeStamp() {
        return this.integerValuesHistogram.getStartTimeStamp();
    }

    @Override
    public void setStartTimeStamp(long l2) {
        this.integerValuesHistogram.setStartTimeStamp(l2);
    }

    @Override
    public long getEndTimeStamp() {
        return this.integerValuesHistogram.getEndTimeStamp();
    }

    @Override
    public void setEndTimeStamp(long l2) {
        this.integerValuesHistogram.setEndTimeStamp(l2);
    }

    @Override
    public String getTag() {
        return this.integerValuesHistogram.getTag();
    }

    @Override
    public void setTag(String string) {
        this.integerValuesHistogram.setTag(string);
    }

    public double getMinValue() {
        return (double)this.integerValuesHistogram.getMinValue() * this.getIntegerToDoubleValueConversionRatio();
    }

    public double getMaxValue() {
        return (double)this.integerValuesHistogram.getMaxValue() * this.getIntegerToDoubleValueConversionRatio();
    }

    public double getMinNonZeroValue() {
        return (double)this.integerValuesHistogram.getMinNonZeroValue() * this.getIntegerToDoubleValueConversionRatio();
    }

    @Override
    public double getMaxValueAsDouble() {
        return this.getMaxValue();
    }

    public double getMean() {
        return this.integerValuesHistogram.getMean() * this.getIntegerToDoubleValueConversionRatio();
    }

    public double getStdDeviation() {
        return this.integerValuesHistogram.getStdDeviation() * this.getIntegerToDoubleValueConversionRatio();
    }

    public double getValueAtPercentile(double d2) {
        return (double)this.integerValuesHistogram.getValueAtPercentile(d2) * this.getIntegerToDoubleValueConversionRatio();
    }

    public double getPercentileAtOrBelowValue(double d2) {
        return this.integerValuesHistogram.getPercentileAtOrBelowValue((long)(d2 * this.getDoubleToIntegerValueConversionRatio()));
    }

    public double getCountBetweenValues(double d2, double d3) throws ArrayIndexOutOfBoundsException {
        return this.integerValuesHistogram.getCountBetweenValues((long)(d2 * this.getDoubleToIntegerValueConversionRatio()), (long)(d3 * this.getDoubleToIntegerValueConversionRatio()));
    }

    public long getCountAtValue(double d2) throws ArrayIndexOutOfBoundsException {
        return this.integerValuesHistogram.getCountAtValue((long)(d2 * this.getDoubleToIntegerValueConversionRatio()));
    }

    public Percentiles percentiles(int n2) {
        return new Percentiles(this, n2);
    }

    public LinearBucketValues linearBucketValues(double d2) {
        return new LinearBucketValues(this, d2);
    }

    public LogarithmicBucketValues logarithmicBucketValues(double d2, double d3) {
        return new LogarithmicBucketValues(this, d2, d3);
    }

    public RecordedValues recordedValues() {
        return new RecordedValues(this);
    }

    public AllValues allValues() {
        return new AllValues(this);
    }

    public void outputPercentileDistribution(PrintStream printStream, Double d2) {
        this.outputPercentileDistribution(printStream, 5, d2);
    }

    public void outputPercentileDistribution(PrintStream printStream, int n2, Double d2) {
        this.outputPercentileDistribution(printStream, n2, d2, false);
    }

    public void outputPercentileDistribution(PrintStream printStream, int n2, Double d2, boolean bl2) {
        this.integerValuesHistogram.outputPercentileDistribution(printStream, n2, d2 / this.getIntegerToDoubleValueConversionRatio(), bl2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.configuredHighestToLowestValueRatio);
        objectOutputStream.writeDouble(this.currentLowestValueInAutoRange);
        objectOutputStream.writeObject(this.integerValuesHistogram);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        long l2 = objectInputStream.readLong();
        double d2 = objectInputStream.readDouble();
        AbstractHistogram abstractHistogram = (AbstractHistogram)objectInputStream.readObject();
        this.init(l2, d2, abstractHistogram);
    }

    @Override
    public int getNeededByteBufferCapacity() {
        return this.integerValuesHistogram.getNeededByteBufferCapacity();
    }

    private int getNeededByteBufferCapacity(int n2) {
        return this.integerValuesHistogram.getNeededByteBufferCapacity(n2);
    }

    static boolean isDoubleHistogramCookie(int n2) {
        return DoubleHistogram.isCompressedDoubleHistogramCookie(n2) || DoubleHistogram.isNonCompressedDoubleHistogramCookie(n2);
    }

    static boolean isCompressedDoubleHistogramCookie(int n2) {
        return n2 == 208802383;
    }

    static boolean isNonCompressedDoubleHistogramCookie(int n2) {
        return n2 == 208802382;
    }

    public synchronized int encodeIntoByteBuffer(ByteBuffer byteBuffer) {
        long l2 = this.integerValuesHistogram.getMaxValue();
        int n2 = this.integerValuesHistogram.getLengthForNumberOfBuckets(this.integerValuesHistogram.getBucketsNeededToCoverValue(l2));
        if (byteBuffer.capacity() < this.getNeededByteBufferCapacity(n2)) {
            throw new ArrayIndexOutOfBoundsException("buffer does not have capacity for " + this.getNeededByteBufferCapacity(n2) + " bytes");
        }
        byteBuffer.putInt(208802382);
        byteBuffer.putInt(this.getNumberOfSignificantValueDigits());
        byteBuffer.putLong(this.configuredHighestToLowestValueRatio);
        return this.integerValuesHistogram.encodeIntoByteBuffer(byteBuffer) + 16;
    }

    @Override
    public synchronized int encodeIntoCompressedByteBuffer(ByteBuffer byteBuffer, int n2) {
        byteBuffer.putInt(208802383);
        byteBuffer.putInt(this.getNumberOfSignificantValueDigits());
        byteBuffer.putLong(this.configuredHighestToLowestValueRatio);
        return this.integerValuesHistogram.encodeIntoCompressedByteBuffer(byteBuffer, n2) + 16;
    }

    public int encodeIntoCompressedByteBuffer(ByteBuffer byteBuffer) {
        return this.encodeIntoCompressedByteBuffer(byteBuffer, -1);
    }

    static <T extends DoubleHistogram> T constructHistogramFromBuffer(int n2, ByteBuffer byteBuffer, Class<T> clazz, Class<? extends AbstractHistogram> clazz2, long l2) throws DataFormatException {
        AbstractHistogram abstractHistogram;
        int n3 = byteBuffer.getInt();
        long l3 = byteBuffer.getLong();
        if (DoubleHistogram.isNonCompressedDoubleHistogramCookie(n2)) {
            abstractHistogram = AbstractHistogram.decodeFromByteBuffer(byteBuffer, clazz2, l2);
        } else if (DoubleHistogram.isCompressedDoubleHistogramCookie(n2)) {
            abstractHistogram = AbstractHistogram.decodeFromCompressedByteBuffer(byteBuffer, clazz2, l2);
        } else {
            throw new IllegalArgumentException("The buffer does not contain a DoubleHistogram");
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(constructorArgTypes);
            DoubleHistogram doubleHistogram = (DoubleHistogram)constructor.newInstance(l3, n3, clazz2, abstractHistogram);
            doubleHistogram.setAutoResize(true);
            return (T)doubleHistogram;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalStateException("Unable to construct DoubleHistogram of type " + clazz);
        }
    }

    public static DoubleHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        return DoubleHistogram.decodeFromByteBuffer(byteBuffer, Histogram.class, l2);
    }

    public static DoubleHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, Class<? extends AbstractHistogram> clazz, long l2) {
        try {
            int n2 = byteBuffer.getInt();
            if (!DoubleHistogram.isNonCompressedDoubleHistogramCookie(n2)) {
                throw new IllegalArgumentException("The buffer does not contain a DoubleHistogram");
            }
            DoubleHistogram doubleHistogram = DoubleHistogram.constructHistogramFromBuffer(n2, byteBuffer, DoubleHistogram.class, clazz, l2);
            return doubleHistogram;
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(dataFormatException);
        }
    }

    public static DoubleHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        return DoubleHistogram.decodeFromCompressedByteBuffer(byteBuffer, Histogram.class, l2);
    }

    public static DoubleHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, Class<? extends AbstractHistogram> clazz, long l2) throws DataFormatException {
        int n2 = byteBuffer.getInt();
        if (!DoubleHistogram.isCompressedDoubleHistogramCookie(n2)) {
            throw new IllegalArgumentException("The buffer does not contain a compressed DoubleHistogram");
        }
        DoubleHistogram doubleHistogram = DoubleHistogram.constructHistogramFromBuffer(n2, byteBuffer, DoubleHistogram.class, clazz, l2);
        return doubleHistogram;
    }

    public static DoubleHistogram fromString(String string) throws DataFormatException {
        return DoubleHistogram.decodeFromCompressedByteBuffer(ByteBuffer.wrap(Base64Helper.parseBase64Binary(string)), 0L);
    }

    private long deriveInternalHighestToLowestValueRatio(long l2) {
        long l3 = 1L << DoubleHistogram.findContainingBinaryOrderOfMagnitude(l2) + 1;
        return l3;
    }

    private long deriveIntegerValueRange(long l2, int n2) {
        long l3 = this.deriveInternalHighestToLowestValueRatio(l2);
        long l4 = AbstractHistogram.numberOfSubbuckets(n2) / 2;
        long l5 = l4 * l3;
        return l5;
    }

    private long getLowestTrackingIntegerValue() {
        return this.integerValuesHistogram.subBucketHalfCount;
    }

    private static int findContainingBinaryOrderOfMagnitude(long l2) {
        int n2 = 64 - Long.numberOfLeadingZeros(l2);
        return n2;
    }

    private static int findContainingBinaryOrderOfMagnitude(double d2) {
        long l2 = (long)Math.ceil(d2);
        return DoubleHistogram.findContainingBinaryOrderOfMagnitude(l2);
    }

    private int findCappedContainingBinaryOrderOfMagnitude(double d2) {
        if (d2 > (double)this.configuredHighestToLowestValueRatio) {
            return (int)(Math.log(this.configuredHighestToLowestValueRatio) / Math.log(2.0));
        }
        if (d2 > Math.pow(2.0, 50.0)) {
            return 50;
        }
        return DoubleHistogram.findContainingBinaryOrderOfMagnitude(d2);
    }

    static {
        double d2;
        constructorArgTypes = new Class[]{Long.TYPE, Integer.TYPE, Class.class, AbstractHistogram.class};
        for (d2 = 1.0; d2 < 4.4942328371557893E307; d2 *= 2.0) {
        }
        highestAllowedValueEver = d2;
    }

    public class AllValues
    implements Iterable<DoubleHistogramIterationValue> {
        final DoubleHistogram histogram;

        private AllValues(DoubleHistogram doubleHistogram2) {
            this.histogram = doubleHistogram2;
        }

        @Override
        public Iterator<DoubleHistogramIterationValue> iterator() {
            return new DoubleAllValuesIterator(this.histogram);
        }
    }

    public class RecordedValues
    implements Iterable<DoubleHistogramIterationValue> {
        final DoubleHistogram histogram;

        private RecordedValues(DoubleHistogram doubleHistogram2) {
            this.histogram = doubleHistogram2;
        }

        @Override
        public Iterator<DoubleHistogramIterationValue> iterator() {
            return new DoubleRecordedValuesIterator(this.histogram);
        }
    }

    public class LogarithmicBucketValues
    implements Iterable<DoubleHistogramIterationValue> {
        final DoubleHistogram histogram;
        final double valueUnitsInFirstBucket;
        final double logBase;

        private LogarithmicBucketValues(DoubleHistogram doubleHistogram2, double d2, double d3) {
            this.histogram = doubleHistogram2;
            this.valueUnitsInFirstBucket = d2;
            this.logBase = d3;
        }

        @Override
        public Iterator<DoubleHistogramIterationValue> iterator() {
            return new DoubleLogarithmicIterator(this.histogram, this.valueUnitsInFirstBucket, this.logBase);
        }
    }

    public class LinearBucketValues
    implements Iterable<DoubleHistogramIterationValue> {
        final DoubleHistogram histogram;
        final double valueUnitsPerBucket;

        private LinearBucketValues(DoubleHistogram doubleHistogram2, double d2) {
            this.histogram = doubleHistogram2;
            this.valueUnitsPerBucket = d2;
        }

        @Override
        public Iterator<DoubleHistogramIterationValue> iterator() {
            return new DoubleLinearIterator(this.histogram, this.valueUnitsPerBucket);
        }
    }

    public class Percentiles
    implements Iterable<DoubleHistogramIterationValue> {
        final DoubleHistogram histogram;
        final int percentileTicksPerHalfDistance;

        private Percentiles(DoubleHistogram doubleHistogram2, int n2) {
            this.histogram = doubleHistogram2;
            this.percentileTicksPerHalfDistance = n2;
        }

        @Override
        public Iterator<DoubleHistogramIterationValue> iterator() {
            return new DoublePercentileIterator(this.histogram, this.percentileTicksPerHalfDistance);
        }
    }
}

