/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.HdrHistogram;

import com.contrastsecurity.thirdparty.org.HdrHistogram.Base64Helper;
import com.contrastsecurity.thirdparty.org.HdrHistogram.EncodableHistogram;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Scanner;
import java.util.zip.DataFormatException;

public class HistogramLogScanner
implements Closeable {
    private final LazyHistogramReader lazyReader;
    protected final Scanner scanner;

    public HistogramLogScanner(String string) throws FileNotFoundException {
        this(new Scanner(new File(string)));
    }

    public HistogramLogScanner(InputStream inputStream) {
        this(new Scanner(inputStream));
    }

    public HistogramLogScanner(File file) throws FileNotFoundException {
        this(new Scanner(file));
    }

    private HistogramLogScanner(Scanner scanner) {
        this.scanner = scanner;
        this.lazyReader = new LazyHistogramReader(scanner);
        this.initScanner();
    }

    private void initScanner() {
        this.scanner.useLocale(Locale.US);
        this.scanner.useDelimiter("[ ,\\r\\n]");
    }

    @Override
    public void close() {
        this.scanner.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(EventHandler eventHandler) {
        while (this.scanner.hasNextLine()) {
            try {
                if (this.scanner.hasNext("\\#.*")) {
                    if (this.scanner.hasNext("#\\[StartTime:")) {
                        this.scanner.next("#\\[StartTime:");
                        if (!this.scanner.hasNextDouble()) continue;
                        double d2 = this.scanner.nextDouble();
                        if (!eventHandler.onStartTime(d2)) continue;
                        return;
                    }
                    if (this.scanner.hasNext("#\\[BaseTime:")) {
                        this.scanner.next("#\\[BaseTime:");
                        if (!this.scanner.hasNextDouble()) continue;
                        double d3 = this.scanner.nextDouble();
                        if (!eventHandler.onBaseTime(d3)) continue;
                        return;
                    }
                    if (!eventHandler.onComment(this.scanner.next("\\#.*"))) continue;
                    return;
                }
                if (this.scanner.hasNext("\"StartTimestamp\".*")) continue;
                String string = null;
                if (this.scanner.hasNext("Tag\\=.*")) {
                    string = this.scanner.next("Tag\\=.*").substring(4);
                }
                double d4 = this.scanner.nextDouble();
                double d5 = this.scanner.nextDouble();
                this.scanner.nextDouble();
                this.lazyReader.allowGet();
                if (!eventHandler.onHistogram(string, d4, d5, this.lazyReader)) continue;
                return;
            }
            catch (Throwable throwable) {
                if (!eventHandler.onException(throwable)) continue;
                return;
            }
            finally {
                this.scanner.nextLine();
            }
        }
    }

    public boolean hasNextLine() {
        return this.scanner.hasNextLine();
    }

    private static class LazyHistogramReader
    implements EncodableHistogramSupplier {
        private final Scanner scanner;
        private boolean gotIt = true;

        private LazyHistogramReader(Scanner scanner) {
            this.scanner = scanner;
        }

        private void allowGet() {
            this.gotIt = false;
        }

        @Override
        public EncodableHistogram read() throws DataFormatException {
            if (this.gotIt) {
                throw new IllegalStateException();
            }
            this.gotIt = true;
            String string = this.scanner.next();
            ByteBuffer byteBuffer = ByteBuffer.wrap(Base64Helper.parseBase64Binary(string));
            EncodableHistogram encodableHistogram = EncodableHistogram.decodeFromCompressedByteBuffer(byteBuffer, 0L);
            return encodableHistogram;
        }
    }

    public static interface EventHandler {
        public boolean onComment(String var1);

        public boolean onBaseTime(double var1);

        public boolean onStartTime(double var1);

        public boolean onHistogram(String var1, double var2, double var4, EncodableHistogramSupplier var6);

        public boolean onException(Throwable var1);
    }

    public static interface EncodableHistogramSupplier {
        public EncodableHistogram read() throws DataFormatException;
    }
}

