/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.HdrHistogram;

import com.contrastsecurity.thirdparty.org.HdrHistogram.AbstractHistogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.Base64Helper;
import com.contrastsecurity.thirdparty.org.HdrHistogram.ConcurrentHistogram;
import com.contrastsecurity.thirdparty.org.HdrHistogram.WriterReaderPhaser;
import com.contrastsecurity.thirdparty.org.HdrHistogram.packedarray.ConcurrentPackedLongArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;

public class PackedConcurrentHistogram
extends ConcurrentHistogram {
    @Override
    ConcurrentHistogram.ConcurrentArrayWithNormalizingOffset allocateArray(int n2, int n3) {
        return new ConcurrentPackedArrayWithNormalizingOffset(n2, n3);
    }

    @Override
    void clearCounts() {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            for (int i2 = 0; i2 < this.activeCounts.length(); ++i2) {
                this.activeCounts.lazySet(i2, 0L);
                this.inactiveCounts.lazySet(i2, 0L);
            }
            totalCountUpdater.set(this, 0L);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    @Override
    public PackedConcurrentHistogram copy() {
        PackedConcurrentHistogram packedConcurrentHistogram = new PackedConcurrentHistogram(this);
        packedConcurrentHistogram.add(this);
        return packedConcurrentHistogram;
    }

    @Override
    public PackedConcurrentHistogram copyCorrectedForCoordinatedOmission(long l2) {
        PackedConcurrentHistogram packedConcurrentHistogram = new PackedConcurrentHistogram(this);
        packedConcurrentHistogram.addWhileCorrectingForCoordinatedOmission(this, l2);
        return packedConcurrentHistogram;
    }

    @Override
    public long getTotalCount() {
        return totalCountUpdater.get(this);
    }

    @Override
    void setTotalCount(long l2) {
        totalCountUpdater.set(this, l2);
    }

    @Override
    void incrementTotalCount() {
        totalCountUpdater.incrementAndGet(this);
    }

    @Override
    void addToTotalCount(long l2) {
        totalCountUpdater.addAndGet(this, l2);
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        try {
            this.wrp.readerLock();
            int n2 = 128 + this.activeCounts.getEstimatedFootprintInBytes() + this.inactiveCounts.getEstimatedFootprintInBytes();
            return n2;
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    public PackedConcurrentHistogram(int n2) {
        this(1L, 2L, n2);
        this.setAutoResize(true);
    }

    public PackedConcurrentHistogram(long l2, int n2) {
        this(1L, l2, n2);
    }

    public PackedConcurrentHistogram(long l2, long l3, int n2) {
        this(l2, l3, n2, true);
    }

    public PackedConcurrentHistogram(AbstractHistogram abstractHistogram) {
        this(abstractHistogram, true);
    }

    PackedConcurrentHistogram(AbstractHistogram abstractHistogram, boolean bl2) {
        super(abstractHistogram, false);
        if (bl2) {
            this.activeCounts = new ConcurrentPackedArrayWithNormalizingOffset(this.countsArrayLength, 0);
            this.inactiveCounts = new ConcurrentPackedArrayWithNormalizingOffset(this.countsArrayLength, 0);
        }
        this.wordSizeInBytes = 8;
    }

    PackedConcurrentHistogram(long l2, long l3, int n2, boolean bl2) {
        super(l2, l3, n2, false);
        if (bl2) {
            this.activeCounts = new ConcurrentPackedArrayWithNormalizingOffset(this.countsArrayLength, 0);
            this.inactiveCounts = new ConcurrentPackedArrayWithNormalizingOffset(this.countsArrayLength, 0);
        }
        this.wordSizeInBytes = 8;
    }

    public static PackedConcurrentHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        return PackedConcurrentHistogram.decodeFromByteBuffer(byteBuffer, PackedConcurrentHistogram.class, l2);
    }

    public static PackedConcurrentHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        return PackedConcurrentHistogram.decodeFromCompressedByteBuffer(byteBuffer, PackedConcurrentHistogram.class, l2);
    }

    public static PackedConcurrentHistogram fromString(String string) throws DataFormatException {
        return PackedConcurrentHistogram.decodeFromCompressedByteBuffer(ByteBuffer.wrap(Base64Helper.parseBase64Binary(string)), 0L);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.wrp = new WriterReaderPhaser();
    }

    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer byteBuffer) {
        try {
            this.wrp.readerLock();
            super.fillBufferFromCountsArray(byteBuffer);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    static class ConcurrentPackedArrayWithNormalizingOffset
    implements ConcurrentHistogram.ConcurrentArrayWithNormalizingOffset,
    Serializable {
        private ConcurrentPackedLongArray packedCounts;
        private int normalizingIndexOffset;
        private double doubleToIntegerValueConversionRatio;

        ConcurrentPackedArrayWithNormalizingOffset(int n2, int n3) {
            this.packedCounts = new ConcurrentPackedLongArray(n2);
            this.normalizingIndexOffset = n3;
        }

        @Override
        public int getNormalizingIndexOffset() {
            return this.normalizingIndexOffset;
        }

        @Override
        public void setNormalizingIndexOffset(int n2) {
            this.normalizingIndexOffset = n2;
        }

        @Override
        public double getDoubleToIntegerValueConversionRatio() {
            return this.doubleToIntegerValueConversionRatio;
        }

        @Override
        public void setDoubleToIntegerValueConversionRatio(double d2) {
            this.doubleToIntegerValueConversionRatio = d2;
        }

        @Override
        public long get(int n2) {
            return this.packedCounts.get(n2);
        }

        @Override
        public void atomicIncrement(int n2) {
            this.packedCounts.increment(n2);
        }

        @Override
        public void atomicAdd(int n2, long l2) {
            this.packedCounts.add(n2, l2);
        }

        @Override
        public void lazySet(int n2, long l2) {
            this.packedCounts.set(n2, l2);
        }

        @Override
        public int length() {
            return this.packedCounts.length();
        }

        @Override
        public int getEstimatedFootprintInBytes() {
            return 128 + 8 * this.packedCounts.getPhysicalLength();
        }
    }
}

