/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.codec.language;

import com.contrastsecurity.thirdparty.org.apache.commons.codec.EncoderException;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.StringEncoder;
import java.util.Locale;

public class ColognePhonetic
implements StringEncoder {
    private static final char[] AEIJOUY = new char[]{'A', 'E', 'I', 'J', 'O', 'U', 'Y'};
    private static final char[] SCZ = new char[]{'S', 'C', 'Z'};
    private static final char[] WFPV = new char[]{'W', 'F', 'P', 'V'};
    private static final char[] GKQ = new char[]{'G', 'K', 'Q'};
    private static final char[] CKQ = new char[]{'C', 'K', 'Q'};
    private static final char[] AHKLOQRUX = new char[]{'A', 'H', 'K', 'L', 'O', 'Q', 'R', 'U', 'X'};
    private static final char[] SZ = new char[]{'S', 'Z'};
    private static final char[] AHOUKQX = new char[]{'A', 'H', 'O', 'U', 'K', 'Q', 'X'};
    private static final char[] TDX = new char[]{'T', 'D', 'X'};
    private static final char[][] PREPROCESS_MAP = new char[][]{{'\u00c4', 'A'}, {'\u00dc', 'U'}, {'\u00d6', 'O'}, {'\u00df', 'S'}};

    private static boolean arrayContains(char[] cArray, char c2) {
        for (char c3 : cArray) {
            if (c3 != c2) continue;
            return true;
        }
        return false;
    }

    public String colognePhonetic(String string) {
        if (string == null) {
            return null;
        }
        string = this.preprocess(string);
        CologneOutputBuffer cologneOutputBuffer = new CologneOutputBuffer(string.length() * 2);
        CologneInputBuffer cologneInputBuffer = new CologneInputBuffer(string.toCharArray());
        char c2 = '-';
        int n2 = 47;
        int n3 = cologneInputBuffer.length();
        while (n3 > 0) {
            int n4;
            char c3 = cologneInputBuffer.removeNext();
            n3 = cologneInputBuffer.length();
            char c4 = n3 > 0 ? (char)cologneInputBuffer.getNextChar() : (char)'-';
            if (ColognePhonetic.arrayContains(AEIJOUY, c3)) {
                n4 = 48;
            } else if (c3 == 'H' || c3 < 'A' || c3 > 'Z') {
                if (n2 == 47) continue;
                n4 = 45;
            } else if (c3 == 'B' || c3 == 'P' && c4 != 'H') {
                n4 = 49;
            } else if (!(c3 != 'D' && c3 != 'T' || ColognePhonetic.arrayContains(SCZ, c4))) {
                n4 = 50;
            } else if (ColognePhonetic.arrayContains(WFPV, c3)) {
                n4 = 51;
            } else if (ColognePhonetic.arrayContains(GKQ, c3)) {
                n4 = 52;
            } else if (c3 == 'X' && !ColognePhonetic.arrayContains(CKQ, c2)) {
                n4 = 52;
                cologneInputBuffer.addLeft('S');
                ++n3;
            } else {
                n4 = c3 == 'S' || c3 == 'Z' ? 56 : (c3 == 'C' ? (n2 == 47 ? (ColognePhonetic.arrayContains(AHKLOQRUX, c4) ? 52 : 56) : (ColognePhonetic.arrayContains(SZ, c2) || !ColognePhonetic.arrayContains(AHOUKQX, c4) ? 56 : 52)) : (ColognePhonetic.arrayContains(TDX, c3) ? 56 : (c3 == 'R' ? 55 : (c3 == 'L' ? 53 : (c3 == 'M' || c3 == 'N' ? 54 : (int)c3)))));
            }
            if (n4 != 45 && (n2 != n4 && (n4 != 48 || n2 == 47) || n4 < 48 || n4 > 56)) {
                cologneOutputBuffer.addRight((char)n4);
            }
            c2 = c3;
            n2 = n4;
        }
        return cologneOutputBuffer.toString();
    }

    @Override
    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("This method's parameter was expected to be of the type " + String.class.getName() + ". But actually it was of the type " + object.getClass().getName() + ".");
        }
        return this.encode((String)object);
    }

    @Override
    public String encode(String string) {
        return this.colognePhonetic(string);
    }

    public boolean isEncodeEqual(String string, String string2) {
        return this.colognePhonetic(string).equals(this.colognePhonetic(string2));
    }

    private String preprocess(String string) {
        string = string.toUpperCase(Locale.GERMAN);
        char[] cArray = string.toCharArray();
        block0: for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] <= 'Z') continue;
            for (char[] cArray2 : PREPROCESS_MAP) {
                if (cArray[i2] != cArray2[0]) continue;
                cArray[i2] = cArray2[1];
                continue block0;
            }
        }
        return new String(cArray);
    }

    private class CologneInputBuffer
    extends CologneBuffer {
        public CologneInputBuffer(char[] cArray) {
            super(cArray);
        }

        public void addLeft(char c2) {
            ++this.length;
            this.data[this.getNextPos()] = c2;
        }

        @Override
        protected char[] copyData(int n2, int n3) {
            char[] cArray = new char[n3];
            System.arraycopy(this.data, this.data.length - this.length + n2, cArray, 0, n3);
            return cArray;
        }

        public char getNextChar() {
            return this.data[this.getNextPos()];
        }

        protected int getNextPos() {
            return this.data.length - this.length;
        }

        public char removeNext() {
            char c2 = this.getNextChar();
            --this.length;
            return c2;
        }
    }

    private class CologneOutputBuffer
    extends CologneBuffer {
        public CologneOutputBuffer(int n2) {
            super(n2);
        }

        public void addRight(char c2) {
            this.data[this.length] = c2;
            ++this.length;
        }

        @Override
        protected char[] copyData(int n2, int n3) {
            char[] cArray = new char[n3];
            System.arraycopy(this.data, n2, cArray, 0, n3);
            return cArray;
        }
    }

    private abstract class CologneBuffer {
        protected final char[] data;
        protected int length = 0;

        public CologneBuffer(char[] cArray) {
            this.data = cArray;
            this.length = cArray.length;
        }

        public CologneBuffer(int n2) {
            this.data = new char[n2];
            this.length = 0;
        }

        protected abstract char[] copyData(int var1, int var2);

        public int length() {
            return this.length;
        }

        public String toString() {
            return new String(this.copyData(0, this.length));
        }
    }
}

