/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NumberUtils {
    public static int stringToInt(String string) {
        return NumberUtils.stringToInt(string, 0);
    }

    public static int stringToInt(String string, int n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static Number createNumber(String string) throws NumberFormatException {
        Number number;
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            throw new NumberFormatException("\"\" is not a valid number.");
        }
        if (string.length() == 1 && !Character.isDigit(string.charAt(0))) {
            throw new NumberFormatException(string + " is not a valid number.");
        }
        if (string.startsWith("--")) {
            return null;
        }
        if (string.startsWith("0x") || string.startsWith("-0x")) {
            return NumberUtils.createInteger(string);
        }
        char c2 = string.charAt(string.length() - 1);
        int n2 = string.indexOf(46);
        int n3 = string.indexOf(101) + string.indexOf(69) + 1;
        if (n2 > -1) {
            if (n3 > -1) {
                if (n3 < n2) {
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                string3 = string.substring(n2 + 1, n3);
            } else {
                string3 = string.substring(n2 + 1);
            }
            string2 = string.substring(0, n2);
        } else {
            string2 = n3 > -1 ? string.substring(0, n3) : string;
            string3 = null;
        }
        if (!Character.isDigit(c2)) {
            String string4 = n3 > -1 && n3 < string.length() - 1 ? string.substring(n3 + 1, string.length() - 1) : null;
            String string5 = string.substring(0, string.length() - 1);
            boolean bl2 = NumberUtils.isAllZeros(string2) && NumberUtils.isAllZeros(string4);
            switch (c2) {
                case 'L': 
                case 'l': {
                    if (string3 == null && string4 == null && (string5.charAt(0) == '-' && NumberUtils.isDigits(string5.substring(1)) || NumberUtils.isDigits(string5))) {
                        try {
                            return NumberUtils.createLong(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(string5);
                        }
                    }
                    throw new NumberFormatException(string + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    Number number2;
                    try {
                        number2 = NumberUtils.createFloat(string5);
                        if (!((Float)number2).isInfinite() && (((Float)number2).floatValue() != 0.0f || bl2)) {
                            return number2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    Number number2;
                    try {
                        number2 = NumberUtils.createDouble(string5);
                        if (!((Double)number2).isInfinite() && ((double)((Double)number2).floatValue() != 0.0 || bl2)) {
                            return number2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(string + " is not a valid number.");
        }
        String string6 = n3 > -1 && n3 < string.length() - 1 ? string.substring(n3 + 1, string.length()) : null;
        if (string3 == null && string6 == null) {
            try {
                return NumberUtils.createInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return NumberUtils.createLong(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    return NumberUtils.createBigInteger(string);
                }
            }
        }
        boolean bl3 = NumberUtils.isAllZeros(string2) && NumberUtils.isAllZeros(string6);
        try {
            number = NumberUtils.createFloat(string);
            if (!((Float)number).isInfinite() && (((Float)number).floatValue() != 0.0f || bl3)) {
                return number;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            number = NumberUtils.createDouble(string);
            if (!((Double)number).isInfinite() && ((Double)number != 0.0 || bl3)) {
                return number;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(string);
    }

    private static boolean isAllZeros(String string) {
        if (string == null) {
            return true;
        }
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            if (string.charAt(i2) == '0') continue;
            return false;
        }
        return string.length() > 0;
    }

    public static Float createFloat(String string) {
        return Float.valueOf(string);
    }

    public static Double createDouble(String string) {
        return Double.valueOf(string);
    }

    public static Integer createInteger(String string) {
        return Integer.decode(string);
    }

    public static Long createLong(String string) {
        return Long.valueOf(string);
    }

    public static BigInteger createBigInteger(String string) {
        BigInteger bigInteger = new BigInteger(string);
        return bigInteger;
    }

    public static BigDecimal createBigDecimal(String string) {
        BigDecimal bigDecimal = new BigDecimal(string);
        return bigDecimal;
    }

    public static long minimum(long l2, long l3, long l4) {
        if (l3 < l2) {
            l2 = l3;
        }
        if (l4 < l2) {
            l2 = l4;
        }
        return l2;
    }

    public static int minimum(int n2, int n3, int n4) {
        if (n3 < n2) {
            n2 = n3;
        }
        if (n4 < n2) {
            n2 = n4;
        }
        return n2;
    }

    public static long maximum(long l2, long l3, long l4) {
        if (l3 > l2) {
            l2 = l3;
        }
        if (l4 > l2) {
            l2 = l4;
        }
        return l2;
    }

    public static int maximum(int n2, int n3, int n4) {
        if (n3 > n2) {
            n2 = n3;
        }
        if (n4 > n2) {
            n2 = n4;
        }
        return n2;
    }

    public static int compare(double d2, double d3) {
        long l2;
        if (d2 < d3) {
            return -1;
        }
        if (d2 > d3) {
            return 1;
        }
        long l3 = Double.doubleToLongBits(d2);
        if (l3 == (l2 = Double.doubleToLongBits(d3))) {
            return 0;
        }
        if (l3 < l2) {
            return -1;
        }
        return 1;
    }

    public static int compare(float f2, float f3) {
        int n2;
        if (f2 < f3) {
            return -1;
        }
        if (f2 > f3) {
            return 1;
        }
        int n3 = Float.floatToIntBits(f2);
        if (n3 == (n2 = Float.floatToIntBits(f3))) {
            return 0;
        }
        if (n3 < n2) {
            return -1;
        }
        return 1;
    }

    public static boolean isDigits(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String string) {
        int n2;
        int n3;
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n5 = n3 = cArray[0] == '-' ? 1 : 0;
        if (n4 > n3 + 1 && cArray[n3] == '0' && cArray[n3 + 1] == 'x') {
            int n6 = n3 + 2;
            if (n6 == n4) {
                return false;
            }
            while (n6 < cArray.length) {
                if (!(cArray[n6] >= '0' && cArray[n6] <= '9' || cArray[n6] >= 'a' && cArray[n6] <= 'f' || cArray[n6] >= 'A' && cArray[n6] <= 'F')) {
                    return false;
                }
                ++n6;
            }
            return true;
        }
        --n4;
        for (n2 = n3; n2 < n4 || n2 < n4 + 1 && bl4 && !bl5; ++n2) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                bl5 = true;
                bl4 = false;
                continue;
            }
            if (cArray[n2] == '.') {
                if (bl3 || bl2) {
                    return false;
                }
                bl3 = true;
                continue;
            }
            if (cArray[n2] == 'e' || cArray[n2] == 'E') {
                if (bl2) {
                    return false;
                }
                if (!bl5) {
                    return false;
                }
                bl2 = true;
                bl4 = true;
                continue;
            }
            if (cArray[n2] == '+' || cArray[n2] == '-') {
                if (!bl4) {
                    return false;
                }
                bl4 = false;
                bl5 = false;
                continue;
            }
            return false;
        }
        if (n2 < cArray.length) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                return true;
            }
            if (cArray[n2] == 'e' || cArray[n2] == 'E') {
                return false;
            }
            if (!(bl4 || cArray[n2] != 'd' && cArray[n2] != 'D' && cArray[n2] != 'f' && cArray[n2] != 'F')) {
                return bl5;
            }
            if (cArray[n2] == 'l' || cArray[n2] == 'L') {
                return bl5 && !bl2;
            }
            return false;
        }
        return !bl4 && bl5;
    }
}

