/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.exception.CloneFailedException;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.reflect.MethodUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

public class ObjectUtils {
    public static final Null NULL = new Null();

    public static Object defaultIfNull(Object object, Object object2) {
        return object != null ? object : object2;
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static boolean notEqual(Object object, Object object2) {
        return !ObjectUtils.equals(object, object2);
    }

    public static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ObjectUtils.identityToString(stringBuffer, object);
        return stringBuffer.toString();
    }

    public static void identityToString(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot get the toString of a null identity");
        }
        stringBuffer.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static StringBuffer appendIdentityToString(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            return null;
        }
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        return stringBuffer.append(object.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(object)));
    }

    public static String toString(Object object) {
        return object == null ? "" : object.toString();
    }

    public static String toString(Object object, String string) {
        return object == null ? string : object.toString();
    }

    public static Object min(Comparable comparable, Comparable comparable2) {
        return ObjectUtils.compare(comparable, comparable2, true) <= 0 ? comparable : comparable2;
    }

    public static Object max(Comparable comparable, Comparable comparable2) {
        return ObjectUtils.compare(comparable, comparable2, false) >= 0 ? comparable : comparable2;
    }

    public static int compare(Comparable comparable, Comparable comparable2) {
        return ObjectUtils.compare(comparable, comparable2, false);
    }

    public static int compare(Comparable comparable, Comparable comparable2, boolean bl2) {
        if (comparable == comparable2) {
            return 0;
        }
        if (comparable == null) {
            return bl2 ? 1 : -1;
        }
        if (comparable2 == null) {
            return bl2 ? -1 : 1;
        }
        return comparable.compareTo(comparable2);
    }

    public static Object clone(Object object) {
        if (object instanceof Cloneable) {
            Object object2;
            if (object.getClass().isArray()) {
                Class<?> clazz = object.getClass().getComponentType();
                if (!clazz.isPrimitive()) {
                    object2 = ((Object[])object).clone();
                } else {
                    int n2 = Array.getLength(object);
                    object2 = Array.newInstance(clazz, n2);
                    while (n2-- > 0) {
                        Array.set(object2, n2, Array.get(object, n2));
                    }
                }
            } else {
                try {
                    object2 = MethodUtils.invokeMethod(object, "clone", null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new CloneFailedException("Cloneable type " + object.getClass().getName() + " has no clone method", noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new CloneFailedException("Cannot clone Cloneable type " + object.getClass().getName(), illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new CloneFailedException("Exception cloning Cloneable type " + object.getClass().getName(), invocationTargetException.getTargetException());
                }
            }
            return object2;
        }
        return null;
    }

    public static Object cloneIfPossible(Object object) {
        Object object2 = ObjectUtils.clone(object);
        return object2 == null ? object : object2;
    }

    public static class Null
    implements Serializable {
        private static final long serialVersionUID = 7092611880189329093L;

        Null() {
        }

        private Object readResolve() {
            return NULL;
        }
    }
}

