/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.ArrayUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.CharSetUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.CharUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.ObjectUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringEscapeUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.WordUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public class StringUtils {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isBlank(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String string) {
        return !StringUtils.isBlank(string);
    }

    public static String clean(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String trimToNull(String string) {
        String string2 = StringUtils.trim(string);
        return StringUtils.isEmpty(string2) ? null : string2;
    }

    public static String trimToEmpty(String string) {
        return string == null ? EMPTY : string.trim();
    }

    public static String strip(String string) {
        return StringUtils.strip(string, null);
    }

    public static String stripToNull(String string) {
        if (string == null) {
            return null;
        }
        return (string = StringUtils.strip(string, null)).length() == 0 ? null : string;
    }

    public static String stripToEmpty(String string) {
        return string == null ? EMPTY : StringUtils.strip(string, null);
    }

    public static String strip(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        string = StringUtils.stripStart(string, string2);
        return StringUtils.stripEnd(string, string2);
    }

    public static String stripStart(String string, String string2) {
        int n2;
        int n3;
        if (string == null || (n3 = string.length()) == 0) {
            return string;
        }
        if (string2 == null) {
            for (n2 = 0; n2 != n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
            }
        } else {
            if (string2.length() == 0) {
                return string;
            }
            while (n2 != n3 && string2.indexOf(string.charAt(n2)) != -1) {
                ++n2;
            }
        }
        return string.substring(n2);
    }

    public static String stripEnd(String string, String string2) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return string;
        }
        if (string2 == null) {
            while (n2 != 0 && Character.isWhitespace(string.charAt(n2 - 1))) {
                --n2;
            }
        } else {
            if (string2.length() == 0) {
                return string;
            }
            while (n2 != 0 && string2.indexOf(string.charAt(n2 - 1)) != -1) {
                --n2;
            }
        }
        return string.substring(0, n2);
    }

    public static String[] stripAll(String[] stringArray) {
        return StringUtils.stripAll(stringArray, null);
    }

    public static String[] stripAll(String[] stringArray, String string) {
        int n2;
        if (stringArray == null || (n2 = stringArray.length) == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray2[i2] = StringUtils.strip(stringArray[i2], string);
        }
        return stringArray2;
    }

    public static boolean equals(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string == null ? string2 == null : string.equalsIgnoreCase(string2);
    }

    public static int indexOf(String string, char c2) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.indexOf(c2);
    }

    public static int indexOf(String string, char c2, int n2) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.indexOf(c2, n2);
    }

    public static int indexOf(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        return string.indexOf(string2);
    }

    public static int ordinalIndexOf(String string, String string2, int n2) {
        return StringUtils.ordinalIndexOf(string, string2, n2, false);
    }

    private static int ordinalIndexOf(String string, String string2, int n2, boolean bl2) {
        if (string == null || string2 == null || n2 <= 0) {
            return -1;
        }
        if (string2.length() == 0) {
            return bl2 ? string.length() : 0;
        }
        int n3 = 0;
        int n4 = bl2 ? string.length() : -1;
        do {
            if ((n4 = bl2 ? string.lastIndexOf(string2, n4 - 1) : string.indexOf(string2, n4 + 1)) >= 0) continue;
            return n4;
        } while (++n3 < n2);
        return n4;
    }

    public static int indexOf(String string, String string2, int n2) {
        if (string == null || string2 == null) {
            return -1;
        }
        if (string2.length() == 0 && n2 >= string.length()) {
            return string.length();
        }
        return string.indexOf(string2, n2);
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return StringUtils.indexOfIgnoreCase(string, string2, 0);
    }

    public static int indexOfIgnoreCase(String string, String string2, int n2) {
        int n3;
        if (string == null || string2 == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > (n3 = string.length() - string2.length() + 1)) {
            return -1;
        }
        if (string2.length() == 0) {
            return n2;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!string.regionMatches(true, i2, string2, 0, string2.length())) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(String string, char c2) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.lastIndexOf(c2);
    }

    public static int lastIndexOf(String string, char c2, int n2) {
        if (StringUtils.isEmpty(string)) {
            return -1;
        }
        return string.lastIndexOf(c2, n2);
    }

    public static int lastIndexOf(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        return string.lastIndexOf(string2);
    }

    public static int lastOrdinalIndexOf(String string, String string2, int n2) {
        return StringUtils.ordinalIndexOf(string, string2, n2, true);
    }

    public static int lastIndexOf(String string, String string2, int n2) {
        if (string == null || string2 == null) {
            return -1;
        }
        return string.lastIndexOf(string2, n2);
    }

    public static int lastIndexOfIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        return StringUtils.lastIndexOfIgnoreCase(string, string2, string.length());
    }

    public static int lastIndexOfIgnoreCase(String string, String string2, int n2) {
        if (string == null || string2 == null) {
            return -1;
        }
        if (n2 > string.length() - string2.length()) {
            n2 = string.length() - string2.length();
        }
        if (n2 < 0) {
            return -1;
        }
        if (string2.length() == 0) {
            return n2;
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            if (!string.regionMatches(true, i2, string2, 0, string2.length())) continue;
            return i2;
        }
        return -1;
    }

    public static boolean contains(String string, char c2) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        return string.indexOf(c2) >= 0;
    }

    public static boolean contains(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.indexOf(string2) >= 0;
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n2 = string2.length();
        int n3 = string.length() - n2;
        for (int i2 = 0; i2 <= n3; ++i2) {
            if (!string.regionMatches(true, i2, string2, 0, n2)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfAny(String string, char[] cArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(cArray)) {
            return -1;
        }
        int n2 = string.length();
        int n3 = n2 - 1;
        int n4 = cArray.length;
        int n5 = n4 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (cArray[i3] != c2) continue;
                if (i2 < n3 && i3 < n5 && CharUtils.isHighSurrogate(c2)) {
                    if (cArray[i3 + 1] != string.charAt(i2 + 1)) continue;
                    return i2;
                }
                return i2;
            }
        }
        return -1;
    }

    public static int indexOfAny(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return -1;
        }
        return StringUtils.indexOfAny(string, string2.toCharArray());
    }

    public static boolean containsAny(String string, char[] cArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(cArray)) {
            return false;
        }
        int n2 = string.length();
        int n3 = cArray.length;
        int n4 = n2 - 1;
        int n5 = n3 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                if (cArray[i3] != c2) continue;
                if (CharUtils.isHighSurrogate(c2)) {
                    if (i3 == n5) {
                        return true;
                    }
                    if (i2 >= n4 || cArray[i3 + 1] != string.charAt(i2 + 1)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        return StringUtils.containsAny(string, string2.toCharArray());
    }

    public static int indexOfAnyBut(String string, char[] cArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(cArray)) {
            return -1;
        }
        int n2 = string.length();
        int n3 = n2 - 1;
        int n4 = cArray.length;
        int n5 = n4 - 1;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (cArray[i3] == c2 && (i2 >= n3 || i3 >= n5 || !CharUtils.isHighSurrogate(c2) || cArray[i3 + 1] == string.charAt(i2 + 1))) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int indexOfAnyBut(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return -1;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            char c2 = string.charAt(i2);
            boolean bl3 = bl2 = string2.indexOf(c2) >= 0;
            if (i2 + 1 < n2 && CharUtils.isHighSurrogate(c2)) {
                char c3 = string.charAt(i2 + 1);
                if (!bl2 || string2.indexOf(c3) >= 0) continue;
                return i2;
            }
            if (bl2) continue;
            return i2;
        }
        return -1;
    }

    public static boolean containsOnly(String string, char[] cArray) {
        if (cArray == null || string == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        if (cArray.length == 0) {
            return false;
        }
        return StringUtils.indexOfAnyBut(string, cArray) == -1;
    }

    public static boolean containsOnly(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return StringUtils.containsOnly(string, string2.toCharArray());
    }

    public static boolean containsNone(String string, char[] cArray) {
        if (string == null || cArray == null) {
            return true;
        }
        int n2 = string.length();
        int n3 = n2 - 1;
        int n4 = cArray.length;
        int n5 = n4 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            for (int i3 = 0; i3 < n4; ++i3) {
                if (cArray[i3] != c2) continue;
                if (CharUtils.isHighSurrogate(c2)) {
                    if (i3 == n5) {
                        return false;
                    }
                    if (i2 >= n3 || cArray[i3 + 1] != string.charAt(i2 + 1)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean containsNone(String string, String string2) {
        if (string == null || string2 == null) {
            return true;
        }
        return StringUtils.containsNone(string, string2.toCharArray());
    }

    public static int indexOfAny(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return -1;
        }
        int n2 = stringArray.length;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (string2 == null || (n4 = string.indexOf(string2)) == -1 || n4 >= n3) continue;
            n3 = n4;
        }
        return n3 == Integer.MAX_VALUE ? -1 : n3;
    }

    public static int lastIndexOfAny(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return -1;
        }
        int n2 = stringArray.length;
        int n3 = -1;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (string2 == null || (n4 = string.lastIndexOf(string2)) <= n3) continue;
            n3 = n4;
        }
        return n3;
    }

    public static String substring(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > string.length()) {
            return EMPTY;
        }
        return string.substring(n2);
    }

    public static String substring(String string, int n2, int n3) {
        if (string == null) {
            return null;
        }
        if (n3 < 0) {
            n3 = string.length() + n3;
        }
        if (n2 < 0) {
            n2 = string.length() + n2;
        }
        if (n3 > string.length()) {
            n3 = string.length();
        }
        if (n2 > n3) {
            return EMPTY;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return string.substring(n2, n3);
    }

    public static String left(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            return EMPTY;
        }
        if (string.length() <= n2) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String right(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 < 0) {
            return EMPTY;
        }
        if (string.length() <= n2) {
            return string;
        }
        return string.substring(string.length() - n2);
    }

    public static String mid(String string, int n2, int n3) {
        if (string == null) {
            return null;
        }
        if (n3 < 0 || n2 > string.length()) {
            return EMPTY;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (string.length() <= n2 + n3) {
            return string.substring(n2);
        }
        return string.substring(n2, n2 + n3);
    }

    public static String substringBefore(String string, String string2) {
        if (StringUtils.isEmpty(string) || string2 == null) {
            return string;
        }
        if (string2.length() == 0) {
            return EMPTY;
        }
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String substringAfter(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (string2 == null) {
            return EMPTY;
        }
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return EMPTY;
        }
        return string.substring(n2 + string2.length());
    }

    public static String substringBeforeLast(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String substringAfterLast(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (StringUtils.isEmpty(string2)) {
            return EMPTY;
        }
        int n2 = string.lastIndexOf(string2);
        if (n2 == -1 || n2 == string.length() - string2.length()) {
            return EMPTY;
        }
        return string.substring(n2 + string2.length());
    }

    public static String substringBetween(String string, String string2) {
        return StringUtils.substringBetween(string, string2, string2);
    }

    public static String substringBetween(String string, String string2, String string3) {
        int n2;
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        int n3 = string.indexOf(string2);
        if (n3 != -1 && (n2 = string.indexOf(string3, n3 + string2.length())) != -1) {
            return string.substring(n3 + string2.length(), n2);
        }
        return null;
    }

    public static String[] substringsBetween(String string, String string2, String string3) {
        int n2;
        int n3;
        if (string == null || StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3)) {
            return null;
        }
        int n4 = string.length();
        if (n4 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int n5 = string3.length();
        int n6 = string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n7 = 0;
        while (n7 < n4 - n5 && (n3 = string.indexOf(string2, n7)) >= 0 && (n2 = string.indexOf(string3, n3 += n6)) >= 0) {
            arrayList.add(string.substring(n3, n2));
            n7 = n2 + n5;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getNestedString(String string, String string2) {
        return StringUtils.substringBetween(string, string2, string2);
    }

    public static String getNestedString(String string, String string2, String string3) {
        return StringUtils.substringBetween(string, string2, string3);
    }

    public static String[] split(String string) {
        return StringUtils.split(string, null, -1);
    }

    public static String[] split(String string, char c2) {
        return StringUtils.splitWorker(string, c2, false);
    }

    public static String[] split(String string, String string2) {
        return StringUtils.splitWorker(string, string2, -1, false);
    }

    public static String[] split(String string, String string2, int n2) {
        return StringUtils.splitWorker(string, string2, n2, false);
    }

    public static String[] splitByWholeSeparator(String string, String string2) {
        return StringUtils.splitByWholeSeparatorWorker(string, string2, -1, false);
    }

    public static String[] splitByWholeSeparator(String string, String string2, int n2) {
        return StringUtils.splitByWholeSeparatorWorker(string, string2, n2, false);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String string, String string2) {
        return StringUtils.splitByWholeSeparatorWorker(string, string2, -1, true);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String string, String string2, int n2) {
        return StringUtils.splitByWholeSeparatorWorker(string, string2, n2, true);
    }

    private static String[] splitByWholeSeparatorWorker(String string, String string2, int n2, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (string2 == null || EMPTY.equals(string2)) {
            return StringUtils.splitWorker(string, null, n2, bl2);
        }
        int n4 = string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            n7 = string.indexOf(string2, n6);
            if (n7 > -1) {
                if (n7 > n6) {
                    if (++n5 == n2) {
                        n7 = n3;
                        arrayList.add(string.substring(n6));
                        continue;
                    }
                    arrayList.add(string.substring(n6, n7));
                    n6 = n7 + n4;
                    continue;
                }
                if (bl2) {
                    if (++n5 == n2) {
                        n7 = n3;
                        arrayList.add(string.substring(n6));
                    } else {
                        arrayList.add(EMPTY);
                    }
                }
                n6 = n7 + n4;
                continue;
            }
            arrayList.add(string.substring(n6));
            n7 = n3;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitPreserveAllTokens(String string) {
        return StringUtils.splitWorker(string, null, -1, true);
    }

    public static String[] splitPreserveAllTokens(String string, char c2) {
        return StringUtils.splitWorker(string, c2, true);
    }

    private static String[] splitWorker(String string, char c2, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        while (n3 < n2) {
            if (string.charAt(n3) == c2) {
                if (bl3 || bl2) {
                    arrayList.add(string.substring(n4, n3));
                    bl3 = false;
                    bl4 = true;
                }
                n4 = ++n3;
                continue;
            }
            bl4 = false;
            bl3 = true;
            ++n3;
        }
        if (bl3 || bl2 && bl4) {
            arrayList.add(string.substring(n4, n3));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitPreserveAllTokens(String string, String string2) {
        return StringUtils.splitWorker(string, string2, -1, true);
    }

    public static String[] splitPreserveAllTokens(String string, String string2, int n2) {
        return StringUtils.splitWorker(string, string2, n2, true);
    }

    private static String[] splitWorker(String string, String string2, int n2, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string2 == null) {
            while (n5 < n3) {
                if (Character.isWhitespace(string.charAt(n5))) {
                    if (bl3 || bl2) {
                        bl4 = true;
                        if (n4++ == n2) {
                            n5 = n3;
                            bl4 = false;
                        }
                        arrayList.add(string.substring(n6, n5));
                        bl3 = false;
                    }
                    n6 = ++n5;
                    continue;
                }
                bl4 = false;
                bl3 = true;
                ++n5;
            }
        } else if (string2.length() == 1) {
            char c2 = string2.charAt(0);
            while (n5 < n3) {
                if (string.charAt(n5) == c2) {
                    if (bl3 || bl2) {
                        bl4 = true;
                        if (n4++ == n2) {
                            n5 = n3;
                            bl4 = false;
                        }
                        arrayList.add(string.substring(n6, n5));
                        bl3 = false;
                    }
                    n6 = ++n5;
                    continue;
                }
                bl4 = false;
                bl3 = true;
                ++n5;
            }
        } else {
            while (n5 < n3) {
                if (string2.indexOf(string.charAt(n5)) >= 0) {
                    if (bl3 || bl2) {
                        bl4 = true;
                        if (n4++ == n2) {
                            n5 = n3;
                            bl4 = false;
                        }
                        arrayList.add(string.substring(n6, n5));
                        bl3 = false;
                    }
                    n6 = ++n5;
                    continue;
                }
                bl4 = false;
                bl3 = true;
                ++n5;
            }
        }
        if (bl3 || bl2 && bl4) {
            arrayList.add(string.substring(n6, n5));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitByCharacterType(String string) {
        return StringUtils.splitByCharacterType(string, false);
    }

    public static String[] splitByCharacterTypeCamelCase(String string) {
        return StringUtils.splitByCharacterType(string, true);
    }

    private static String[] splitByCharacterType(String string, boolean bl2) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        char[] cArray = string.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = Character.getType(cArray[n2]);
        for (int i2 = n2 + 1; i2 < cArray.length; ++i2) {
            int n4 = Character.getType(cArray[i2]);
            if (n4 == n3) continue;
            if (bl2 && n4 == 2 && n3 == 1) {
                int n5 = i2 - 1;
                if (n5 != n2) {
                    arrayList.add(new String(cArray, n2, n5 - n2));
                    n2 = n5;
                }
            } else {
                arrayList.add(new String(cArray, n2, i2 - n2));
                n2 = i2;
            }
            n3 = n4;
        }
        arrayList.add(new String(cArray, n2, cArray.length - n2));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String concatenate(Object[] objectArray) {
        return StringUtils.join(objectArray, null);
    }

    public static String join(Object[] objectArray) {
        return StringUtils.join(objectArray, null);
    }

    public static String join(Object[] objectArray, char c2) {
        if (objectArray == null) {
            return null;
        }
        return StringUtils.join(objectArray, c2, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, char c2, int n2, int n3) {
        if (objectArray == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        StrBuilder strBuilder = new StrBuilder(n4 *= (objectArray[n2] == null ? 16 : objectArray[n2].toString().length()) + 1);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                strBuilder.append(c2);
            }
            if (objectArray[i2] == null) continue;
            strBuilder.append(objectArray[i2]);
        }
        return strBuilder.toString();
    }

    public static String join(Object[] objectArray, String string) {
        if (objectArray == null) {
            return null;
        }
        return StringUtils.join(objectArray, string, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, String string, int n2, int n3) {
        int n4;
        if (objectArray == null) {
            return null;
        }
        if (string == null) {
            string = EMPTY;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY;
        }
        StrBuilder strBuilder = new StrBuilder(n4 *= (objectArray[n2] == null ? 16 : objectArray[n2].toString().length()) + string.length());
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                strBuilder.append(string);
            }
            if (objectArray[i2] == null) continue;
            strBuilder.append(objectArray[i2]);
        }
        return strBuilder.toString();
    }

    public static String join(Iterator iterator, char c2) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object e2 = iterator.next();
        if (!iterator.hasNext()) {
            return ObjectUtils.toString(e2);
        }
        StrBuilder strBuilder = new StrBuilder(256);
        if (e2 != null) {
            strBuilder.append(e2);
        }
        while (iterator.hasNext()) {
            strBuilder.append(c2);
            Object e3 = iterator.next();
            if (e3 == null) continue;
            strBuilder.append(e3);
        }
        return strBuilder.toString();
    }

    public static String join(Iterator iterator, String string) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object e2 = iterator.next();
        if (!iterator.hasNext()) {
            return ObjectUtils.toString(e2);
        }
        StrBuilder strBuilder = new StrBuilder(256);
        if (e2 != null) {
            strBuilder.append(e2);
        }
        while (iterator.hasNext()) {
            Object e3;
            if (string != null) {
                strBuilder.append(string);
            }
            if ((e3 = iterator.next()) == null) continue;
            strBuilder.append(e3);
        }
        return strBuilder.toString();
    }

    public static String join(Collection collection, char c2) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), c2);
    }

    public static String join(Collection collection, String string) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), string);
    }

    public static String deleteSpaces(String string) {
        if (string == null) {
            return null;
        }
        return CharSetUtils.delete(string, " \t\r\n\b");
    }

    public static String deleteWhitespace(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            cArray[n3++] = string.charAt(i2);
        }
        if (n3 == n2) {
            return string;
        }
        return new String(cArray, 0, n3);
    }

    public static String removeStart(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String removeStartIgnoreCase(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (StringUtils.startsWithIgnoreCase(string, string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String removeEnd(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String removeEndIgnoreCase(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (StringUtils.endsWithIgnoreCase(string, string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String remove(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        return StringUtils.replace(string, string2, EMPTY, -1);
    }

    public static String remove(String string, char c2) {
        if (StringUtils.isEmpty(string) || string.indexOf(c2) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == c2) continue;
            cArray[n2++] = cArray[i2];
        }
        return new String(cArray, 0, n2);
    }

    public static String replaceOnce(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, 1);
    }

    public static String replace(String string, String string2, String string3) {
        return StringUtils.replace(string, string2, string3, -1);
    }

    public static String replace(String string, String string2, String string3, int n2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2) || string3 == null || n2 == 0) {
            return string;
        }
        int n3 = 0;
        int n4 = string.indexOf(string2, n3);
        if (n4 == -1) {
            return string;
        }
        int n5 = string2.length();
        int n6 = string3.length() - n5;
        int n7 = n6 = n6 < 0 ? 0 : n6;
        StrBuilder strBuilder = new StrBuilder(string.length() + (n6 *= n2 < 0 ? 16 : (n2 > 64 ? 64 : n2)));
        while (n4 != -1) {
            strBuilder.append(string.substring(n3, n4)).append(string3);
            n3 = n4 + n5;
            if (--n2 == 0) break;
            n4 = string.indexOf(string2, n3);
        }
        strBuilder.append(string.substring(n3));
        return strBuilder.toString();
    }

    public static String replaceEach(String string, String[] stringArray, String[] stringArray2) {
        return StringUtils.replaceEach(string, stringArray, stringArray2, false, 0);
    }

    public static String replaceEachRepeatedly(String string, String[] stringArray, String[] stringArray2) {
        int n2 = stringArray == null ? 0 : stringArray.length;
        return StringUtils.replaceEach(string, stringArray, stringArray2, true, n2);
    }

    private static String replaceEach(String string, String[] stringArray, String[] stringArray2, boolean bl2, int n2) {
        int n3;
        int n4;
        if (string == null || string.length() == 0 || stringArray == null || stringArray.length == 0 || stringArray2 == null || stringArray2.length == 0) {
            return string;
        }
        if (n2 < 0) {
            throw new IllegalStateException("TimeToLive of " + n2 + " is less than 0: " + string);
        }
        int n5 = stringArray.length;
        int n6 = stringArray2.length;
        if (n5 != n6) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + n5 + " vs " + n6);
        }
        boolean[] blArray = new boolean[n5];
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        for (n4 = 0; n4 < n5; ++n4) {
            if (blArray[n4] || stringArray[n4] == null || stringArray[n4].length() == 0 || stringArray2[n4] == null) continue;
            n9 = string.indexOf(stringArray[n4]);
            if (n9 == -1) {
                blArray[n4] = true;
                continue;
            }
            if (n7 != -1 && n9 >= n7) continue;
            n7 = n9;
            n8 = n4;
        }
        if (n7 == -1) {
            return string;
        }
        n4 = 0;
        int n10 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null || stringArray2[i2] == null || (n3 = stringArray2[i2].length() - stringArray[i2].length()) <= 0) continue;
            n10 += 3 * n3;
        }
        n10 = Math.min(n10, string.length() / 5);
        StrBuilder strBuilder = new StrBuilder(string.length() + n10);
        while (n7 != -1) {
            for (n3 = n4; n3 < n7; ++n3) {
                strBuilder.append(string.charAt(n3));
            }
            strBuilder.append(stringArray2[n8]);
            n4 = n7 + stringArray[n8].length();
            n7 = -1;
            n8 = -1;
            n9 = -1;
            for (n3 = 0; n3 < n5; ++n3) {
                if (blArray[n3] || stringArray[n3] == null || stringArray[n3].length() == 0 || stringArray2[n3] == null) continue;
                n9 = string.indexOf(stringArray[n3], n4);
                if (n9 == -1) {
                    blArray[n3] = true;
                    continue;
                }
                if (n7 != -1 && n9 >= n7) continue;
                n7 = n9;
                n8 = n3;
            }
        }
        n3 = string.length();
        for (int i3 = n4; i3 < n3; ++i3) {
            strBuilder.append(string.charAt(i3));
        }
        String string2 = strBuilder.toString();
        if (!bl2) {
            return string2;
        }
        return StringUtils.replaceEach(string2, stringArray, stringArray2, bl2, n2 - 1);
    }

    public static String replaceChars(String string, char c2, char c3) {
        if (string == null) {
            return null;
        }
        return string.replace(c2, c3);
    }

    public static String replaceChars(String string, String string2, String string3) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (string3 == null) {
            string3 = EMPTY;
        }
        boolean bl2 = false;
        int n2 = string3.length();
        int n3 = string.length();
        StrBuilder strBuilder = new StrBuilder(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            int n4 = string2.indexOf(c2);
            if (n4 >= 0) {
                bl2 = true;
                if (n4 >= n2) continue;
                strBuilder.append(string3.charAt(n4));
                continue;
            }
            strBuilder.append(c2);
        }
        if (bl2) {
            return strBuilder.toString();
        }
        return string;
    }

    public static String overlayString(String string, String string2, int n2, int n3) {
        return new StrBuilder(n2 + string2.length() + string.length() - n3 + 1).append(string.substring(0, n2)).append(string2).append(string.substring(n3)).toString();
    }

    public static String overlay(String string, String string2, int n2, int n3) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = EMPTY;
        }
        int n4 = string.length();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        return new StrBuilder(n4 + n2 - n3 + string2.length() + 1).append(string.substring(0, n2)).append(string2).append(string.substring(n3)).toString();
    }

    public static String chomp(String string) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        if (string.length() == 1) {
            char c2 = string.charAt(0);
            if (c2 == '\r' || c2 == '\n') {
                return EMPTY;
            }
            return string;
        }
        int n2 = string.length() - 1;
        char c3 = string.charAt(n2);
        if (c3 == '\n') {
            if (string.charAt(n2 - 1) == '\r') {
                --n2;
            }
        } else if (c3 != '\r') {
            ++n2;
        }
        return string.substring(0, n2);
    }

    public static String chomp(String string, String string2) {
        if (StringUtils.isEmpty(string) || string2 == null) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String chompLast(String string) {
        return StringUtils.chompLast(string, "\n");
    }

    public static String chompLast(String string, String string2) {
        if (string.length() == 0) {
            return string;
        }
        String string3 = string.substring(string.length() - string2.length());
        if (string2.equals(string3)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String getChomp(String string, String string2) {
        int n2 = string.lastIndexOf(string2);
        if (n2 == string.length() - string2.length()) {
            return string2;
        }
        if (n2 != -1) {
            return string.substring(n2);
        }
        return EMPTY;
    }

    public static String prechomp(String string, String string2) {
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + string2.length());
    }

    public static String getPrechomp(String string, String string2) {
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return EMPTY;
        }
        return string.substring(0, n2 + string2.length());
    }

    public static String chop(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 < 2) {
            return EMPTY;
        }
        int n3 = n2 - 1;
        String string2 = string.substring(0, n3);
        char c2 = string.charAt(n3);
        if (c2 == '\n' && string2.charAt(n3 - 1) == '\r') {
            return string2.substring(0, n3 - 1);
        }
        return string2;
    }

    public static String chopNewline(String string) {
        int n2 = string.length() - 1;
        if (n2 <= 0) {
            return EMPTY;
        }
        char c2 = string.charAt(n2);
        if (c2 == '\n') {
            if (string.charAt(n2 - 1) == '\r') {
                --n2;
            }
        } else {
            ++n2;
        }
        return string.substring(0, n2);
    }

    public static String escape(String string) {
        return StringEscapeUtils.escapeJava(string);
    }

    public static String repeat(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (n2 <= 0) {
            return EMPTY;
        }
        int n3 = string.length();
        if (n2 == 1 || n3 == 0) {
            return string;
        }
        if (n3 == 1 && n2 <= 8192) {
            return StringUtils.padding(n2, string.charAt(0));
        }
        int n4 = n3 * n2;
        switch (n3) {
            case 1: {
                char c2 = string.charAt(0);
                char[] cArray = new char[n4];
                for (int i2 = n2 - 1; i2 >= 0; --i2) {
                    cArray[i2] = c2;
                }
                return new String(cArray);
            }
            case 2: {
                char c3 = string.charAt(0);
                char c4 = string.charAt(1);
                char[] cArray = new char[n4];
                for (int i3 = n2 * 2 - 2; i3 >= 0; --i3) {
                    cArray[i3] = c3;
                    cArray[i3 + 1] = c4;
                    --i3;
                }
                return new String(cArray);
            }
        }
        StrBuilder strBuilder = new StrBuilder(n4);
        for (int i4 = 0; i4 < n2; ++i4) {
            strBuilder.append(string);
        }
        return strBuilder.toString();
    }

    public static String repeat(String string, String string2, int n2) {
        if (string == null || string2 == null) {
            return StringUtils.repeat(string, n2);
        }
        String string3 = StringUtils.repeat(string + string2, n2);
        return StringUtils.removeEnd(string3, string2);
    }

    private static String padding(int n2, char c2) throws IndexOutOfBoundsException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + n2);
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = c2;
        }
        return new String(cArray);
    }

    public static String rightPad(String string, int n2) {
        return StringUtils.rightPad(string, n2, ' ');
    }

    public static String rightPad(String string, int n2, char c2) {
        if (string == null) {
            return null;
        }
        int n3 = n2 - string.length();
        if (n3 <= 0) {
            return string;
        }
        if (n3 > 8192) {
            return StringUtils.rightPad(string, n2, String.valueOf(c2));
        }
        return string.concat(StringUtils.padding(n3, c2));
    }

    public static String rightPad(String string, int n2, String string2) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = " ";
        }
        int n3 = string2.length();
        int n4 = string.length();
        int n5 = n2 - n4;
        if (n5 <= 0) {
            return string;
        }
        if (n3 == 1 && n5 <= 8192) {
            return StringUtils.rightPad(string, n2, string2.charAt(0));
        }
        if (n5 == n3) {
            return string.concat(string2);
        }
        if (n5 < n3) {
            return string.concat(string2.substring(0, n5));
        }
        char[] cArray = new char[n5];
        char[] cArray2 = string2.toCharArray();
        for (int i2 = 0; i2 < n5; ++i2) {
            cArray[i2] = cArray2[i2 % n3];
        }
        return string.concat(new String(cArray));
    }

    public static String leftPad(String string, int n2) {
        return StringUtils.leftPad(string, n2, ' ');
    }

    public static String leftPad(String string, int n2, char c2) {
        if (string == null) {
            return null;
        }
        int n3 = n2 - string.length();
        if (n3 <= 0) {
            return string;
        }
        if (n3 > 8192) {
            return StringUtils.leftPad(string, n2, String.valueOf(c2));
        }
        return StringUtils.padding(n3, c2).concat(string);
    }

    public static String leftPad(String string, int n2, String string2) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = " ";
        }
        int n3 = string2.length();
        int n4 = string.length();
        int n5 = n2 - n4;
        if (n5 <= 0) {
            return string;
        }
        if (n3 == 1 && n5 <= 8192) {
            return StringUtils.leftPad(string, n2, string2.charAt(0));
        }
        if (n5 == n3) {
            return string2.concat(string);
        }
        if (n5 < n3) {
            return string2.substring(0, n5).concat(string);
        }
        char[] cArray = new char[n5];
        char[] cArray2 = string2.toCharArray();
        for (int i2 = 0; i2 < n5; ++i2) {
            cArray[i2] = cArray2[i2 % n3];
        }
        return new String(cArray).concat(string);
    }

    public static int length(String string) {
        return string == null ? 0 : string.length();
    }

    public static String center(String string, int n2) {
        return StringUtils.center(string, n2, ' ');
    }

    public static String center(String string, int n2, char c2) {
        if (string == null || n2 <= 0) {
            return string;
        }
        int n3 = string.length();
        int n4 = n2 - n3;
        if (n4 <= 0) {
            return string;
        }
        string = StringUtils.leftPad(string, n3 + n4 / 2, c2);
        string = StringUtils.rightPad(string, n2, c2);
        return string;
    }

    public static String center(String string, int n2, String string2) {
        int n3;
        int n4;
        if (string == null || n2 <= 0) {
            return string;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = " ";
        }
        if ((n4 = n2 - (n3 = string.length())) <= 0) {
            return string;
        }
        string = StringUtils.leftPad(string, n3 + n4 / 2, string2);
        string = StringUtils.rightPad(string, n2, string2);
        return string;
    }

    public static String upperCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase();
    }

    public static String upperCase(String string, Locale locale) {
        if (string == null) {
            return null;
        }
        return string.toUpperCase(locale);
    }

    public static String lowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static String lowerCase(String string, Locale locale) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase(locale);
    }

    public static String capitalize(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return string;
        }
        return new StrBuilder(n2).append(Character.toTitleCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String capitalise(String string) {
        return StringUtils.capitalize(string);
    }

    public static String uncapitalize(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return string;
        }
        return new StrBuilder(n2).append(Character.toLowerCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String uncapitalise(String string) {
        return StringUtils.uncapitalize(string);
    }

    public static String swapCase(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return string;
        }
        StrBuilder strBuilder = new StrBuilder(n2);
        char c2 = '\u0000';
        for (int i2 = 0; i2 < n2; ++i2) {
            c2 = string.charAt(i2);
            if (Character.isUpperCase(c2)) {
                c2 = Character.toLowerCase(c2);
            } else if (Character.isTitleCase(c2)) {
                c2 = Character.toLowerCase(c2);
            } else if (Character.isLowerCase(c2)) {
                c2 = Character.toUpperCase(c2);
            }
            strBuilder.append(c2);
        }
        return strBuilder.toString();
    }

    public static String capitaliseAllWords(String string) {
        return WordUtils.capitalize(string);
    }

    public static int countMatches(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n3)) != -1) {
            ++n2;
            n3 += string2.length();
        }
        return n2;
    }

    public static boolean isAlpha(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetter(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaSpace(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetter(string.charAt(i2)) || string.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetterOrDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLetterOrDigit(string.charAt(i2)) || string.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isAsciiPrintable(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (CharUtils.isAsciiPrintable(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumericSpace(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isDigit(string.charAt(i2)) || string.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(String string) {
        if (string == null) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllLowerCase(String string) {
        if (string == null || StringUtils.isEmpty(string)) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isLowerCase(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllUpperCase(String string) {
        if (string == null || StringUtils.isEmpty(string)) {
            return false;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isUpperCase(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String defaultString(String string) {
        return string == null ? EMPTY : string;
    }

    public static String defaultString(String string, String string2) {
        return string == null ? string2 : string;
    }

    public static String defaultIfBlank(String string, String string2) {
        return StringUtils.isBlank(string) ? string2 : string;
    }

    public static String defaultIfEmpty(String string, String string2) {
        return StringUtils.isEmpty(string) ? string2 : string;
    }

    public static String reverse(String string) {
        if (string == null) {
            return null;
        }
        return new StrBuilder(string).reverse().toString();
    }

    public static String reverseDelimited(String string, char c2) {
        if (string == null) {
            return null;
        }
        Object[] objectArray = StringUtils.split(string, c2);
        ArrayUtils.reverse(objectArray);
        return StringUtils.join(objectArray, c2);
    }

    public static String reverseDelimitedString(String string, String string2) {
        if (string == null) {
            return null;
        }
        Object[] objectArray = StringUtils.split(string, string2);
        ArrayUtils.reverse(objectArray);
        if (string2 == null) {
            return StringUtils.join(objectArray, ' ');
        }
        return StringUtils.join(objectArray, string2);
    }

    public static String abbreviate(String string, int n2) {
        return StringUtils.abbreviate(string, 0, n2);
    }

    public static String abbreviate(String string, int n2, int n3) {
        if (string == null) {
            return null;
        }
        if (n3 < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (string.length() <= n3) {
            return string;
        }
        if (n2 > string.length()) {
            n2 = string.length();
        }
        if (string.length() - n2 < n3 - 3) {
            n2 = string.length() - (n3 - 3);
        }
        if (n2 <= 4) {
            return string.substring(0, n3 - 3) + "...";
        }
        if (n3 < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (n2 + (n3 - 3) < string.length()) {
            return "..." + StringUtils.abbreviate(string.substring(n2), n3 - 3);
        }
        return "..." + string.substring(string.length() - (n3 - 3));
    }

    public static String abbreviateMiddle(String string, String string2, int n2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        if (n2 >= string.length() || n2 < string2.length() + 2) {
            return string;
        }
        int n3 = n2 - string2.length();
        int n4 = n3 / 2 + n3 % 2;
        int n5 = string.length() - n3 / 2;
        StrBuilder strBuilder = new StrBuilder(n2);
        strBuilder.append(string.substring(0, n4));
        strBuilder.append(string2);
        strBuilder.append(string.substring(n5));
        return strBuilder.toString();
    }

    public static String difference(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n2 = StringUtils.indexOfDifference(string, string2);
        if (n2 == -1) {
            return EMPTY;
        }
        return string2.substring(n2);
    }

    public static int indexOfDifference(String string, String string2) {
        int n2;
        if (string == string2) {
            return -1;
        }
        if (string == null || string2 == null) {
            return 0;
        }
        for (n2 = 0; n2 < string.length() && n2 < string2.length() && string.charAt(n2) == string2.charAt(n2); ++n2) {
        }
        if (n2 < string2.length() || n2 < string.length()) {
            return n2;
        }
        return -1;
    }

    public static int indexOfDifference(String[] stringArray) {
        int n2;
        if (stringArray == null || stringArray.length <= 1) {
            return -1;
        }
        boolean bl2 = false;
        boolean bl3 = true;
        int n3 = stringArray.length;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (stringArray[n2] == null) {
                bl2 = true;
                n4 = 0;
                continue;
            }
            bl3 = false;
            n4 = Math.min(stringArray[n2].length(), n4);
            n5 = Math.max(stringArray[n2].length(), n5);
        }
        if (bl3 || n5 == 0 && !bl2) {
            return -1;
        }
        if (n4 == 0) {
            return 0;
        }
        n2 = -1;
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = stringArray[0].charAt(i2);
            for (int i3 = 1; i3 < n3; ++i3) {
                if (stringArray[i3].charAt(i2) == c2) continue;
                n2 = i2;
                break;
            }
            if (n2 != -1) break;
        }
        if (n2 == -1 && n4 != n5) {
            return n4;
        }
        return n2;
    }

    public static String getCommonPrefix(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return EMPTY;
        }
        int n2 = StringUtils.indexOfDifference(stringArray);
        if (n2 == -1) {
            if (stringArray[0] == null) {
                return EMPTY;
            }
            return stringArray[0];
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return stringArray[0].substring(0, n2);
    }

    public static int getLevenshteinDistance(String string, String string2) {
        int n2;
        Object object;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 == 0) {
            return n4;
        }
        if (n4 == 0) {
            return n3;
        }
        if (n3 > n4) {
            object = string;
            string = string2;
            string2 = object;
            n3 = n4;
            n4 = string2.length();
        }
        object = new int[n3 + 1];
        Object object2 = new int[n3 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            object[n2] = n2;
        }
        for (int i2 = 1; i2 <= n4; ++i2) {
            char c2 = string2.charAt(i2 - 1);
            object2[0] = i2;
            for (n2 = 1; n2 <= n3; ++n2) {
                boolean bl2 = string.charAt(n2 - 1) != c2;
                object2[n2] = Math.min(Math.min(object2[n2 - 1] + 1, (int)(object[n2] + true)), (int)(object[n2 - 1] + bl2));
            }
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
        return (int)object[n3];
    }

    public static boolean startsWith(String string, String string2) {
        return StringUtils.startsWith(string, string2, false);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        return StringUtils.startsWith(string, string2, true);
    }

    private static boolean startsWith(String string, String string2, boolean bl2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (string2.length() > string.length()) {
            return false;
        }
        return string.regionMatches(bl2, 0, string2, 0, string2.length());
    }

    public static boolean startsWithAny(String string, String[] stringArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(stringArray)) {
            return false;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (!StringUtils.startsWith(string, string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(String string, String string2) {
        return StringUtils.endsWith(string, string2, false);
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        return StringUtils.endsWith(string, string2, true);
    }

    private static boolean endsWith(String string, String string2, boolean bl2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (string2.length() > string.length()) {
            return false;
        }
        int n2 = string.length() - string2.length();
        return string.regionMatches(bl2, n2, string2, 0, string2.length());
    }

    public static String normalizeSpace(String string) {
        if ((string = StringUtils.strip(string)) == null || string.length() <= 2) {
            return string;
        }
        StrBuilder strBuilder = new StrBuilder(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isWhitespace(c2)) {
                if (i2 <= 0 || Character.isWhitespace(string.charAt(i2 - 1))) continue;
                strBuilder.append(' ');
                continue;
            }
            strBuilder.append(c2);
        }
        return strBuilder.toString();
    }

    public static boolean endsWithAny(String string, String[] stringArray) {
        if (StringUtils.isEmpty(string) || ArrayUtils.isEmpty(stringArray)) {
            return false;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (!StringUtils.endsWith(string, string2)) continue;
            return true;
        }
        return false;
    }
}

