/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.reflect;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.ArrayUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.ClassUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.SystemUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

abstract class MemberUtils {
    private static final int ACCESS_TEST = 7;
    private static final Method IS_SYNTHETIC;
    private static final Class[] ORDERED_PRIMITIVE_TYPES;
    static /* synthetic */ Class class$java$lang$reflect$Member;

    MemberUtils() {
    }

    static void setAccessibleWorkaround(AccessibleObject accessibleObject) {
        if (accessibleObject == null || accessibleObject.isAccessible()) {
            return;
        }
        Member member = (Member)((Object)accessibleObject);
        if (Modifier.isPublic(member.getModifiers()) && MemberUtils.isPackageAccess(member.getDeclaringClass().getModifiers())) {
            try {
                accessibleObject.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    static boolean isPackageAccess(int n2) {
        return (n2 & 7) == 0;
    }

    static boolean isAccessible(Member member) {
        return member != null && Modifier.isPublic(member.getModifiers()) && !MemberUtils.isSynthetic(member);
    }

    static boolean isSynthetic(Member member) {
        if (IS_SYNTHETIC != null) {
            try {
                return (Boolean)IS_SYNTHETIC.invoke((Object)member, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    static int compareParameterTypes(Class[] classArray, Class[] classArray2, Class[] classArray3) {
        float f2;
        float f3 = MemberUtils.getTotalTransformationCost(classArray3, classArray);
        return f3 < (f2 = MemberUtils.getTotalTransformationCost(classArray3, classArray2)) ? -1 : (f2 < f3 ? 1 : 0);
    }

    private static float getTotalTransformationCost(Class[] classArray, Class[] classArray2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class clazz = classArray[i2];
            Class clazz2 = classArray2[i2];
            f2 += MemberUtils.getObjectTransformationCost(clazz, clazz2);
        }
        return f2;
    }

    private static float getObjectTransformationCost(Class clazz, Class clazz2) {
        if (clazz2.isPrimitive()) {
            return MemberUtils.getPrimitivePromotionCost(clazz, clazz2);
        }
        float f2 = 0.0f;
        while (clazz != null && !clazz2.equals(clazz)) {
            if (clazz2.isInterface() && ClassUtils.isAssignable(clazz, clazz2)) {
                f2 += 0.25f;
                break;
            }
            f2 += 1.0f;
            clazz = clazz.getSuperclass();
        }
        if (clazz == null) {
            f2 += 1.5f;
        }
        return f2;
    }

    private static float getPrimitivePromotionCost(Class clazz, Class clazz2) {
        float f2 = 0.0f;
        Class clazz3 = clazz;
        if (!clazz3.isPrimitive()) {
            f2 += 0.1f;
            clazz3 = ClassUtils.wrapperToPrimitive(clazz3);
        }
        for (int i2 = 0; clazz3 != clazz2 && i2 < ORDERED_PRIMITIVE_TYPES.length; ++i2) {
            if (clazz3 != ORDERED_PRIMITIVE_TYPES[i2]) continue;
            f2 += 0.1f;
            if (i2 >= ORDERED_PRIMITIVE_TYPES.length - 1) continue;
            clazz3 = ORDERED_PRIMITIVE_TYPES[i2 + 1];
        }
        return f2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Method method = null;
        if (SystemUtils.isJavaVersionAtLeast(1.5f)) {
            try {
                method = (class$java$lang$reflect$Member == null ? (class$java$lang$reflect$Member = MemberUtils.class$("java.lang.reflect.Member")) : class$java$lang$reflect$Member).getMethod("isSynthetic", ArrayUtils.EMPTY_CLASS_ARRAY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        IS_SYNTHETIC = method;
        ORDERED_PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    }
}

