/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.commons.lang.time;

import com.contrastsecurity.thirdparty.org.apache.commons.lang.Validate;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.text.StrBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class FastDateFormat
extends Format {
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private static String cDefaultPattern;
    private static final Map cInstanceCache;
    private static final Map cDateInstanceCache;
    private static final Map cTimeInstanceCache;
    private static final Map cDateTimeInstanceCache;
    private static final Map cTimeZoneDisplayCache;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final boolean mTimeZoneForced;
    private final Locale mLocale;
    private final boolean mLocaleForced;
    private transient Rule[] mRules;
    private transient int mMaxLengthEstimate;

    public static FastDateFormat getInstance() {
        return FastDateFormat.getInstance(FastDateFormat.getDefaultPattern(), null, null);
    }

    public static FastDateFormat getInstance(String string) {
        return FastDateFormat.getInstance(string, null, null);
    }

    public static FastDateFormat getInstance(String string, TimeZone timeZone) {
        return FastDateFormat.getInstance(string, timeZone, null);
    }

    public static FastDateFormat getInstance(String string, Locale locale) {
        return FastDateFormat.getInstance(string, null, locale);
    }

    public static synchronized FastDateFormat getInstance(String string, TimeZone timeZone, Locale locale) {
        FastDateFormat fastDateFormat = new FastDateFormat(string, timeZone, locale);
        FastDateFormat fastDateFormat2 = (FastDateFormat)cInstanceCache.get(fastDateFormat);
        if (fastDateFormat2 == null) {
            fastDateFormat2 = fastDateFormat;
            fastDateFormat2.init();
            cInstanceCache.put(fastDateFormat2, fastDateFormat2);
        }
        return fastDateFormat2;
    }

    public static FastDateFormat getDateInstance(int n2) {
        return FastDateFormat.getDateInstance(n2, null, null);
    }

    public static FastDateFormat getDateInstance(int n2, Locale locale) {
        return FastDateFormat.getDateInstance(n2, null, locale);
    }

    public static FastDateFormat getDateInstance(int n2, TimeZone timeZone) {
        return FastDateFormat.getDateInstance(n2, timeZone, null);
    }

    public static synchronized FastDateFormat getDateInstance(int n2, TimeZone timeZone, Locale locale) {
        FastDateFormat fastDateFormat;
        Object object = new Integer(n2);
        if (timeZone != null) {
            object = new Pair(object, timeZone);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((fastDateFormat = (FastDateFormat)cDateInstanceCache.get(object = new Pair(object, locale))) == null) {
            try {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(n2, locale);
                String string = simpleDateFormat.toPattern();
                fastDateFormat = FastDateFormat.getInstance(string, timeZone, locale);
                cDateInstanceCache.put(object, fastDateFormat);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date pattern for locale: " + locale);
            }
        }
        return fastDateFormat;
    }

    public static FastDateFormat getTimeInstance(int n2) {
        return FastDateFormat.getTimeInstance(n2, null, null);
    }

    public static FastDateFormat getTimeInstance(int n2, Locale locale) {
        return FastDateFormat.getTimeInstance(n2, null, locale);
    }

    public static FastDateFormat getTimeInstance(int n2, TimeZone timeZone) {
        return FastDateFormat.getTimeInstance(n2, timeZone, null);
    }

    public static synchronized FastDateFormat getTimeInstance(int n2, TimeZone timeZone, Locale locale) {
        FastDateFormat fastDateFormat;
        Object object = new Integer(n2);
        if (timeZone != null) {
            object = new Pair(object, timeZone);
        }
        if (locale != null) {
            object = new Pair(object, locale);
        }
        if ((fastDateFormat = (FastDateFormat)cTimeInstanceCache.get(object)) == null) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            try {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(n2, locale);
                String string = simpleDateFormat.toPattern();
                fastDateFormat = FastDateFormat.getInstance(string, timeZone, locale);
                cTimeInstanceCache.put(object, fastDateFormat);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date pattern for locale: " + locale);
            }
        }
        return fastDateFormat;
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3) {
        return FastDateFormat.getDateTimeInstance(n2, n3, null, null);
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3, Locale locale) {
        return FastDateFormat.getDateTimeInstance(n2, n3, null, locale);
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3, TimeZone timeZone) {
        return FastDateFormat.getDateTimeInstance(n2, n3, timeZone, null);
    }

    public static synchronized FastDateFormat getDateTimeInstance(int n2, int n3, TimeZone timeZone, Locale locale) {
        FastDateFormat fastDateFormat;
        Pair pair = new Pair(new Integer(n2), new Integer(n3));
        if (timeZone != null) {
            pair = new Pair(pair, timeZone);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((fastDateFormat = (FastDateFormat)cDateTimeInstanceCache.get(pair = new Pair(pair, locale))) == null) {
            try {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(n2, n3, locale);
                String string = simpleDateFormat.toPattern();
                fastDateFormat = FastDateFormat.getInstance(string, timeZone, locale);
                cDateTimeInstanceCache.put(pair, fastDateFormat);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date time pattern for locale: " + locale);
            }
        }
        return fastDateFormat;
    }

    static synchronized String getTimeZoneDisplay(TimeZone timeZone, boolean bl2, int n2, Locale locale) {
        TimeZoneDisplayKey timeZoneDisplayKey = new TimeZoneDisplayKey(timeZone, bl2, n2, locale);
        String string = (String)cTimeZoneDisplayCache.get(timeZoneDisplayKey);
        if (string == null) {
            string = timeZone.getDisplayName(bl2, n2, locale);
            cTimeZoneDisplayCache.put(timeZoneDisplayKey, string);
        }
        return string;
    }

    private static synchronized String getDefaultPattern() {
        if (cDefaultPattern == null) {
            cDefaultPattern = new SimpleDateFormat().toPattern();
        }
        return cDefaultPattern;
    }

    protected FastDateFormat(String string, TimeZone timeZone, Locale locale) {
        if (string == null) {
            throw new IllegalArgumentException("The pattern must not be null");
        }
        this.mPattern = string;
        boolean bl2 = this.mTimeZoneForced = timeZone != null;
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this.mTimeZone = timeZone;
        boolean bl3 = this.mLocaleForced = locale != null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.mLocale = locale;
    }

    protected void init() {
        List list = this.parsePattern();
        this.mRules = list.toArray(new Rule[list.size()]);
        int n2 = 0;
        int n3 = this.mRules.length;
        while (--n3 >= 0) {
            n2 += this.mRules[n3].estimateLength();
        }
        this.mMaxLengthEstimate = n2;
    }

    protected List parsePattern() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.mLocale);
        ArrayList<TwoDigitYearField> arrayList = new ArrayList<TwoDigitYearField>();
        String[] stringArray = dateFormatSymbols.getEras();
        String[] stringArray2 = dateFormatSymbols.getMonths();
        String[] stringArray3 = dateFormatSymbols.getShortMonths();
        String[] stringArray4 = dateFormatSymbols.getWeekdays();
        String[] stringArray5 = dateFormatSymbols.getShortWeekdays();
        String[] stringArray6 = dateFormatSymbols.getAmPmStrings();
        int n2 = this.mPattern.length();
        int[] nArray = new int[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            Rule rule;
            nArray[0] = i2;
            String string = this.parseToken(this.mPattern, nArray);
            i2 = nArray[0];
            int n3 = string.length();
            if (n3 == 0) break;
            char c2 = string.charAt(0);
            switch (c2) {
                case 'G': {
                    rule = new TextField(0, stringArray);
                    break;
                }
                case 'y': {
                    if (n3 >= 4) {
                        rule = this.selectNumberRule(1, n3);
                        break;
                    }
                    rule = TwoDigitYearField.INSTANCE;
                    break;
                }
                case 'M': {
                    if (n3 >= 4) {
                        rule = new TextField(2, stringArray2);
                        break;
                    }
                    if (n3 == 3) {
                        rule = new TextField(2, stringArray3);
                        break;
                    }
                    if (n3 == 2) {
                        rule = TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    rule = UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    rule = this.selectNumberRule(5, n3);
                    break;
                }
                case 'h': {
                    rule = new TwelveHourField(this.selectNumberRule(10, n3));
                    break;
                }
                case 'H': {
                    rule = this.selectNumberRule(11, n3);
                    break;
                }
                case 'm': {
                    rule = this.selectNumberRule(12, n3);
                    break;
                }
                case 's': {
                    rule = this.selectNumberRule(13, n3);
                    break;
                }
                case 'S': {
                    rule = this.selectNumberRule(14, n3);
                    break;
                }
                case 'E': {
                    rule = new TextField(7, n3 < 4 ? stringArray5 : stringArray4);
                    break;
                }
                case 'D': {
                    rule = this.selectNumberRule(6, n3);
                    break;
                }
                case 'F': {
                    rule = this.selectNumberRule(8, n3);
                    break;
                }
                case 'w': {
                    rule = this.selectNumberRule(3, n3);
                    break;
                }
                case 'W': {
                    rule = this.selectNumberRule(4, n3);
                    break;
                }
                case 'a': {
                    rule = new TextField(9, stringArray6);
                    break;
                }
                case 'k': {
                    rule = new TwentyFourHourField(this.selectNumberRule(11, n3));
                    break;
                }
                case 'K': {
                    rule = this.selectNumberRule(10, n3);
                    break;
                }
                case 'z': {
                    if (n3 >= 4) {
                        rule = new TimeZoneNameRule(this.mTimeZone, this.mTimeZoneForced, this.mLocale, 1);
                        break;
                    }
                    rule = new TimeZoneNameRule(this.mTimeZone, this.mTimeZoneForced, this.mLocale, 0);
                    break;
                }
                case 'Z': {
                    if (n3 == 1) {
                        rule = TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    rule = TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String string2 = string.substring(1);
                    if (string2.length() == 1) {
                        rule = new CharacterLiteral(string2.charAt(0));
                        break;
                    }
                    rule = new StringLiteral(string2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string);
                }
            }
            arrayList.add((TwoDigitYearField)rule);
        }
        return arrayList;
    }

    protected String parseToken(String string, int[] nArray) {
        int n2;
        StrBuilder strBuilder = new StrBuilder();
        int n3 = string.length();
        char c2 = string.charAt(n2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char c3;
            strBuilder.append(c2);
            while (n2 + 1 < n3 && (c3 = string.charAt(n2 + 1)) == c2) {
                strBuilder.append(c2);
                ++n2;
            }
        } else {
            strBuilder.append('\'');
            boolean bl2 = false;
            for (n2 = nArray[0]; n2 < n3; ++n2) {
                c2 = string.charAt(n2);
                if (c2 == '\'') {
                    if (n2 + 1 < n3 && string.charAt(n2 + 1) == '\'') {
                        ++n2;
                        strBuilder.append(c2);
                        continue;
                    }
                    bl2 = !bl2;
                    continue;
                }
                if (bl2 || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    strBuilder.append(c2);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n2;
        return strBuilder.toString();
    }

    protected NumberRule selectNumberRule(int n2, int n3) {
        switch (n3) {
            case 1: {
                return new UnpaddedNumberField(n2);
            }
            case 2: {
                return new TwoDigitNumberField(n2);
            }
        }
        return new PaddedNumberField(n2, n3);
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format((Long)object, stringBuffer);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    public String format(long l2) {
        return this.format(new Date(l2));
    }

    public String format(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.mTimeZone, this.mLocale);
        gregorianCalendar.setTime(date);
        return this.applyRules(gregorianCalendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    public StringBuffer format(long l2, StringBuffer stringBuffer) {
        return this.format(new Date(l2), stringBuffer);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.mTimeZone);
        gregorianCalendar.setTime(date);
        return this.applyRules(gregorianCalendar, stringBuffer);
    }

    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        if (this.mTimeZoneForced) {
            calendar.getTime();
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.mTimeZone);
        }
        return this.applyRules(calendar, stringBuffer);
    }

    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        Rule[] ruleArray = this.mRules;
        int n2 = this.mRules.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ruleArray[i2].appendTo(stringBuffer, calendar);
        }
        return stringBuffer;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        parsePosition.setIndex(0);
        parsePosition.setErrorIndex(0);
        return null;
    }

    public String getPattern() {
        return this.mPattern;
    }

    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public boolean getTimeZoneOverridesCalendar() {
        return this.mTimeZoneForced;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDateFormat)) {
            return false;
        }
        FastDateFormat fastDateFormat = (FastDateFormat)object;
        return !(this.mPattern != fastDateFormat.mPattern && !this.mPattern.equals(fastDateFormat.mPattern) || this.mTimeZone != fastDateFormat.mTimeZone && !this.mTimeZone.equals(fastDateFormat.mTimeZone) || this.mLocale != fastDateFormat.mLocale && !this.mLocale.equals(fastDateFormat.mLocale) || this.mTimeZoneForced != fastDateFormat.mTimeZoneForced || this.mLocaleForced != fastDateFormat.mLocaleForced);
    }

    public int hashCode() {
        int n2 = 0;
        n2 += this.mPattern.hashCode();
        n2 += this.mTimeZone.hashCode();
        n2 += this.mTimeZoneForced ? 1 : 0;
        n2 += this.mLocale.hashCode();
        return n2 += this.mLocaleForced ? 1 : 0;
    }

    public String toString() {
        return "FastDateFormat[" + this.mPattern + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    static {
        cInstanceCache = new HashMap(7);
        cDateInstanceCache = new HashMap(7);
        cTimeInstanceCache = new HashMap(7);
        cDateTimeInstanceCache = new HashMap(7);
        cTimeZoneDisplayCache = new HashMap(7);
    }

    private static class Pair {
        private final Object mObj1;
        private final Object mObj2;

        public Pair(Object object, Object object2) {
            this.mObj1 = object;
            this.mObj2 = object2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)object;
            return (this.mObj1 == null ? pair.mObj1 == null : this.mObj1.equals(pair.mObj1)) && (this.mObj2 == null ? pair.mObj2 == null : this.mObj2.equals(pair.mObj2));
        }

        public int hashCode() {
            return (this.mObj1 == null ? 0 : this.mObj1.hashCode()) + (this.mObj2 == null ? 0 : this.mObj2.hashCode());
        }

        public String toString() {
            return "[" + this.mObj1 + ':' + this.mObj2 + ']';
        }
    }

    private static class TimeZoneDisplayKey {
        private final TimeZone mTimeZone;
        private final int mStyle;
        private final Locale mLocale;

        TimeZoneDisplayKey(TimeZone timeZone, boolean bl2, int n2, Locale locale) {
            this.mTimeZone = timeZone;
            if (bl2) {
                n2 |= Integer.MIN_VALUE;
            }
            this.mStyle = n2;
            this.mLocale = locale;
        }

        public int hashCode() {
            return this.mStyle * 31 + this.mLocale.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof TimeZoneDisplayKey) {
                TimeZoneDisplayKey timeZoneDisplayKey = (TimeZoneDisplayKey)object;
                return this.mTimeZone.equals(timeZoneDisplayKey.mTimeZone) && this.mStyle == timeZoneDisplayKey.mStyle && this.mLocale.equals(timeZoneDisplayKey.mLocale);
            }
            return false;
        }
    }

    private static class TimeZoneNumberRule
    implements Rule {
        static final TimeZoneNumberRule INSTANCE_COLON = new TimeZoneNumberRule(true);
        static final TimeZoneNumberRule INSTANCE_NO_COLON = new TimeZoneNumberRule(false);
        final boolean mColon;

        TimeZoneNumberRule(boolean bl2) {
            this.mColon = bl2;
        }

        public int estimateLength() {
            return 5;
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            int n2 = calendar.get(15) + calendar.get(16);
            if (n2 < 0) {
                stringBuffer.append('-');
                n2 = -n2;
            } else {
                stringBuffer.append('+');
            }
            int n3 = n2 / 3600000;
            stringBuffer.append((char)(n3 / 10 + 48));
            stringBuffer.append((char)(n3 % 10 + 48));
            if (this.mColon) {
                stringBuffer.append(':');
            }
            int n4 = n2 / 60000 - 60 * n3;
            stringBuffer.append((char)(n4 / 10 + 48));
            stringBuffer.append((char)(n4 % 10 + 48));
        }
    }

    private static class TimeZoneNameRule
    implements Rule {
        private final TimeZone mTimeZone;
        private final boolean mTimeZoneForced;
        private final Locale mLocale;
        private final int mStyle;
        private final String mStandard;
        private final String mDaylight;

        TimeZoneNameRule(TimeZone timeZone, boolean bl2, Locale locale, int n2) {
            this.mTimeZone = timeZone;
            this.mTimeZoneForced = bl2;
            this.mLocale = locale;
            this.mStyle = n2;
            if (bl2) {
                this.mStandard = FastDateFormat.getTimeZoneDisplay(timeZone, false, n2, locale);
                this.mDaylight = FastDateFormat.getTimeZoneDisplay(timeZone, true, n2, locale);
            } else {
                this.mStandard = null;
                this.mDaylight = null;
            }
        }

        public int estimateLength() {
            if (this.mTimeZoneForced) {
                return Math.max(this.mStandard.length(), this.mDaylight.length());
            }
            if (this.mStyle == 0) {
                return 4;
            }
            return 40;
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            if (this.mTimeZoneForced) {
                if (this.mTimeZone.useDaylightTime() && calendar.get(16) != 0) {
                    stringBuffer.append(this.mDaylight);
                } else {
                    stringBuffer.append(this.mStandard);
                }
            } else {
                TimeZone timeZone = calendar.getTimeZone();
                if (timeZone.useDaylightTime() && calendar.get(16) != 0) {
                    stringBuffer.append(FastDateFormat.getTimeZoneDisplay(timeZone, true, this.mStyle, this.mLocale));
                } else {
                    stringBuffer.append(FastDateFormat.getTimeZoneDisplay(timeZone, false, this.mStyle, this.mLocale));
                }
            }
        }
    }

    private static class TwentyFourHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwentyFourHourField(NumberRule numberRule) {
            this.mRule = numberRule;
        }

        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            int n2 = calendar.get(11);
            if (n2 == 0) {
                n2 = calendar.getMaximum(11) + 1;
            }
            this.mRule.appendTo(stringBuffer, n2);
        }

        public void appendTo(StringBuffer stringBuffer, int n2) {
            this.mRule.appendTo(stringBuffer, n2);
        }
    }

    private static class TwelveHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwelveHourField(NumberRule numberRule) {
            this.mRule = numberRule;
        }

        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            int n2 = calendar.get(10);
            if (n2 == 0) {
                n2 = calendar.getLeastMaximum(10) + 1;
            }
            this.mRule.appendTo(stringBuffer, n2);
        }

        public void appendTo(StringBuffer stringBuffer, int n2) {
            this.mRule.appendTo(stringBuffer, n2);
        }
    }

    private static class TwoDigitMonthField
    implements NumberRule {
        static final TwoDigitMonthField INSTANCE = new TwoDigitMonthField();

        TwoDigitMonthField() {
        }

        public int estimateLength() {
            return 2;
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(2) + 1);
        }

        public final void appendTo(StringBuffer stringBuffer, int n2) {
            stringBuffer.append((char)(n2 / 10 + 48));
            stringBuffer.append((char)(n2 % 10 + 48));
        }
    }

    private static class TwoDigitYearField
    implements NumberRule {
        static final TwoDigitYearField INSTANCE = new TwoDigitYearField();

        TwoDigitYearField() {
        }

        public int estimateLength() {
            return 2;
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(1) % 100);
        }

        public final void appendTo(StringBuffer stringBuffer, int n2) {
            stringBuffer.append((char)(n2 / 10 + 48));
            stringBuffer.append((char)(n2 % 10 + 48));
        }
    }

    private static class TwoDigitNumberField
    implements NumberRule {
        private final int mField;

        TwoDigitNumberField(int n2) {
            this.mField = n2;
        }

        public int estimateLength() {
            return 2;
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(this.mField));
        }

        public final void appendTo(StringBuffer stringBuffer, int n2) {
            if (n2 < 100) {
                stringBuffer.append((char)(n2 / 10 + 48));
                stringBuffer.append((char)(n2 % 10 + 48));
            } else {
                stringBuffer.append(Integer.toString(n2));
            }
        }
    }

    private static class PaddedNumberField
    implements NumberRule {
        private final int mField;
        private final int mSize;

        PaddedNumberField(int n2, int n3) {
            if (n3 < 3) {
                throw new IllegalArgumentException();
            }
            this.mField = n2;
            this.mSize = n3;
        }

        public int estimateLength() {
            return 4;
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(this.mField));
        }

        public final void appendTo(StringBuffer stringBuffer, int n2) {
            if (n2 < 100) {
                int n3 = this.mSize;
                while (--n3 >= 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append((char)(n2 / 10 + 48));
                stringBuffer.append((char)(n2 % 10 + 48));
            } else {
                int n4;
                if (n2 < 1000) {
                    n4 = 3;
                } else {
                    Validate.isTrue(n2 > -1, "Negative values should not be possible", n2);
                    n4 = Integer.toString(n2).length();
                }
                int n5 = this.mSize;
                while (--n5 >= n4) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toString(n2));
            }
        }
    }

    private static class UnpaddedMonthField
    implements NumberRule {
        static final UnpaddedMonthField INSTANCE = new UnpaddedMonthField();

        UnpaddedMonthField() {
        }

        public int estimateLength() {
            return 2;
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(2) + 1);
        }

        public final void appendTo(StringBuffer stringBuffer, int n2) {
            if (n2 < 10) {
                stringBuffer.append((char)(n2 + 48));
            } else {
                stringBuffer.append((char)(n2 / 10 + 48));
                stringBuffer.append((char)(n2 % 10 + 48));
            }
        }
    }

    private static class UnpaddedNumberField
    implements NumberRule {
        private final int mField;

        UnpaddedNumberField(int n2) {
            this.mField = n2;
        }

        public int estimateLength() {
            return 4;
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(this.mField));
        }

        public final void appendTo(StringBuffer stringBuffer, int n2) {
            if (n2 < 10) {
                stringBuffer.append((char)(n2 + 48));
            } else if (n2 < 100) {
                stringBuffer.append((char)(n2 / 10 + 48));
                stringBuffer.append((char)(n2 % 10 + 48));
            } else {
                stringBuffer.append(Integer.toString(n2));
            }
        }
    }

    private static class TextField
    implements Rule {
        private final int mField;
        private final String[] mValues;

        TextField(int n2, String[] stringArray) {
            this.mField = n2;
            this.mValues = stringArray;
        }

        public int estimateLength() {
            int n2 = 0;
            int n3 = this.mValues.length;
            while (--n3 >= 0) {
                int n4 = this.mValues[n3].length();
                if (n4 <= n2) continue;
                n2 = n4;
            }
            return n2;
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            stringBuffer.append(this.mValues[calendar.get(this.mField)]);
        }
    }

    private static class StringLiteral
    implements Rule {
        private final String mValue;

        StringLiteral(String string) {
            this.mValue = string;
        }

        public int estimateLength() {
            return this.mValue.length();
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            stringBuffer.append(this.mValue);
        }
    }

    private static class CharacterLiteral
    implements Rule {
        private final char mValue;

        CharacterLiteral(char c2) {
            this.mValue = c2;
        }

        public int estimateLength() {
            return 1;
        }

        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            stringBuffer.append(this.mValue);
        }
    }

    private static interface NumberRule
    extends Rule {
        public void appendTo(StringBuffer var1, int var2);
    }

    private static interface Rule {
        public int estimateLength();

        public void appendTo(StringBuffer var1, Calendar var2);
    }
}

