/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.http.impl.execchain;

import com.contrastsecurity.thirdparty.org.apache.commons.logging.Log;
import com.contrastsecurity.thirdparty.org.apache.commons.logging.LogFactory;
import com.contrastsecurity.thirdparty.org.apache.http.ConnectionReuseStrategy;
import com.contrastsecurity.thirdparty.org.apache.http.HttpClientConnection;
import com.contrastsecurity.thirdparty.org.apache.http.HttpEntity;
import com.contrastsecurity.thirdparty.org.apache.http.HttpException;
import com.contrastsecurity.thirdparty.org.apache.http.HttpHost;
import com.contrastsecurity.thirdparty.org.apache.http.HttpRequest;
import com.contrastsecurity.thirdparty.org.apache.http.HttpResponse;
import com.contrastsecurity.thirdparty.org.apache.http.ProtocolException;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.Contract;
import com.contrastsecurity.thirdparty.org.apache.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.org.apache.http.client.config.RequestConfig;
import com.contrastsecurity.thirdparty.org.apache.http.client.methods.CloseableHttpResponse;
import com.contrastsecurity.thirdparty.org.apache.http.client.methods.HttpExecutionAware;
import com.contrastsecurity.thirdparty.org.apache.http.client.methods.HttpRequestWrapper;
import com.contrastsecurity.thirdparty.org.apache.http.client.methods.HttpUriRequest;
import com.contrastsecurity.thirdparty.org.apache.http.client.protocol.HttpClientContext;
import com.contrastsecurity.thirdparty.org.apache.http.client.protocol.RequestClientConnControl;
import com.contrastsecurity.thirdparty.org.apache.http.client.utils.URIUtils;
import com.contrastsecurity.thirdparty.org.apache.http.conn.ConnectionKeepAliveStrategy;
import com.contrastsecurity.thirdparty.org.apache.http.conn.ConnectionRequest;
import com.contrastsecurity.thirdparty.org.apache.http.conn.HttpClientConnectionManager;
import com.contrastsecurity.thirdparty.org.apache.http.conn.routing.HttpRoute;
import com.contrastsecurity.thirdparty.org.apache.http.impl.conn.ConnectionShutdownException;
import com.contrastsecurity.thirdparty.org.apache.http.impl.execchain.ClientExecChain;
import com.contrastsecurity.thirdparty.org.apache.http.impl.execchain.ConnectionHolder;
import com.contrastsecurity.thirdparty.org.apache.http.impl.execchain.HttpResponseProxy;
import com.contrastsecurity.thirdparty.org.apache.http.impl.execchain.RequestAbortedException;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpProcessor;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.HttpRequestExecutor;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.ImmutableHttpProcessor;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.RequestContent;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.RequestTargetHost;
import com.contrastsecurity.thirdparty.org.apache.http.protocol.RequestUserAgent;
import com.contrastsecurity.thirdparty.org.apache.http.util.Args;
import com.contrastsecurity.thirdparty.org.apache.http.util.VersionInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class MinimalClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor httpProcessor;

    public MinimalClientExec(HttpRequestExecutor httpRequestExecutor, HttpClientConnectionManager httpClientConnectionManager, ConnectionReuseStrategy connectionReuseStrategy, ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        Args.notNull(httpRequestExecutor, "HTTP request executor");
        Args.notNull(httpClientConnectionManager, "Client connection manager");
        Args.notNull(connectionReuseStrategy, "Connection reuse strategy");
        Args.notNull(connectionKeepAliveStrategy, "Connection keep alive strategy");
        this.httpProcessor = new ImmutableHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getUserAgent("Apache-HttpClient", "com.contrastsecurity.thirdparty.org.apache.http.client", this.getClass())));
        this.requestExecutor = httpRequestExecutor;
        this.connManager = httpClientConnectionManager;
        this.reuseStrategy = connectionReuseStrategy;
        this.keepAliveStrategy = connectionKeepAliveStrategy;
    }

    static void rewriteRequestURI(HttpRequestWrapper httpRequestWrapper, HttpRoute httpRoute, boolean bl2) throws ProtocolException {
        try {
            URI uRI = httpRequestWrapper.getURI();
            if (uRI != null) {
                uRI = uRI.isAbsolute() ? URIUtils.rewriteURI(uRI, null, bl2 ? URIUtils.DROP_FRAGMENT_AND_NORMALIZE : URIUtils.DROP_FRAGMENT) : URIUtils.rewriteURI(uRI);
                httpRequestWrapper.setURI(uRI);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid URI: " + httpRequestWrapper.getRequestLine().getUri(), uRISyntaxException);
        }
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        HttpClientConnection httpClientConnection;
        Args.notNull(httpRoute, "HTTP route");
        Args.notNull(httpRequestWrapper, "HTTP request");
        Args.notNull(httpClientContext, "HTTP context");
        MinimalClientExec.rewriteRequestURI(httpRequestWrapper, httpRoute, httpClientContext.getRequestConfig().isNormalizeUri());
        ConnectionRequest connectionRequest = this.connManager.requestConnection(httpRoute, null);
        if (httpExecutionAware != null) {
            if (httpExecutionAware.isAborted()) {
                connectionRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            httpExecutionAware.setCancellable(connectionRequest);
        }
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        try {
            int n2 = requestConfig.getConnectionRequestTimeout();
            httpClientConnection = connectionRequest.get(n2 > 0 ? (long)n2 : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable == null) {
                throwable = executionException;
            }
            throw new RequestAbortedException("Request execution failed", throwable);
        }
        ConnectionHolder connectionHolder = new ConnectionHolder(this.log, this.connManager, httpClientConnection);
        try {
            Object object;
            int n3;
            if (httpExecutionAware != null) {
                if (httpExecutionAware.isAborted()) {
                    connectionHolder.close();
                    throw new RequestAbortedException("Request aborted");
                }
                httpExecutionAware.setCancellable(connectionHolder);
            }
            if (!httpClientConnection.isOpen()) {
                n3 = requestConfig.getConnectTimeout();
                this.connManager.connect(httpClientConnection, httpRoute, n3 > 0 ? n3 : 0, httpClientContext);
                this.connManager.routeComplete(httpClientConnection, httpRoute, httpClientContext);
            }
            if ((n3 = requestConfig.getSocketTimeout()) >= 0) {
                httpClientConnection.setSocketTimeout(n3);
            }
            HttpHost httpHost = null;
            HttpRequest httpRequest = httpRequestWrapper.getOriginal();
            if (httpRequest instanceof HttpUriRequest && ((URI)(object = ((HttpUriRequest)httpRequest).getURI())).isAbsolute()) {
                httpHost = new HttpHost(((URI)object).getHost(), ((URI)object).getPort(), ((URI)object).getScheme());
            }
            if (httpHost == null) {
                httpHost = httpRoute.getTargetHost();
            }
            httpClientContext.setAttribute("http.target_host", httpHost);
            httpClientContext.setAttribute("http.request", httpRequestWrapper);
            httpClientContext.setAttribute("http.connection", httpClientConnection);
            httpClientContext.setAttribute("http.route", httpRoute);
            this.httpProcessor.process(httpRequestWrapper, (HttpContext)httpClientContext);
            object = this.requestExecutor.execute(httpRequestWrapper, httpClientConnection, httpClientContext);
            this.httpProcessor.process((HttpResponse)object, (HttpContext)httpClientContext);
            if (this.reuseStrategy.keepAlive((HttpResponse)object, httpClientContext)) {
                long l2 = this.keepAliveStrategy.getKeepAliveDuration((HttpResponse)object, httpClientContext);
                connectionHolder.setValidFor(l2, TimeUnit.MILLISECONDS);
                connectionHolder.markReusable();
            } else {
                connectionHolder.markNonReusable();
            }
            HttpEntity httpEntity = object.getEntity();
            if (httpEntity == null || !httpEntity.isStreaming()) {
                connectionHolder.releaseConnection();
                return new HttpResponseProxy((HttpResponse)object, null);
            }
            return new HttpResponseProxy((HttpResponse)object, connectionHolder);
        }
        catch (ConnectionShutdownException connectionShutdownException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("Connection has been shut down");
            interruptedIOException.initCause(connectionShutdownException);
            throw interruptedIOException;
        }
        catch (HttpException httpException) {
            connectionHolder.abortConnection();
            throw httpException;
        }
        catch (IOException iOException) {
            connectionHolder.abortConnection();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            connectionHolder.abortConnection();
            throw runtimeException;
        }
        catch (Error error) {
            this.connManager.shutdown();
            throw error;
        }
    }
}

