/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender;

import com.contrastsecurity.agent.commons.p;
import com.contrastsecurity.agent.commons.w;
import com.contrastsecurity.agent.logging.log4j2.b;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Appender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.AppenderControl;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.Log4jLogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Log4jThread;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

final class AsyncAppenderEventDispatcher
extends Log4jThread {
    private static final LogEvent STOP_EVENT = new Log4jLogEvent().toImmutable();
    private static final LogEvent END_OF_BATCH_EVENT;
    private static final AtomicLong THREAD_COUNTER;
    private static final Logger LOGGER;
    private final AppenderControl errorAppender;
    private final List<AppenderControl> appenders;
    private final BlockingQueue<LogEvent> queue;
    private final AtomicBoolean stoppedRef;
    private final boolean useStandardLog4jBatching;
    private final long batchTimeoutMs;

    AsyncAppenderEventDispatcher(String string, AppenderControl appenderControl, List<AppenderControl> list, BlockingQueue<LogEvent> blockingQueue) {
        super("AsyncAppenderEventDispatcher-" + THREAD_COUNTER.incrementAndGet() + "-" + string);
        this.setDaemon(true);
        this.errorAppender = appenderControl;
        this.appenders = list;
        this.queue = blockingQueue;
        this.stoppedRef = new AtomicBoolean();
        b b2 = null;
        for (AppenderControl appenderControl2 : list) {
            if (!(appenderControl2.getAppender() instanceof b)) continue;
            b2 = (b)appenderControl2.getAppender();
            break;
        }
        if (b2 == null) {
            this.useStandardLog4jBatching = true;
            this.batchTimeoutMs = -1L;
            return;
        }
        p.a(list.size() == 1, "Cannot have more than one appender in the background thread when using BatchTimeout.");
        this.useStandardLog4jBatching = false;
        long l2 = b2.batchTimeoutMs();
        p.a(l2 > 0L, "batchTimeoutMs must be a positive integer.");
        this.batchTimeoutMs = l2;
    }

    List<Appender> getAppenders() {
        return this.appenders.stream().map(AppenderControl::getAppender).collect(Collectors.toList());
    }

    @Override
    public void run() {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        AsyncAppenderEventDispatcher asyncAppenderEventDispatcher = this;
        try {
            LOGGER.trace("{} has started.", (Object)asyncAppenderEventDispatcher.getName());
            asyncAppenderEventDispatcher.dispatchAll();
            asyncAppenderEventDispatcher.dispatchRemaining();
            asyncAppenderEventDispatcher = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (asyncAppenderEventDispatcher != null) {
            throw asyncAppenderEventDispatcher;
        }
    }

    private void dispatchAll() {
        while (!this.stoppedRef.get()) {
            LogEvent logEvent;
            try {
                logEvent = this.useStandardLog4jBatching ? this.queue.take() : this.queue.poll(this.batchTimeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
                break;
            }
            if (logEvent == STOP_EVENT) break;
            if (this.useStandardLog4jBatching && this.queue.isEmpty()) {
                logEvent.setEndOfBatch(true);
            } else if (logEvent == null) {
                logEvent = END_OF_BATCH_EVENT;
            }
            this.dispatch(logEvent);
        }
        LOGGER.trace("{} has stopped.", (Object)this.getName());
    }

    private void dispatchRemaining() {
        int n2 = 0;
        while (true) {
            LogEvent logEvent;
            if ((logEvent = (LogEvent)this.queue.poll()) == null) {
                if (this.useStandardLog4jBatching) break;
                this.dispatch(END_OF_BATCH_EVENT);
                break;
            }
            if (logEvent == STOP_EVENT) continue;
            if (this.useStandardLog4jBatching && this.queue.isEmpty()) {
                logEvent.setEndOfBatch(true);
            }
            this.dispatch(logEvent);
            ++n2;
        }
        LOGGER.trace("{} has processed the last {} remaining event(s).", (Object)this.getName(), (Object)n2);
    }

    void dispatch(LogEvent logEvent) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.appenders.size(); ++i2) {
            AppenderControl appenderControl = this.appenders.get(i2);
            try {
                appenderControl.callAppender(logEvent);
                bl2 = true;
                continue;
            }
            catch (Throwable throwable) {
                w.a(throwable);
                LOGGER.trace("{} has failed to call appender {}", (Object)this.getName(), (Object)appenderControl.getAppenderName(), (Object)throwable);
            }
        }
        if (!bl2 && this.errorAppender != null) {
            try {
                this.errorAppender.callAppender(logEvent);
            }
            catch (Throwable throwable) {
                w.a(throwable);
                LOGGER.trace("{} has failed to call the error appender {}", (Object)this.getName(), (Object)this.errorAppender.getAppenderName(), (Object)throwable);
            }
        }
    }

    void stop(long l2) throws InterruptedException {
        boolean bl2 = this.stoppedRef.compareAndSet(false, true);
        if (bl2) {
            LOGGER.trace("{} is signaled to stop.", (Object)this.getName());
        }
        while (Thread.State.NEW.equals((Object)this.getState())) {
        }
        boolean bl3 = this.queue.offer(STOP_EVENT);
        if (!bl3) {
            this.interrupt();
        }
        this.join(l2);
    }

    static {
        Log4jLogEvent log4jLogEvent = new Log4jLogEvent();
        log4jLogEvent.setEndOfBatch(true);
        END_OF_BATCH_EVENT = log4jLogEvent.toImmutable();
        THREAD_COUNTER = new AtomicLong(0L);
        LOGGER = StatusLogger.getLogger();
    }
}

