/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;

public final class GzCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8192;
    private final File source;
    private final File destination;
    private final boolean deleteSource;
    private final int compressionLevel;

    public GzCompressAction(File file, File file2, boolean bl2, int n2) {
        Objects.requireNonNull(file, "source");
        Objects.requireNonNull(file2, "destination");
        this.source = file;
        this.destination = file2;
        this.deleteSource = bl2;
        this.compressionLevel = n2;
    }

    @Deprecated
    public GzCompressAction(File file, File file2, boolean bl2) {
        this(file, file2, bl2, -1);
    }

    @Override
    public boolean execute() throws IOException {
        return GzCompressAction.execute(this.source, this.destination, this.deleteSource, this.compressionLevel);
    }

    @Deprecated
    public static boolean execute(File file, File file2, boolean bl2) throws IOException {
        return GzCompressAction.execute(file, file2, bl2, -1);
    }

    public static boolean execute(File file, File file2, boolean bl2, int n2) throws IOException {
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 FileOutputStream fileOutputStream = new FileOutputStream(file2);
                 ConfigurableLevelGZIPOutputStream configurableLevelGZIPOutputStream = new ConfigurableLevelGZIPOutputStream((OutputStream)fileOutputStream, 8192, n2);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(configurableLevelGZIPOutputStream, 8192);){
                int n3;
                byte[] byArray = new byte[8192];
                while ((n3 = fileInputStream.read(byArray)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n3);
                }
            }
            if (bl2 && !file.delete()) {
                LOGGER.warn("Unable to delete {}.", (Object)file);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void reportException(Exception exception) {
        LOGGER.warn("Exception during compression of '" + this.source.toString() + "'.", (Throwable)exception);
    }

    public String toString() {
        return GzCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }

    private static final class ConfigurableLevelGZIPOutputStream
    extends GZIPOutputStream {
        ConfigurableLevelGZIPOutputStream(OutputStream outputStream, int n2, int n3) throws IOException {
            super(outputStream, n2);
            this.def.setLevel(n3);
        }
    }
}

