/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.AbstractLifeCycle;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.CronScheduledFuture;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.CronExpression;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Log4jThreadFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConfigurationScheduler
extends AbstractLifeCycle {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String SIMPLE_NAME = "Log4j2 " + ConfigurationScheduler.class.getSimpleName();
    private static final int MAX_SCHEDULED_ITEMS = 5;
    private volatile ScheduledExecutorService executorService;
    private int scheduledItems = 0;
    private final String name;

    public ConfigurationScheduler() {
        this(SIMPLE_NAME);
    }

    public ConfigurationScheduler(String string) {
        this.name = string;
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        if (this.isExecutorServiceSet()) {
            LOGGER.debug("{} shutting down threads in {}", (Object)this.name, (Object)this.getExecutorService());
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(l2, timeUnit);
            }
            catch (InterruptedException interruptedException) {
                this.executorService.shutdownNow();
                try {
                    this.executorService.awaitTermination(l2, timeUnit);
                }
                catch (InterruptedException interruptedException2) {
                    LOGGER.warn("{} stopped but some scheduled services may not have completed.", (Object)this.name);
                }
                Thread.currentThread().interrupt();
            }
        }
        this.setStopped();
        return true;
    }

    public boolean isExecutorServiceSet() {
        return this.executorService != null;
    }

    public void incrementScheduledItems() {
        if (this.isExecutorServiceSet()) {
            LOGGER.error("{} attempted to increment scheduled items after start", (Object)this.name);
        } else {
            ++this.scheduledItems;
        }
    }

    public void decrementScheduledItems() {
        if (!this.isStarted() && this.scheduledItems > 0) {
            --this.scheduledItems;
        }
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l2, TimeUnit timeUnit) {
        return this.getExecutorService().schedule(callable, l2, timeUnit);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        return this.getExecutorService().schedule(runnable, l2, timeUnit);
    }

    public CronScheduledFuture<?> scheduleWithCron(CronExpression cronExpression, Runnable runnable) {
        return this.scheduleWithCron(cronExpression, new Date(), runnable);
    }

    public CronScheduledFuture<?> scheduleWithCron(CronExpression cronExpression, Date date, Runnable runnable) {
        Date date2 = cronExpression.getNextValidTimeAfter(date == null ? new Date() : date);
        CronRunnable cronRunnable = new CronRunnable(runnable, cronExpression);
        ScheduledFuture<?> scheduledFuture = this.schedule(cronRunnable, this.nextFireInterval(date2), TimeUnit.MILLISECONDS);
        CronScheduledFuture cronScheduledFuture = new CronScheduledFuture(scheduledFuture, date2);
        cronRunnable.setScheduledFuture(cronScheduledFuture);
        LOGGER.debug("{} scheduled cron expression {} to fire at {}", (Object)this.name, (Object)cronExpression.getCronExpression(), (Object)date2);
        return cronScheduledFuture;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.getExecutorService().scheduleAtFixedRate(runnable, l2, l3, timeUnit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return this.getExecutorService().scheduleWithFixedDelay(runnable, l2, l3, timeUnit);
    }

    public long nextFireInterval(Date date) {
        return date.getTime() - new Date().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            ConfigurationScheduler configurationScheduler = this;
            synchronized (configurationScheduler) {
                if (this.executorService == null) {
                    if (this.scheduledItems > 0) {
                        LOGGER.debug("{} starting {} threads", (Object)this.name, (Object)this.scheduledItems);
                        this.scheduledItems = Math.min(this.scheduledItems, 5);
                        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(this.scheduledItems, Log4jThreadFactory.createDaemonThreadFactory("Scheduled"));
                        scheduledThreadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
                        scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                        this.executorService = scheduledThreadPoolExecutor;
                    } else {
                        LOGGER.debug("{}: No scheduled items", (Object)this.name);
                    }
                }
            }
        }
        return this.executorService;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ConfigurationScheduler [name=");
        stringBuilder.append(this.name);
        stringBuilder.append(", [");
        if (this.executorService != null) {
            BlockingQueue<Runnable> blockingQueue = ((ScheduledThreadPoolExecutor)this.executorService).getQueue();
            boolean bl2 = true;
            for (Runnable runnable : blockingQueue) {
                if (!bl2) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(runnable.toString());
                bl2 = false;
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public class CronRunnable
    implements Runnable {
        private final CronExpression cronExpression;
        private final Runnable runnable;
        private CronScheduledFuture<?> scheduledFuture;

        public CronRunnable(Runnable runnable, CronExpression cronExpression) {
            this.cronExpression = cronExpression;
            this.runnable = runnable;
        }

        public void setScheduledFuture(CronScheduledFuture<?> cronScheduledFuture) {
            this.scheduledFuture = cronScheduledFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long l2 = this.scheduledFuture.getFireTime().getTime() - System.currentTimeMillis();
                if (l2 > 0L) {
                    LOGGER.debug("{} Cron thread woke up {} millis early. Sleeping", (Object)ConfigurationScheduler.this.name, (Object)l2);
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.runnable.run();
            }
            catch (Throwable throwable) {
                LOGGER.error("{} caught error running command", (Object)ConfigurationScheduler.this.name, (Object)throwable);
            }
            finally {
                Date date = this.cronExpression.getNextValidTimeAfter(new Date());
                ScheduledFuture<?> scheduledFuture = ConfigurationScheduler.this.schedule(this, ConfigurationScheduler.this.nextFireInterval(date), TimeUnit.MILLISECONDS);
                LOGGER.debug("{} Cron expression {} scheduled to fire again at {}", (Object)ConfigurationScheduler.this.name, (Object)this.cronExpression.getCronExpression(), (Object)date);
                this.scheduledFuture.reset(scheduledFuture, date);
            }
        }

        public String toString() {
            return "CronRunnable{" + this.cronExpression.getCronExpression() + " - " + this.scheduledFuture.getFireTime();
        }
    }
}

