/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.convert;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Constants;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.LoaderUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Base64Converter {
    private static final Logger LOGGER;
    private static Method method;
    private static Object decoder;

    public static byte[] parseBase64Binary(String string) {
        if (method == null) {
            LOGGER.error("No base64 converter");
        } else {
            try {
                return (byte[])method.invoke(decoder, string);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                LOGGER.error("Error decoding string - " + reflectiveOperationException.getMessage());
            }
        }
        return Constants.EMPTY_BYTE_ARRAY;
    }

    static {
        Class<?> clazz;
        LOGGER = StatusLogger.getLogger();
        method = null;
        decoder = null;
        try {
            clazz = LoaderUtil.loadClass("java.util.Base64");
            Method method = clazz.getMethod("getDecoder", null);
            decoder = method.invoke(null, (Object[])null);
            clazz = decoder.getClass();
            Base64Converter.method = clazz.getMethod("decode", String.class);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        if (method == null) {
            try {
                clazz = LoaderUtil.loadClass("javax.xml.bind.DatatypeConverter");
                method = clazz.getMethod("parseBase64Binary", String.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.error("No Base64 Converter is available");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

