/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.processor;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;

public class PluginCache {
    private final Map<String, Map<String, PluginEntry>> categories = new TreeMap<String, Map<String, PluginEntry>>();

    public Map<String, Map<String, PluginEntry>> getAllCategories() {
        return this.categories;
    }

    public Map<String, PluginEntry> getCategory(String string2) {
        String string3 = string2.toLowerCase();
        return this.categories.computeIfAbsent(string3, string -> new TreeMap());
    }

    public void writeCache(OutputStream outputStream) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));){
            dataOutputStream.writeInt(this.categories.size());
            for (Map.Entry<String, Map<String, PluginEntry>> entry : this.categories.entrySet()) {
                dataOutputStream.writeUTF(entry.getKey());
                Map<String, PluginEntry> map = entry.getValue();
                dataOutputStream.writeInt(map.size());
                for (Map.Entry<String, PluginEntry> entry2 : map.entrySet()) {
                    PluginEntry pluginEntry = entry2.getValue();
                    dataOutputStream.writeUTF(pluginEntry.getKey());
                    dataOutputStream.writeUTF(pluginEntry.getClassName());
                    dataOutputStream.writeUTF(pluginEntry.getName());
                    dataOutputStream.writeBoolean(pluginEntry.isPrintable());
                    dataOutputStream.writeBoolean(pluginEntry.isDefer());
                }
            }
        }
    }

    public void loadCacheFiles(Enumeration<URL> enumeration) throws IOException {
        this.categories.clear();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRL.openStream()));
            Throwable throwable = null;
            try {
                int n2 = dataInputStream.readInt();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = dataInputStream.readUTF();
                    Map<String, PluginEntry> map = this.getCategory(string);
                    int n3 = dataInputStream.readInt();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        String string2 = dataInputStream.readUTF();
                        String string3 = dataInputStream.readUTF();
                        String string5 = dataInputStream.readUTF();
                        boolean bl2 = dataInputStream.readBoolean();
                        boolean bl3 = dataInputStream.readBoolean();
                        map.computeIfAbsent(string2, string4 -> {
                            PluginEntry pluginEntry = new PluginEntry();
                            pluginEntry.setKey((String)string4);
                            pluginEntry.setClassName(string3);
                            pluginEntry.setName(string5);
                            pluginEntry.setPrintable(bl2);
                            pluginEntry.setDefer(bl3);
                            pluginEntry.setCategory(string);
                            return pluginEntry;
                        });
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataInputStream == null) continue;
                if (throwable != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataInputStream.close();
            }
        }
    }

    public int size() {
        return this.categories.size();
    }
}

