/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LifeCycle;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LoggerContext;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.AbstractConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.ConfigurationSource;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.DefaultConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.ContextAnchor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.selector.ClassLoaderContextSelector;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.selector.ContextSelector;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Cancellable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Constants;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.DefaultShutdownCallbackRegistry;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.LoggerContextFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Log4jContextFactory
implements ShutdownCallbackRegistry,
LoggerContextFactory {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final boolean SHUTDOWN_HOOK_ENABLED = PropertiesUtil.getProperties().getBooleanProperty("com.contrastsecurity.thirdparty.log4j.shutdownHookEnabled", true) && !Constants.IS_WEB_APP;
    private final ContextSelector selector;
    private final ShutdownCallbackRegistry shutdownCallbackRegistry;

    public Log4jContextFactory() {
        this(Log4jContextFactory.createContextSelector(), Log4jContextFactory.createShutdownCallbackRegistry());
    }

    public Log4jContextFactory(ContextSelector contextSelector) {
        this(contextSelector, Log4jContextFactory.createShutdownCallbackRegistry());
    }

    public Log4jContextFactory(ShutdownCallbackRegistry shutdownCallbackRegistry) {
        this(Log4jContextFactory.createContextSelector(), shutdownCallbackRegistry);
    }

    public Log4jContextFactory(ContextSelector contextSelector, ShutdownCallbackRegistry shutdownCallbackRegistry) {
        this.selector = Objects.requireNonNull(contextSelector, "No ContextSelector provided");
        this.shutdownCallbackRegistry = Objects.requireNonNull(shutdownCallbackRegistry, "No ShutdownCallbackRegistry provided");
        LOGGER.debug("Using ShutdownCallbackRegistry {}", (Object)shutdownCallbackRegistry.getClass());
        this.initializeShutdownCallbackRegistry();
    }

    private static ContextSelector createContextSelector() {
        try {
            ContextSelector contextSelector = Loader.newCheckedInstanceOfProperty("Log4jContextSelector", ContextSelector.class);
            if (contextSelector != null) {
                return contextSelector;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to create custom ContextSelector. Falling back to default.", (Throwable)exception);
        }
        return new ClassLoaderContextSelector();
    }

    private static ShutdownCallbackRegistry createShutdownCallbackRegistry() {
        try {
            ShutdownCallbackRegistry shutdownCallbackRegistry = Loader.newCheckedInstanceOfProperty("com.contrastsecurity.thirdparty.log4j.shutdownCallbackRegistry", ShutdownCallbackRegistry.class);
            if (shutdownCallbackRegistry != null) {
                return shutdownCallbackRegistry;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to create custom ShutdownCallbackRegistry. Falling back to default.", (Throwable)exception);
        }
        return new DefaultShutdownCallbackRegistry();
    }

    private void initializeShutdownCallbackRegistry() {
        if (this.isShutdownHookEnabled() && this.shutdownCallbackRegistry instanceof LifeCycle) {
            try {
                ((LifeCycle)((Object)this.shutdownCallbackRegistry)).start();
            }
            catch (IllegalStateException illegalStateException) {
                LOGGER.error("Cannot start ShutdownCallbackRegistry, already shutting down.");
                throw illegalStateException;
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("There was an error starting the ShutdownCallbackRegistry.", (Throwable)runtimeException);
            }
        }
    }

    @Override
    public LoggerContext getContext(String string, ClassLoader classLoader, Object object, boolean bl2) {
        LoggerContext loggerContext = this.selector.getContext(string, classLoader, bl2);
        if (object != null && loggerContext.getExternalContext() == null) {
            loggerContext.setExternalContext(object);
        }
        if (loggerContext.getState() == LifeCycle.State.INITIALIZED) {
            loggerContext.start();
        }
        return loggerContext;
    }

    public LoggerContext getContext(String string, ClassLoader classLoader, Object object, boolean bl2, ConfigurationSource configurationSource) {
        LoggerContext loggerContext = this.selector.getContext(string, classLoader, bl2, null);
        if (object != null && loggerContext.getExternalContext() == null) {
            loggerContext.setExternalContext(object);
        }
        if (loggerContext.getState() == LifeCycle.State.INITIALIZED) {
            if (configurationSource != null) {
                ContextAnchor.THREAD_CONTEXT.set(loggerContext);
                Configuration configuration = ConfigurationFactory.getInstance().getConfiguration(loggerContext, configurationSource);
                LOGGER.debug("Starting LoggerContext[name={}] from configuration {}", (Object)loggerContext.getName(), (Object)configurationSource);
                loggerContext.start(configuration);
                ContextAnchor.THREAD_CONTEXT.remove();
            } else {
                loggerContext.start();
            }
        }
        return loggerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggerContext getContext(String string, ClassLoader classLoader, Object object, boolean bl2, Configuration configuration) {
        LoggerContext loggerContext = this.selector.getContext(string, classLoader, bl2, null);
        if (object != null && loggerContext.getExternalContext() == null) {
            loggerContext.setExternalContext(object);
        }
        if (loggerContext.getState() == LifeCycle.State.INITIALIZED) {
            ContextAnchor.THREAD_CONTEXT.set(loggerContext);
            try {
                loggerContext.start(configuration);
            }
            finally {
                ContextAnchor.THREAD_CONTEXT.remove();
            }
        }
        return loggerContext;
    }

    @Override
    public LoggerContext getContext(String string, ClassLoader classLoader, Object object, boolean bl2, URI uRI, String string2) {
        LoggerContext loggerContext = this.selector.getContext(string, classLoader, bl2, uRI);
        if (object != null && loggerContext.getExternalContext() == null) {
            loggerContext.setExternalContext(object);
        }
        if (string2 != null) {
            loggerContext.setName(string2);
        }
        if (loggerContext.getState() == LifeCycle.State.INITIALIZED) {
            if (uRI != null || string2 != null) {
                ContextAnchor.THREAD_CONTEXT.set(loggerContext);
                Configuration configuration = ConfigurationFactory.getInstance().getConfiguration(loggerContext, string2, uRI);
                LOGGER.debug("Starting LoggerContext[name={}] from configuration at {}", (Object)loggerContext.getName(), (Object)uRI);
                loggerContext.start(configuration);
                ContextAnchor.THREAD_CONTEXT.remove();
            } else {
                loggerContext.start();
            }
        }
        return loggerContext;
    }

    public LoggerContext getContext(String string, ClassLoader classLoader, Map.Entry<String, Object> entry, boolean bl2, URI uRI, String string2) {
        LoggerContext loggerContext = this.selector.getContext(string, classLoader, entry, bl2, uRI);
        if (string2 != null) {
            loggerContext.setName(string2);
        }
        if (loggerContext.getState() == LifeCycle.State.INITIALIZED) {
            if (uRI != null || string2 != null) {
                ContextAnchor.THREAD_CONTEXT.set(loggerContext);
                Configuration configuration = ConfigurationFactory.getInstance().getConfiguration(loggerContext, string2, uRI);
                LOGGER.debug("Starting LoggerContext[name={}] from configuration at {}", (Object)loggerContext.getName(), (Object)uRI);
                loggerContext.start(configuration);
                ContextAnchor.THREAD_CONTEXT.remove();
            } else {
                loggerContext.start();
            }
        }
        return loggerContext;
    }

    public LoggerContext getContext(String string, ClassLoader classLoader, Object object, boolean bl2, List<URI> list, String string2) {
        LoggerContext loggerContext = this.selector.getContext(string, classLoader, bl2, null);
        if (object != null && loggerContext.getExternalContext() == null) {
            loggerContext.setExternalContext(object);
        }
        if (string2 != null) {
            loggerContext.setName(string2);
        }
        if (loggerContext.getState() == LifeCycle.State.INITIALIZED) {
            if (list != null && !list.isEmpty()) {
                Object object2;
                ContextAnchor.THREAD_CONTEXT.set(loggerContext);
                ArrayList<AbstractConfiguration> arrayList = new ArrayList<AbstractConfiguration>(list.size());
                for (URI uRI : list) {
                    Configuration configuration = ConfigurationFactory.getInstance().getConfiguration(loggerContext, string2, uRI);
                    if (configuration != null) {
                        if (configuration instanceof DefaultConfiguration) {
                            LOGGER.warn("Unable to locate configuration {}, ignoring", (Object)uRI.toString());
                            continue;
                        }
                        if (configuration instanceof AbstractConfiguration) {
                            arrayList.add((AbstractConfiguration)configuration);
                            continue;
                        }
                        LOGGER.error("Found configuration {}, which is not an AbstractConfiguration and can't be handled by CompositeConfiguration", (Object)uRI);
                        continue;
                    }
                    LOGGER.info("Unable to access configuration {}, ignoring", (Object)uRI.toString());
                }
                if (arrayList.isEmpty()) {
                    LOGGER.error("No configurations could be created for {}", (Object)list.toString());
                } else if (arrayList.size() == 1) {
                    object2 = (AbstractConfiguration)arrayList.get(0);
                    LOGGER.debug("Starting LoggerContext[name={}] from configuration at {}", (Object)loggerContext.getName(), (Object)((AbstractConfiguration)object2).getConfigurationSource().getLocation());
                    loggerContext.start((Configuration)object2);
                } else {
                    object2 = new CompositeConfiguration(arrayList);
                    LOGGER.debug("Starting LoggerContext[name={}] from configurations at {}", (Object)loggerContext.getName(), (Object)list);
                    loggerContext.start((Configuration)object2);
                }
                ContextAnchor.THREAD_CONTEXT.remove();
            } else {
                loggerContext.start();
            }
        }
        return loggerContext;
    }

    @Override
    public void shutdown(String string, ClassLoader classLoader, boolean bl2, boolean bl3) {
        if (this.selector.hasContext(string, classLoader, bl2)) {
            this.selector.shutdown(string, classLoader, bl2, bl3);
        }
    }

    @Override
    public boolean hasContext(String string, ClassLoader classLoader, boolean bl2) {
        return this.selector.hasContext(string, classLoader, bl2);
    }

    public ContextSelector getSelector() {
        return this.selector;
    }

    public ShutdownCallbackRegistry getShutdownCallbackRegistry() {
        return this.shutdownCallbackRegistry;
    }

    @Override
    public void removeContext(com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.LoggerContext loggerContext) {
        if (loggerContext instanceof LoggerContext) {
            this.selector.removeContext((LoggerContext)loggerContext);
        }
    }

    @Override
    public boolean isClassLoaderDependent() {
        return this.selector.isClassLoaderDependent();
    }

    @Override
    public Cancellable addShutdownCallback(Runnable runnable) {
        return this.isShutdownHookEnabled() ? this.shutdownCallbackRegistry.addShutdownCallback(runnable) : null;
    }

    public boolean isShutdownHookEnabled() {
        return SHUTDOWN_HOOK_ENABLED;
    }
}

