/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.JAnsiTextRenderer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.PlainTextRenderer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.TextRenderer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Loader;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Patterns;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public final class ThrowableFormatOptions {
    private static final int DEFAULT_LINES = Integer.MAX_VALUE;
    protected static final ThrowableFormatOptions DEFAULT = new ThrowableFormatOptions();
    private static final String FULL = "full";
    private static final String NONE = "none";
    private static final String SHORT = "short";
    private final TextRenderer textRenderer;
    private final int lines;
    private final String separator;
    private final String suffix;
    private final List<String> ignorePackages;
    public static final String CLASS_NAME = "short.className";
    public static final String METHOD_NAME = "short.methodName";
    public static final String LINE_NUMBER = "short.lineNumber";
    public static final String FILE_NAME = "short.fileName";
    public static final String MESSAGE = "short.message";
    public static final String LOCALIZED_MESSAGE = "short.localizedMessage";

    protected ThrowableFormatOptions(int n2, String string, List<String> list, TextRenderer textRenderer, String string2) {
        this.lines = n2;
        this.separator = string == null ? Strings.LINE_SEPARATOR : string;
        this.ignorePackages = list;
        this.textRenderer = textRenderer == null ? PlainTextRenderer.getInstance() : textRenderer;
        this.suffix = string2;
    }

    protected ThrowableFormatOptions(List<String> list) {
        this(Integer.MAX_VALUE, null, list, null, null);
    }

    protected ThrowableFormatOptions() {
        this(Integer.MAX_VALUE, null, null, null, null);
    }

    public int getLines() {
        return this.lines;
    }

    public String getSeparator() {
        return this.separator;
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public List<String> getIgnorePackages() {
        return this.ignorePackages;
    }

    public boolean allLines() {
        return this.lines == Integer.MAX_VALUE;
    }

    public boolean anyLines() {
        return this.lines > 0;
    }

    public int minLines(int n2) {
        return this.lines > n2 ? n2 : this.lines;
    }

    public boolean hasPackages() {
        return this.ignorePackages != null && !this.ignorePackages.isEmpty();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{').append(this.allLines() ? FULL : (this.lines == 2 ? SHORT : (this.anyLines() ? String.valueOf(this.lines) : NONE))).append('}');
        stringBuilder.append("{separator(").append(this.separator).append(")}");
        if (this.hasPackages()) {
            stringBuilder.append("{filters(");
            for (String string : this.ignorePackages) {
                stringBuilder.append(string).append(',');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append(")}");
        }
        return stringBuilder.toString();
    }

    public static ThrowableFormatOptions newInstance(String[] stringArray) {
        Object object;
        ArrayList<String> arrayList;
        String string;
        if (stringArray == null || stringArray.length == 0) {
            return DEFAULT;
        }
        if (stringArray.length == 1 && Strings.isNotEmpty(stringArray[0])) {
            String[] stringArray2 = stringArray[0].split(Patterns.COMMA_SEPARATOR, 2);
            string = stringArray2[0].trim();
            arrayList = new Scanner(string);
            object = null;
            try {
                if (stringArray2.length > 1 && (string.equalsIgnoreCase(FULL) || string.equalsIgnoreCase(SHORT) || string.equalsIgnoreCase(NONE) || ((Scanner)((Object)arrayList)).hasNextInt())) {
                    stringArray = new String[]{string, stringArray2[1].trim()};
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (arrayList != null) {
                    if (object != null) {
                        try {
                            ((Scanner)((Object)arrayList)).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((Scanner)((Object)arrayList)).close();
                    }
                }
            }
        }
        int n2 = ThrowableFormatOptions.DEFAULT.lines;
        string = ThrowableFormatOptions.DEFAULT.separator;
        arrayList = ThrowableFormatOptions.DEFAULT.ignorePackages;
        object = ThrowableFormatOptions.DEFAULT.textRenderer;
        String string2 = DEFAULT.getSuffix();
        for (String string3 : stringArray) {
            String string4;
            String string5;
            if (string3 == null || (string5 = string3.trim()).isEmpty()) continue;
            if (string5.startsWith("separator(") && string5.endsWith(")")) {
                string = string5.substring("separator(".length(), string5.length() - 1);
                continue;
            }
            if (string5.startsWith("filters(") && string5.endsWith(")")) {
                String[] stringArray3;
                string4 = string5.substring("filters(".length(), string5.length() - 1);
                if (string4.length() <= 0 || (stringArray3 = string4.split(Patterns.COMMA_SEPARATOR)).length <= 0) continue;
                arrayList = new ArrayList<String>(stringArray3.length);
                for (String string6 : stringArray3) {
                    if ((string6 = string6.trim()).length() <= 0) continue;
                    arrayList.add(string6);
                }
                continue;
            }
            if (string5.equalsIgnoreCase(NONE)) {
                n2 = 0;
                continue;
            }
            if (string5.equalsIgnoreCase(SHORT) || string5.equalsIgnoreCase(CLASS_NAME) || string5.equalsIgnoreCase(METHOD_NAME) || string5.equalsIgnoreCase(LINE_NUMBER) || string5.equalsIgnoreCase(FILE_NAME) || string5.equalsIgnoreCase(MESSAGE) || string5.equalsIgnoreCase(LOCALIZED_MESSAGE)) {
                n2 = 2;
                continue;
            }
            if (string5.startsWith("ansi(") && string5.endsWith(")") || string5.equals("ansi")) {
                if (Loader.isJansiAvailable()) {
                    string4 = string5.equals("ansi") ? "" : string5.substring("ansi(".length(), string5.length() - 1);
                    object = new JAnsiTextRenderer(new String[]{null, string4}, JAnsiTextRenderer.DefaultExceptionStyleMap);
                    continue;
                }
                StatusLogger.getLogger().warn("You requested ANSI exception rendering but JANSI is not on the classpath. Please see https://logging.apache.org/log4j/2.x/runtime-dependencies.html");
                continue;
            }
            if (string5.startsWith("S(") && string5.endsWith(")")) {
                string2 = string5.substring("S(".length(), string5.length() - 1);
                continue;
            }
            if (string5.startsWith("suffix(") && string5.endsWith(")")) {
                string2 = string5.substring("suffix(".length(), string5.length() - 1);
                continue;
            }
            if (string5.equalsIgnoreCase(FULL)) continue;
            n2 = Integers.parseInt(string5);
        }
        return new ThrowableFormatOptions(n2, string, (List<String>)arrayList, (TextRenderer)object, string2);
    }

    public String getSuffix() {
        return this.suffix;
    }
}

