/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Level;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.AbstractLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.AbstractStringLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.ByteBufferDestination;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.Encoder;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.PatternSelector;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.internal.ExcludeChecker;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.internal.IncludeChecker;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.internal.ListChecker;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.lookup.StrSubstitutor;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.Severity;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.JsonUtils;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.KeyValuePair;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.NetUtils;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Patterns;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.message.MapMessage;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.StringBuilderFormattable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.TriConsumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

@Plugin(name="GelfLayout", category="Core", elementType="layout", printObject=true)
public final class GelfLayout
extends AbstractStringLayout {
    private static final char C = ',';
    private static final int COMPRESSION_THRESHOLD = 1024;
    private static final char Q = '\"';
    private static final String QC = "\",";
    private static final String QU = "\"_";
    private final KeyValuePair[] additionalFields;
    private final int compressionThreshold;
    private final CompressionType compressionType;
    private final String host;
    private final boolean includeStacktrace;
    private final boolean includeThreadContext;
    private final boolean includeMapMessage;
    private final boolean includeNullDelimiter;
    private final boolean includeNewLineDelimiter;
    private final boolean omitEmptyFields;
    private final PatternLayout layout;
    private final FieldWriter mdcWriter;
    private final FieldWriter mapWriter;
    private static final ThreadLocal<StringBuilder> messageStringBuilder = new ThreadLocal();
    private static final ThreadLocal<StringBuilder> timestampStringBuilder = new ThreadLocal();

    @Deprecated
    public GelfLayout(String string, KeyValuePair[] keyValuePairArray, CompressionType compressionType, int n2, boolean bl2) {
        this(null, string, keyValuePairArray, compressionType, n2, bl2, true, true, false, false, false, null, null, null, "", "");
    }

    private GelfLayout(Configuration configuration, String string, KeyValuePair[] keyValuePairArray, CompressionType compressionType, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, ListChecker listChecker, ListChecker listChecker2, PatternLayout patternLayout, String string2, String string3) {
        super(configuration, StandardCharsets.UTF_8, null, null);
        this.host = string != null ? string : NetUtils.getLocalHostname();
        KeyValuePair[] keyValuePairArray2 = this.additionalFields = keyValuePairArray != null ? keyValuePairArray : KeyValuePair.EMPTY_ARRAY;
        if (configuration == null) {
            for (KeyValuePair keyValuePair : this.additionalFields) {
                if (!GelfLayout.valueNeedsLookup(keyValuePair.getValue())) continue;
                throw new IllegalArgumentException("configuration needs to be set when there are additional fields with variables");
            }
        }
        this.compressionType = compressionType;
        this.compressionThreshold = n2;
        this.includeStacktrace = bl2;
        this.includeThreadContext = bl3;
        this.includeMapMessage = bl4;
        this.includeNullDelimiter = bl5;
        this.includeNewLineDelimiter = bl6;
        this.omitEmptyFields = bl7;
        if (bl5 && compressionType != CompressionType.OFF) {
            throw new IllegalArgumentException("null delimiter cannot be used with compression");
        }
        this.mdcWriter = new FieldWriter(listChecker, string2);
        this.mapWriter = new FieldWriter(listChecker2, string3);
        this.layout = patternLayout;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("host=").append(this.host);
        stringBuilder.append(", compressionType=").append(this.compressionType.toString());
        stringBuilder.append(", compressionThreshold=").append(this.compressionThreshold);
        stringBuilder.append(", includeStackTrace=").append(this.includeStacktrace);
        stringBuilder.append(", includeThreadContext=").append(this.includeThreadContext);
        stringBuilder.append(", includeNullDelimiter=").append(this.includeNullDelimiter);
        stringBuilder.append(", includeNewLineDelimiter=").append(this.includeNewLineDelimiter);
        String string2 = this.mdcWriter.getChecker().toString();
        if (string2.length() > 0) {
            stringBuilder.append(", ").append(string2);
        }
        if ((string = this.mapWriter.getChecker().toString()).length() > 0) {
            stringBuilder.append(", ").append(string);
        }
        if (this.layout != null) {
            stringBuilder.append(", PatternLayout{").append(this.layout.toString()).append("}");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static GelfLayout createLayout(@PluginAttribute(value="host") String string, @PluginElement(value="AdditionalField") KeyValuePair[] keyValuePairArray, @PluginAttribute(value="compressionType", defaultString="GZIP") CompressionType compressionType, @PluginAttribute(value="compressionThreshold", defaultInt=1024) int n2, @PluginAttribute(value="includeStacktrace", defaultBoolean=true) boolean bl2) {
        return new GelfLayout(null, string, keyValuePairArray, compressionType, n2, bl2, true, true, false, false, false, null, null, null, "", "");
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    @Override
    public Map<String, String> getContentFormat() {
        return Collections.emptyMap();
    }

    @Override
    public String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    @Override
    public byte[] toByteArray(LogEvent logEvent) {
        StringBuilder stringBuilder = this.toText(logEvent, GelfLayout.getStringBuilder(), false);
        byte[] byArray = this.getBytes(stringBuilder.toString());
        return this.compressionType != CompressionType.OFF && byArray.length > this.compressionThreshold ? this.compress(byArray) : byArray;
    }

    @Override
    public void encode(LogEvent logEvent, ByteBufferDestination byteBufferDestination) {
        if (this.compressionType != CompressionType.OFF) {
            super.encode(logEvent, byteBufferDestination);
            return;
        }
        StringBuilder stringBuilder = this.toText(logEvent, GelfLayout.getStringBuilder(), true);
        Encoder<StringBuilder> encoder = this.getStringBuilderEncoder();
        encoder.encode(stringBuilder, byteBufferDestination);
    }

    @Override
    public boolean requiresLocation() {
        return Objects.nonNull(this.layout) && this.layout.requiresLocation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] compress(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.compressionThreshold / 8);
            try (DeflaterOutputStream deflaterOutputStream = this.compressionType.createDeflaterOutputStream(byteArrayOutputStream);){
                if (deflaterOutputStream == null) {
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.finish();
                return byteArrayOutputStream.toByteArray();
            }
        }
        catch (IOException iOException) {
            StatusLogger.getLogger().error(iOException);
            return byArray;
        }
    }

    @Override
    public String toSerializable(LogEvent logEvent) {
        StringBuilder stringBuilder = this.toText(logEvent, GelfLayout.getStringBuilder(), false);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder toText(LogEvent logEvent, StringBuilder stringBuilder, boolean bl2) {
        Object object2;
        stringBuilder.append('{');
        stringBuilder.append("\"version\":\"1.1\",");
        stringBuilder.append("\"host\":\"");
        JsonUtils.quoteAsString(GelfLayout.toNullSafeString(this.host), stringBuilder);
        stringBuilder.append(QC);
        stringBuilder.append("\"timestamp\":").append(GelfLayout.formatTimestamp(logEvent.getTimeMillis())).append(',');
        stringBuilder.append("\"level\":").append(this.formatLevel(logEvent.getLevel())).append(',');
        if (logEvent.getThreadName() != null) {
            stringBuilder.append("\"_thread\":\"");
            JsonUtils.quoteAsString(logEvent.getThreadName(), stringBuilder);
            stringBuilder.append(QC);
        }
        if (logEvent.getLoggerName() != null) {
            stringBuilder.append("\"_logger\":\"");
            JsonUtils.quoteAsString(logEvent.getLoggerName(), stringBuilder);
            stringBuilder.append(QC);
        }
        if (this.additionalFields.length > 0) {
            object2 = this.getConfiguration().getStrSubstitutor();
            for (KeyValuePair keyValuePair : this.additionalFields) {
                String string2;
                String string3 = string2 = GelfLayout.valueNeedsLookup(keyValuePair.getValue()) ? ((StrSubstitutor)object2).replace(logEvent, keyValuePair.getValue()) : keyValuePair.getValue();
                if (!Strings.isNotEmpty(string2) && this.omitEmptyFields) continue;
                stringBuilder.append(QU);
                JsonUtils.quoteAsString(keyValuePair.getKey(), stringBuilder);
                stringBuilder.append("\":\"");
                JsonUtils.quoteAsString(GelfLayout.toNullSafeString(string2), stringBuilder);
                stringBuilder.append(QC);
            }
        }
        if (this.includeThreadContext) {
            logEvent.getContextData().forEach(this.mdcWriter, stringBuilder);
        }
        if (this.includeMapMessage && logEvent.getMessage() instanceof MapMessage) {
            ((MapMessage)logEvent.getMessage()).forEach((string, object) -> this.mapWriter.accept((String)string, object, stringBuilder));
        }
        if (logEvent.getThrown() != null || this.layout != null) {
            stringBuilder.append("\"full_message\":\"");
            if (this.layout != null) {
                object2 = GelfLayout.getMessageStringBuilder();
                this.layout.serialize(logEvent, (StringBuilder)object2);
                JsonUtils.quoteAsString((CharSequence)object2, stringBuilder);
            } else if (this.includeStacktrace) {
                JsonUtils.quoteAsString(GelfLayout.formatThrowable(logEvent.getThrown()), stringBuilder);
            } else {
                JsonUtils.quoteAsString(logEvent.getThrown().toString(), stringBuilder);
            }
            stringBuilder.append(QC);
        }
        stringBuilder.append("\"short_message\":\"");
        object2 = logEvent.getMessage();
        if (object2 instanceof CharSequence) {
            JsonUtils.quoteAsString((CharSequence)object2, stringBuilder);
        } else if (bl2 && object2 instanceof StringBuilderFormattable) {
            StringBuilder stringBuilder2 = GelfLayout.getMessageStringBuilder();
            try {
                ((StringBuilderFormattable)object2).formatTo(stringBuilder2);
                JsonUtils.quoteAsString(stringBuilder2, stringBuilder);
            }
            finally {
                GelfLayout.trimToMaxSize(stringBuilder2);
            }
        } else {
            JsonUtils.quoteAsString(GelfLayout.toNullSafeString(object2.getFormattedMessage()), stringBuilder);
        }
        stringBuilder.append('\"');
        stringBuilder.append('}');
        if (this.includeNullDelimiter) {
            stringBuilder.append('\u0000');
        }
        if (this.includeNewLineDelimiter) {
            stringBuilder.append('\n');
        }
        return stringBuilder;
    }

    private static boolean valueNeedsLookup(String string) {
        return string != null && string.contains("${");
    }

    private static StringBuilder getMessageStringBuilder() {
        StringBuilder stringBuilder = messageStringBuilder.get();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(1024);
            messageStringBuilder.set(stringBuilder);
        }
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    private static CharSequence toNullSafeString(CharSequence charSequence) {
        return charSequence == null ? "" : charSequence;
    }

    static CharSequence formatTimestamp(long l2) {
        if (l2 < 1000L) {
            return "0";
        }
        StringBuilder stringBuilder = GelfLayout.getTimestampStringBuilder();
        stringBuilder.append(l2);
        stringBuilder.insert(stringBuilder.length() - 3, '.');
        return stringBuilder;
    }

    private static StringBuilder getTimestampStringBuilder() {
        StringBuilder stringBuilder = timestampStringBuilder.get();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(20);
            timestampStringBuilder.set(stringBuilder);
        }
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    private int formatLevel(Level level) {
        return Severity.getSeverity(level).getCode();
    }

    static CharSequence formatThrowable(Throwable throwable) {
        StringWriter stringWriter = new StringWriter(2048);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.getBuffer();
    }

    private class FieldWriter
    implements TriConsumer<String, Object, StringBuilder> {
        private final ListChecker checker;
        private final String prefix;

        FieldWriter(ListChecker listChecker, String string) {
            this.checker = listChecker;
            this.prefix = string;
        }

        @Override
        public void accept(String string, Object object, StringBuilder stringBuilder) {
            String string2 = String.valueOf(object);
            if (this.checker.check(string) && (Strings.isNotEmpty(string2) || !GelfLayout.this.omitEmptyFields)) {
                stringBuilder.append(GelfLayout.QU);
                JsonUtils.quoteAsString(Strings.concat(this.prefix, string), stringBuilder);
                stringBuilder.append("\":\"");
                JsonUtils.quoteAsString(GelfLayout.toNullSafeString(string2), stringBuilder);
                stringBuilder.append(GelfLayout.QC);
            }
        }

        public ListChecker getChecker() {
            return this.checker;
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractStringLayout.Builder<B>
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<GelfLayout> {
        @PluginBuilderAttribute
        private String host;
        @PluginElement(value="AdditionalField")
        private KeyValuePair[] additionalFields;
        @PluginBuilderAttribute
        private CompressionType compressionType = CompressionType.GZIP;
        @PluginBuilderAttribute
        private int compressionThreshold = 1024;
        @PluginBuilderAttribute
        private boolean includeStacktrace = true;
        @PluginBuilderAttribute
        private boolean includeThreadContext = true;
        @PluginBuilderAttribute
        private boolean includeNullDelimiter;
        @PluginBuilderAttribute
        private boolean includeNewLineDelimiter;
        @PluginBuilderAttribute
        private String threadContextIncludes;
        @PluginBuilderAttribute
        private String threadContextExcludes;
        @PluginBuilderAttribute
        private String mapMessageIncludes;
        @PluginBuilderAttribute
        private String mapMessageExcludes;
        @PluginBuilderAttribute
        private boolean includeMapMessage = true;
        @PluginBuilderAttribute
        private boolean omitEmptyFields;
        @PluginBuilderAttribute
        private String messagePattern;
        @PluginBuilderAttribute
        private String threadContextPrefix = "";
        @PluginBuilderAttribute
        private String mapPrefix = "";
        @PluginElement(value="PatternSelector")
        private PatternSelector patternSelector;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        @Override
        public GelfLayout build() {
            ListChecker listChecker = this.createChecker(this.threadContextExcludes, this.threadContextIncludes);
            ListChecker listChecker2 = this.createChecker(this.mapMessageExcludes, this.mapMessageIncludes);
            PatternLayout patternLayout = null;
            if (this.messagePattern != null && this.patternSelector != null) {
                AbstractLayout.LOGGER.error("A message pattern and PatternSelector cannot both be specified on GelfLayout, ignoring message pattern");
                this.messagePattern = null;
            }
            if (this.messagePattern != null) {
                patternLayout = PatternLayout.newBuilder().withPattern(this.messagePattern).withAlwaysWriteExceptions(this.includeStacktrace).withConfiguration(this.getConfiguration()).build();
            }
            if (this.patternSelector != null) {
                patternLayout = PatternLayout.newBuilder().withPatternSelector(this.patternSelector).withAlwaysWriteExceptions(this.includeStacktrace).withConfiguration(this.getConfiguration()).build();
            }
            return new GelfLayout(this.getConfiguration(), this.host, this.additionalFields, this.compressionType, this.compressionThreshold, this.includeStacktrace, this.includeThreadContext, this.includeMapMessage, this.includeNullDelimiter, this.includeNewLineDelimiter, this.omitEmptyFields, listChecker, listChecker2, patternLayout, this.threadContextPrefix, this.mapPrefix);
        }

        private ListChecker createChecker(String string, String string2) {
            ArrayList<String> arrayList;
            String[] stringArray;
            ListChecker listChecker = null;
            if (string != null && (stringArray = string.split(Patterns.COMMA_SEPARATOR)).length > 0) {
                arrayList = new ArrayList<String>(stringArray.length);
                for (String string3 : stringArray) {
                    arrayList.add(string3.trim());
                }
                listChecker = new ExcludeChecker(arrayList);
            }
            if (string2 != null && (stringArray = string2.split(Patterns.COMMA_SEPARATOR)).length > 0) {
                arrayList = new ArrayList(stringArray.length);
                for (String string3 : stringArray) {
                    arrayList.add(string3.trim());
                }
                listChecker = new IncludeChecker(arrayList);
            }
            if (listChecker == null) {
                listChecker = ListChecker.NOOP_CHECKER;
            }
            return listChecker;
        }

        public String getHost() {
            return this.host;
        }

        public CompressionType getCompressionType() {
            return this.compressionType;
        }

        public int getCompressionThreshold() {
            return this.compressionThreshold;
        }

        public boolean isIncludeStacktrace() {
            return this.includeStacktrace;
        }

        public boolean isIncludeThreadContext() {
            return this.includeThreadContext;
        }

        public boolean isIncludeNullDelimiter() {
            return this.includeNullDelimiter;
        }

        public boolean isIncludeNewLineDelimiter() {
            return this.includeNewLineDelimiter;
        }

        public KeyValuePair[] getAdditionalFields() {
            return this.additionalFields;
        }

        public B setHost(String string) {
            this.host = string;
            return (B)((Builder)this.asBuilder());
        }

        public B setCompressionType(CompressionType compressionType) {
            this.compressionType = compressionType;
            return (B)((Builder)this.asBuilder());
        }

        public B setCompressionThreshold(int n2) {
            this.compressionThreshold = n2;
            return (B)((Builder)this.asBuilder());
        }

        public B setIncludeStacktrace(boolean bl2) {
            this.includeStacktrace = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setIncludeThreadContext(boolean bl2) {
            this.includeThreadContext = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setIncludeNullDelimiter(boolean bl2) {
            this.includeNullDelimiter = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setIncludeNewLineDelimiter(boolean bl2) {
            this.includeNewLineDelimiter = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setAdditionalFields(KeyValuePair[] keyValuePairArray) {
            this.additionalFields = keyValuePairArray;
            return (B)((Builder)this.asBuilder());
        }

        public B setMessagePattern(String string) {
            this.messagePattern = string;
            return (B)((Builder)this.asBuilder());
        }

        public B setPatternSelector(PatternSelector patternSelector) {
            this.patternSelector = patternSelector;
            return (B)((Builder)this.asBuilder());
        }

        public B setMdcIncludes(String string) {
            this.threadContextIncludes = string;
            return (B)((Builder)this.asBuilder());
        }

        public B setMdcExcludes(String string) {
            this.threadContextExcludes = string;
            return (B)((Builder)this.asBuilder());
        }

        public B setIncludeMapMessage(boolean bl2) {
            this.includeMapMessage = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setMapMessageIncludes(String string) {
            this.mapMessageIncludes = string;
            return (B)((Builder)this.asBuilder());
        }

        public B setMapMessageExcludes(String string) {
            this.mapMessageExcludes = string;
            return (B)((Builder)this.asBuilder());
        }

        public B setThreadContextPrefix(String string) {
            if (string != null) {
                this.threadContextPrefix = string;
            }
            return (B)((Builder)this.asBuilder());
        }

        public B setMapPrefix(String string) {
            if (string != null) {
                this.mapPrefix = string;
            }
            return (B)((Builder)this.asBuilder());
        }
    }

    public static enum CompressionType {
        GZIP{

            @Override
            public DeflaterOutputStream createDeflaterOutputStream(OutputStream outputStream) throws IOException {
                return new GZIPOutputStream(outputStream);
            }
        }
        ,
        ZLIB{

            @Override
            public DeflaterOutputStream createDeflaterOutputStream(OutputStream outputStream) throws IOException {
                return new DeflaterOutputStream(outputStream);
            }
        }
        ,
        OFF{

            @Override
            public DeflaterOutputStream createDeflaterOutputStream(OutputStream outputStream) throws IOException {
                return null;
            }
        };


        public abstract DeflaterOutputStream createDeflaterOutputStream(OutputStream var1) throws IOException;
    }
}

