/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.impl.LocationAware;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.AbstractStringLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.ByteBufferDestination;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.Encoder;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.PatternSelector;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.FormattingInfo;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.PatternFormatter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.PatternParser;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.RegexReplacement;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Plugin(name="PatternLayout", category="Core", elementType="layout", printObject=true)
public final class PatternLayout
extends AbstractStringLayout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %notEmpty{%x }- %m%n";
    public static final String SIMPLE_CONVERSION_PATTERN = "%d [%t] %p %c - %m%n";
    public static final String KEY = "Converter";
    private final String conversionPattern;
    private final PatternSelector patternSelector;
    private final AbstractStringLayout.Serializer eventSerializer;

    private PatternLayout(Configuration configuration, RegexReplacement regexReplacement, String string, PatternSelector patternSelector, Charset charset, boolean bl2, boolean bl3, boolean bl4, String string2, String string3) {
        super(configuration, charset, PatternLayout.newSerializerBuilder().setConfiguration(configuration).setReplace(regexReplacement).setPatternSelector(patternSelector).setAlwaysWriteExceptions(bl2).setDisableAnsi(bl3).setNoConsoleNoAnsi(bl4).setPattern(string2).build(), PatternLayout.newSerializerBuilder().setConfiguration(configuration).setReplace(regexReplacement).setPatternSelector(patternSelector).setAlwaysWriteExceptions(bl2).setDisableAnsi(bl3).setNoConsoleNoAnsi(bl4).setPattern(string3).build());
        this.conversionPattern = string;
        this.patternSelector = patternSelector;
        this.eventSerializer = PatternLayout.newSerializerBuilder().setConfiguration(configuration).setReplace(regexReplacement).setPatternSelector(patternSelector).setAlwaysWriteExceptions(bl2).setDisableAnsi(bl3).setNoConsoleNoAnsi(bl4).setPattern(string).setDefaultPattern(DEFAULT_CONVERSION_PATTERN).build();
    }

    public static SerializerBuilder newSerializerBuilder() {
        return new SerializerBuilder();
    }

    @Override
    public boolean requiresLocation() {
        return this.eventSerializer instanceof LocationAware && ((LocationAware)((Object)this.eventSerializer)).requiresLocation();
    }

    @Deprecated
    public static AbstractStringLayout.Serializer createSerializer(Configuration configuration, RegexReplacement regexReplacement, String string, String string2, PatternSelector patternSelector, boolean bl2, boolean bl3) {
        SerializerBuilder serializerBuilder = PatternLayout.newSerializerBuilder();
        serializerBuilder.setAlwaysWriteExceptions(bl2);
        serializerBuilder.setConfiguration(configuration);
        serializerBuilder.setDefaultPattern(string2);
        serializerBuilder.setNoConsoleNoAnsi(bl3);
        serializerBuilder.setPattern(string);
        serializerBuilder.setPatternSelector(patternSelector);
        serializerBuilder.setReplace(regexReplacement);
        return serializerBuilder.build();
    }

    public String getConversionPattern() {
        return this.conversionPattern;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("structured", "false");
        hashMap.put("formatType", "conversion");
        hashMap.put("format", this.conversionPattern);
        return hashMap;
    }

    @Override
    public String toSerializable(LogEvent logEvent) {
        return this.eventSerializer.toSerializable(logEvent);
    }

    public void serialize(LogEvent logEvent, StringBuilder stringBuilder) {
        this.eventSerializer.toSerializable(logEvent, stringBuilder);
    }

    @Override
    public void encode(LogEvent logEvent, ByteBufferDestination byteBufferDestination) {
        StringBuilder stringBuilder = this.toText(this.eventSerializer, logEvent, PatternLayout.getStringBuilder());
        Encoder<StringBuilder> encoder = this.getStringBuilderEncoder();
        encoder.encode(stringBuilder, byteBufferDestination);
        PatternLayout.trimToMaxSize(stringBuilder);
    }

    private StringBuilder toText(AbstractStringLayout.Serializer2 serializer2, LogEvent logEvent, StringBuilder stringBuilder) {
        return serializer2.toSerializable(logEvent, stringBuilder);
    }

    public static PatternParser createPatternParser(Configuration configuration) {
        if (configuration == null) {
            return new PatternParser(configuration, KEY, LogEventPatternConverter.class);
        }
        PatternParser patternParser = (PatternParser)configuration.getComponent(KEY);
        if (patternParser == null) {
            patternParser = new PatternParser(configuration, KEY, LogEventPatternConverter.class);
            configuration.addComponent(KEY, patternParser);
            patternParser = (PatternParser)configuration.getComponent(KEY);
        }
        return patternParser;
    }

    public String toString() {
        return this.patternSelector == null ? this.conversionPattern : this.patternSelector.toString();
    }

    @PluginFactory
    @Deprecated
    public static PatternLayout createLayout(@PluginAttribute(value="pattern", defaultString="%m%n") String string, @PluginElement(value="PatternSelector") PatternSelector patternSelector, @PluginConfiguration Configuration configuration, @PluginElement(value="Replace") RegexReplacement regexReplacement, @PluginAttribute(value="charset") Charset charset, @PluginAttribute(value="alwaysWriteExceptions", defaultBoolean=true) boolean bl2, @PluginAttribute(value="noConsoleNoAnsi") boolean bl3, @PluginAttribute(value="header") String string2, @PluginAttribute(value="footer") String string3) {
        return PatternLayout.newBuilder().withPattern(string).withPatternSelector(patternSelector).withConfiguration(configuration).withRegexReplacement(regexReplacement).withCharset(charset).withAlwaysWriteExceptions(bl2).withNoConsoleNoAnsi(bl3).withHeader(string2).withFooter(string3).build();
    }

    public static PatternLayout createDefaultLayout() {
        return PatternLayout.newBuilder().build();
    }

    public static PatternLayout createDefaultLayout(Configuration configuration) {
        return PatternLayout.newBuilder().withConfiguration(configuration).build();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public AbstractStringLayout.Serializer getEventSerializer() {
        return this.eventSerializer;
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<PatternLayout> {
        @PluginBuilderAttribute
        private String pattern = "%m%n";
        @PluginElement(value="PatternSelector")
        private PatternSelector patternSelector;
        @PluginConfiguration
        private Configuration configuration;
        @PluginElement(value="Replace")
        private RegexReplacement regexReplacement;
        @PluginBuilderAttribute
        private Charset charset = Charset.defaultCharset();
        @PluginBuilderAttribute
        private boolean alwaysWriteExceptions = true;
        @PluginBuilderAttribute
        private boolean disableAnsi = !this.useAnsiEscapeCodes();
        @PluginBuilderAttribute
        private boolean noConsoleNoAnsi;
        @PluginBuilderAttribute
        private String header;
        @PluginBuilderAttribute
        private String footer;

        private Builder() {
        }

        private boolean useAnsiEscapeCodes() {
            PropertiesUtil propertiesUtil = PropertiesUtil.getProperties();
            boolean bl2 = !propertiesUtil.isOsWindows();
            boolean bl3 = !propertiesUtil.getBooleanProperty("com.contrastsecurity.thirdparty.log4j.skipJansi", true);
            return bl2 || bl3;
        }

        public Builder withPattern(String string) {
            this.pattern = string;
            return this;
        }

        public Builder withPatternSelector(PatternSelector patternSelector) {
            this.patternSelector = patternSelector;
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder withRegexReplacement(RegexReplacement regexReplacement) {
            this.regexReplacement = regexReplacement;
            return this;
        }

        public Builder withCharset(Charset charset) {
            if (charset != null) {
                this.charset = charset;
            }
            return this;
        }

        public Builder withAlwaysWriteExceptions(boolean bl2) {
            this.alwaysWriteExceptions = bl2;
            return this;
        }

        public Builder withDisableAnsi(boolean bl2) {
            this.disableAnsi = bl2;
            return this;
        }

        public Builder withNoConsoleNoAnsi(boolean bl2) {
            this.noConsoleNoAnsi = bl2;
            return this;
        }

        public Builder withHeader(String string) {
            this.header = string;
            return this;
        }

        public Builder withFooter(String string) {
            this.footer = string;
            return this;
        }

        @Override
        public PatternLayout build() {
            return new PatternLayout(this.configuration, this.regexReplacement, this.pattern, this.patternSelector, this.charset, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi, this.header, this.footer);
        }
    }

    private static final class PatternSelectorSerializer
    implements LocationAware,
    AbstractStringLayout.Serializer {
        private final PatternSelector patternSelector;
        private final RegexReplacement replace;

        private PatternSelectorSerializer(PatternSelector patternSelector, RegexReplacement regexReplacement) {
            this.patternSelector = patternSelector;
            this.replace = regexReplacement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toSerializable(LogEvent logEvent) {
            StringBuilder stringBuilder = AbstractStringLayout.getStringBuilder();
            try {
                String string = this.toSerializable(logEvent, stringBuilder).toString();
                return string;
            }
            finally {
                AbstractStringLayout.trimToMaxSize(stringBuilder);
            }
        }

        @Override
        public StringBuilder toSerializable(LogEvent logEvent, StringBuilder stringBuilder) {
            for (PatternFormatter patternFormatter : this.patternSelector.getFormatters(logEvent)) {
                patternFormatter.format(logEvent, stringBuilder);
            }
            if (this.replace != null) {
                String string2 = stringBuilder.toString();
                string2 = this.replace.format(string2);
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
            }
            return stringBuilder;
        }

        @Override
        public boolean requiresLocation() {
            return this.patternSelector instanceof LocationAware && ((LocationAware)((Object)this.patternSelector)).requiresLocation();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.toString());
            stringBuilder.append("[patternSelector=");
            stringBuilder.append(this.patternSelector);
            stringBuilder.append(", replace=");
            stringBuilder.append(this.replace);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static class SerializerBuilder
    implements com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder<AbstractStringLayout.Serializer> {
        private Configuration configuration;
        private RegexReplacement replace;
        private String pattern;
        private String defaultPattern;
        private PatternSelector patternSelector;
        private boolean alwaysWriteExceptions;
        private boolean disableAnsi;
        private boolean noConsoleNoAnsi;

        @Override
        public AbstractStringLayout.Serializer build() {
            if (Strings.isEmpty(this.pattern) && Strings.isEmpty(this.defaultPattern)) {
                return null;
            }
            if (this.patternSelector == null) {
                try {
                    PatternParser patternParser = PatternLayout.createPatternParser(this.configuration);
                    List<PatternFormatter> list = patternParser.parse(this.pattern == null ? this.defaultPattern : this.pattern, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi);
                    PatternFormatter[] patternFormatterArray = list.toArray(PatternFormatter.EMPTY_ARRAY);
                    boolean bl2 = false;
                    for (PatternFormatter patternFormatter : patternFormatterArray) {
                        FormattingInfo formattingInfo = patternFormatter.getFormattingInfo();
                        if (formattingInfo == null || formattingInfo == FormattingInfo.getDefault()) continue;
                        bl2 = true;
                        break;
                    }
                    PatternSerializer patternSerializer = bl2 ? new PatternFormatterPatternSerializer(patternFormatterArray) : new NoFormatPatternSerializer(patternFormatterArray);
                    return this.replace == null ? patternSerializer : new PatternSerializerWithReplacement(patternSerializer, this.replace);
                }
                catch (RuntimeException runtimeException) {
                    throw new IllegalArgumentException("Cannot parse pattern '" + this.pattern + "'", runtimeException);
                }
            }
            return new PatternSelectorSerializer(this.patternSelector, this.replace);
        }

        public SerializerBuilder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public SerializerBuilder setReplace(RegexReplacement regexReplacement) {
            this.replace = regexReplacement;
            return this;
        }

        public SerializerBuilder setPattern(String string) {
            this.pattern = string;
            return this;
        }

        public SerializerBuilder setDefaultPattern(String string) {
            this.defaultPattern = string;
            return this;
        }

        public SerializerBuilder setPatternSelector(PatternSelector patternSelector) {
            this.patternSelector = patternSelector;
            return this;
        }

        public SerializerBuilder setAlwaysWriteExceptions(boolean bl2) {
            this.alwaysWriteExceptions = bl2;
            return this;
        }

        public SerializerBuilder setDisableAnsi(boolean bl2) {
            this.disableAnsi = bl2;
            return this;
        }

        public SerializerBuilder setNoConsoleNoAnsi(boolean bl2) {
            this.noConsoleNoAnsi = bl2;
            return this;
        }
    }

    private static final class PatternSerializerWithReplacement
    implements LocationAware,
    AbstractStringLayout.Serializer {
        private final PatternSerializer delegate;
        private final RegexReplacement replace;

        private PatternSerializerWithReplacement(PatternSerializer patternSerializer, RegexReplacement regexReplacement) {
            this.delegate = patternSerializer;
            this.replace = regexReplacement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toSerializable(LogEvent logEvent) {
            StringBuilder stringBuilder = AbstractStringLayout.getStringBuilder();
            try {
                String string = this.toSerializable(logEvent, stringBuilder).toString();
                return string;
            }
            finally {
                AbstractStringLayout.trimToMaxSize(stringBuilder);
            }
        }

        @Override
        public StringBuilder toSerializable(LogEvent logEvent, StringBuilder stringBuilder) {
            StringBuilder stringBuilder2 = this.delegate.toSerializable(logEvent, stringBuilder);
            String string = stringBuilder2.toString();
            string = this.replace.format(string);
            stringBuilder2.setLength(0);
            stringBuilder2.append(string);
            return stringBuilder2;
        }

        @Override
        public boolean requiresLocation() {
            return this.delegate.requiresLocation();
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + ", replace=" + this.replace + "]";
        }
    }

    private static final class PatternFormatterPatternSerializer
    implements PatternSerializer {
        private final PatternFormatter[] formatters;

        private PatternFormatterPatternSerializer(PatternFormatter[] patternFormatterArray) {
            this.formatters = patternFormatterArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toSerializable(LogEvent logEvent) {
            StringBuilder stringBuilder = AbstractStringLayout.getStringBuilder();
            try {
                String string = this.toSerializable(logEvent, stringBuilder).toString();
                return string;
            }
            finally {
                AbstractStringLayout.trimToMaxSize(stringBuilder);
            }
        }

        @Override
        public StringBuilder toSerializable(LogEvent logEvent, StringBuilder stringBuilder) {
            for (PatternFormatter patternFormatter : this.formatters) {
                patternFormatter.format(logEvent, stringBuilder);
            }
            return stringBuilder;
        }

        @Override
        public boolean requiresLocation() {
            for (PatternFormatter patternFormatter : this.formatters) {
                if (!patternFormatter.requiresLocation()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return super.toString() + "[formatters=" + Arrays.toString(this.formatters) + "]";
        }
    }

    private static final class NoFormatPatternSerializer
    implements PatternSerializer {
        private final LogEventPatternConverter[] converters;

        private NoFormatPatternSerializer(PatternFormatter[] patternFormatterArray) {
            this.converters = new LogEventPatternConverter[patternFormatterArray.length];
            for (int i2 = 0; i2 < patternFormatterArray.length; ++i2) {
                this.converters[i2] = patternFormatterArray[i2].getConverter();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toSerializable(LogEvent logEvent) {
            StringBuilder stringBuilder = AbstractStringLayout.getStringBuilder();
            try {
                String string = this.toSerializable(logEvent, stringBuilder).toString();
                return string;
            }
            finally {
                AbstractStringLayout.trimToMaxSize(stringBuilder);
            }
        }

        @Override
        public StringBuilder toSerializable(LogEvent logEvent, StringBuilder stringBuilder) {
            for (LogEventPatternConverter logEventPatternConverter : this.converters) {
                logEventPatternConverter.format(logEvent, stringBuilder);
            }
            return stringBuilder;
        }

        @Override
        public boolean requiresLocation() {
            for (LogEventPatternConverter logEventPatternConverter : this.converters) {
                if (!(logEventPatternConverter instanceof LocationAware) || !((LocationAware)((Object)logEventPatternConverter)).requiresLocation()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return super.toString() + "[converters=" + Arrays.toString(this.converters) + "]";
        }
    }

    private static interface PatternSerializer
    extends LocationAware,
    AbstractStringLayout.Serializer {
    }
}

