/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.LoggingException;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.AbstractStringLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.MailManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.MailManagerFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.MimeMessageBuilder;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.CyclicBuffer;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.NetUtils;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import javax.net.ssl.SSLSocketFactory;

public class SmtpManager
extends MailManager {
    public static final SMTPManagerFactory FACTORY = new SMTPManagerFactory();
    private final Session session;
    private final CyclicBuffer<LogEvent> buffer;
    private volatile MimeMessage message;
    private final MailManager.FactoryData data;

    private static MimeMessage createMimeMessage(MailManager.FactoryData factoryData, Session session, LogEvent logEvent) throws MessagingException {
        return new MimeMessageBuilder(session).setFrom(factoryData.getFrom()).setReplyTo(factoryData.getReplyTo()).setRecipients(Message.RecipientType.TO, factoryData.getTo()).setRecipients(Message.RecipientType.CC, factoryData.getCc()).setRecipients(Message.RecipientType.BCC, factoryData.getBcc()).setSubject(factoryData.getSubjectSerializer().toSerializable(logEvent)).build();
    }

    protected SmtpManager(String string, Session session, MimeMessage mimeMessage, MailManager.FactoryData factoryData) {
        super(null, string);
        this.session = session;
        this.message = mimeMessage;
        this.data = factoryData;
        this.buffer = new CyclicBuffer<LogEvent>(LogEvent.class, factoryData.getBufferSize());
    }

    @Override
    public void add(LogEvent logEvent) {
        this.buffer.add(logEvent.toImmutable());
    }

    @Deprecated
    public static SmtpManager getSmtpManager(Configuration configuration, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n2, String string9, String string10, boolean bl2, String string11, int n3, SslConfiguration sslConfiguration) {
        AbstractStringLayout.Serializer serializer = PatternLayout.newSerializerBuilder().setConfiguration(configuration).setPattern(string6).build();
        MailManager.FactoryData factoryData = new MailManager.FactoryData(string, string2, string3, string4, string5, string6, serializer, string7, string8, n2, string9, string10, bl2, n3, sslConfiguration, string11);
        return (SmtpManager)SmtpManager.getManager(factoryData.getManagerName(), FACTORY, factoryData);
    }

    @Override
    public void sendEvents(Layout<?> layout, LogEvent logEvent) {
        if (this.message == null) {
            this.connect(logEvent);
        }
        try {
            LogEvent[] logEventArray = this.removeAllBufferedEvents();
            byte[] byArray = this.formatContentToBytes(logEventArray, logEvent, layout);
            String string = layout.getContentType();
            String string2 = this.getEncoding(byArray, string);
            byte[] byArray2 = this.encodeContentToBytes(byArray, string2);
            InternetHeaders internetHeaders = this.getHeaders(string, string2);
            MimeMultipart mimeMultipart = this.getMimeMultipart(byArray2, internetHeaders);
            String string3 = this.data.getSubjectSerializer().toSerializable(logEvent);
            this.sendMultipartMessage(this.message, mimeMultipart, string3);
        }
        catch (IOException | RuntimeException | MessagingException throwable) {
            this.logError("Caught exception while sending e-mail notification.", throwable);
            throw new LoggingException("Error occurred while sending email", throwable);
        }
    }

    LogEvent[] removeAllBufferedEvents() {
        return this.buffer.removeAll();
    }

    protected byte[] formatContentToBytes(LogEvent[] logEventArray, LogEvent logEvent, Layout<?> layout) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeContent(logEventArray, logEvent, layout, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeContent(LogEvent[] logEventArray, LogEvent logEvent, Layout<?> layout, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        this.writeHeader(layout, byteArrayOutputStream);
        this.writeBuffer(logEventArray, logEvent, layout, byteArrayOutputStream);
        this.writeFooter(layout, byteArrayOutputStream);
    }

    protected void writeHeader(Layout<?> layout, OutputStream outputStream) throws IOException {
        byte[] byArray = layout.getHeader();
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    protected void writeBuffer(LogEvent[] logEventArray, LogEvent logEvent, Layout<?> layout, OutputStream outputStream) throws IOException {
        for (LogEvent logEvent2 : logEventArray) {
            byte[] byArray = layout.toByteArray(logEvent2);
            outputStream.write(byArray);
        }
        byte[] byArray = layout.toByteArray(logEvent);
        outputStream.write(byArray);
    }

    protected void writeFooter(Layout<?> layout, OutputStream outputStream) throws IOException {
        byte[] byArray = layout.getFooter();
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    protected String getEncoding(byte[] byArray, String string) {
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byArray, string);
        return MimeUtility.getEncoding((DataSource)byteArrayDataSource);
    }

    protected byte[] encodeContentToBytes(byte[] byArray, String string) throws MessagingException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encodeContent(byArray, string, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void encodeContent(byte[] byArray, String string, ByteArrayOutputStream byteArrayOutputStream) throws MessagingException, IOException {
        try (OutputStream outputStream = MimeUtility.encode((OutputStream)byteArrayOutputStream, (String)string);){
            outputStream.write(byArray);
        }
    }

    protected InternetHeaders getHeaders(String string, String string2) {
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.setHeader("Content-Type", string + "; charset=UTF-8");
        internetHeaders.setHeader("Content-Transfer-Encoding", string2);
        return internetHeaders;
    }

    protected MimeMultipart getMimeMultipart(byte[] byArray, InternetHeaders internetHeaders) throws MessagingException {
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart(internetHeaders, byArray);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        return mimeMultipart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void sendMultipartMessage(MimeMessage mimeMessage, MimeMultipart mimeMultipart) throws MessagingException {
        MimeMessage mimeMessage2 = mimeMessage;
        synchronized (mimeMessage2) {
            mimeMessage.setContent((Multipart)mimeMultipart);
            mimeMessage.setSentDate(new Date());
            Transport.send((Message)mimeMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMultipartMessage(MimeMessage mimeMessage, MimeMultipart mimeMultipart, String string) throws MessagingException {
        MimeMessage mimeMessage2 = mimeMessage;
        synchronized (mimeMessage2) {
            mimeMessage.setContent((Multipart)mimeMultipart);
            mimeMessage.setSentDate(new Date());
            mimeMessage.setSubject(string);
            Transport.send((Message)mimeMessage);
        }
    }

    private synchronized void connect(LogEvent logEvent) {
        if (this.message != null) {
            return;
        }
        try {
            this.message = SmtpManager.createMimeMessage(this.data, this.session, logEvent);
        }
        catch (MessagingException messagingException) {
            this.logError("Could not set SmtpAppender message options", messagingException);
            this.message = null;
        }
    }

    public static class SMTPManagerFactory
    implements MailManagerFactory {
        @Override
        public SmtpManager createManager(String string, MailManager.FactoryData factoryData) {
            SslConfiguration sslConfiguration;
            Authenticator authenticator;
            String string2;
            String string3 = factoryData.getSmtpProtocol();
            String string4 = "mail." + string3;
            Properties properties = PropertiesUtil.getSystemProperties();
            properties.setProperty("mail.transport.protocol", string3);
            if (properties.getProperty("mail.host") == null) {
                properties.setProperty("mail.host", NetUtils.getLocalHostname());
            }
            if (null != (string2 = factoryData.getSmtpHost())) {
                properties.setProperty(string4 + ".host", string2);
            }
            if (factoryData.getSmtpPort() > 0) {
                properties.setProperty(string4 + ".port", String.valueOf(factoryData.getSmtpPort()));
            }
            if (null != (authenticator = this.buildAuthenticator(factoryData.getSmtpUsername(), factoryData.getSmtpPassword()))) {
                properties.setProperty(string4 + ".auth", "true");
            }
            if (string3.equals("smtps") && (sslConfiguration = factoryData.getSslConfiguration()) != null) {
                SSLSocketFactory sSLSocketFactory = sslConfiguration.getSslSocketFactory();
                properties.put(string4 + ".ssl.socketFactory", sSLSocketFactory);
                properties.setProperty(string4 + ".ssl.checkserveridentity", Boolean.toString(sslConfiguration.isVerifyHostName()));
            }
            sslConfiguration = Session.getInstance((Properties)properties, (Authenticator)authenticator);
            sslConfiguration.setProtocolForAddress("rfc822", string3);
            sslConfiguration.setDebug(factoryData.isSmtpDebug());
            return new SmtpManager(string, (Session)sslConfiguration, null, factoryData);
        }

        private Authenticator buildAuthenticator(final String string, final String string2) {
            if (null != string2 && null != string) {
                return new Authenticator(){
                    private final PasswordAuthentication passwordAuthentication;
                    {
                        this.passwordAuthentication = new PasswordAuthentication(string, string2);
                    }

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return this.passwordAuthentication;
                    }
                };
            }
            return null;
        }
    }
}

