/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.SocketOptions;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.TcpSocketManager;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SslSocketManager
extends TcpSocketManager {
    public static final int DEFAULT_PORT = 6514;
    private static final SslSocketManagerFactory FACTORY = new SslSocketManagerFactory();
    private final SslConfiguration sslConfig;

    @Deprecated
    public SslSocketManager(String string, OutputStream outputStream, Socket socket, SslConfiguration sslConfiguration, InetAddress inetAddress, String string2, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5) {
        super(string, outputStream, socket, inetAddress, string2, n2, n3, n4, bl2, layout, n5, null);
        this.sslConfig = sslConfiguration;
    }

    public SslSocketManager(String string, OutputStream outputStream, Socket socket, SslConfiguration sslConfiguration, InetAddress inetAddress, String string2, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
        super(string, outputStream, socket, inetAddress, string2, n2, n3, n4, bl2, layout, n5, socketOptions);
        this.sslConfig = sslConfiguration;
    }

    @Deprecated
    public static SslSocketManager getSocketManager(SslConfiguration sslConfiguration, String string, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5) {
        return SslSocketManager.getSocketManager(sslConfiguration, string, n2, n3, n4, bl2, layout, n5, null);
    }

    public static SslSocketManager getSocketManager(SslConfiguration sslConfiguration, String string, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (n2 <= 0) {
            n2 = 6514;
        }
        if (n4 == 0) {
            n4 = 30000;
        }
        String string2 = "TLS:" + string + ':' + n2;
        return (SslSocketManager)SslSocketManager.getManager(string2, new SslFactoryData(sslConfiguration, string, n2, n3, n4, bl2, layout, n5, socketOptions), FACTORY);
    }

    @Override
    protected Socket createSocket(InetSocketAddress inetSocketAddress) throws IOException {
        SSLSocketFactory sSLSocketFactory = SslSocketManager.createSslSocketFactory(this.sslConfig);
        Socket socket = sSLSocketFactory.createSocket();
        socket.connect(inetSocketAddress, this.getConnectTimeoutMillis());
        return socket;
    }

    private static SSLSocketFactory createSslSocketFactory(SslConfiguration sslConfiguration) {
        SSLSocketFactory sSLSocketFactory = sslConfiguration != null ? sslConfiguration.getSslSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
        return sSLSocketFactory;
    }

    static Socket createSocket(InetSocketAddress inetSocketAddress, int n2, SslConfiguration sslConfiguration, SocketOptions socketOptions) throws IOException {
        SSLSocketFactory sSLSocketFactory = SslSocketManager.createSslSocketFactory(sslConfiguration);
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
        if (socketOptions != null) {
            socketOptions.apply(sSLSocket);
        }
        sSLSocket.connect(inetSocketAddress, n2);
        if (socketOptions != null) {
            socketOptions.apply(sSLSocket);
        }
        return sSLSocket;
    }

    private static class SslSocketManagerFactory
    extends TcpSocketManager.TcpSocketManagerFactory<SslSocketManager, SslFactoryData> {
        private SslSocketManagerFactory() {
        }

        @Override
        SslSocketManager createManager(String string, OutputStream outputStream, Socket socket, InetAddress inetAddress, SslFactoryData sslFactoryData) {
            return new SslSocketManager(string, outputStream, socket, sslFactoryData.sslConfiguration, inetAddress, sslFactoryData.host, sslFactoryData.port, sslFactoryData.connectTimeoutMillis, sslFactoryData.reconnectDelayMillis, sslFactoryData.immediateFail, sslFactoryData.layout, sslFactoryData.bufferSize, sslFactoryData.socketOptions);
        }

        @Override
        Socket createSocket(SslFactoryData sslFactoryData) throws IOException {
            List<InetSocketAddress> list = RESOLVER.resolveHost(sslFactoryData.host, sslFactoryData.port);
            IOException iOException = null;
            for (InetSocketAddress inetSocketAddress : list) {
                try {
                    return SslSocketManager.createSocket(inetSocketAddress, sslFactoryData.connectTimeoutMillis, sslFactoryData.sslConfiguration, sslFactoryData.socketOptions);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            throw new IOException(this.errorMessage(sslFactoryData, list), iOException);
        }
    }

    private static class SslFactoryData
    extends TcpSocketManager.FactoryData {
        protected SslConfiguration sslConfiguration;

        public SslFactoryData(SslConfiguration sslConfiguration, String string, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
            super(string, n2, n3, n4, bl2, layout, n5, socketOptions);
            this.sslConfiguration = sslConfiguration;
        }

        @Override
        public String toString() {
            return "SslFactoryData [sslConfiguration=" + this.sslConfiguration + ", host=" + this.host + ", port=" + this.port + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", reconnectDelayMillis=" + this.reconnectDelayMillis + ", immediateFail=" + this.immediateFail + ", layout=" + this.layout + ", bufferSize=" + this.bufferSize + ", socketOptions=" + this.socketOptions + "]";
        }
    }
}

