/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.KeyStoreConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.net.ssl.TrustStoreConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.Strings;

public class SslConfigurationFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static SslConfiguration sslConfiguration = SslConfigurationFactory.createSslConfiguration(PropertiesUtil.getProperties());
    private static final String trustStorelocation = "com.contrastsecurity.thirdparty.log4j2.trustStoreLocation";
    private static final String trustStorePassword = "com.contrastsecurity.thirdparty.log4j2.trustStorePassword";
    private static final String trustStorePasswordFile = "com.contrastsecurity.thirdparty.log4j2.trustStorePasswordFile";
    private static final String trustStorePasswordEnvVar = "com.contrastsecurity.thirdparty.log4j2.trustStorePasswordEnvironmentVariable";
    private static final String trustStoreKeyStoreType = "com.contrastsecurity.thirdparty.log4j2.trustStoreKeyStoreType";
    private static final String trustStoreKeyManagerFactoryAlgorithm = "com.contrastsecurity.thirdparty.log4j2.trustStoreKeyManagerFactoryAlgorithm";
    private static final String keyStoreLocation = "com.contrastsecurity.thirdparty.log4j2.keyStoreLocation";
    private static final String keyStorePassword = "com.contrastsecurity.thirdparty.log4j2.keyStorePassword";
    private static final String keyStorePasswordFile = "com.contrastsecurity.thirdparty.log4j2.keyStorePasswordFile";
    private static final String keyStorePasswordEnvVar = "com.contrastsecurity.thirdparty.log4j2.keyStorePasswordEnvironmentVariable";
    private static final String keyStoreType = "com.contrastsecurity.thirdparty.log4j2.keyStoreType";
    private static final String keyStoreKeyManagerFactoryAlgorithm = "com.contrastsecurity.thirdparty.log4j2.keyStoreKeyManagerFactoryAlgorithm";
    private static final String verifyHostName = "com.contrastsecurity.thirdparty.log4j2.sslVerifyHostName";

    static SslConfiguration createSslConfiguration(PropertiesUtil propertiesUtil) {
        char[] cArray;
        String string;
        KeyStoreConfiguration keyStoreConfiguration = null;
        TrustStoreConfiguration trustStoreConfiguration = null;
        String string2 = propertiesUtil.getStringProperty(trustStorelocation);
        String string3 = propertiesUtil.getStringProperty(trustStoreKeyStoreType);
        if (Strings.isNotEmpty(string2) || string3 != null) {
            string = propertiesUtil.getStringProperty(trustStorePassword);
            cArray = SslConfigurationFactory.getPassword(string, string3);
            try {
                trustStoreConfiguration = TrustStoreConfiguration.createKeyStoreConfiguration(Strings.trimToNull(string2), cArray, propertiesUtil.getStringProperty(trustStorePasswordEnvVar), propertiesUtil.getStringProperty(trustStorePasswordFile), string3, propertiesUtil.getStringProperty(trustStoreKeyManagerFactoryAlgorithm));
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to create trust store configuration due to: {} {}", (Object)exception.getClass().getName(), (Object)exception.getMessage());
            }
        }
        string2 = propertiesUtil.getStringProperty(keyStoreLocation);
        string3 = propertiesUtil.getStringProperty(keyStoreType);
        if (Strings.isNotEmpty(string2) || string3 != null) {
            string = propertiesUtil.getStringProperty(keyStorePassword);
            cArray = SslConfigurationFactory.getPassword(string, string3);
            try {
                keyStoreConfiguration = KeyStoreConfiguration.createKeyStoreConfiguration(Strings.trimToNull(string2), cArray, propertiesUtil.getStringProperty(keyStorePasswordEnvVar), propertiesUtil.getStringProperty(keyStorePasswordFile), string3, propertiesUtil.getStringProperty(keyStoreKeyManagerFactoryAlgorithm));
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to create key store configuration due to: {} {}", (Object)exception.getClass().getName(), (Object)exception.getMessage());
            }
        }
        if (trustStoreConfiguration != null || keyStoreConfiguration != null) {
            boolean bl2 = propertiesUtil.getBooleanProperty(verifyHostName, false);
            return SslConfiguration.createSSLConfiguration(null, keyStoreConfiguration, trustStoreConfiguration, bl2);
        }
        return null;
    }

    private static char[] getPassword(String string, String string2) {
        if (string2.equals("JKS") || string2.equals("PKCS12")) {
            return string != null ? string.toCharArray() : null;
        }
        return Strings.isEmpty(string) ? null : string.toCharArray();
    }

    public static SslConfiguration getSslConfiguration() {
        return sslConfiguration;
    }
}

