/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.ConverterKeys;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.PatternFormatter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.pattern.PatternParser;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PerformanceSensitive;
import java.util.List;

@Plugin(name="maxLength", category="Converter")
@ConverterKeys(value={"maxLength", "maxLen"})
@PerformanceSensitive(value={"allocation"})
public final class MaxLengthConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final int maxLength;

    public static MaxLengthConverter newInstance(Configuration configuration, String[] stringArray) {
        if (stringArray.length != 2) {
            LOGGER.error("Incorrect number of options on maxLength: expected 2 received {}: {}", (Object)stringArray.length, (Object)stringArray);
            return null;
        }
        if (stringArray[0] == null) {
            LOGGER.error("No pattern supplied on maxLength");
            return null;
        }
        if (stringArray[1] == null) {
            LOGGER.error("No length supplied on maxLength");
            return null;
        }
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        List<PatternFormatter> list = patternParser.parse(stringArray[0]);
        return new MaxLengthConverter(list, AbstractAppender.parseInt(stringArray[1], 100));
    }

    private MaxLengthConverter(List<PatternFormatter> list, int n2) {
        super("MaxLength", "maxLength");
        this.maxLength = n2;
        this.formatters = list;
        LOGGER.trace("new MaxLengthConverter with {}", (Object)n2);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        for (int i2 = 0; i2 < this.formatters.size(); ++i2) {
            PatternFormatter patternFormatter = this.formatters.get(i2);
            patternFormatter.format(logEvent, stringBuilder);
            if (stringBuilder.length() > n2 + this.maxLength) break;
        }
        if (stringBuilder.length() > n2 + this.maxLength) {
            stringBuilder.setLength(n2 + this.maxLength);
            if (this.maxLength > 20) {
                stringBuilder.append("...");
            }
        }
    }
}

