/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.tools.picocli;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Integers;
import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Time;
import java.text.BreakIterator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public class CommandLine {
    public static final String VERSION = "2.0.3";
    private final Tracer tracer = new Tracer();
    private final Interpreter interpreter;
    private String commandName = "<main class>";
    private boolean overwrittenOptionsAllowed = false;
    private boolean unmatchedArgumentsAllowed = false;
    private final List<String> unmatchedArguments = new ArrayList<String>();
    private CommandLine parent;
    private boolean usageHelpRequested;
    private boolean versionHelpRequested;
    private final List<String> versionLines = new ArrayList<String>();

    public CommandLine(Object object) {
        this.interpreter = new Interpreter(object);
    }

    public CommandLine addSubcommand(String string, Object object) {
        CommandLine commandLine = CommandLine.toCommandLine(object);
        commandLine.parent = this;
        this.interpreter.commands.put(string, commandLine);
        return this;
    }

    public Map<String, CommandLine> getSubcommands() {
        return new LinkedHashMap<String, CommandLine>(this.interpreter.commands);
    }

    public CommandLine getParent() {
        return this.parent;
    }

    public <T> T getCommand() {
        return (T)this.interpreter.command;
    }

    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    public boolean isVersionHelpRequested() {
        return this.versionHelpRequested;
    }

    public boolean isOverwrittenOptionsAllowed() {
        return this.overwrittenOptionsAllowed;
    }

    public CommandLine setOverwrittenOptionsAllowed(boolean bl2) {
        this.overwrittenOptionsAllowed = bl2;
        for (CommandLine commandLine : this.interpreter.commands.values()) {
            commandLine.setOverwrittenOptionsAllowed(bl2);
        }
        return this;
    }

    public boolean isUnmatchedArgumentsAllowed() {
        return this.unmatchedArgumentsAllowed;
    }

    public CommandLine setUnmatchedArgumentsAllowed(boolean bl2) {
        this.unmatchedArgumentsAllowed = bl2;
        for (CommandLine commandLine : this.interpreter.commands.values()) {
            commandLine.setUnmatchedArgumentsAllowed(bl2);
        }
        return this;
    }

    public List<String> getUnmatchedArguments() {
        return this.unmatchedArguments;
    }

    public static <T> T populateCommand(T t2, String ... stringArray) {
        CommandLine commandLine = CommandLine.toCommandLine(t2);
        commandLine.parse(stringArray);
        return t2;
    }

    public List<CommandLine> parse(String ... stringArray) {
        return this.interpreter.parse(stringArray);
    }

    public static boolean printHelpIfRequested(List<CommandLine> list, PrintStream printStream, Help.Ansi ansi) {
        for (CommandLine commandLine : list) {
            if (commandLine.isUsageHelpRequested()) {
                commandLine.usage(printStream, ansi);
                return true;
            }
            if (!commandLine.isVersionHelpRequested()) continue;
            commandLine.printVersionHelp(printStream, ansi);
            return true;
        }
        return false;
    }

    private static Object execute(CommandLine commandLine) {
        Object t2 = commandLine.getCommand();
        if (t2 instanceof Runnable) {
            try {
                ((Runnable)t2).run();
                return null;
            }
            catch (Exception exception) {
                throw new ExecutionException(commandLine, "Error while running command (" + t2 + ")", exception);
            }
        }
        if (t2 instanceof Callable) {
            try {
                return ((Callable)t2).call();
            }
            catch (Exception exception) {
                throw new ExecutionException(commandLine, "Error while calling command (" + t2 + ")", exception);
            }
        }
        throw new ExecutionException(commandLine, "Parsed command (" + t2 + ") is not Runnable or Callable");
    }

    public List<Object> parseWithHandler(IParseResultHandler iParseResultHandler, PrintStream printStream, String ... stringArray) {
        return this.parseWithHandlers(iParseResultHandler, printStream, Help.Ansi.AUTO, new DefaultExceptionHandler(), stringArray);
    }

    public List<Object> parseWithHandlers(IParseResultHandler iParseResultHandler, PrintStream printStream, Help.Ansi ansi, IExceptionHandler iExceptionHandler, String ... stringArray) {
        try {
            List<CommandLine> list = this.parse(stringArray);
            return iParseResultHandler.handleParseResult(list, printStream, ansi);
        }
        catch (ParameterException parameterException) {
            return iExceptionHandler.handleException(parameterException, printStream, ansi, stringArray);
        }
    }

    public static void usage(Object object, PrintStream printStream) {
        CommandLine.toCommandLine(object).usage(printStream);
    }

    public static void usage(Object object, PrintStream printStream, Help.Ansi ansi) {
        CommandLine.toCommandLine(object).usage(printStream, ansi);
    }

    public static void usage(Object object, PrintStream printStream, Help.ColorScheme colorScheme) {
        CommandLine.toCommandLine(object).usage(printStream, colorScheme);
    }

    public void usage(PrintStream printStream) {
        this.usage(printStream, Help.Ansi.AUTO);
    }

    public void usage(PrintStream printStream, Help.Ansi ansi) {
        this.usage(printStream, Help.defaultColorScheme(ansi));
    }

    public void usage(PrintStream printStream, Help.ColorScheme colorScheme) {
        Help help = new Help(this.interpreter.command, colorScheme).addAllSubcommands(this.getSubcommands());
        if (!"=".equals(this.getSeparator())) {
            help.separator = this.getSeparator();
            help.parameterLabelRenderer = help.createDefaultParamLabelRenderer();
        }
        if (!"<main class>".equals(this.getCommandName())) {
            help.commandName = this.getCommandName();
        }
        StringBuilder stringBuilder = new StringBuilder().append(help.headerHeading(new Object[0])).append(help.header(new Object[0])).append(help.synopsisHeading(new Object[0])).append(help.synopsis(help.synopsisHeadingLength())).append(help.descriptionHeading(new Object[0])).append(help.description(new Object[0])).append(help.parameterListHeading(new Object[0])).append(help.parameterList()).append(help.optionListHeading(new Object[0])).append(help.optionList()).append(help.commandListHeading(new Object[0])).append(help.commandList()).append(help.footerHeading(new Object[0])).append(help.footer(new Object[0]));
        printStream.print(stringBuilder);
    }

    public void printVersionHelp(PrintStream printStream) {
        this.printVersionHelp(printStream, Help.Ansi.AUTO);
    }

    public void printVersionHelp(PrintStream printStream, Help.Ansi ansi) {
        for (String string : this.versionLines) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            printStream.println(ansi2.new Help.Ansi.Text(string));
        }
    }

    public void printVersionHelp(PrintStream printStream, Help.Ansi ansi, Object ... objectArray) {
        for (String string : this.versionLines) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            printStream.println(ansi2.new Help.Ansi.Text(String.format(string, objectArray)));
        }
    }

    public static <C extends Callable<T>, T> T call(C c2, PrintStream printStream, String ... stringArray) {
        return CommandLine.call(c2, printStream, Help.Ansi.AUTO, stringArray);
    }

    public static <C extends Callable<T>, T> T call(C c2, PrintStream printStream, Help.Ansi ansi, String ... stringArray) {
        CommandLine commandLine = new CommandLine(c2);
        List<Object> list = commandLine.parseWithHandlers(new RunLast(), printStream, ansi, new DefaultExceptionHandler(), stringArray);
        return (T)(list == null || list.isEmpty() ? null : list.get(0));
    }

    public static <R extends Runnable> void run(R r2, PrintStream printStream, String ... stringArray) {
        CommandLine.run(r2, printStream, Help.Ansi.AUTO, stringArray);
    }

    public static <R extends Runnable> void run(R r2, PrintStream printStream, Help.Ansi ansi, String ... stringArray) {
        CommandLine commandLine = new CommandLine(r2);
        commandLine.parseWithHandlers(new RunLast(), printStream, ansi, new DefaultExceptionHandler(), stringArray);
    }

    public <K> CommandLine registerConverter(Class<K> clazz, ITypeConverter<K> iTypeConverter) {
        this.interpreter.converterRegistry.put(Assert.notNull(clazz, "class"), Assert.notNull(iTypeConverter, "converter"));
        for (CommandLine commandLine : this.interpreter.commands.values()) {
            commandLine.registerConverter(clazz, iTypeConverter);
        }
        return this;
    }

    public String getSeparator() {
        return this.interpreter.separator;
    }

    public CommandLine setSeparator(String string) {
        this.interpreter.separator = Assert.notNull(string, "separator");
        return this;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public CommandLine setCommandName(String string) {
        this.commandName = Assert.notNull(string, "commandName");
        return this;
    }

    private static boolean empty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private static boolean empty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static boolean empty(Help.Ansi.Text text) {
        return text == null || text.plain.toString().trim().length() == 0;
    }

    private static String str(String[] stringArray, int n2) {
        return stringArray == null || stringArray.length == 0 ? "" : stringArray[n2];
    }

    private static boolean isBoolean(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    private static CommandLine toCommandLine(Object object) {
        return object instanceof CommandLine ? (CommandLine)object : new CommandLine(object);
    }

    private static boolean isMultiValue(Field field) {
        return CommandLine.isMultiValue(field.getType());
    }

    private static boolean isMultiValue(Class<?> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private static Class<?>[] getTypeAttribute(Field field) {
        Class<?>[] classArray;
        Class<?>[] classArray2 = classArray = field.isAnnotationPresent(Parameters.class) ? field.getAnnotation(Parameters.class).type() : field.getAnnotation(Option.class).type();
        if (classArray.length > 0) {
            return classArray;
        }
        if (field.getType().isArray()) {
            return new Class[]{field.getType().getComponentType()};
        }
        if (CommandLine.isMultiValue(field)) {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                Object[] objectArray = new Class[typeArray.length];
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    if (typeArray[i2] instanceof Class) {
                        objectArray[i2] = (Class)typeArray[i2];
                        continue;
                    }
                    if (typeArray[i2] instanceof WildcardType) {
                        WildcardType wildcardType = (WildcardType)typeArray[i2];
                        Type[] typeArray2 = wildcardType.getLowerBounds();
                        if (typeArray2.length > 0 && typeArray2[0] instanceof Class) {
                            objectArray[i2] = (Class)typeArray2[0];
                            continue;
                        }
                        Type[] typeArray3 = wildcardType.getUpperBounds();
                        if (typeArray3.length > 0 && typeArray3[0] instanceof Class) {
                            objectArray[i2] = (Class)typeArray3[0];
                            continue;
                        }
                    }
                    Arrays.fill(objectArray, String.class);
                    return objectArray;
                }
                return objectArray;
            }
            return new Class[]{String.class, String.class};
        }
        return new Class[]{field.getType()};
    }

    static void init(Class<?> clazz, List<Field> list, Map<String, Field> map, Map<Character, Field> map2, List<Field> list2) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            Object object;
            field.setAccessible(true);
            if (field.isAnnotationPresent(Option.class)) {
                object = field.getAnnotation(Option.class);
                if (object.required()) {
                    list.add(field);
                }
                for (String string : object.names()) {
                    char c2;
                    Field field2;
                    Field field3 = map.put(string, field);
                    if (field3 != null && field3 != field) {
                        throw DuplicateOptionAnnotationsException.create(string, field, field3);
                    }
                    if (string.length() != 2 || !string.startsWith("-") || (field2 = map2.put(Character.valueOf(c2 = string.charAt(1)), field)) == null || field2 == field) continue;
                    throw DuplicateOptionAnnotationsException.create(string, field, field2);
                }
            }
            if (!field.isAnnotationPresent(Parameters.class)) continue;
            if (field.isAnnotationPresent(Option.class)) {
                throw new DuplicateOptionAnnotationsException("A field can be either @Option or @Parameters, but '" + field.getName() + "' is both.");
            }
            list2.add(field);
            object = Range.parameterArity(field);
            if (((Range)object).min <= 0) continue;
            list.add(field);
        }
    }

    static void validatePositionalParameters(List<Field> list) {
        int n2 = 0;
        for (Field field : list) {
            Range range = Range.parameterIndex(field);
            if (range.min > n2) {
                throw new ParameterIndexGapException("Missing field annotated with @Parameter(index=" + n2 + "). Nearest field '" + field.getName() + "' has index=" + range.min);
            }
            n2 = (n2 = Math.max(n2, range.max)) == Integer.MAX_VALUE ? n2 : n2 + 1;
        }
    }

    private static <T> Stack<T> reverse(Stack<T> stack) {
        Collections.reverse(stack);
        return stack;
    }

    public static class MissingTypeConverterException
    extends ParameterException {
        private static final long serialVersionUID = -6050931703233083760L;

        public MissingTypeConverterException(CommandLine commandLine, String string) {
            super(commandLine, string);
        }
    }

    public static class OverwrittenOptionException
    extends ParameterException {
        private static final long serialVersionUID = 1338029208271055776L;

        public OverwrittenOptionException(CommandLine commandLine, String string) {
            super(commandLine, string);
        }
    }

    public static class MaxValuesforFieldExceededException
    extends ParameterException {
        private static final long serialVersionUID = 6536145439570100641L;

        public MaxValuesforFieldExceededException(CommandLine commandLine, String string) {
            super(commandLine, string);
        }
    }

    public static class UnmatchedArgumentException
    extends ParameterException {
        private static final long serialVersionUID = -8700426380701452440L;

        public UnmatchedArgumentException(CommandLine commandLine, String string) {
            super(commandLine, string);
        }

        public UnmatchedArgumentException(CommandLine commandLine, Stack<String> stack) {
            this(commandLine, new ArrayList<String>(CommandLine.reverse(stack)));
        }

        public UnmatchedArgumentException(CommandLine commandLine, List<String> list) {
            this(commandLine, "Unmatched argument" + (list.size() == 1 ? " " : "s ") + list);
        }
    }

    public static class ParameterIndexGapException
    extends InitializationException {
        private static final long serialVersionUID = -1520981133257618319L;

        public ParameterIndexGapException(String string) {
            super(string);
        }
    }

    public static class DuplicateOptionAnnotationsException
    extends InitializationException {
        private static final long serialVersionUID = -3355128012575075641L;

        public DuplicateOptionAnnotationsException(String string) {
            super(string);
        }

        private static DuplicateOptionAnnotationsException create(String string, Field field, Field field2) {
            return new DuplicateOptionAnnotationsException("Option name '" + string + "' is used by both " + field.getDeclaringClass().getName() + "." + field.getName() + " and " + field2.getDeclaringClass().getName() + "." + field2.getName());
        }
    }

    public static class MissingParameterException
    extends ParameterException {
        private static final long serialVersionUID = 5075678535706338753L;

        public MissingParameterException(CommandLine commandLine, String string) {
            super(commandLine, string);
        }

        private static MissingParameterException create(CommandLine commandLine, Collection<Field> collection, String string) {
            if (collection.size() == 1) {
                return new MissingParameterException(commandLine, "Missing required option '" + MissingParameterException.describe(collection.iterator().next(), string) + "'");
            }
            ArrayList<String> arrayList = new ArrayList<String>(collection.size());
            for (Field field : collection) {
                arrayList.add(MissingParameterException.describe(field, string));
            }
            return new MissingParameterException(commandLine, "Missing required options " + ((Object)arrayList).toString());
        }

        private static String describe(Field field, String string) {
            String string2 = field.isAnnotationPresent(Option.class) ? field.getAnnotation(Option.class).names()[0] + string : "params[" + field.getAnnotation(Parameters.class).index() + "]" + string;
            return string2 + Help.DefaultParamLabelRenderer.renderParameterName(field);
        }
    }

    public static class ParameterException
    extends PicocliException {
        private static final long serialVersionUID = 1477112829129763139L;
        private final CommandLine commandLine;

        public ParameterException(CommandLine commandLine, String string) {
            super(string);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ParameterException(CommandLine commandLine, String string, Exception exception) {
            super(string, exception);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }

        private static ParameterException create(CommandLine commandLine, Exception exception, String string, int n2, String[] stringArray) {
            String string2 = exception.getClass().getSimpleName() + ": " + exception.getLocalizedMessage() + " while processing argument at or before arg[" + n2 + "] '" + string + "' in " + Arrays.toString(stringArray) + ": " + exception.toString();
            return new ParameterException(commandLine, string2, exception);
        }
    }

    public static class TypeConversionException
    extends PicocliException {
        private static final long serialVersionUID = 4251973913816346114L;

        public TypeConversionException(String string) {
            super(string);
        }
    }

    public static class ExecutionException
    extends PicocliException {
        private static final long serialVersionUID = 7764539594267007998L;
        private final CommandLine commandLine;

        public ExecutionException(CommandLine commandLine, String string) {
            super(string);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ExecutionException(CommandLine commandLine, String string, Exception exception) {
            super(string, exception);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }
    }

    public static class InitializationException
    extends PicocliException {
        private static final long serialVersionUID = 8423014001666638895L;

        public InitializationException(String string) {
            super(string);
        }

        public InitializationException(String string, Exception exception) {
            super(string, exception);
        }
    }

    public static class PicocliException
    extends RuntimeException {
        private static final long serialVersionUID = -2574128880125050818L;

        public PicocliException(String string) {
            super(string);
        }

        public PicocliException(String string, Exception exception) {
            super(string, exception);
        }
    }

    private static class Tracer {
        TraceLevel level = TraceLevel.lookup(System.getProperty("picocli.trace"));
        PrintStream stream = System.err;

        private Tracer() {
        }

        void warn(String string, Object ... objectArray) {
            TraceLevel.WARN.print(this, string, objectArray);
        }

        void info(String string, Object ... objectArray) {
            TraceLevel.INFO.print(this, string, objectArray);
        }

        void debug(String string, Object ... objectArray) {
            TraceLevel.DEBUG.print(this, string, objectArray);
        }

        boolean isWarn() {
            return this.level.isEnabled(TraceLevel.WARN);
        }

        boolean isInfo() {
            return this.level.isEnabled(TraceLevel.INFO);
        }

        boolean isDebug() {
            return this.level.isEnabled(TraceLevel.DEBUG);
        }
    }

    private static enum TraceLevel {
        OFF,
        WARN,
        INFO,
        DEBUG;


        public boolean isEnabled(TraceLevel traceLevel) {
            return this.ordinal() >= traceLevel.ordinal();
        }

        private void print(Tracer tracer, String string, Object ... objectArray) {
            if (tracer.level.isEnabled(this)) {
                tracer.stream.printf(this.prefix(string), objectArray);
            }
        }

        private String prefix(String string) {
            return "[picocli " + (Object)((Object)this) + "] " + string;
        }

        static TraceLevel lookup(String string) {
            return string == null ? WARN : (CommandLine.empty(string) || "true".equalsIgnoreCase(string) ? INFO : TraceLevel.valueOf(string));
        }
    }

    private static final class Assert {
        static <T> T notNull(T t2, String string) {
            if (t2 == null) {
                throw new NullPointerException(string);
            }
            return t2;
        }

        private Assert() {
        }
    }

    public static class Help {
        protected static final String DEFAULT_COMMAND_NAME = "<main class>";
        protected static final String DEFAULT_SEPARATOR = "=";
        private static final int usageHelpWidth = 80;
        private static final int optionsColumnWidth = 29;
        private final Object command;
        private final Map<String, Help> commands = new LinkedHashMap<String, Help>();
        final ColorScheme colorScheme;
        public final List<Field> optionFields;
        public final List<Field> positionalParametersFields;
        public String separator;
        public String commandName = "<main class>";
        public String[] description = new String[0];
        public String[] customSynopsis = new String[0];
        public String[] header = new String[0];
        public String[] footer = new String[0];
        public IParamLabelRenderer parameterLabelRenderer;
        public Boolean abbreviateSynopsis;
        public Boolean sortOptions;
        public Boolean showDefaultValues;
        public Character requiredOptionMarker;
        public String headerHeading;
        public String synopsisHeading;
        public String descriptionHeading;
        public String parameterListHeading;
        public String optionListHeading;
        public String commandListHeading;
        public String footerHeading;

        public Help(Object object) {
            this(object, Ansi.AUTO);
        }

        public Help(Object object, Ansi ansi) {
            this(object, Help.defaultColorScheme(ansi));
        }

        public Help(Object object, ColorScheme colorScheme) {
            this.command = Assert.notNull(object, "command");
            this.colorScheme = Assert.notNull(colorScheme, "colorScheme").applySystemProperties();
            ArrayList<Field> arrayList = new ArrayList<Field>();
            ArrayList<Field> arrayList2 = new ArrayList<Field>();
            for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    Option option;
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Option.class) && !(option = field.getAnnotation(Option.class)).hidden()) {
                        arrayList.add(field);
                    }
                    if (!field.isAnnotationPresent(Parameters.class)) continue;
                    arrayList2.add(field);
                }
                if (!clazz.isAnnotationPresent(Command.class)) continue;
                Command command = clazz.getAnnotation(Command.class);
                if (DEFAULT_COMMAND_NAME.equals(this.commandName)) {
                    this.commandName = command.name();
                }
                this.separator = this.separator == null ? command.separator() : this.separator;
                this.abbreviateSynopsis = this.abbreviateSynopsis == null ? command.abbreviateSynopsis() : this.abbreviateSynopsis.booleanValue();
                this.sortOptions = this.sortOptions == null ? command.sortOptions() : this.sortOptions.booleanValue();
                this.requiredOptionMarker = Character.valueOf(this.requiredOptionMarker == null ? command.requiredOptionMarker() : this.requiredOptionMarker.charValue());
                this.showDefaultValues = this.showDefaultValues == null ? command.showDefaultValues() : this.showDefaultValues.booleanValue();
                this.customSynopsis = CommandLine.empty(this.customSynopsis) ? command.customSynopsis() : this.customSynopsis;
                this.description = CommandLine.empty(this.description) ? command.description() : this.description;
                this.header = CommandLine.empty(this.header) ? command.header() : this.header;
                this.footer = CommandLine.empty(this.footer) ? command.footer() : this.footer;
                this.headerHeading = CommandLine.empty(this.headerHeading) ? command.headerHeading() : this.headerHeading;
                this.synopsisHeading = CommandLine.empty(this.synopsisHeading) || "Usage: ".equals(this.synopsisHeading) ? command.synopsisHeading() : this.synopsisHeading;
                this.descriptionHeading = CommandLine.empty(this.descriptionHeading) ? command.descriptionHeading() : this.descriptionHeading;
                this.parameterListHeading = CommandLine.empty(this.parameterListHeading) ? command.parameterListHeading() : this.parameterListHeading;
                this.optionListHeading = CommandLine.empty(this.optionListHeading) ? command.optionListHeading() : this.optionListHeading;
                this.commandListHeading = CommandLine.empty(this.commandListHeading) || "Commands:%n".equals(this.commandListHeading) ? command.commandListHeading() : this.commandListHeading;
                this.footerHeading = CommandLine.empty(this.footerHeading) ? command.footerHeading() : this.footerHeading;
            }
            this.sortOptions = this.sortOptions == null ? true : this.sortOptions;
            this.abbreviateSynopsis = this.abbreviateSynopsis == null ? false : this.abbreviateSynopsis;
            this.requiredOptionMarker = Character.valueOf(this.requiredOptionMarker == null ? (char)' ' : this.requiredOptionMarker.charValue());
            this.showDefaultValues = this.showDefaultValues == null ? false : this.showDefaultValues;
            this.synopsisHeading = this.synopsisHeading == null ? "Usage: " : this.synopsisHeading;
            this.commandListHeading = this.commandListHeading == null ? "Commands:%n" : this.commandListHeading;
            this.separator = this.separator == null ? DEFAULT_SEPARATOR : this.separator;
            this.parameterLabelRenderer = this.createDefaultParamLabelRenderer();
            Collections.sort(arrayList2, new PositionalParametersSorter());
            this.positionalParametersFields = Collections.unmodifiableList(arrayList2);
            this.optionFields = Collections.unmodifiableList(arrayList);
        }

        public Help addAllSubcommands(Map<String, CommandLine> map) {
            if (map != null) {
                for (Map.Entry<String, CommandLine> entry : map.entrySet()) {
                    this.addSubcommand(entry.getKey(), entry.getValue().getCommand());
                }
            }
            return this;
        }

        public Help addSubcommand(String string, Object object) {
            this.commands.put(string, new Help(object));
            return this;
        }

        @Deprecated
        public String synopsis() {
            return this.synopsis(0);
        }

        public String synopsis(int n2) {
            if (!CommandLine.empty(this.customSynopsis)) {
                return this.customSynopsis(new Object[0]);
            }
            return this.abbreviateSynopsis != false ? this.abbreviatedSynopsis() : this.detailedSynopsis(n2, Help.createShortOptionArityAndNameComparator(), true);
        }

        public String abbreviatedSynopsis() {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.optionFields.isEmpty()) {
                stringBuilder.append(" [OPTIONS]");
            }
            for (Field field : this.positionalParametersFields) {
                if (field.getAnnotation(Parameters.class).hidden()) continue;
                stringBuilder.append(' ').append(this.parameterLabelRenderer.renderParameterLabel(field, this.ansi(), this.colorScheme.parameterStyles));
            }
            return this.colorScheme.commandText(this.commandName).toString() + stringBuilder.toString() + System.getProperty("line.separator");
        }

        @Deprecated
        public String detailedSynopsis(Comparator<Field> comparator, boolean bl2) {
            return this.detailedSynopsis(0, comparator, bl2);
        }

        public String detailedSynopsis(int n2, Comparator<Field> comparator, boolean bl2) {
            Object object;
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text text = ansi.new Ansi.Text(0);
            ArrayList<Field> arrayList = new ArrayList<Field>(this.optionFields);
            if (comparator != null) {
                Collections.sort(arrayList, comparator);
            }
            if (bl2) {
                Iterator<Field> iterator = new ArrayList();
                StringBuilder object22 = new StringBuilder("-");
                object = new StringBuilder("-");
                for (Field field : arrayList) {
                    Option option;
                    String string;
                    if (field.getType() != Boolean.TYPE && field.getType() != Boolean.class || (string = ShortestFirst.sort((option = field.getAnnotation(Option.class)).names())[0]).length() != 2 || !string.startsWith("-")) continue;
                    iterator.add(field);
                    if (option.required()) {
                        object22.append(string.substring(1));
                        continue;
                    }
                    ((StringBuilder)object).append(string.substring(1));
                }
                arrayList.removeAll((Collection<?>)((Object)iterator));
                if (object22.length() > 1) {
                    text = text.append(" ").append(this.colorScheme.optionText(object22.toString()));
                }
                if (((StringBuilder)object).length() > 1) {
                    text = text.append(" [").append(this.colorScheme.optionText(((StringBuilder)object).toString())).append("]");
                }
            }
            for (Field field : arrayList) {
                object = field.getAnnotation(Option.class);
                if (object.hidden()) continue;
                if (object.required()) {
                    text = this.appendOptionSynopsis(text, field, ShortestFirst.sort(object.names())[0], " ", "");
                    if (!CommandLine.isMultiValue(field)) continue;
                    text = this.appendOptionSynopsis(text, field, ShortestFirst.sort(object.names())[0], " [", "]...");
                    continue;
                }
                text = this.appendOptionSynopsis(text, field, ShortestFirst.sort(object.names())[0], " [", "]");
                if (!CommandLine.isMultiValue(field)) continue;
                text = text.append("...");
            }
            for (Field field : this.positionalParametersFields) {
                if (field.getAnnotation(Parameters.class).hidden()) continue;
                text = text.append(" ");
                object = this.parameterLabelRenderer.renderParameterLabel(field, this.colorScheme.ansi(), this.colorScheme.parameterStyles);
                text = text.append((Ansi.Text)object);
            }
            int n3 = this.commandName.length() + n2;
            TextTable textTable = new TextTable(this.ansi(), n3, 80 - n3);
            textTable.indentWrappedLines = 1;
            Ansi ansi2 = Ansi.OFF;
            ((Object)((Object)ansi2)).getClass();
            object = ansi2.new Ansi.Text(Help.stringOf('X', n2));
            textTable.addRowValues(((Ansi.Text)object).append(this.colorScheme.commandText(this.commandName)), text);
            return textTable.toString().substring(n2);
        }

        private Ansi.Text appendOptionSynopsis(Ansi.Text text, Field field, String string, String string2, String string3) {
            Ansi.Text text2 = this.parameterLabelRenderer.renderParameterLabel(field, this.colorScheme.ansi(), this.colorScheme.optionParamStyles);
            return text.append(string2).append(this.colorScheme.optionText(string)).append(text2).append(string3);
        }

        public int synopsisHeadingLength() {
            Ansi ansi = Ansi.OFF;
            ((Object)((Object)ansi)).getClass();
            String[] stringArray = ansi.new Ansi.Text(this.synopsisHeading).toString().split("\\r?\\n|\\r|%n", -1);
            return stringArray[stringArray.length - 1].length();
        }

        public String optionList() {
            Comparator<Field> comparator = this.sortOptions == null || this.sortOptions != false ? Help.createShortOptionNameComparator() : null;
            return this.optionList(this.createDefaultLayout(), comparator, this.parameterLabelRenderer);
        }

        public String optionList(Layout layout, Comparator<Field> comparator, IParamLabelRenderer iParamLabelRenderer) {
            ArrayList<Field> arrayList = new ArrayList<Field>(this.optionFields);
            if (comparator != null) {
                Collections.sort(arrayList, comparator);
            }
            layout.addOptions(arrayList, iParamLabelRenderer);
            return layout.toString();
        }

        public String parameterList() {
            return this.parameterList(this.createDefaultLayout(), this.parameterLabelRenderer);
        }

        public String parameterList(Layout layout, IParamLabelRenderer iParamLabelRenderer) {
            layout.addPositionalParameters(this.positionalParametersFields, iParamLabelRenderer);
            return layout.toString();
        }

        private static String heading(Ansi ansi, String string, Object ... objectArray) {
            StringBuilder stringBuilder = Help.join(ansi, new String[]{string}, new StringBuilder(), objectArray);
            String string2 = stringBuilder.toString();
            string2 = string2.endsWith(System.getProperty("line.separator")) ? string2.substring(0, string2.length() - System.getProperty("line.separator").length()) : string2;
            return string2 + new String(Help.spaces(Help.countTrailingSpaces(string)));
        }

        private static char[] spaces(int n2) {
            char[] cArray = new char[n2];
            Arrays.fill(cArray, ' ');
            return cArray;
        }

        private static int countTrailingSpaces(String string) {
            if (string == null) {
                return 0;
            }
            int n2 = 0;
            for (int i2 = string.length() - 1; i2 >= 0 && string.charAt(i2) == ' '; --i2) {
                ++n2;
            }
            return n2;
        }

        public static StringBuilder join(Ansi ansi, String[] stringArray, StringBuilder stringBuilder, Object ... objectArray) {
            if (stringArray != null) {
                TextTable textTable = new TextTable(ansi, 80);
                textTable.indentWrappedLines = 0;
                for (String string : stringArray) {
                    Ansi.Text[] textArray;
                    Ansi ansi2 = ansi;
                    ((Object)((Object)ansi2)).getClass();
                    for (Ansi.Text text : textArray = ansi2.new Ansi.Text(Help.format(string, objectArray)).splitLines()) {
                        textTable.addRowValues(text);
                    }
                }
                textTable.toString(stringBuilder);
            }
            return stringBuilder;
        }

        private static String format(String string, Object ... objectArray) {
            return string == null ? "" : String.format(string, objectArray);
        }

        public String customSynopsis(Object ... objectArray) {
            return Help.join(this.ansi(), this.customSynopsis, new StringBuilder(), objectArray).toString();
        }

        public String description(Object ... objectArray) {
            return Help.join(this.ansi(), this.description, new StringBuilder(), objectArray).toString();
        }

        public String header(Object ... objectArray) {
            return Help.join(this.ansi(), this.header, new StringBuilder(), objectArray).toString();
        }

        public String footer(Object ... objectArray) {
            return Help.join(this.ansi(), this.footer, new StringBuilder(), objectArray).toString();
        }

        public String headerHeading(Object ... objectArray) {
            return Help.heading(this.ansi(), this.headerHeading, objectArray);
        }

        public String synopsisHeading(Object ... objectArray) {
            return Help.heading(this.ansi(), this.synopsisHeading, objectArray);
        }

        public String descriptionHeading(Object ... objectArray) {
            return CommandLine.empty(this.descriptionHeading) ? "" : Help.heading(this.ansi(), this.descriptionHeading, objectArray);
        }

        public String parameterListHeading(Object ... objectArray) {
            return this.positionalParametersFields.isEmpty() ? "" : Help.heading(this.ansi(), this.parameterListHeading, objectArray);
        }

        public String optionListHeading(Object ... objectArray) {
            return this.optionFields.isEmpty() ? "" : Help.heading(this.ansi(), this.optionListHeading, objectArray);
        }

        public String commandListHeading(Object ... objectArray) {
            return this.commands.isEmpty() ? "" : Help.heading(this.ansi(), this.commandListHeading, objectArray);
        }

        public String footerHeading(Object ... objectArray) {
            return Help.heading(this.ansi(), this.footerHeading, objectArray);
        }

        public String commandList() {
            if (this.commands.isEmpty()) {
                return "";
            }
            int n2 = Help.maxLength(this.commands.keySet());
            TextTable textTable = new TextTable(this.ansi(), new Column(n2 + 2, 2, Column.Overflow.SPAN), new Column(80 - (n2 + 2), 2, Column.Overflow.WRAP));
            for (Map.Entry<String, Help> entry : this.commands.entrySet()) {
                Help help = entry.getValue();
                String string = help.header != null && help.header.length > 0 ? help.header[0] : (help.description != null && help.description.length > 0 ? help.description[0] : "");
                Ansi.Text[] textArray = new Ansi.Text[2];
                textArray[0] = this.colorScheme.commandText(entry.getKey());
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray[1] = ansi.new Ansi.Text(string);
                textTable.addRowValues(textArray);
            }
            return textTable.toString();
        }

        private static int maxLength(Collection<String> collection) {
            ArrayList<String> arrayList = new ArrayList<String>(collection);
            Collections.sort(arrayList, Collections.reverseOrder(Help.shortestFirst()));
            return ((String)arrayList.get(0)).length();
        }

        private static String join(String[] stringArray, int n2, int n3, String string) {
            if (stringArray == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                stringBuilder.append(i2 > n2 ? string : "").append(stringArray[i2]);
            }
            return stringBuilder.toString();
        }

        private static String stringOf(char c2, int n2) {
            char[] cArray = new char[n2];
            Arrays.fill(cArray, c2);
            return new String(cArray);
        }

        public Layout createDefaultLayout() {
            return new Layout(this.colorScheme, new TextTable(this.colorScheme.ansi()), this.createDefaultOptionRenderer(), this.createDefaultParameterRenderer());
        }

        public IOptionRenderer createDefaultOptionRenderer() {
            DefaultOptionRenderer defaultOptionRenderer = new DefaultOptionRenderer();
            defaultOptionRenderer.requiredMarker = String.valueOf(this.requiredOptionMarker);
            if (this.showDefaultValues != null && this.showDefaultValues.booleanValue()) {
                defaultOptionRenderer.command = this.command;
            }
            return defaultOptionRenderer;
        }

        public static IOptionRenderer createMinimalOptionRenderer() {
            return new MinimalOptionRenderer();
        }

        public IParameterRenderer createDefaultParameterRenderer() {
            DefaultParameterRenderer defaultParameterRenderer = new DefaultParameterRenderer();
            defaultParameterRenderer.requiredMarker = String.valueOf(this.requiredOptionMarker);
            return defaultParameterRenderer;
        }

        public static IParameterRenderer createMinimalParameterRenderer() {
            return new MinimalParameterRenderer();
        }

        public static IParamLabelRenderer createMinimalParamLabelRenderer() {
            return new IParamLabelRenderer(){

                @Override
                public Ansi.Text renderParameterLabel(Field field, Ansi ansi, List<Ansi.IStyle> list) {
                    String string = DefaultParamLabelRenderer.renderParameterName(field);
                    return ansi.apply(string, list);
                }

                @Override
                public String separator() {
                    return "";
                }
            };
        }

        public IParamLabelRenderer createDefaultParamLabelRenderer() {
            return new DefaultParamLabelRenderer(this.separator);
        }

        public static Comparator<Field> createShortOptionNameComparator() {
            return new SortByShortestOptionNameAlphabetically();
        }

        public static Comparator<Field> createShortOptionArityAndNameComparator() {
            return new SortByOptionArityAndNameAlphabetically();
        }

        public static Comparator<String> shortestFirst() {
            return new ShortestFirst();
        }

        public Ansi ansi() {
            return this.colorScheme.ansi;
        }

        public static ColorScheme defaultColorScheme(Ansi ansi) {
            return new ColorScheme(ansi).commands(Ansi.Style.bold).options(Ansi.Style.fg_yellow).parameters(Ansi.Style.fg_yellow).optionParams(Ansi.Style.italic);
        }

        public static enum Ansi {
            AUTO,
            ON,
            OFF;

            static Text EMPTY_TEXT;
            static final boolean isWindows;
            static final boolean isXterm;
            static final boolean ISATTY;

            static final boolean calcTTY() {
                if (isWindows && isXterm) {
                    return true;
                }
                try {
                    return System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]) != null;
                }
                catch (Throwable throwable) {
                    return true;
                }
            }

            private static boolean ansiPossible() {
                return ISATTY && (!isWindows || isXterm);
            }

            public boolean enabled() {
                if (this == ON) {
                    return true;
                }
                if (this == OFF) {
                    return false;
                }
                return System.getProperty("picocli.ansi") == null ? Ansi.ansiPossible() : Boolean.getBoolean("picocli.ansi");
            }

            public Text apply(String string, List<IStyle> list) {
                if (string.length() == 0) {
                    return new Text(0);
                }
                Text text = new Text(string.length());
                IStyle[] iStyleArray = list.toArray(new IStyle[list.size()]);
                text.sections.add(new StyledSection(0, string.length(), Style.on(iStyleArray), Style.off(Ansi.reverse(iStyleArray)) + Style.reset.off()));
                text.plain.append(string);
                text.length = text.plain.length();
                return text;
            }

            private static <T> T[] reverse(T[] TArray) {
                for (int i2 = 0; i2 < TArray.length / 2; ++i2) {
                    T t2 = TArray[i2];
                    TArray[i2] = TArray[TArray.length - i2 - 1];
                    TArray[TArray.length - i2 - 1] = t2;
                }
                return TArray;
            }

            static {
                Ansi ansi = OFF;
                ((Object)((Object)ansi)).getClass();
                EMPTY_TEXT = ansi.new Text(0);
                isWindows = System.getProperty("os.name").startsWith("Windows");
                isXterm = System.getenv("TERM") != null && System.getenv("TERM").startsWith("xterm");
                ISATTY = Ansi.calcTTY();
            }

            public class Text
            implements Cloneable {
                private final int maxLength;
                private int from;
                private int length;
                private StringBuilder plain = new StringBuilder();
                private List<StyledSection> sections = new ArrayList<StyledSection>();

                public Text(int n2) {
                    this.maxLength = n2;
                }

                public Text(String string) {
                    this.maxLength = -1;
                    this.plain.setLength(0);
                    int n2 = 0;
                    while (true) {
                        int n3;
                        if ((n3 = string.indexOf("@|", n2)) == -1) {
                            if (n2 == 0) {
                                this.plain.append(string);
                                this.length = this.plain.length();
                                return;
                            }
                            this.plain.append(string.substring(n2, string.length()));
                            this.length = this.plain.length();
                            return;
                        }
                        this.plain.append(string.substring(n2, n3));
                        int n4 = string.indexOf("|@", n3);
                        if (n4 == -1) {
                            this.plain.append(string);
                            this.length = this.plain.length();
                            return;
                        }
                        String string2 = string.substring(n3 += 2, n4);
                        String[] stringArray = string2.split(" ", 2);
                        if (stringArray.length == 1) {
                            this.plain.append(string);
                            this.length = this.plain.length();
                            return;
                        }
                        Object[] objectArray = Style.parse(stringArray[0]);
                        this.addStyledSection(this.plain.length(), stringArray[1].length(), Style.on((IStyle[])objectArray), Style.off((IStyle[])Ansi.reverse(objectArray)) + Style.reset.off());
                        this.plain.append(stringArray[1]);
                        n2 = n4 + 2;
                    }
                }

                private void addStyledSection(int n2, int n3, String string, String string2) {
                    this.sections.add(new StyledSection(n2, n3, string, string2));
                }

                public Object clone() {
                    try {
                        return super.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new IllegalStateException(cloneNotSupportedException);
                    }
                }

                public Text[] splitLines() {
                    ArrayList<Text> arrayList = new ArrayList<Text>();
                    boolean bl2 = false;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < this.plain.length()) {
                        char c2 = this.plain.charAt(n4);
                        boolean bl3 = c2 == '\n';
                        bl3 |= c2 == '\r' && n4 + 1 < this.plain.length() && this.plain.charAt(n4 + 1) == '\n' && ++n4 > 0;
                        if (bl3 |= c2 == '\r') {
                            arrayList.add(this.substring(n2, n3));
                            bl2 = n4 == this.plain.length() - 1;
                            n2 = n4 + 1;
                        }
                        n3 = ++n4;
                    }
                    if (n2 < this.plain.length() || bl2) {
                        arrayList.add(this.substring(n2, this.plain.length()));
                    }
                    return arrayList.toArray(new Text[arrayList.size()]);
                }

                public Text substring(int n2) {
                    return this.substring(n2, this.length);
                }

                public Text substring(int n2, int n3) {
                    Text text = (Text)this.clone();
                    text.from = this.from + n2;
                    text.length = n3 - n2;
                    return text;
                }

                public Text append(String string) {
                    return this.append(new Text(string));
                }

                public Text append(Text text) {
                    Text text2 = (Text)this.clone();
                    text2.plain = new StringBuilder(this.plain.toString().substring(this.from, this.from + this.length));
                    text2.from = 0;
                    text2.sections = new ArrayList<StyledSection>();
                    for (StyledSection styledSection : this.sections) {
                        text2.sections.add(styledSection.withStartIndex(styledSection.startIndex - this.from));
                    }
                    text2.plain.append(text.plain.toString().substring(text.from, text.from + text.length));
                    for (StyledSection styledSection : text.sections) {
                        int n2 = text2.length + styledSection.startIndex - text.from;
                        text2.sections.add(styledSection.withStartIndex(n2));
                    }
                    text2.length = text2.plain.length();
                    return text2;
                }

                public void getStyledChars(int n2, int n3, Text text, int n4) {
                    if (text.length < n4) {
                        for (int i2 = text.length; i2 < n4; ++i2) {
                            text.plain.append(' ');
                        }
                        text.length = n4;
                    }
                    for (StyledSection styledSection : this.sections) {
                        text.sections.add(styledSection.withStartIndex(styledSection.startIndex - n2 + text.length));
                    }
                    text.plain.append(this.plain.toString().substring(n2, n2 + n3));
                    text.length = text.plain.length();
                }

                public String plainString() {
                    return this.plain.toString().substring(this.from, this.from + this.length);
                }

                public boolean equals(Object object) {
                    return this.toString().equals(String.valueOf(object));
                }

                public int hashCode() {
                    return this.toString().hashCode();
                }

                public String toString() {
                    if (!Ansi.this.enabled()) {
                        return this.plain.toString().substring(this.from, this.from + this.length);
                    }
                    if (this.length == 0) {
                        return "";
                    }
                    StringBuilder stringBuilder = new StringBuilder(this.plain.length() + 20 * this.sections.size());
                    StyledSection styledSection = null;
                    int n2 = Math.min(this.from + this.length, this.plain.length());
                    for (int i2 = this.from; i2 < n2; ++i2) {
                        StyledSection styledSection2 = this.findSectionContaining(i2);
                        if (styledSection2 != styledSection) {
                            if (styledSection != null) {
                                stringBuilder.append(styledSection.endStyles);
                            }
                            if (styledSection2 != null) {
                                stringBuilder.append(styledSection2.startStyles);
                            }
                            styledSection = styledSection2;
                        }
                        stringBuilder.append(this.plain.charAt(i2));
                    }
                    if (styledSection != null) {
                        stringBuilder.append(styledSection.endStyles);
                    }
                    return stringBuilder.toString();
                }

                private StyledSection findSectionContaining(int n2) {
                    for (StyledSection styledSection : this.sections) {
                        if (n2 < styledSection.startIndex || n2 >= styledSection.startIndex + styledSection.length) continue;
                        return styledSection;
                    }
                    return null;
                }
            }

            private static class StyledSection {
                int startIndex;
                int length;
                String startStyles;
                String endStyles;

                StyledSection(int n2, int n3, String string, String string2) {
                    this.startIndex = n2;
                    this.length = n3;
                    this.startStyles = string;
                    this.endStyles = string2;
                }

                StyledSection withStartIndex(int n2) {
                    return new StyledSection(n2, this.length, this.startStyles, this.endStyles);
                }
            }

            static class Palette256Color
            implements IStyle {
                private final int fgbg;
                private final int color;

                Palette256Color(boolean bl2, String string) {
                    this.fgbg = bl2 ? 38 : 48;
                    String[] stringArray = string.split(";");
                    this.color = stringArray.length == 3 ? 16 + 36 * Integer.decode(stringArray[0]) + 6 * Integer.decode(stringArray[1]) + Integer.decode(stringArray[2]) : Integer.decode(string);
                }

                @Override
                public String on() {
                    return String.format("\u001b[%d;5;%dm", this.fgbg, this.color);
                }

                @Override
                public String off() {
                    return "\u001b[" + (this.fgbg + 1) + "m";
                }
            }

            public static enum Style implements IStyle
            {
                reset(0, 0),
                bold(1, 21),
                faint(2, 22),
                italic(3, 23),
                underline(4, 24),
                blink(5, 25),
                reverse(7, 27),
                fg_black(30, 39),
                fg_red(31, 39),
                fg_green(32, 39),
                fg_yellow(33, 39),
                fg_blue(34, 39),
                fg_magenta(35, 39),
                fg_cyan(36, 39),
                fg_white(37, 39),
                bg_black(40, 49),
                bg_red(41, 49),
                bg_green(42, 49),
                bg_yellow(43, 49),
                bg_blue(44, 49),
                bg_magenta(45, 49),
                bg_cyan(46, 49),
                bg_white(47, 49);

                private final int startCode;
                private final int endCode;

                private Style(int n3, int n4) {
                    this.startCode = n3;
                    this.endCode = n4;
                }

                @Override
                public String on() {
                    return "\u001b[" + this.startCode + "m";
                }

                @Override
                public String off() {
                    return "\u001b[" + this.endCode + "m";
                }

                public static String on(IStyle ... iStyleArray) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (IStyle iStyle : iStyleArray) {
                        stringBuilder.append(iStyle.on());
                    }
                    return stringBuilder.toString();
                }

                public static String off(IStyle ... iStyleArray) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (IStyle iStyle : iStyleArray) {
                        stringBuilder.append(iStyle.off());
                    }
                    return stringBuilder.toString();
                }

                public static IStyle fg(String string) {
                    try {
                        return Style.valueOf(string.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("fg_" + string.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(true, string);
                        }
                    }
                }

                public static IStyle bg(String string) {
                    try {
                        return Style.valueOf(string.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("bg_" + string.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(false, string);
                        }
                    }
                }

                public static IStyle[] parse(String string) {
                    String[] stringArray = string.split(",");
                    IStyle[] iStyleArray = new IStyle[stringArray.length];
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        int n2;
                        if (stringArray[i2].toLowerCase(Locale.ENGLISH).startsWith("fg(")) {
                            n2 = stringArray[i2].indexOf(41);
                            iStyleArray[i2] = Style.fg(stringArray[i2].substring(3, n2 < 0 ? stringArray[i2].length() : n2));
                            continue;
                        }
                        if (stringArray[i2].toLowerCase(Locale.ENGLISH).startsWith("bg(")) {
                            n2 = stringArray[i2].indexOf(41);
                            iStyleArray[i2] = Style.bg(stringArray[i2].substring(3, n2 < 0 ? stringArray[i2].length() : n2));
                            continue;
                        }
                        iStyleArray[i2] = Style.fg(stringArray[i2]);
                    }
                    return iStyleArray;
                }
            }

            public static interface IStyle {
                public static final String CSI = "\u001b[";

                public String on();

                public String off();
            }
        }

        public static class ColorScheme {
            public final List<Ansi.IStyle> commandStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> optionStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> parameterStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> optionParamStyles = new ArrayList<Ansi.IStyle>();
            private final Ansi ansi;

            public ColorScheme() {
                this(Ansi.AUTO);
            }

            public ColorScheme(Ansi ansi) {
                this.ansi = Assert.notNull(ansi, "ansi");
            }

            public ColorScheme commands(Ansi.IStyle ... iStyleArray) {
                return this.addAll(this.commandStyles, iStyleArray);
            }

            public ColorScheme options(Ansi.IStyle ... iStyleArray) {
                return this.addAll(this.optionStyles, iStyleArray);
            }

            public ColorScheme parameters(Ansi.IStyle ... iStyleArray) {
                return this.addAll(this.parameterStyles, iStyleArray);
            }

            public ColorScheme optionParams(Ansi.IStyle ... iStyleArray) {
                return this.addAll(this.optionParamStyles, iStyleArray);
            }

            public Ansi.Text commandText(String string) {
                return this.ansi().apply(string, this.commandStyles);
            }

            public Ansi.Text optionText(String string) {
                return this.ansi().apply(string, this.optionStyles);
            }

            public Ansi.Text parameterText(String string) {
                return this.ansi().apply(string, this.parameterStyles);
            }

            public Ansi.Text optionParamText(String string) {
                return this.ansi().apply(string, this.optionParamStyles);
            }

            public ColorScheme applySystemProperties() {
                this.replace(this.commandStyles, System.getProperty("picocli.color.commands"));
                this.replace(this.optionStyles, System.getProperty("picocli.color.options"));
                this.replace(this.parameterStyles, System.getProperty("picocli.color.parameters"));
                this.replace(this.optionParamStyles, System.getProperty("picocli.color.optionParams"));
                return this;
            }

            private void replace(List<Ansi.IStyle> list, String string) {
                if (string != null) {
                    list.clear();
                    this.addAll(list, Ansi.Style.parse(string));
                }
            }

            private ColorScheme addAll(List<Ansi.IStyle> list, Ansi.IStyle ... iStyleArray) {
                list.addAll(Arrays.asList(iStyleArray));
                return this;
            }

            public Ansi ansi() {
                return this.ansi;
            }
        }

        public static class Column {
            public final int width;
            public final int indent;
            public final Overflow overflow;

            public Column(int n2, int n3, Overflow overflow) {
                this.width = n2;
                this.indent = n3;
                this.overflow = Assert.notNull(overflow, "overflow");
            }

            public static enum Overflow {
                TRUNCATE,
                SPAN,
                WRAP;

            }
        }

        public static class TextTable {
            public final Column[] columns;
            protected final List<Ansi.Text> columnValues = new ArrayList<Ansi.Text>();
            public int indentWrappedLines = 2;
            private final Ansi ansi;

            public TextTable(Ansi ansi) {
                this(ansi, new Column(2, 0, Column.Overflow.TRUNCATE), new Column(2, 0, Column.Overflow.TRUNCATE), new Column(1, 0, Column.Overflow.TRUNCATE), new Column(24, 1, Column.Overflow.SPAN), new Column(51, 1, Column.Overflow.WRAP));
            }

            public TextTable(Ansi ansi, int ... nArray) {
                this.ansi = Assert.notNull(ansi, "ansi");
                this.columns = new Column[nArray.length];
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    this.columns[i2] = new Column(nArray[i2], 0, i2 == nArray.length - 1 ? Column.Overflow.SPAN : Column.Overflow.WRAP);
                }
            }

            public TextTable(Ansi ansi, Column ... columnArray) {
                this.ansi = Assert.notNull(ansi, "ansi");
                this.columns = Assert.notNull(columnArray, "columns");
                if (columnArray.length == 0) {
                    throw new IllegalArgumentException("At least one column is required");
                }
            }

            public Ansi.Text textAt(int n2, int n3) {
                return this.columnValues.get(n3 + n2 * this.columns.length);
            }

            @Deprecated
            public Ansi.Text cellAt(int n2, int n3) {
                return this.textAt(n2, n3);
            }

            public int rowCount() {
                return this.columnValues.size() / this.columns.length;
            }

            public void addEmptyRow() {
                for (int i2 = 0; i2 < this.columns.length; ++i2) {
                    Ansi ansi = this.ansi;
                    ((Object)((Object)ansi)).getClass();
                    this.columnValues.add(ansi.new Ansi.Text(this.columns[i2].width));
                }
            }

            public void addRowValues(String ... stringArray) {
                Ansi.Text[] textArray = new Ansi.Text[stringArray.length];
                for (int i2 = 0; i2 < textArray.length; ++i2) {
                    Ansi.Text text;
                    if (stringArray[i2] == null) {
                        text = Ansi.EMPTY_TEXT;
                    } else {
                        Ansi ansi = this.ansi;
                        ((Object)((Object)ansi)).getClass();
                        text = ansi.new Ansi.Text(stringArray[i2]);
                    }
                    textArray[i2] = text;
                }
                this.addRowValues(textArray);
            }

            public void addRowValues(Ansi.Text ... textArray) {
                if (textArray.length > this.columns.length) {
                    throw new IllegalArgumentException(textArray.length + " values don't fit in " + this.columns.length + " columns");
                }
                this.addEmptyRow();
                for (int i2 = 0; i2 < textArray.length; ++i2) {
                    int n2 = this.rowCount() - 1;
                    Cell cell = this.putValue(n2, i2, textArray[i2]);
                    if (cell.row == n2 && cell.column == i2 || i2 == textArray.length - 1) continue;
                    this.addEmptyRow();
                }
            }

            public Cell putValue(int n2, int n3, Ansi.Text text) {
                if (n2 > this.rowCount() - 1) {
                    throw new IllegalArgumentException("Cannot write to row " + n2 + ": rowCount=" + this.rowCount());
                }
                if (text == null || text.plain.length() == 0) {
                    return new Cell(n3, n2);
                }
                Column column = this.columns[n3];
                int n4 = column.indent;
                switch (column.overflow) {
                    case TRUNCATE: {
                        TextTable.copy(text, this.textAt(n2, n3), n4);
                        return new Cell(n3, n2);
                    }
                    case SPAN: {
                        int n5 = n3;
                        do {
                            boolean bl2 = n3 == this.columns.length - 1;
                            int n6 = bl2 ? this.copy(BreakIterator.getLineInstance(), text, this.textAt(n2, n3), n4) : TextTable.copy(text, this.textAt(n2, n3), n4);
                            text = text.substring(n6);
                            n4 = 0;
                            if (text.length > 0) {
                                ++n3;
                            }
                            if (text.length <= 0 || n3 < this.columns.length) continue;
                            this.addEmptyRow();
                            ++n2;
                            n3 = n5;
                            n4 = column.indent + this.indentWrappedLines;
                        } while (text.length > 0);
                        return new Cell(n3, n2);
                    }
                    case WRAP: {
                        BreakIterator breakIterator = BreakIterator.getLineInstance();
                        do {
                            int n7 = this.copy(breakIterator, text, this.textAt(n2, n3), n4);
                            text = text.substring(n7);
                            n4 = column.indent + this.indentWrappedLines;
                            if (text.length <= 0) continue;
                            ++n2;
                            this.addEmptyRow();
                        } while (text.length > 0);
                        return new Cell(n3, n2);
                    }
                }
                throw new IllegalStateException(column.overflow.toString());
            }

            private static int length(Ansi.Text text) {
                return text.length;
            }

            private int copy(BreakIterator breakIterator, Ansi.Text text, Ansi.Text text2, int n2) {
                breakIterator.setText(text.plainString().replace("-", "\u00ff"));
                int n3 = 0;
                int n4 = breakIterator.first();
                int n5 = breakIterator.next();
                while (n5 != -1) {
                    Ansi.Text text3 = text.substring(n4, n5);
                    if (text2.maxLength < n2 + n3 + TextTable.length(text3)) break;
                    n3 += TextTable.copy(text3, text2, n2 + n3);
                    n4 = n5;
                    n5 = breakIterator.next();
                }
                if (n3 == 0 && TextTable.length(text) > text2.maxLength) {
                    n3 = TextTable.copy(text, text2, n2);
                }
                return n3;
            }

            private static int copy(Ansi.Text text, Ansi.Text text2, int n2) {
                int n3 = Math.min(text.length, text2.maxLength - n2);
                text.getStyledChars(text.from, n3, text2, n2);
                return n3;
            }

            public StringBuilder toString(StringBuilder stringBuilder) {
                int n2 = this.columns.length;
                StringBuilder stringBuilder2 = new StringBuilder(80);
                for (int i2 = 0; i2 < this.columnValues.size(); ++i2) {
                    int n3;
                    Ansi.Text text = this.columnValues.get(i2);
                    stringBuilder2.append(text.toString());
                    stringBuilder2.append(new String(Help.spaces(this.columns[i2 % n2].width - text.length)));
                    if (i2 % n2 != n2 - 1) continue;
                    for (n3 = stringBuilder2.length() - 1; n3 >= 0 && stringBuilder2.charAt(n3) == ' '; --n3) {
                    }
                    stringBuilder2.setLength(n3 + 1);
                    stringBuilder.append(stringBuilder2.toString()).append(System.getProperty("line.separator"));
                    stringBuilder2.setLength(0);
                }
                return stringBuilder;
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }

            public static class Cell {
                public final int column;
                public final int row;

                public Cell(int n2, int n3) {
                    this.column = n2;
                    this.row = n3;
                }
            }
        }

        static class SortByOptionArityAndNameAlphabetically
        extends SortByShortestOptionNameAlphabetically {
            SortByOptionArityAndNameAlphabetically() {
            }

            @Override
            public int compare(Field field, Field field2) {
                Option option = field.getAnnotation(Option.class);
                Option option2 = field2.getAnnotation(Option.class);
                Range range = Range.optionArity(field);
                Range range2 = Range.optionArity(field2);
                int n2 = range.max - range2.max;
                if (n2 == 0) {
                    n2 = range.min - range2.min;
                }
                if (n2 == 0) {
                    if (CommandLine.isMultiValue(field) && !CommandLine.isMultiValue(field2)) {
                        n2 = 1;
                    }
                    if (!CommandLine.isMultiValue(field) && CommandLine.isMultiValue(field2)) {
                        n2 = -1;
                    }
                }
                return n2 == 0 ? super.compare(field, field2) : n2;
            }
        }

        static class SortByShortestOptionNameAlphabetically
        implements Comparator<Field> {
            SortByShortestOptionNameAlphabetically() {
            }

            @Override
            public int compare(Field field, Field field2) {
                Option option = field.getAnnotation(Option.class);
                Option option2 = field2.getAnnotation(Option.class);
                if (option == null) {
                    return 1;
                }
                if (option2 == null) {
                    return -1;
                }
                String[] stringArray = ShortestFirst.sort(option.names());
                String[] stringArray2 = ShortestFirst.sort(option2.names());
                int n2 = stringArray[0].toUpperCase().compareTo(stringArray2[0].toUpperCase());
                int n3 = n2 = n2 == 0 ? -stringArray[0].compareTo(stringArray2[0]) : n2;
                return option.help() == option2.help() ? n2 : (option2.help() ? -1 : 1);
            }
        }

        static class ShortestFirst
        implements Comparator<String> {
            ShortestFirst() {
            }

            @Override
            public int compare(String string, String string2) {
                return string.length() - string2.length();
            }

            public static String[] sort(String[] stringArray) {
                Arrays.sort(stringArray, new ShortestFirst());
                return stringArray;
            }
        }

        public static class Layout {
            protected final ColorScheme colorScheme;
            protected final TextTable table;
            protected IOptionRenderer optionRenderer;
            protected IParameterRenderer parameterRenderer;

            public Layout(ColorScheme colorScheme) {
                this(colorScheme, new TextTable(colorScheme.ansi()));
            }

            public Layout(ColorScheme colorScheme, TextTable textTable) {
                this(colorScheme, textTable, new DefaultOptionRenderer(), new DefaultParameterRenderer());
            }

            public Layout(ColorScheme colorScheme, TextTable textTable, IOptionRenderer iOptionRenderer, IParameterRenderer iParameterRenderer) {
                this.colorScheme = Assert.notNull(colorScheme, "colorScheme");
                this.table = Assert.notNull(textTable, "textTable");
                this.optionRenderer = Assert.notNull(iOptionRenderer, "optionRenderer");
                this.parameterRenderer = Assert.notNull(iParameterRenderer, "parameterRenderer");
            }

            public void layout(Field field, Ansi.Text[][] textArray) {
                for (Ansi.Text[] textArray2 : textArray) {
                    this.table.addRowValues(textArray2);
                }
            }

            public void addOptions(List<Field> list, IParamLabelRenderer iParamLabelRenderer) {
                for (Field field : list) {
                    Option option = field.getAnnotation(Option.class);
                    if (option.hidden()) continue;
                    this.addOption(field, iParamLabelRenderer);
                }
            }

            public void addOption(Field field, IParamLabelRenderer iParamLabelRenderer) {
                Option option = field.getAnnotation(Option.class);
                Ansi.Text[][] textArray = this.optionRenderer.render(option, field, iParamLabelRenderer, this.colorScheme);
                this.layout(field, textArray);
            }

            public void addPositionalParameters(List<Field> list, IParamLabelRenderer iParamLabelRenderer) {
                for (Field field : list) {
                    Parameters parameters = field.getAnnotation(Parameters.class);
                    if (parameters.hidden()) continue;
                    this.addPositionalParameter(field, iParamLabelRenderer);
                }
            }

            public void addPositionalParameter(Field field, IParamLabelRenderer iParamLabelRenderer) {
                Parameters parameters = field.getAnnotation(Parameters.class);
                Ansi.Text[][] textArray = this.parameterRenderer.render(parameters, field, iParamLabelRenderer, this.colorScheme);
                this.layout(field, textArray);
            }

            public String toString() {
                return this.table.toString();
            }
        }

        static class DefaultParamLabelRenderer
        implements IParamLabelRenderer {
            public final String separator;

            public DefaultParamLabelRenderer(String string) {
                this.separator = Assert.notNull(string, "separator");
            }

            @Override
            public String separator() {
                return this.separator;
            }

            @Override
            public Ansi.Text renderParameterLabel(Field field, Ansi ansi, List<Ansi.IStyle> list) {
                Ansi.Text text;
                block6: {
                    int n2;
                    Ansi.Text text2;
                    String string;
                    Range range;
                    boolean bl2;
                    block4: {
                        block5: {
                            bl2 = field.isAnnotationPresent(Option.class);
                            range = bl2 ? Range.optionArity(field) : Range.parameterCapacity(field);
                            String string2 = bl2 ? field.getAnnotation(Option.class).split() : field.getAnnotation(Parameters.class).split();
                            Ansi ansi2 = ansi;
                            ((Object)((Object)ansi2)).getClass();
                            text = ansi2.new Ansi.Text("");
                            string = bl2 ? this.separator : "";
                            text2 = ansi.apply(DefaultParamLabelRenderer.renderParameterName(field), list);
                            if (!CommandLine.empty(string2)) {
                                text2 = text2.append("[" + string2).append(text2).append("]...");
                            }
                            for (n2 = 0; n2 < range.min; ++n2) {
                                text = text.append(string).append(text2);
                                string = " ";
                            }
                            if (!range.isVariable) break block4;
                            if (text.length != 0) break block5;
                            text = text.append(string + "[").append(text2).append("]...");
                            break block6;
                        }
                        if (text.plainString().endsWith("...")) break block6;
                        text = text.append("...");
                        break block6;
                    }
                    string = text.length == 0 ? (bl2 ? this.separator : "") : " ";
                    for (n2 = range.min; n2 < range.max; ++n2) {
                        text = string.trim().length() == 0 ? text.append(string + "[").append(text2) : text.append("[" + string).append(text2);
                        string = " ";
                    }
                    for (n2 = range.min; n2 < range.max; ++n2) {
                        text = text.append("]");
                    }
                }
                return text;
            }

            private static String renderParameterName(Field field) {
                String string = null;
                if (field.isAnnotationPresent(Option.class)) {
                    string = field.getAnnotation(Option.class).paramLabel();
                } else if (field.isAnnotationPresent(Parameters.class)) {
                    string = field.getAnnotation(Parameters.class).paramLabel();
                }
                if (string != null && string.trim().length() > 0) {
                    return string.trim();
                }
                String string2 = field.getName();
                if (Map.class.isAssignableFrom(field.getType())) {
                    Class[] classArray = CommandLine.getTypeAttribute(field);
                    string2 = classArray.length < 2 || classArray[0] == null || classArray[1] == null ? "String=String" : classArray[0].getSimpleName() + Help.DEFAULT_SEPARATOR + classArray[1].getSimpleName();
                }
                return "<" + string2 + ">";
            }
        }

        public static interface IParamLabelRenderer {
            public Ansi.Text renderParameterLabel(Field var1, Ansi var2, List<Ansi.IStyle> var3);

            public String separator();
        }

        static class DefaultParameterRenderer
        implements IParameterRenderer {
            public String requiredMarker = " ";

            DefaultParameterRenderer() {
            }

            @Override
            public Ansi.Text[][] render(Parameters parameters, Field field, IParamLabelRenderer iParamLabelRenderer, ColorScheme colorScheme) {
                int n2;
                Ansi.Text text = iParamLabelRenderer.renderParameterLabel(field, colorScheme.ansi(), colorScheme.parameterStyles);
                Ansi.Text text2 = colorScheme.parameterText(Range.parameterArity((Field)field).min > 0 ? this.requiredMarker : "");
                Ansi.Text text3 = Ansi.EMPTY_TEXT;
                ArrayList<Ansi.Text[]> arrayList = new ArrayList<Ansi.Text[]>();
                Ansi ansi = colorScheme.ansi();
                ((Object)((Object)ansi)).getClass();
                Ansi.Text[] textArray = ansi.new Ansi.Text(CommandLine.str(parameters.description(), 0)).splitLines();
                if (textArray.length == 0) {
                    textArray = new Ansi.Text[]{text3};
                }
                arrayList.add(new Ansi.Text[]{text2, text3, text3, text, textArray[0]});
                for (n2 = 1; n2 < textArray.length; ++n2) {
                    arrayList.add(new Ansi.Text[]{text3, text3, text3, text3, textArray[n2]});
                }
                for (n2 = 1; n2 < parameters.description().length; ++n2) {
                    Ansi.Text[] textArray2;
                    Ansi ansi2 = colorScheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    for (Ansi.Text text4 : textArray2 = ansi2.new Ansi.Text(parameters.description()[n2]).splitLines()) {
                        arrayList.add(new Ansi.Text[]{text3, text3, text3, text3, text4});
                    }
                }
                return (Ansi.Text[][])arrayList.toArray((T[])new Ansi.Text[arrayList.size()][]);
            }
        }

        public static interface IParameterRenderer {
            public Ansi.Text[][] render(Parameters var1, Field var2, IParamLabelRenderer var3, ColorScheme var4);
        }

        static class MinimalParameterRenderer
        implements IParameterRenderer {
            MinimalParameterRenderer() {
            }

            @Override
            public Ansi.Text[][] render(Parameters parameters, Field field, IParamLabelRenderer iParamLabelRenderer, ColorScheme colorScheme) {
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = iParamLabelRenderer.renderParameterLabel(field, colorScheme.ansi(), colorScheme.parameterStyles);
                Ansi ansi = colorScheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(parameters.description().length == 0 ? "" : parameters.description()[0]);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class MinimalOptionRenderer
        implements IOptionRenderer {
            MinimalOptionRenderer() {
            }

            @Override
            public Ansi.Text[][] render(Option option, Field field, IParamLabelRenderer iParamLabelRenderer, ColorScheme colorScheme) {
                Ansi.Text text = colorScheme.optionText(option.names()[0]);
                Ansi.Text text2 = iParamLabelRenderer.renderParameterLabel(field, colorScheme.ansi(), colorScheme.optionParamStyles);
                text = text.append(text2);
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = text;
                Ansi ansi = colorScheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(option.description().length == 0 ? "" : option.description()[0]);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class DefaultOptionRenderer
        implements IOptionRenderer {
            public String requiredMarker = " ";
            public Object command;
            private String sep;
            private boolean showDefault;

            DefaultOptionRenderer() {
            }

            @Override
            public Ansi.Text[][] render(Option option, Field field, IParamLabelRenderer iParamLabelRenderer, ColorScheme colorScheme) {
                String[] stringArray = ShortestFirst.sort(option.names());
                int n2 = stringArray[0].length() == 2 ? 1 : 0;
                String string = n2 > 0 ? stringArray[0] : "";
                this.sep = n2 > 0 && stringArray.length > 1 ? "," : "";
                String string2 = Help.join(stringArray, n2, stringArray.length - n2, ", ");
                Ansi.Text text = this.createLongOptionText(field, iParamLabelRenderer, colorScheme, string2);
                this.showDefault = this.command != null && !option.help() && !CommandLine.isBoolean(field.getType());
                Object object = this.createDefaultValue(field);
                String string3 = option.required() ? this.requiredMarker : "";
                return this.renderDescriptionLines(option, colorScheme, string3, string, text, object);
            }

            private Object createDefaultValue(Field field) {
                Object object = null;
                try {
                    object = field.get(this.command);
                    if (object == null) {
                        this.showDefault = false;
                    } else if (field.getType().isArray()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i2 = 0; i2 < Array.getLength(object); ++i2) {
                            stringBuilder.append(i2 > 0 ? ", " : "").append(Array.get(object, i2));
                        }
                        object = stringBuilder.insert(0, "[").append("]").toString();
                    }
                }
                catch (Exception exception) {
                    this.showDefault = false;
                }
                return object;
            }

            private Ansi.Text createLongOptionText(Field field, IParamLabelRenderer iParamLabelRenderer, ColorScheme colorScheme, String string) {
                Ansi.Text text = iParamLabelRenderer.renderParameterLabel(field, colorScheme.ansi(), colorScheme.optionParamStyles);
                if (text.length > 0 && string.length() == 0) {
                    this.sep = iParamLabelRenderer.separator();
                    int n2 = text.plainString().indexOf(this.sep);
                    Ansi.Text text2 = text.substring(0, n2);
                    text = text2.append(text.substring(n2 + this.sep.length()));
                }
                Ansi.Text text3 = colorScheme.optionText(string);
                text3 = text3.append(text);
                return text3;
            }

            private Ansi.Text[][] renderDescriptionLines(Option option, ColorScheme colorScheme, String string, String string2, Ansi.Text text, Object object) {
                int n2;
                Ansi.Text text2 = Ansi.EMPTY_TEXT;
                ArrayList<Ansi.Text[]> arrayList = new ArrayList<Ansi.Text[]>();
                Ansi ansi = colorScheme.ansi();
                ((Object)((Object)ansi)).getClass();
                Ansi.Text[] textArray = ansi.new Ansi.Text(CommandLine.str(option.description(), 0)).splitLines();
                if (textArray.length == 0) {
                    if (this.showDefault) {
                        Ansi.Text[] textArray2 = new Ansi.Text[1];
                        Ansi ansi2 = colorScheme.ansi();
                        ((Object)((Object)ansi2)).getClass();
                        textArray2[0] = ansi2.new Ansi.Text("  Default: " + object);
                        textArray = textArray2;
                        this.showDefault = false;
                    } else {
                        textArray = new Ansi.Text[]{text2};
                    }
                }
                Ansi.Text[] textArray3 = new Ansi.Text[5];
                textArray3[0] = colorScheme.optionText(string);
                textArray3[1] = colorScheme.optionText(string2);
                Ansi ansi3 = colorScheme.ansi();
                ((Object)((Object)ansi3)).getClass();
                textArray3[2] = ansi3.new Ansi.Text(this.sep);
                textArray3[3] = text;
                textArray3[4] = textArray[0];
                arrayList.add(textArray3);
                for (n2 = 1; n2 < textArray.length; ++n2) {
                    arrayList.add(new Ansi.Text[]{text2, text2, text2, text2, textArray[n2]});
                }
                for (n2 = 1; n2 < option.description().length; ++n2) {
                    Ansi.Text[] textArray4;
                    Ansi ansi4 = colorScheme.ansi();
                    ((Object)((Object)ansi4)).getClass();
                    for (Ansi.Text text3 : textArray4 = ansi4.new Ansi.Text(option.description()[n2]).splitLines()) {
                        arrayList.add(new Ansi.Text[]{text2, text2, text2, text2, text3});
                    }
                }
                if (this.showDefault) {
                    Ansi.Text[] textArray5 = new Ansi.Text[5];
                    textArray5[0] = text2;
                    textArray5[1] = text2;
                    textArray5[2] = text2;
                    textArray5[3] = text2;
                    Ansi ansi5 = colorScheme.ansi();
                    ((Object)((Object)ansi5)).getClass();
                    textArray5[4] = ansi5.new Ansi.Text("  Default: " + object);
                    arrayList.add(textArray5);
                }
                return (Ansi.Text[][])arrayList.toArray((T[])new Ansi.Text[arrayList.size()][]);
            }
        }

        public static interface IOptionRenderer {
            public Ansi.Text[][] render(Option var1, Field var2, IParamLabelRenderer var3, ColorScheme var4);
        }
    }

    private static class BuiltIn {
        private BuiltIn() {
        }

        static class UUIDConverter
        implements ITypeConverter<UUID> {
            UUIDConverter() {
            }

            @Override
            public UUID convert(String string) throws Exception {
                return UUID.fromString(string);
            }
        }

        static class PatternConverter
        implements ITypeConverter<Pattern> {
            PatternConverter() {
            }

            @Override
            public Pattern convert(String string) {
                return Pattern.compile(string);
            }
        }

        static class InetAddressConverter
        implements ITypeConverter<InetAddress> {
            InetAddressConverter() {
            }

            @Override
            public InetAddress convert(String string) throws Exception {
                return InetAddress.getByName(string);
            }
        }

        static class CharsetConverter
        implements ITypeConverter<Charset> {
            CharsetConverter() {
            }

            @Override
            public Charset convert(String string) {
                return Charset.forName(string);
            }
        }

        static class BigIntegerConverter
        implements ITypeConverter<BigInteger> {
            BigIntegerConverter() {
            }

            @Override
            public BigInteger convert(String string) {
                return new BigInteger(string);
            }
        }

        static class BigDecimalConverter
        implements ITypeConverter<BigDecimal> {
            BigDecimalConverter() {
            }

            @Override
            public BigDecimal convert(String string) {
                return new BigDecimal(string);
            }
        }

        static class ISO8601TimeConverter
        implements ITypeConverter<Time> {
            ISO8601TimeConverter() {
            }

            @Override
            public Time convert(String string) {
                try {
                    if (string.length() <= 5) {
                        return new Time(new SimpleDateFormat("HH:mm").parse(string).getTime());
                    }
                    if (string.length() <= 8) {
                        return new Time(new SimpleDateFormat("HH:mm:ss").parse(string).getTime());
                    }
                    if (string.length() <= 12) {
                        try {
                            return new Time(new SimpleDateFormat("HH:mm:ss.SSS").parse(string).getTime());
                        }
                        catch (ParseException parseException) {
                            return new Time(new SimpleDateFormat("HH:mm:ss,SSS").parse(string).getTime());
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                throw new TypeConversionException("'" + string + "' is not a HH:mm[:ss[.SSS]] time");
            }
        }

        static class ISO8601DateConverter
        implements ITypeConverter<Date> {
            ISO8601DateConverter() {
            }

            @Override
            public Date convert(String string) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(string);
                }
                catch (ParseException parseException) {
                    throw new TypeConversionException("'" + string + "' is not a yyyy-MM-dd date");
                }
            }
        }

        static class URIConverter
        implements ITypeConverter<URI> {
            URIConverter() {
            }

            @Override
            public URI convert(String string) throws URISyntaxException {
                return new URI(string);
            }
        }

        static class URLConverter
        implements ITypeConverter<URL> {
            URLConverter() {
            }

            @Override
            public URL convert(String string) throws MalformedURLException {
                return new URL(string);
            }
        }

        static class FileConverter
        implements ITypeConverter<File> {
            FileConverter() {
            }

            @Override
            public File convert(String string) {
                return new File(string);
            }
        }

        static class DoubleConverter
        implements ITypeConverter<Double> {
            DoubleConverter() {
            }

            @Override
            public Double convert(String string) {
                return Double.valueOf(string);
            }
        }

        static class FloatConverter
        implements ITypeConverter<Float> {
            FloatConverter() {
            }

            @Override
            public Float convert(String string) {
                return Float.valueOf(string);
            }
        }

        static class LongConverter
        implements ITypeConverter<Long> {
            LongConverter() {
            }

            @Override
            public Long convert(String string) {
                return Long.valueOf(string);
            }
        }

        static class IntegerConverter
        implements ITypeConverter<Integer> {
            IntegerConverter() {
            }

            @Override
            public Integer convert(String string) {
                return Integer.valueOf(string);
            }
        }

        static class ShortConverter
        implements ITypeConverter<Short> {
            ShortConverter() {
            }

            @Override
            public Short convert(String string) {
                return Short.valueOf(string);
            }
        }

        static class CharacterConverter
        implements ITypeConverter<Character> {
            CharacterConverter() {
            }

            @Override
            public Character convert(String string) {
                if (string.length() > 1) {
                    throw new TypeConversionException("'" + string + "' is not a single character");
                }
                return Character.valueOf(string.charAt(0));
            }
        }

        static class BooleanConverter
        implements ITypeConverter<Boolean> {
            BooleanConverter() {
            }

            @Override
            public Boolean convert(String string) {
                if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                    return Boolean.parseBoolean(string);
                }
                throw new TypeConversionException("'" + string + "' is not a boolean");
            }
        }

        static class ByteConverter
        implements ITypeConverter<Byte> {
            ByteConverter() {
            }

            @Override
            public Byte convert(String string) {
                return Byte.valueOf(string);
            }
        }

        static class CharSequenceConverter
        implements ITypeConverter<CharSequence> {
            CharSequenceConverter() {
            }

            @Override
            public String convert(String string) {
                return string;
            }
        }

        static class StringBuilderConverter
        implements ITypeConverter<StringBuilder> {
            StringBuilderConverter() {
            }

            @Override
            public StringBuilder convert(String string) {
                return new StringBuilder(string);
            }
        }

        static class StringConverter
        implements ITypeConverter<String> {
            StringConverter() {
            }

            @Override
            public String convert(String string) {
                return string;
            }
        }

        static class PathConverter
        implements ITypeConverter<Path> {
            PathConverter() {
            }

            @Override
            public Path convert(String string) {
                return Paths.get(string, new String[0]);
            }
        }
    }

    private static class PositionalParametersSorter
    implements Comparator<Field> {
        private PositionalParametersSorter() {
        }

        @Override
        public int compare(Field field, Field field2) {
            int n2 = Range.parameterIndex(field).compareTo(Range.parameterIndex(field2));
            return n2 == 0 ? Range.parameterArity(field).compareTo(Range.parameterArity(field2)) : n2;
        }
    }

    private class Interpreter {
        private final Map<String, CommandLine> commands = new LinkedHashMap<String, CommandLine>();
        private final Map<Class<?>, ITypeConverter<?>> converterRegistry = new HashMap();
        private final Map<String, Field> optionName2Field = new HashMap<String, Field>();
        private final Map<Character, Field> singleCharOption2Field = new HashMap<Character, Field>();
        private final List<Field> requiredFields = new ArrayList<Field>();
        private final List<Field> positionalParametersFields = new ArrayList<Field>();
        private final Object command;
        private boolean isHelpRequested;
        private String separator = "=";
        private int position;

        Interpreter(Object object) {
            this.converterRegistry.put(Path.class, new BuiltIn.PathConverter());
            this.converterRegistry.put(Object.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(String.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(StringBuilder.class, new BuiltIn.StringBuilderConverter());
            this.converterRegistry.put(CharSequence.class, new BuiltIn.CharSequenceConverter());
            this.converterRegistry.put(Byte.class, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Byte.TYPE, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Boolean.class, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Boolean.TYPE, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Character.class, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Character.TYPE, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Short.class, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Short.TYPE, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Integer.class, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Integer.TYPE, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Long.class, new BuiltIn.LongConverter());
            this.converterRegistry.put(Long.TYPE, new BuiltIn.LongConverter());
            this.converterRegistry.put(Float.class, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Float.TYPE, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Double.class, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(Double.TYPE, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(File.class, new BuiltIn.FileConverter());
            this.converterRegistry.put(URI.class, new BuiltIn.URIConverter());
            this.converterRegistry.put(URL.class, new BuiltIn.URLConverter());
            this.converterRegistry.put(Date.class, new BuiltIn.ISO8601DateConverter());
            this.converterRegistry.put(Time.class, new BuiltIn.ISO8601TimeConverter());
            this.converterRegistry.put(BigDecimal.class, new BuiltIn.BigDecimalConverter());
            this.converterRegistry.put(BigInteger.class, new BuiltIn.BigIntegerConverter());
            this.converterRegistry.put(Charset.class, new BuiltIn.CharsetConverter());
            this.converterRegistry.put(InetAddress.class, new BuiltIn.InetAddressConverter());
            this.converterRegistry.put(Pattern.class, new BuiltIn.PatternConverter());
            this.converterRegistry.put(UUID.class, new BuiltIn.UUIDConverter());
            this.command = Assert.notNull(object, "command");
            String string = null;
            String string2 = null;
            boolean bl2 = false;
            for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                CommandLine.init(clazz, this.requiredFields, this.optionName2Field, this.singleCharOption2Field, this.positionalParametersFields);
                if (!clazz.isAnnotationPresent(Command.class)) continue;
                bl2 = true;
                Command command = clazz.getAnnotation(Command.class);
                string2 = string2 == null ? command.separator() : string2;
                string = string == null ? command.name() : string;
                CommandLine.this.versionLines.addAll(Arrays.asList(command.version()));
                for (Class<?> clazz2 : command.subcommands()) {
                    Command command2 = clazz2.getAnnotation(Command.class);
                    if (command2 == null || "<main class>".equals(command2.name())) {
                        throw new InitializationException("Subcommand " + clazz2.getName() + " is missing the mandatory @Command annotation with a 'name' attribute");
                    }
                    try {
                        Constructor<?> constructor = clazz2.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        CommandLine commandLine2 = CommandLine.toCommandLine(constructor.newInstance(new Object[0]));
                        commandLine2.parent = CommandLine.this;
                        this.commands.put(command2.name(), commandLine2);
                    }
                    catch (InitializationException initializationException) {
                        throw initializationException;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new InitializationException("Cannot instantiate subcommand " + clazz2.getName() + ": the class has no constructor", noSuchMethodException);
                    }
                    catch (Exception exception) {
                        throw new InitializationException("Could not instantiate and add subcommand " + clazz2.getName() + ": " + exception, exception);
                    }
                }
            }
            this.separator = string2 != null ? string2 : this.separator;
            CommandLine.this.commandName = string != null ? string : CommandLine.this.commandName;
            Collections.sort(this.positionalParametersFields, new PositionalParametersSorter());
            CommandLine.validatePositionalParameters(this.positionalParametersFields);
            if (this.positionalParametersFields.isEmpty() && this.optionName2Field.isEmpty() && !bl2) {
                throw new InitializationException(object + " (" + object.getClass() + ") is not a command: it has no @Command, @Option or @Parameters annotations");
            }
        }

        List<CommandLine> parse(String ... stringArray) {
            Assert.notNull(stringArray, "argument array");
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Parsing %d command line args %s%n", stringArray.length, Arrays.toString(stringArray));
            }
            Stack<String> stack = new Stack<String>();
            for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                stack.push(stringArray[i2]);
            }
            ArrayList<CommandLine> arrayList = new ArrayList<CommandLine>();
            this.parse(arrayList, stack, stringArray);
            return arrayList;
        }

        private void parse(List<CommandLine> list, Stack<String> stack, String[] stringArray) {
            this.isHelpRequested = false;
            CommandLine.this.versionHelpRequested = false;
            CommandLine.this.usageHelpRequested = false;
            Class<?> clazz = this.command.getClass();
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Initializing %s: %d options, %d positional parameters, %d required, %d subcommands.%n", clazz.getName(), new HashSet<Field>(this.optionName2Field.values()).size(), this.positionalParametersFields.size(), this.requiredFields.size(), this.commands.size());
            }
            list.add(CommandLine.this);
            ArrayList<Field> arrayList = new ArrayList<Field>(this.requiredFields);
            HashSet<Field> hashSet = new HashSet<Field>();
            Collections.sort(arrayList, new PositionalParametersSorter());
            try {
                this.processArguments(list, stack, arrayList, hashSet, stringArray);
            }
            catch (ParameterException parameterException) {
                throw parameterException;
            }
            catch (Exception exception) {
                int n2 = stringArray.length - stack.size() - 1;
                String string = n2 >= 0 && n2 < stringArray.length ? stringArray[n2] : "?";
                throw ParameterException.create(CommandLine.this, exception, string, n2, stringArray);
            }
            if (!this.isAnyHelpRequested() && !arrayList.isEmpty()) {
                for (Field field : arrayList) {
                    if (field.isAnnotationPresent(Option.class)) {
                        throw MissingParameterException.create(CommandLine.this, arrayList, this.separator);
                    }
                    this.assertNoMissingParameters(field, Range.parameterArity((Field)field).min, stack);
                }
            }
            if (!CommandLine.this.unmatchedArguments.isEmpty()) {
                if (!CommandLine.this.isUnmatchedArgumentsAllowed()) {
                    throw new UnmatchedArgumentException(CommandLine.this, CommandLine.this.unmatchedArguments);
                }
                if (CommandLine.this.tracer.isWarn()) {
                    CommandLine.this.tracer.warn("Unmatched arguments: %s%n", CommandLine.this.unmatchedArguments);
                }
            }
        }

        private void processArguments(List<CommandLine> list, Stack<String> stack, Collection<Field> collection, Set<Field> set, String[] stringArray) throws Exception {
            while (!stack.isEmpty()) {
                String string = stack.pop();
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Processing argument '%s'. Remainder=%s%n", string, CommandLine.reverse((Stack)stack.clone()));
                }
                if ("--".equals(string)) {
                    CommandLine.this.tracer.info("Found end-of-options delimiter '--'. Treating remainder as positional parameters.%n", new Object[0]);
                    this.processRemainderAsPositionalParameters(collection, set, stack);
                    return;
                }
                if (this.commands.containsKey(string)) {
                    if (!this.isHelpRequested && !collection.isEmpty()) {
                        throw MissingParameterException.create(CommandLine.this, collection, this.separator);
                    }
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Found subcommand '%s' (%s)%n", string, ((CommandLine)this.commands.get((Object)string)).interpreter.command.getClass().getName());
                    }
                    this.commands.get(string).interpreter.parse(list, stack, stringArray);
                    return;
                }
                boolean bl2 = false;
                int n2 = string.indexOf(this.separator);
                if (n2 > 0) {
                    String string2 = string.substring(0, n2);
                    if (this.optionName2Field.containsKey(string2) && !this.optionName2Field.containsKey(string)) {
                        bl2 = true;
                        String string3 = string.substring(n2 + this.separator.length());
                        stack.push(string3);
                        string = string2;
                        if (CommandLine.this.tracer.isDebug()) {
                            CommandLine.this.tracer.debug("Separated '%s' option from '%s' option parameter%n", string2, string3);
                        }
                    } else if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("'%s' contains separator '%s' but '%s' is not a known option%n", string, this.separator, string2);
                    }
                } else if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("'%s' cannot be separated into <option>%s<option-parameter>%n", string, this.separator);
                }
                if (this.optionName2Field.containsKey(string)) {
                    this.processStandaloneOption(collection, set, string, stack, bl2);
                    continue;
                }
                if (string.length() > 2 && string.startsWith("-")) {
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Trying to process '%s' as clustered short options%n", string, stack);
                    }
                    this.processClusteredShortOptions(collection, set, string, stack);
                    continue;
                }
                stack.push(string);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Could not find option '%s', deciding whether to treat as unmatched option or positional parameter...%n", string);
                }
                if (this.resemblesOption(string)) {
                    this.handleUnmatchedArguments(stack.pop());
                    continue;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("No option named '%s' found. Processing remainder as positional parameters%n", string);
                }
                this.processPositionalParameter(collection, set, stack);
            }
        }

        private boolean resemblesOption(String string) {
            boolean bl2;
            int n2 = 0;
            for (String string2 : this.optionName2Field.keySet()) {
                for (int i2 = 0; i2 < string.length() && string2.length() > i2 && string.charAt(i2) == string2.charAt(i2); ++i2) {
                    ++n2;
                }
            }
            boolean bl3 = bl2 = n2 > 0 && n2 * 10 >= this.optionName2Field.size() * 9;
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("%s %s an option: %d matching prefix chars out of %d option names%n", string, bl2 ? "resembles" : "doesn't resemble", n2, this.optionName2Field.size());
            }
            return bl2;
        }

        private void handleUnmatchedArguments(String string) {
            Stack<String> stack = new Stack<String>();
            stack.add(string);
            this.handleUnmatchedArguments(stack);
        }

        private void handleUnmatchedArguments(Stack<String> stack) {
            while (!stack.isEmpty()) {
                CommandLine.this.unmatchedArguments.add(stack.pop());
            }
        }

        private void processRemainderAsPositionalParameters(Collection<Field> collection, Set<Field> set, Stack<String> stack) throws Exception {
            while (!stack.empty()) {
                this.processPositionalParameter(collection, set, stack);
            }
        }

        private void processPositionalParameter(Collection<Field> collection, Set<Field> set, Stack<String> stack) throws Exception {
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Processing next arg as a positional parameter at index=%d. Remainder=%s%n", this.position, CommandLine.reverse((Stack)stack.clone()));
            }
            int n2 = 0;
            for (Field field : this.positionalParametersFields) {
                Range range = Range.parameterIndex(field);
                if (!range.contains(this.position)) continue;
                Stack stack2 = (Stack)stack.clone();
                Range range2 = Range.parameterArity(field);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Position %d is in index range %s. Trying to assign args to %s, arity=%s%n", this.position, range, field, range2);
                }
                this.assertNoMissingParameters(field, range2.min, stack2);
                int n3 = stack2.size();
                this.applyOption(field, Parameters.class, range2, false, stack2, set, "args[" + range + "] at position " + this.position);
                int n4 = n3 - stack2.size();
                if (n4 > 0) {
                    collection.remove(field);
                }
                n2 = Math.max(n2, n4);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                stack.pop();
            }
            this.position += n2;
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Consumed %d arguments, moving position to index %d.%n", n2, this.position);
            }
            if (n2 == 0 && !stack.isEmpty()) {
                this.handleUnmatchedArguments(stack.pop());
            }
        }

        private void processStandaloneOption(Collection<Field> collection, Set<Field> set, String string, Stack<String> stack, boolean bl2) throws Exception {
            Field field = this.optionName2Field.get(string);
            collection.remove(field);
            Range range = Range.optionArity(field);
            if (bl2) {
                range = range.min(Math.max(1, range.min));
            }
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Found option named '%s': field %s, arity=%s%n", string, field, range);
            }
            this.applyOption(field, Option.class, range, bl2, stack, set, "option " + string);
        }

        private void processClusteredShortOptions(Collection<Field> collection, Set<Field> set, String string, Stack<String> stack) throws Exception {
            String string2 = string.substring(0, 1);
            String string3 = string.substring(1);
            boolean bl2 = true;
            while (string3.length() > 0 && this.singleCharOption2Field.containsKey(Character.valueOf(string3.charAt(0)))) {
                Field field = this.singleCharOption2Field.get(Character.valueOf(string3.charAt(0)));
                Range range = Range.optionArity(field);
                String string4 = "option " + string2 + string3.charAt(0);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Found option '%s%s' in %s: field %s, arity=%s%n", string2, Character.valueOf(string3.charAt(0)), string, field, range);
                }
                collection.remove(field);
                string3 = string3.length() > 0 ? string3.substring(1) : "";
                boolean bl3 = bl2 = string3.length() > 0;
                if (string3.startsWith(this.separator)) {
                    string3 = string3.substring(this.separator.length());
                    range = range.min(Math.max(1, range.min));
                }
                if (range.min > 0 && !CommandLine.empty(string3) && CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Trying to process '%s' as option parameter%n", string3);
                }
                if (!CommandLine.empty(string3)) {
                    stack.push(string3);
                }
                int n2 = this.applyOption(field, Option.class, range, bl2, stack, set, string4);
                if (CommandLine.empty(string3) || n2 > 0 || stack.isEmpty()) {
                    return;
                }
                string3 = stack.pop();
            }
            if (string3.length() == 0) {
                return;
            }
            if (string.endsWith(string3)) {
                stack.push(bl2 ? string2 + string3 : string3);
                if (stack.peek().equals(string)) {
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Could not match any short options in %s, deciding whether to treat as unmatched option or positional parameter...%n", string);
                    }
                    if (this.resemblesOption(string)) {
                        this.handleUnmatchedArguments(stack.pop());
                        return;
                    }
                    this.processPositionalParameter(collection, set, stack);
                    return;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("No option found for %s in %s%n", string3, string);
                }
                this.handleUnmatchedArguments(stack.pop());
            } else {
                stack.push(string3);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("%s is not an option parameter for %s%n", string3, string);
                }
                this.processPositionalParameter(collection, set, stack);
            }
        }

        private int applyOption(Field field, Class<?> clazz, Range range, boolean bl2, Stack<String> stack, Set<Field> set, String string) throws Exception {
            this.updateHelpRequested(field);
            int n2 = stack.size();
            this.assertNoMissingParameters(field, range.min, stack);
            Class clazz2 = field.getType();
            if (clazz2.isArray()) {
                return this.applyValuesToArrayField(field, clazz, range, stack, clazz2, string);
            }
            if (Collection.class.isAssignableFrom(clazz2)) {
                return this.applyValuesToCollectionField(field, clazz, range, stack, clazz2, string);
            }
            if (Map.class.isAssignableFrom(clazz2)) {
                return this.applyValuesToMapField(field, clazz, range, stack, clazz2, string);
            }
            clazz2 = CommandLine.getTypeAttribute(field)[0];
            return this.applyValueToSingleValuedField(field, range, stack, clazz2, set, string);
        }

        private int applyValueToSingleValuedField(Field field, Range range, Stack<String> stack, Class<?> clazz, Set<Field> set, String string) throws Exception {
            Object object;
            boolean bl2 = stack.isEmpty();
            String string2 = stack.isEmpty() ? null : this.trim(stack.pop());
            int n2 = range.min;
            if ((clazz == Boolean.class || clazz == Boolean.TYPE) && range.min <= 0) {
                if (range.max > 0 && ("true".equalsIgnoreCase(string2) || "false".equalsIgnoreCase(string2))) {
                    n2 = 1;
                } else {
                    if (string2 != null) {
                        stack.push(string2);
                    }
                    string2 = String.valueOf((object = (Boolean)field.get(this.command)) == null ? true : !((Boolean)object).booleanValue());
                }
            }
            if (bl2 && string2 == null) {
                return 0;
            }
            object = this.getTypeConverter(clazz, field);
            Object object2 = this.tryConvert(field, -1, (ITypeConverter<?>)object, string2, clazz);
            Object object3 = field.get(this.command);
            TraceLevel traceLevel = TraceLevel.INFO;
            String string3 = "Setting %s field '%s.%s' to '%5$s' (was '%4$s') for %6$s%n";
            if (set != null) {
                if (set.contains(field)) {
                    if (!CommandLine.this.isOverwrittenOptionsAllowed()) {
                        throw new OverwrittenOptionException(CommandLine.this, this.optionDescription("", field, 0) + " should be specified only once");
                    }
                    traceLevel = TraceLevel.WARN;
                    string3 = "Overwriting %s field '%s.%s' value '%s' with '%s' for %s%n";
                }
                set.add(field);
            }
            if (((CommandLine)CommandLine.this).tracer.level.isEnabled(traceLevel)) {
                traceLevel.print(CommandLine.this.tracer, string3, new Object[]{field.getType().getSimpleName(), field.getDeclaringClass().getSimpleName(), field.getName(), String.valueOf(object3), String.valueOf(object2), string});
            }
            field.set(this.command, object2);
            return n2;
        }

        private int applyValuesToMapField(Field field, Class<?> clazz, Range range, Stack<String> stack, Class<?> clazz2, String string) throws Exception {
            Class[] classArray = CommandLine.getTypeAttribute(field);
            if (classArray.length < 2) {
                throw new ParameterException(CommandLine.this, "Field " + field + " needs two types (one for the map key, one for the value) but only has " + classArray.length + " types configured.");
            }
            ITypeConverter<?> iTypeConverter = this.getTypeConverter(classArray[0], field);
            ITypeConverter<?> iTypeConverter2 = this.getTypeConverter(classArray[1], field);
            Map<Object, Object> map = (Map<Object, Object>)field.get(this.command);
            if (map == null) {
                map = this.createMap(clazz2);
                field.set(this.command, map);
            }
            int n2 = map.size();
            this.consumeMapArguments(field, range, stack, classArray, iTypeConverter, iTypeConverter2, map, string);
            return map.size() - n2;
        }

        private void consumeMapArguments(Field field, Range range, Stack<String> stack, Class<?>[] classArray, ITypeConverter<?> iTypeConverter, ITypeConverter<?> iTypeConverter2, Map<Object, Object> map, String string) throws Exception {
            int n2;
            for (n2 = 0; n2 < range.min; ++n2) {
                this.consumeOneMapArgument(field, range, stack, classArray, iTypeConverter, iTypeConverter2, map, n2, string);
            }
            for (n2 = range.min; n2 < range.max && !stack.isEmpty(); ++n2) {
                if (!field.isAnnotationPresent(Parameters.class) && (this.commands.containsKey(stack.peek()) || this.isOption(stack.peek()))) {
                    return;
                }
                this.consumeOneMapArgument(field, range, stack, classArray, iTypeConverter, iTypeConverter2, map, n2, string);
            }
        }

        private void consumeOneMapArgument(Field field, Range range, Stack<String> stack, Class<?>[] classArray, ITypeConverter<?> iTypeConverter, ITypeConverter<?> iTypeConverter2, Map<Object, Object> map, int n2, String string) throws Exception {
            String[] stringArray;
            for (String string2 : stringArray = this.split(this.trim(stack.pop()), field)) {
                Object object;
                String[] stringArray2 = string2.split("=");
                if (stringArray2.length < 2) {
                    object = this.splitRegex(field);
                    if (((String)object).length() == 0) {
                        throw new ParameterException(CommandLine.this, "Value for option " + this.optionDescription("", field, 0) + " should be in KEY=VALUE format but was " + string2);
                    }
                    throw new ParameterException(CommandLine.this, "Value for option " + this.optionDescription("", field, 0) + " should be in KEY=VALUE[" + (String)object + "KEY=VALUE]... format but was " + string2);
                }
                object = this.tryConvert(field, n2, iTypeConverter, stringArray2[0], classArray[0]);
                Object object2 = this.tryConvert(field, n2, iTypeConverter2, stringArray2[1], classArray[1]);
                map.put(object, object2);
                if (!CommandLine.this.tracer.isInfo()) continue;
                CommandLine.this.tracer.info("Putting [%s : %s] in %s<%s, %s> field '%s.%s' for %s%n", String.valueOf(object), String.valueOf(object2), map.getClass().getSimpleName(), classArray[0].getSimpleName(), classArray[1].getSimpleName(), field.getDeclaringClass().getSimpleName(), field.getName(), string);
            }
        }

        private void checkMaxArityExceeded(Range range, int n2, Field field, String[] stringArray) {
            if (stringArray.length <= n2) {
                return;
            }
            String string = range.max == n2 ? "" + n2 : range + ", remainder=" + n2;
            throw new MaxValuesforFieldExceededException(CommandLine.this, this.optionDescription("", field, -1) + " max number of values (" + range.max + ") exceeded: remainder is " + n2 + " but " + stringArray.length + " values were specified: " + Arrays.toString(stringArray));
        }

        private int applyValuesToArrayField(Field field, Class<?> clazz, Range range, Stack<String> stack, Class<?> clazz2, String string) throws Exception {
            Object object = field.get(this.command);
            int n2 = object == null ? 0 : Array.getLength(object);
            Class clazz3 = CommandLine.getTypeAttribute(field)[0];
            List<Object> list = this.consumeArguments(field, clazz, range, stack, clazz3, n2, string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(Array.get(object, i2));
            }
            for (Object object2 : list) {
                if (object2 instanceof Collection) {
                    arrayList.addAll((Collection)object2);
                    continue;
                }
                arrayList.add(object2);
            }
            Object object3 = Array.newInstance(clazz3, arrayList.size());
            field.set(this.command, object3);
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                Array.set(object3, i3, arrayList.get(i3));
            }
            return list.size();
        }

        private int applyValuesToCollectionField(Field field, Class<?> clazz, Range range, Stack<String> stack, Class<?> clazz2, String string) throws Exception {
            Collection<Object> collection = (Collection<Object>)field.get(this.command);
            Class clazz3 = CommandLine.getTypeAttribute(field)[0];
            int n2 = collection == null ? 0 : collection.size();
            List<Object> list = this.consumeArguments(field, clazz, range, stack, clazz3, n2, string);
            if (collection == null) {
                collection = this.createCollection(clazz2);
                field.set(this.command, collection);
            }
            for (Object object : list) {
                if (object instanceof Collection) {
                    collection.addAll((Collection)object);
                    continue;
                }
                collection.add(object);
            }
            return list.size();
        }

        private List<Object> consumeArguments(Field field, Class<?> clazz, Range range, Stack<String> stack, Class<?> clazz2, int n2, String string) throws Exception {
            int n3;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (n3 = 0; n3 < range.min; ++n3) {
                this.consumeOneArgument(field, range, stack, clazz2, arrayList, n3, n2, string);
            }
            for (n3 = range.min; n3 < range.max && !stack.isEmpty(); ++n3) {
                if (clazz != Parameters.class && (this.commands.containsKey(stack.peek()) || this.isOption(stack.peek()))) {
                    return arrayList;
                }
                this.consumeOneArgument(field, range, stack, clazz2, arrayList, n3, n2, string);
            }
            return arrayList;
        }

        private int consumeOneArgument(Field field, Range range, Stack<String> stack, Class<?> clazz, List<Object> list, int n2, int n3, String string) throws Exception {
            String[] stringArray = this.split(this.trim(stack.pop()), field);
            ITypeConverter<?> iTypeConverter = this.getTypeConverter(clazz, field);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                list.add(this.tryConvert(field, n2, iTypeConverter, stringArray[i2], clazz));
                if (!CommandLine.this.tracer.isInfo()) continue;
                if (field.getType().isArray()) {
                    CommandLine.this.tracer.info("Adding [%s] to %s[] field '%s.%s' for %s%n", String.valueOf(list.get(list.size() - 1)), clazz.getSimpleName(), field.getDeclaringClass().getSimpleName(), field.getName(), string);
                    continue;
                }
                CommandLine.this.tracer.info("Adding [%s] to %s<%s> field '%s.%s' for %s%n", String.valueOf(list.get(list.size() - 1)), field.getType().getSimpleName(), clazz.getSimpleName(), field.getDeclaringClass().getSimpleName(), field.getName(), string);
            }
            return ++n2;
        }

        private String splitRegex(Field field) {
            if (field.isAnnotationPresent(Option.class)) {
                return field.getAnnotation(Option.class).split();
            }
            if (field.isAnnotationPresent(Parameters.class)) {
                return field.getAnnotation(Parameters.class).split();
            }
            return "";
        }

        private String[] split(String string, Field field) {
            String[] stringArray;
            String string2 = this.splitRegex(field);
            if (string2.length() == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string;
            } else {
                stringArray = string.split(string2);
            }
            return stringArray;
        }

        private boolean isOption(String string) {
            if ("--".equals(string)) {
                return true;
            }
            if (this.optionName2Field.containsKey(string)) {
                return true;
            }
            int n2 = string.indexOf(this.separator);
            if (n2 > 0 && this.optionName2Field.containsKey(string.substring(0, n2))) {
                return true;
            }
            return string.length() > 2 && string.startsWith("-") && this.singleCharOption2Field.containsKey(Character.valueOf(string.charAt(1)));
        }

        private Object tryConvert(Field field, int n2, ITypeConverter<?> iTypeConverter, String string, Class<?> clazz) throws Exception {
            try {
                return iTypeConverter.convert(string);
            }
            catch (TypeConversionException typeConversionException) {
                throw new ParameterException(CommandLine.this, typeConversionException.getMessage() + this.optionDescription(" for ", field, n2));
            }
            catch (Exception exception) {
                String string2 = this.optionDescription(" for ", field, n2) + ": " + exception;
                throw new ParameterException(CommandLine.this, "Could not convert '" + string + "' to " + clazz.getSimpleName() + string2, exception);
            }
        }

        private String optionDescription(String string, Field field, int n2) {
            Help.IParamLabelRenderer iParamLabelRenderer = Help.createMinimalParamLabelRenderer();
            String string2 = "";
            if (field.isAnnotationPresent(Option.class)) {
                string2 = string + "option '" + field.getAnnotation(Option.class).names()[0] + "'";
                if (n2 >= 0) {
                    Range range = Range.optionArity(field);
                    if (range.max > 1) {
                        string2 = string2 + " at index " + n2;
                    }
                    string2 = string2 + " (" + iParamLabelRenderer.renderParameterLabel(field, Help.Ansi.OFF, Collections.emptyList()) + ")";
                }
            } else if (field.isAnnotationPresent(Parameters.class)) {
                Range range = Range.parameterIndex(field);
                Help.Ansi.Text text = iParamLabelRenderer.renderParameterLabel(field, Help.Ansi.OFF, Collections.emptyList());
                string2 = string + "positional parameter at index " + range + " (" + text + ")";
            }
            return string2;
        }

        private boolean isAnyHelpRequested() {
            return this.isHelpRequested || CommandLine.this.versionHelpRequested || CommandLine.this.usageHelpRequested;
        }

        private void updateHelpRequested(Field field) {
            if (field.isAnnotationPresent(Option.class)) {
                this.isHelpRequested |= this.is(field, "help", field.getAnnotation(Option.class).help());
                CommandLine commandLine = CommandLine.this;
                commandLine.versionHelpRequested = commandLine.versionHelpRequested | this.is(field, "versionHelp", field.getAnnotation(Option.class).versionHelp());
                commandLine = CommandLine.this;
                commandLine.usageHelpRequested = commandLine.usageHelpRequested | this.is(field, "usageHelp", field.getAnnotation(Option.class).usageHelp());
            }
        }

        private boolean is(Field field, String string, boolean bl2) {
            if (bl2 && CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Field '%s.%s' has '%s' annotation: not validating required fields%n", field.getDeclaringClass().getSimpleName(), field.getName(), string);
            }
            return bl2;
        }

        private Collection<Object> createCollection(Class<?> clazz) throws Exception {
            if (clazz.isInterface()) {
                if (SortedSet.class.isAssignableFrom(clazz)) {
                    return new TreeSet<Object>();
                }
                if (Set.class.isAssignableFrom(clazz)) {
                    return new LinkedHashSet<Object>();
                }
                if (Queue.class.isAssignableFrom(clazz)) {
                    return new LinkedList<Object>();
                }
                return new ArrayList<Object>();
            }
            return (Collection)clazz.newInstance();
        }

        private Map<Object, Object> createMap(Class<?> clazz) throws Exception {
            try {
                return (Map)clazz.newInstance();
            }
            catch (Exception exception) {
                return new LinkedHashMap<Object, Object>();
            }
        }

        private ITypeConverter<?> getTypeConverter(final Class<?> clazz, Field field) {
            ITypeConverter<?> iTypeConverter = this.converterRegistry.get(clazz);
            if (iTypeConverter != null) {
                return iTypeConverter;
            }
            if (clazz.isEnum()) {
                return new ITypeConverter<Object>(){

                    @Override
                    public Object convert(String string) throws Exception {
                        return Enum.valueOf(clazz, string);
                    }
                };
            }
            throw new MissingTypeConverterException(CommandLine.this, "No TypeConverter registered for " + clazz.getName() + " of field " + field);
        }

        private void assertNoMissingParameters(Field field, int n2, Stack<String> stack) {
            if (n2 > stack.size()) {
                if (n2 == 1) {
                    if (field.isAnnotationPresent(Option.class)) {
                        throw new MissingParameterException(CommandLine.this, "Missing required parameter for " + this.optionDescription("", field, 0));
                    }
                    Range range = Range.parameterIndex(field);
                    Help.IParamLabelRenderer iParamLabelRenderer = Help.createMinimalParamLabelRenderer();
                    String string = "";
                    String string2 = "";
                    int n3 = 0;
                    for (int i2 = range.min; i2 < this.positionalParametersFields.size(); ++i2) {
                        if (Range.parameterArity((Field)this.positionalParametersFields.get((int)i2)).min <= 0) continue;
                        string2 = string2 + string + iParamLabelRenderer.renderParameterLabel(this.positionalParametersFields.get(i2), Help.Ansi.OFF, Collections.emptyList());
                        string = ", ";
                        ++n3;
                    }
                    String string3 = "Missing required parameter";
                    Range range2 = Range.parameterArity(field);
                    string3 = range2.isVariable ? string3 + "s at positions " + range + ": " : string3 + (n3 > 1 ? "s: " : ": ");
                    throw new MissingParameterException(CommandLine.this, string3 + string2);
                }
                if (stack.isEmpty()) {
                    throw new MissingParameterException(CommandLine.this, this.optionDescription("", field, 0) + " requires at least " + n2 + " values, but none were specified.");
                }
                throw new MissingParameterException(CommandLine.this, this.optionDescription("", field, 0) + " requires at least " + n2 + " values, but only " + stack.size() + " were specified: " + CommandLine.reverse(stack));
            }
        }

        private String trim(String string) {
            return this.unquote(string);
        }

        private String unquote(String string) {
            return string == null ? null : (string.length() > 1 && string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1) : string);
        }
    }

    public static class Range
    implements Comparable<Range> {
        public final int min;
        public final int max;
        public final boolean isVariable;
        private final boolean isUnspecified;
        private final String originalValue;

        public Range(int n2, int n3, boolean bl2, boolean bl3, String string) {
            this.min = n2;
            this.max = n3;
            this.isVariable = bl2;
            this.isUnspecified = bl3;
            this.originalValue = string;
        }

        public static Range optionArity(Field field) {
            return field.isAnnotationPresent(Option.class) ? Range.adjustForType(Range.valueOf(field.getAnnotation(Option.class).arity()), field) : new Range(0, 0, false, true, "0");
        }

        public static Range parameterArity(Field field) {
            return field.isAnnotationPresent(Parameters.class) ? Range.adjustForType(Range.valueOf(field.getAnnotation(Parameters.class).arity()), field) : new Range(0, 0, false, true, "0");
        }

        public static Range parameterIndex(Field field) {
            return field.isAnnotationPresent(Parameters.class) ? Range.valueOf(field.getAnnotation(Parameters.class).index()) : new Range(0, 0, false, true, "0");
        }

        static Range adjustForType(Range range, Field field) {
            return range.isUnspecified ? Range.defaultArity(field) : range;
        }

        public static Range defaultArity(Field field) {
            Class<?> clazz = field.getType();
            if (field.isAnnotationPresent(Option.class)) {
                return Range.defaultArity(clazz);
            }
            if (CommandLine.isMultiValue(clazz)) {
                return Range.valueOf("0..1");
            }
            return Range.valueOf("1");
        }

        public static Range defaultArity(Class<?> clazz) {
            return CommandLine.isBoolean(clazz) ? Range.valueOf("0") : Range.valueOf("1");
        }

        private int size() {
            return 1 + this.max - this.min;
        }

        static Range parameterCapacity(Field field) {
            Range range = Range.parameterArity(field);
            if (!CommandLine.isMultiValue(field)) {
                return range;
            }
            Range range2 = Range.parameterIndex(field);
            if (range.max == 0) {
                return range;
            }
            if (range2.size() == 1) {
                return range;
            }
            if (range2.isVariable) {
                return Range.valueOf(range.min + "..*");
            }
            if (range.size() == 1) {
                return Range.valueOf(range.min * range2.size() + "");
            }
            if (range.isVariable) {
                return Range.valueOf(range.min * range2.size() + "..*");
            }
            return Range.valueOf(range.min * range2.size() + ".." + range.max * range2.size());
        }

        public static Range valueOf(String string) {
            boolean bl2 = (string = string.trim()).length() == 0 || string.startsWith("..");
            int n2 = -1;
            int n3 = -1;
            boolean bl3 = false;
            int n4 = -1;
            n4 = string.indexOf("..");
            if (n4 >= 0) {
                n2 = Range.parseInt(string.substring(0, n4), 0);
                n3 = Range.parseInt(string.substring(n4 + 2), Integer.MAX_VALUE);
                bl3 = n3 == Integer.MAX_VALUE;
            } else {
                n3 = Range.parseInt(string, Integer.MAX_VALUE);
                bl3 = n3 == Integer.MAX_VALUE;
                n2 = bl3 ? 0 : n3;
            }
            Range range = new Range(n2, n3, bl3, bl2, string);
            return range;
        }

        private static int parseInt(String string, int n2) {
            try {
                return Integers.parseInt(string);
            }
            catch (Exception exception) {
                return n2;
            }
        }

        public Range min(int n2) {
            return new Range(n2, Math.max(n2, this.max), this.isVariable, this.isUnspecified, this.originalValue);
        }

        public Range max(int n2) {
            return new Range(Math.min(this.min, n2), n2, this.isVariable, this.isUnspecified, this.originalValue);
        }

        public boolean contains(int n2) {
            return this.min <= n2 && this.max >= n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Range)) {
                return false;
            }
            Range range = (Range)object;
            return range.max == this.max && range.min == this.min && range.isVariable == this.isVariable;
        }

        public int hashCode() {
            return ((629 + this.max) * 37 + this.min) * 37 + (this.isVariable ? 1 : 0);
        }

        public String toString() {
            return this.min == this.max ? String.valueOf(this.min) : this.min + ".." + (this.isVariable ? "*" : Integer.valueOf(this.max));
        }

        @Override
        public int compareTo(Range range) {
            int n2 = this.min - range.min;
            return n2 == 0 ? this.max - range.max : n2;
        }
    }

    public static interface ITypeConverter<K> {
        public K convert(String var1) throws Exception;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.LOCAL_VARIABLE, ElementType.PACKAGE})
    public static @interface Command {
        public String name() default "<main class>";

        public Class<?>[] subcommands() default {};

        public String separator() default "=";

        public String[] version() default {};

        public String headerHeading() default "";

        public String[] header() default {};

        public String synopsisHeading() default "Usage: ";

        public boolean abbreviateSynopsis() default false;

        public String[] customSynopsis() default {};

        public String descriptionHeading() default "";

        public String[] description() default {};

        public String parameterListHeading() default "";

        public String optionListHeading() default "";

        public boolean sortOptions() default true;

        public char requiredOptionMarker() default 32;

        public boolean showDefaultValues() default false;

        public String commandListHeading() default "Commands:%n";

        public String footerHeading() default "";

        public String[] footer() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameters {
        public String index() default "*";

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public Class<?>[] type() default {};

        public String split() default "";

        public boolean hidden() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Option {
        public String[] names();

        public boolean required() default false;

        public boolean help() default false;

        public boolean usageHelp() default false;

        public boolean versionHelp() default false;

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public Class<?>[] type() default {};

        public String split() default "";

        public boolean hidden() default false;
    }

    public static class RunAll
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> list, PrintStream printStream, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(list, printStream, ansi)) {
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (CommandLine commandLine : list) {
                arrayList.add(CommandLine.execute(commandLine));
            }
            return arrayList;
        }
    }

    public static class RunLast
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> list, PrintStream printStream, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(list, printStream, ansi)) {
                return Collections.emptyList();
            }
            CommandLine commandLine = list.get(list.size() - 1);
            return Arrays.asList(CommandLine.execute(commandLine));
        }
    }

    public static class RunFirst
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> list, PrintStream printStream, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(list, printStream, ansi)) {
                return Collections.emptyList();
            }
            return Arrays.asList(CommandLine.execute(list.get(0)));
        }
    }

    public static class DefaultExceptionHandler
    implements IExceptionHandler {
        @Override
        public List<Object> handleException(ParameterException parameterException, PrintStream printStream, Help.Ansi ansi, String ... stringArray) {
            printStream.println(parameterException.getMessage());
            parameterException.getCommandLine().usage(printStream, ansi);
            return Collections.emptyList();
        }
    }

    public static interface IExceptionHandler {
        public List<Object> handleException(ParameterException var1, PrintStream var2, Help.Ansi var3, String ... var4);
    }

    public static interface IParseResultHandler {
        public List<Object> handleParseResult(List<CommandLine> var1, PrintStream var2, Help.Ansi var3) throws ExecutionException;
    }
}

