/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.AbstractLifeCycle;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LifeCycle;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LifeCycle2;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Cancellable;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.status.StatusLogger;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultShutdownCallbackRegistry
implements LifeCycle2,
ShutdownCallbackRegistry,
Runnable {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private final AtomicReference<LifeCycle.State> state = new AtomicReference<LifeCycle.State>(LifeCycle.State.INITIALIZED);
    private final ThreadFactory threadFactory;
    private final Collection<Reference<Cancellable>> hooks = new CopyOnWriteArrayList<Reference<Cancellable>>();
    private Reference<Thread> shutdownHookRef;

    public DefaultShutdownCallbackRegistry() {
        this(Executors.defaultThreadFactory());
    }

    protected DefaultShutdownCallbackRegistry(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    public void run() {
        if (this.state.compareAndSet(LifeCycle.State.STARTED, LifeCycle.State.STOPPING)) {
            for (Reference<Cancellable> reference : this.hooks) {
                Cancellable cancellable = reference.get();
                if (cancellable == null) continue;
                try {
                    cancellable.run();
                }
                catch (Throwable throwable) {
                    try {
                        LOGGER.error(SHUTDOWN_HOOK_MARKER, "Caught exception executing shutdown hook {}", (Object)cancellable, (Object)throwable);
                    }
                    catch (Throwable throwable2) {
                        System.err.println("Caught exception " + throwable2.getClass() + " logging exception " + throwable.getClass());
                        throwable.printStackTrace();
                    }
                }
            }
            this.state.set(LifeCycle.State.STOPPED);
        }
    }

    @Override
    public Cancellable addShutdownCallback(Runnable runnable) {
        if (this.isStarted()) {
            RegisteredCancellable registeredCancellable = new RegisteredCancellable(runnable, this.hooks);
            this.hooks.add(new SoftReference<RegisteredCancellable>(registeredCancellable));
            return registeredCancellable;
        }
        throw new IllegalStateException("Cannot add new shutdown hook as this is not started. Current state: " + this.state.get().name());
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        if (this.state.compareAndSet(LifeCycle.State.INITIALIZED, LifeCycle.State.STARTING)) {
            try {
                this.addShutdownHook(this.threadFactory.newThread(this));
                this.state.set(LifeCycle.State.STARTED);
            }
            catch (IllegalStateException illegalStateException) {
                this.state.set(LifeCycle.State.STOPPED);
                throw illegalStateException;
            }
            catch (Exception exception) {
                LOGGER.catching(exception);
                this.state.set(LifeCycle.State.STOPPED);
            }
        }
    }

    private void addShutdownHook(Thread thread) {
        this.shutdownHookRef = new WeakReference<Thread>(thread);
        Runtime.getRuntime().addShutdownHook(thread);
    }

    @Override
    public void stop() {
        this.stop(0L, AbstractLifeCycle.DEFAULT_STOP_TIMEUNIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        if (this.state.compareAndSet(LifeCycle.State.STARTED, LifeCycle.State.STOPPING)) {
            try {
                this.removeShutdownHook();
            }
            finally {
                this.state.set(LifeCycle.State.STOPPED);
            }
        }
        return true;
    }

    private void removeShutdownHook() {
        Thread thread = this.shutdownHookRef.get();
        if (thread != null) {
            Runtime.getRuntime().removeShutdownHook(thread);
            this.shutdownHookRef.enqueue();
        }
    }

    @Override
    public LifeCycle.State getState() {
        return this.state.get();
    }

    @Override
    public boolean isStarted() {
        return this.state.get() == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state.get() == LifeCycle.State.STOPPED;
    }

    private static class RegisteredCancellable
    implements Cancellable {
        private Runnable callback;
        private Collection<Reference<Cancellable>> registered;

        RegisteredCancellable(Runnable runnable, Collection<Reference<Cancellable>> collection) {
            this.callback = runnable;
            this.registered = collection;
        }

        @Override
        public void cancel() {
            this.callback = null;
            Collection<Reference<Cancellable>> collection = this.registered;
            if (collection != null) {
                this.registered = null;
                collection.removeIf(reference -> {
                    Cancellable cancellable = (Cancellable)reference.get();
                    return cancellable == null || cancellable == this;
                });
            }
        }

        @Override
        public void run() {
            Runnable runnable = this.callback;
            if (runnable != null) {
                runnable.run();
                this.callback = null;
            }
        }

        public String toString() {
            return String.valueOf(this.callback);
        }
    }
}

