/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectArrayIterator<E>
implements Iterator<E> {
    final E[] array;
    final int startIndex;
    final int endIndex;
    int index = 0;

    @SafeVarargs
    public ObjectArrayIterator(E ... EArray) {
        this(EArray, 0, EArray.length);
    }

    public ObjectArrayIterator(E[] EArray, int n2) {
        this(EArray, n2, EArray.length);
    }

    public ObjectArrayIterator(E[] EArray, int n2, int n3) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Start index must not be less than zero");
        }
        if (n3 > EArray.length) {
            throw new ArrayIndexOutOfBoundsException("End index must not be greater than the array length");
        }
        if (n2 > EArray.length) {
            throw new ArrayIndexOutOfBoundsException("Start index must not be greater than the array length");
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("End index must not be less than start index");
        }
        this.array = EArray;
        this.startIndex = n2;
        this.endIndex = n3;
        this.index = n2;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.array[this.index++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported for an ObjectArrayIterator");
    }

    public E[] getArray() {
        return this.array;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void reset() {
        this.index = this.startIndex;
    }
}

