/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.logging.log4j.util;

import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.LoaderUtil;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.util.PropertiesUtil;

public final class Constants {
    public static final boolean IS_WEB_APP = PropertiesUtil.getProperties().getBooleanProperty("com.contrastsecurity.thirdparty.log4j2.is.webapp", Constants.isClassAvailable("com.contrastsecurity.thirdparty.javax.servlet.Servlet") || Constants.isClassAvailable("com.contrastsecurity.thirdparty.jakarta.servlet.Servlet"));
    public static final boolean ENABLE_THREADLOCALS = !IS_WEB_APP && PropertiesUtil.getProperties().getBooleanProperty("com.contrastsecurity.thirdparty.log4j2.enable.threadlocals", true);
    public static final int JAVA_MAJOR_VERSION = Constants.getMajorVersion();
    public static final int MAX_REUSABLE_MESSAGE_SIZE = Constants.size("com.contrastsecurity.thirdparty.log4j.maxReusableMsgSize", 518);
    public static final String LOG4J2_DEBUG = "com.contrastsecurity.thirdparty.log4j2.debug";
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private static int size(String string, int n2) {
        return PropertiesUtil.getProperties().getIntegerProperty(string, n2);
    }

    private static boolean isClassAvailable(String string) {
        try {
            return LoaderUtil.loadClass(string) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private Constants() {
    }

    private static int getMajorVersion() {
        return Constants.getMajorVersion(System.getProperty("java.version"));
    }

    static int getMajorVersion(String string) {
        String[] stringArray = string.split("-|\\.");
        try {
            boolean bl2;
            int n2 = Integer.parseInt(stringArray[0]);
            boolean bl3 = bl2 = n2 != 1;
            if (bl2) {
                return n2;
            }
            return Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

