/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.apache.oro.text.regex;

import com.contrastsecurity.thirdparty.org.apache.oro.text.regex.CharStringPointer;
import com.contrastsecurity.thirdparty.org.apache.oro.text.regex.MalformedPatternException;
import com.contrastsecurity.thirdparty.org.apache.oro.text.regex.OpCode;
import com.contrastsecurity.thirdparty.org.apache.oro.text.regex.Pattern;
import com.contrastsecurity.thirdparty.org.apache.oro.text.regex.PatternCompiler;
import com.contrastsecurity.thirdparty.org.apache.oro.text.regex.Perl5Pattern;
import java.util.HashMap;

public final class Perl5Compiler
implements PatternCompiler {
    private static final int __WORSTCASE = 0;
    private static final int __NONNULL = 1;
    private static final int __SIMPLE = 2;
    private static final int __SPSTART = 4;
    private static final int __TRYAGAIN = 8;
    private static final char __CASE_INSENSITIVE = '\u0001';
    private static final char __GLOBAL = '\u0002';
    private static final char __KEEP = '\u0004';
    private static final char __MULTILINE = '\b';
    private static final char __SINGLELINE = '\u0010';
    private static final char __EXTENDED = ' ';
    private static final char __READ_ONLY = '\u8000';
    private static final String __HEX_DIGIT = "0123456789abcdef0123456789ABCDEFx";
    private CharStringPointer __input;
    private boolean __sawBackreference;
    private char[] __modifierFlags = new char[]{'\u0000'};
    private int __numParentheses;
    private int __programSize;
    private int __cost;
    private char[] __program;
    private static final HashMap __hashPOSIX = new HashMap();
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int MULTILINE_MASK = 8;
    public static final int SINGLELINE_MASK = 16;
    public static final int EXTENDED_MASK = 32;
    public static final int READ_ONLY_MASK = 32768;

    public static final String quotemeta(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer(2 * cArray.length);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (!OpCode._isWordCharacter(cArray[i2])) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(cArray[i2]);
        }
        return stringBuffer.toString();
    }

    public static final String quotemeta(String string) {
        return Perl5Compiler.quotemeta(string.toCharArray());
    }

    private static boolean __isSimpleRepetitionOp(char c2) {
        return c2 == '*' || c2 == '+' || c2 == '?';
    }

    private static boolean __isComplexRepetitionOp(char[] cArray, int n2) {
        if (n2 < cArray.length && n2 >= 0) {
            return cArray[n2] == '*' || cArray[n2] == '+' || cArray[n2] == '?' || cArray[n2] == '{' && Perl5Compiler.__parseRepetition(cArray, n2);
        }
        return false;
    }

    private static boolean __parseRepetition(char[] cArray, int n2) {
        if (cArray[n2] != '{') {
            return false;
        }
        if (++n2 >= cArray.length || !Character.isDigit(cArray[n2])) {
            return false;
        }
        while (n2 < cArray.length && Character.isDigit(cArray[n2])) {
            ++n2;
        }
        if (n2 < cArray.length && cArray[n2] == ',') {
            ++n2;
        }
        while (n2 < cArray.length && Character.isDigit(cArray[n2])) {
            ++n2;
        }
        return n2 < cArray.length && cArray[n2] == '}';
    }

    private static int __parseHex(char[] cArray, int n2, int n3, int[] nArray) {
        int n4;
        int n5 = 0;
        nArray[0] = 0;
        while (n2 < cArray.length && n3-- > 0 && (n4 = __HEX_DIGIT.indexOf(cArray[n2])) != -1) {
            n5 <<= 4;
            n5 |= n4 & 0xF;
            ++n2;
            nArray[0] = nArray[0] + 1;
        }
        return n5;
    }

    private static int __parseOctal(char[] cArray, int n2, int n3, int[] nArray) {
        int n4 = 0;
        nArray[0] = 0;
        while (n2 < cArray.length && n3 > 0 && cArray[n2] >= '0' && cArray[n2] <= '7') {
            n4 <<= 3;
            n4 |= cArray[n2] - 48;
            --n3;
            ++n2;
            nArray[0] = nArray[0] + 1;
        }
        return n4;
    }

    private static void __setModifierFlag(char[] cArray, char c2) {
        switch (c2) {
            case 'i': {
                cArray[0] = (char)(cArray[0] | '\u0001');
                return;
            }
            case 'g': {
                cArray[0] = (char)(cArray[0] | 2);
                return;
            }
            case 'o': {
                cArray[0] = (char)(cArray[0] | 4);
                return;
            }
            case 'm': {
                cArray[0] = (char)(cArray[0] | 8);
                return;
            }
            case 's': {
                cArray[0] = (char)(cArray[0] | 0x10);
                return;
            }
            case 'x': {
                cArray[0] = (char)(cArray[0] | 0x20);
                return;
            }
        }
    }

    private void __emitCode(char c2) {
        if (this.__program != null) {
            this.__program[this.__programSize] = c2;
        }
        ++this.__programSize;
    }

    private int __emitNode(char c2) {
        int n2 = this.__programSize;
        if (this.__program == null) {
            this.__programSize += 2;
        } else {
            this.__program[this.__programSize++] = c2;
            this.__program[this.__programSize++] = '\u0000';
        }
        return n2;
    }

    private int __emitArgNode(char c2, char c3) {
        int n2 = this.__programSize;
        if (this.__program == null) {
            this.__programSize += 3;
        } else {
            this.__program[this.__programSize++] = c2;
            this.__program[this.__programSize++] = '\u0000';
            this.__program[this.__programSize++] = c3;
        }
        return n2;
    }

    private void __programInsertOperator(char c2, int n2) {
        int n3;
        int n4 = n3 = OpCode._opType[c2] == '\n' ? 2 : 0;
        if (this.__program == null) {
            this.__programSize += 2 + n3;
            return;
        }
        int n5 = this.__programSize;
        this.__programSize += 2 + n3;
        int n6 = this.__programSize;
        while (n5 > n2) {
            this.__program[--n6] = this.__program[--n5];
        }
        this.__program[n2++] = c2;
        this.__program[n2++] = '\u0000';
        while (n3-- > 0) {
            this.__program[n2++] = '\u0000';
        }
    }

    private void __programAddTail(int n2, int n3) {
        int n4;
        if (this.__program == null || n2 == -1) {
            return;
        }
        int n5 = n2;
        while ((n4 = OpCode._getNext(this.__program, n5)) != -1) {
            n5 = n4;
        }
        int n6 = this.__program[n5] == '\r' ? n5 - n3 : n3 - n5;
        this.__program[n5 + 1] = (char)n6;
    }

    private void __programAddOperatorTail(int n2, int n3) {
        if (this.__program == null || n2 == -1 || OpCode._opType[this.__program[n2]] != '\f') {
            return;
        }
        this.__programAddTail(OpCode._getNextOperator(n2), n3);
    }

    private char __getNextChar() {
        char c2 = this.__input._postIncrement();
        while (true) {
            char c3;
            if ((c3 = this.__input._getValue()) == '(' && this.__input._getValueRelative(1) == '?' && this.__input._getValueRelative(2) == '#') {
                while (c3 != '\uffff' && c3 != ')') {
                    c3 = this.__input._increment();
                }
                this.__input._increment();
                continue;
            }
            if ((this.__modifierFlags[0] & 0x20) == 0) break;
            if (Character.isWhitespace(c3)) {
                this.__input._increment();
                continue;
            }
            if (c3 != '#') break;
            while (c3 != '\uffff' && c3 != '\n') {
                c3 = this.__input._increment();
            }
            this.__input._increment();
        }
        return c2;
    }

    private int __parseAlternation(int[] nArray) throws MalformedPatternException {
        int n2 = 0;
        nArray[0] = 0;
        int n3 = this.__emitNode('\f');
        int n4 = -1;
        if (this.__input._getOffset() == 0) {
            this.__input._setOffset(-1);
            this.__getNextChar();
        } else {
            this.__input._decrement();
            this.__getNextChar();
        }
        char c2 = this.__input._getValue();
        while (c2 != '\uffff' && c2 != '|' && c2 != ')') {
            n2 &= 0xFFFFFFF7;
            int n5 = this.__parseBranch(nArray);
            if (n5 == -1) {
                if ((n2 & 8) != 0) {
                    c2 = this.__input._getValue();
                    continue;
                }
                return -1;
            }
            nArray[0] = nArray[0] | n2 & 1;
            if (n4 == -1) {
                nArray[0] = nArray[0] | n2 & 4;
            } else {
                ++this.__cost;
                this.__programAddTail(n4, n5);
            }
            n4 = n5;
            c2 = this.__input._getValue();
        }
        if (n4 == -1) {
            this.__emitNode('\u000f');
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    private int __parseAtom(int[] var1_1) throws MalformedPatternException {
        var5_2 = new int[]{0};
        var1_1[0] = 0;
        var2_3 = false;
        var4_4 = -1;
        block50: while (true) {
            var3_5 = this.__input._getValue();
            switch (var3_5) {
                case '^': {
                    this.__getNextChar();
                    if ((this.__modifierFlags[0] & 8) != 0) {
                        var4_4 = this.__emitNode('\u0002');
                        break block50;
                    }
                    if ((this.__modifierFlags[0] & 16) != 0) {
                        var4_4 = this.__emitNode('\u0003');
                        break block50;
                    }
                    var4_4 = this.__emitNode('\u0001');
                    break block50;
                }
                case '$': {
                    this.__getNextChar();
                    if ((this.__modifierFlags[0] & 8) != 0) {
                        var4_4 = this.__emitNode('\u0005');
                        break block50;
                    }
                    if ((this.__modifierFlags[0] & 16) != 0) {
                        var4_4 = this.__emitNode('\u0006');
                        break block50;
                    }
                    var4_4 = this.__emitNode('\u0004');
                    break block50;
                }
                case '.': {
                    this.__getNextChar();
                    var4_4 = (this.__modifierFlags[0] & 16) != 0 ? this.__emitNode('\b') : this.__emitNode('\u0007');
                    ++this.__cost;
                    var1_1[0] = var1_1[0] | 3;
                    break block50;
                }
                case '[': {
                    this.__input._increment();
                    var4_4 = this.__parseUnicodeClass();
                    var1_1[0] = var1_1[0] | 3;
                    break block50;
                }
                case '(': {
                    this.__getNextChar();
                    var4_4 = this.__parseExpression(true, var5_2);
                    if (var4_4 == -1) {
                        if ((var5_2[0] & 8) != 0) continue block50;
                        return -1;
                    }
                    var1_1[0] = var1_1[0] | var5_2[0] & 5;
                    break block50;
                }
                case ')': 
                case '|': {
                    if ((var5_2[0] & 8) != 0) {
                        var1_1[0] = var1_1[0] | 8;
                        return -1;
                    }
                    throw new MalformedPatternException("Error in expression at " + this.__input._toString(this.__input._getOffset()));
                }
                case '*': 
                case '+': 
                case '?': {
                    throw new MalformedPatternException("?+* follows nothing in expression");
                }
                case '\\': {
                    var3_5 = this.__input._increment();
                    switch (var3_5) {
                        case 'A': {
                            var4_4 = this.__emitNode('\u0003');
                            var1_1[0] = var1_1[0] | 2;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'G': {
                            var4_4 = this.__emitNode('\u001e');
                            var1_1[0] = var1_1[0] | 2;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'Z': {
                            var4_4 = this.__emitNode('\u0006');
                            var1_1[0] = var1_1[0] | 2;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'w': {
                            var4_4 = this.__emitNode('\u0012');
                            var1_1[0] = var1_1[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'W': {
                            var4_4 = this.__emitNode('\u0013');
                            var1_1[0] = var1_1[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'b': {
                            var4_4 = this.__emitNode('\u0014');
                            var1_1[0] = var1_1[0] | 2;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'B': {
                            var4_4 = this.__emitNode('\u0015');
                            var1_1[0] = var1_1[0] | 2;
                            this.__getNextChar();
                            break block50;
                        }
                        case 's': {
                            var4_4 = this.__emitNode('\u0016');
                            var1_1[0] = var1_1[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'S': {
                            var4_4 = this.__emitNode('\u0017');
                            var1_1[0] = var1_1[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'd': {
                            var4_4 = this.__emitNode('\u0018');
                            var1_1[0] = var1_1[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case 'D': {
                            var4_4 = this.__emitNode('\u0019');
                            var1_1[0] = var1_1[0] | 3;
                            this.__getNextChar();
                            break block50;
                        }
                        case '0': 
                        case 'a': 
                        case 'c': 
                        case 'e': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': 
                        case 'x': {
                            var2_3 = true;
                            break block50;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            var7_6 = new StringBuffer(10);
                            var6_8 = '\u0000';
                            var3_5 = this.__input._getValueRelative(var6_8);
                            while (Character.isDigit(var3_5)) {
                                var7_6.append(var3_5);
                                var3_5 = this.__input._getValueRelative(++var6_8);
                            }
                            try {
                                var6_8 = Integer.parseInt(var7_6.toString());
                            }
                            catch (NumberFormatException var8_9) {
                                throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + var8_9.getMessage());
                            }
                            if (var6_8 > '\t' && var6_8 >= this.__numParentheses) {
                                var2_3 = true;
                                break block50;
                            }
                            if (var6_8 >= this.__numParentheses) {
                                throw new MalformedPatternException("Invalid backreference: \\" + var6_8);
                            }
                            this.__sawBackreference = true;
                            var4_4 = this.__emitArgNode('\u001a', var6_8);
                            var1_1[0] = var1_1[0] | 1;
                            var3_5 = this.__input._getValue();
                            while (Character.isDigit(var3_5)) {
                                var3_5 = this.__input._increment();
                            }
                            this.__input._decrement();
                            this.__getNextChar();
                            break block50;
                        }
                        case '\u0000': 
                        case '\uffff': {
                            if (!this.__input._isAtEnd()) break;
                            throw new MalformedPatternException("Trailing \\ in expression.");
                        }
                    }
                    var2_3 = true;
                    break block50;
                }
                case '#': {
                    if ((this.__modifierFlags[0] & 32) != 0) {
                        while (!this.__input._isAtEnd() && this.__input._getValue() != '\n') {
                            this.__input._increment();
                        }
                        if (this.__input._isAtEnd()) ** break;
                        continue block50;
                    }
                }
                default: {
                    this.__input._increment();
                    var2_3 = true;
                    break block50;
                }
            }
            break;
        }
        if (var2_3) {
            var4_4 = this.__emitNode('\u000e');
            this.__emitCode('\uffff');
            var8_10 = this.__input._getOffset() - 1;
            var9_11 = this.__input._getLength();
            block54: for (var7_7 = 0; var7_7 < 127 && var8_10 < var9_11; ++var7_7) {
                var10_12 = var8_10;
                var3_5 = this.__input._getValue(var8_10);
                switch (var3_5) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '.': 
                    case '[': 
                    case '^': 
                    case '|': {
                        break block54;
                    }
                    case '\\': {
                        var3_5 = this.__input._getValue(++var8_10);
                        switch (var3_5) {
                            case 'A': 
                            case 'B': 
                            case 'D': 
                            case 'G': 
                            case 'S': 
                            case 'W': 
                            case 'Z': 
                            case 'b': 
                            case 'd': 
                            case 's': 
                            case 'w': {
                                --var8_10;
                                break block54;
                            }
                            case 'n': {
                                var6_8 = '\n';
                                ++var8_10;
                                break;
                            }
                            case 'r': {
                                var6_8 = '\r';
                                ++var8_10;
                                break;
                            }
                            case 't': {
                                var6_8 = '\t';
                                ++var8_10;
                                break;
                            }
                            case 'f': {
                                var6_8 = '\f';
                                ++var8_10;
                                break;
                            }
                            case 'e': {
                                var6_8 = '\u001b';
                                ++var8_10;
                                break;
                            }
                            case 'a': {
                                var6_8 = '\u0007';
                                ++var8_10;
                                break;
                            }
                            case 'x': {
                                var11_13 = new int[1];
                                var6_8 = (char)Perl5Compiler.__parseHex(this.__input._array, ++var8_10, 2, var11_13);
                                var8_10 += var11_13[0];
                                break;
                            }
                            case 'c': {
                                v0 = ++var8_10;
                                ++var8_10;
                                var6_8 = this.__input._getValue(v0);
                                if (Character.isLowerCase(var6_8)) {
                                    var6_8 = Character.toUpperCase(var6_8);
                                }
                                var6_8 = (char)(var6_8 ^ 64);
                                break;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                var12_14 = false;
                                var3_5 = this.__input._getValue(var8_10);
                                if (var3_5 == '0') {
                                    var12_14 = true;
                                }
                                if (Character.isDigit(var3_5 = this.__input._getValue(var8_10 + 1))) {
                                    var14_16 = new StringBuffer(10);
                                    var13_15 = var8_10;
                                    var3_5 = this.__input._getValue(var13_15);
                                    while (Character.isDigit(var3_5)) {
                                        var14_16.append(var3_5);
                                        var3_5 = this.__input._getValue(++var13_15);
                                    }
                                    try {
                                        var13_15 = Integer.parseInt(var14_16.toString());
                                    }
                                    catch (NumberFormatException var15_17) {
                                        throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + var15_17.getMessage());
                                    }
                                    if (!var12_14) {
                                        v1 = var12_14 = var13_15 >= this.__numParentheses;
                                    }
                                }
                                if (var12_14) {
                                    var11_13 = new int[1];
                                    var6_8 = (char)Perl5Compiler.__parseOctal(this.__input._array, var8_10, 3, var11_13);
                                    var8_10 += var11_13[0];
                                    break;
                                }
                                --var8_10;
                                break block54;
                            }
                            case '\u0000': 
                            case '\uffff': {
                                if (var8_10 >= var9_11) {
                                    throw new MalformedPatternException("Trailing \\ in expression.");
                                }
                            }
                            default: {
                                var6_8 = this.__input._getValue(var8_10++);
                                break;
                            }
                        }
                        break;
                    }
                    case '#': {
                        if ((this.__modifierFlags[0] & 32) != 0) {
                            while (var8_10 < var9_11 && this.__input._getValue(var8_10) != '\n') {
                                ++var8_10;
                            }
                        }
                    }
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if ((this.__modifierFlags[0] & 32) != 0) {
                            ++var8_10;
                            --var7_7;
                            continue block54;
                        }
                    }
                    default: {
                        var6_8 = this.__input._getValue(var8_10++);
                    }
                }
                if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(var6_8)) {
                    var6_8 = Character.toLowerCase(var6_8);
                }
                if (var8_10 < var9_11 && Perl5Compiler.__isComplexRepetitionOp(this.__input._array, var8_10)) {
                    if (var7_7 > 0) {
                        var8_10 = var10_12;
                        break;
                    }
                    ++var7_7;
                    this.__emitCode(var6_8);
                    break;
                }
                this.__emitCode(var6_8);
            }
            this.__input._setOffset(var8_10 - 1);
            this.__getNextChar();
            if (var7_7 < 0) {
                throw new MalformedPatternException("Unexpected compilation failure.  Please report this bug!");
            }
            if (var7_7 > 0) {
                var1_1[0] = var1_1[0] | 1;
            }
            if (var7_7 == 1) {
                var1_1[0] = var1_1[0] | 2;
            }
            if (this.__program != null) {
                this.__program[OpCode._getOperand((int)var4_4)] = (char)var7_7;
            }
            this.__emitCode('\uffff');
        }
        return var4_4;
    }

    private int __parseUnicodeClass() throws MalformedPatternException {
        int n2;
        boolean bl2 = false;
        char c2 = '\uffff';
        int[] nArray = new int[]{0};
        boolean[] blArray = new boolean[]{false};
        if (this.__input._getValue() == '^') {
            n2 = this.__emitNode('$');
            this.__input._increment();
        } else {
            n2 = this.__emitNode('#');
        }
        char c3 = this.__input._getValue();
        boolean bl3 = c3 == ']' || c3 == '-';
        while (!this.__input._isAtEnd() && (c3 = this.__input._getValue()) != ']' || bl3) {
            bl3 = false;
            boolean bl4 = false;
            this.__input._increment();
            if (c3 == '\\' || c3 == '[') {
                if (c3 == '\\') {
                    c3 = this.__input._postIncrement();
                } else {
                    char c4 = this.__parsePOSIX(blArray);
                    if (c4 != '\u0000') {
                        bl4 = true;
                        c3 = c4;
                    }
                }
                if (!bl4) {
                    switch (c3) {
                        case 'w': {
                            bl4 = true;
                            c3 = '\u0012';
                            c2 = '\uffff';
                            break;
                        }
                        case 'W': {
                            bl4 = true;
                            c3 = '\u0013';
                            c2 = '\uffff';
                            break;
                        }
                        case 's': {
                            bl4 = true;
                            c3 = '\u0016';
                            c2 = '\uffff';
                            break;
                        }
                        case 'S': {
                            bl4 = true;
                            c3 = '\u0017';
                            c2 = '\uffff';
                            break;
                        }
                        case 'd': {
                            bl4 = true;
                            c3 = '\u0018';
                            c2 = '\uffff';
                            break;
                        }
                        case 'D': {
                            bl4 = true;
                            c3 = '\u0019';
                            c2 = '\uffff';
                            break;
                        }
                        case 'n': {
                            c3 = '\n';
                            break;
                        }
                        case 'r': {
                            c3 = '\r';
                            break;
                        }
                        case 't': {
                            c3 = '\t';
                            break;
                        }
                        case 'f': {
                            c3 = '\f';
                            break;
                        }
                        case 'b': {
                            c3 = '\b';
                            break;
                        }
                        case 'e': {
                            c3 = '\u001b';
                            break;
                        }
                        case 'a': {
                            c3 = '\u0007';
                            break;
                        }
                        case 'x': {
                            c3 = (char)Perl5Compiler.__parseHex(this.__input._array, this.__input._getOffset(), 2, nArray);
                            this.__input._increment(nArray[0]);
                            break;
                        }
                        case 'c': {
                            c3 = this.__input._postIncrement();
                            if (Character.isLowerCase(c3)) {
                                c3 = Character.toUpperCase(c3);
                            }
                            c3 = (char)(c3 ^ 0x40);
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            c3 = (char)Perl5Compiler.__parseOctal(this.__input._array, this.__input._getOffset() - 1, 3, nArray);
                            this.__input._increment(nArray[0] - 1);
                            break;
                        }
                    }
                }
            }
            if (bl2) {
                if (c2 > c3) {
                    throw new MalformedPatternException("Invalid [] range in expression.");
                }
                bl2 = false;
            } else {
                c2 = c3;
                if (!bl4 && this.__input._getValue() == '-' && this.__input._getOffset() + 1 < this.__input._getLength() && this.__input._getValueRelative(1) != ']') {
                    this.__input._increment();
                    bl2 = true;
                    continue;
                }
            }
            if (c2 == c3) {
                if (bl4) {
                    if (!blArray[0]) {
                        this.__emitCode('/');
                    } else {
                        this.__emitCode('0');
                    }
                } else {
                    this.__emitCode('1');
                }
                this.__emitCode(c3);
                if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(c3) && Character.isUpperCase(c2)) {
                    --this.__programSize;
                    this.__emitCode(Character.toLowerCase(c3));
                }
            }
            if (c2 < c3) {
                this.__emitCode('%');
                this.__emitCode(c2);
                this.__emitCode(c3);
                if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(c3) && Character.isUpperCase(c2)) {
                    this.__programSize -= 2;
                    this.__emitCode(Character.toLowerCase(c2));
                    this.__emitCode(Character.toLowerCase(c3));
                }
                c2 = '\uffff';
                bl2 = false;
            }
            c2 = c3;
        }
        if (this.__input._getValue() != ']') {
            throw new MalformedPatternException("Unmatched [] in expression.");
        }
        this.__getNextChar();
        this.__emitCode('\u0000');
        return n2;
    }

    private char __parsePOSIX(boolean[] blArray) throws MalformedPatternException {
        char c2;
        int n2 = this.__input._getOffset();
        int n3 = this.__input._getLength();
        int n4 = n2;
        if ((c2 = this.__input._getValue(n4++)) != ':') {
            return '\u0000';
        }
        if (this.__input._getValue(n4) == '^') {
            blArray[0] = true;
            ++n4;
        } else {
            blArray[0] = false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while ((c2 = this.__input._getValue(n4++)) != ':' && n4 < n3) {
                stringBuffer.append(c2);
            }
        }
        catch (Exception exception) {
            return '\u0000';
        }
        if (this.__input._getValue(n4++) != ']') {
            return '\u0000';
        }
        Object v2 = __hashPOSIX.get(stringBuffer.toString());
        if (v2 == null) {
            return '\u0000';
        }
        this.__input._setOffset(n4);
        return ((Character)v2).charValue();
    }

    private int __parseBranch(int[] nArray) throws MalformedPatternException {
        boolean bl2 = false;
        boolean bl3 = false;
        int[] nArray2 = new int[]{0};
        int n2 = 0;
        int n3 = 65535;
        int n4 = this.__parseAtom(nArray2);
        if (n4 == -1) {
            if ((nArray2[0] & 8) != 0) {
                nArray[0] = nArray[0] | 8;
            }
            return -1;
        }
        char c2 = this.__input._getValue();
        if (c2 == '(' && this.__input._getValueRelative(1) == '?' && this.__input._getValueRelative(2) == '#') {
            while (c2 != '\uffff' && c2 != ')') {
                c2 = this.__input._increment();
            }
            if (c2 != '\uffff') {
                this.__getNextChar();
                c2 = this.__input._getValue();
            }
        }
        if (c2 == '{' && Perl5Compiler.__parseRepetition(this.__input._array, this.__input._getOffset())) {
            int n5;
            int n6 = this.__input._getOffset() + 1;
            int n7 = n5 = this.__input._getLength();
            char c3 = this.__input._getValue(n6);
            while (Character.isDigit(c3) || c3 == ',') {
                if (c3 == ',') {
                    if (n7 != n5) break;
                    n7 = n6;
                }
                c3 = this.__input._getValue(++n6);
            }
            if (c3 == '}') {
                StringBuffer stringBuffer = new StringBuffer(10);
                if (n7 == n5) {
                    n7 = n6;
                }
                this.__input._increment();
                int n8 = this.__input._getOffset();
                c3 = this.__input._getValue(n8);
                while (Character.isDigit(c3)) {
                    stringBuffer.append(c3);
                    c3 = this.__input._getValue(++n8);
                }
                try {
                    n2 = Integer.parseInt(stringBuffer.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberFormatException.getMessage());
                }
                c3 = this.__input._getValue(n7);
                n7 = c3 == ',' ? ++n7 : this.__input._getOffset();
                n8 = n7;
                stringBuffer = new StringBuffer(10);
                c3 = this.__input._getValue(n8);
                while (Character.isDigit(c3)) {
                    stringBuffer.append(c3);
                    c3 = this.__input._getValue(++n8);
                }
                try {
                    if (n8 != n7) {
                        n3 = Integer.parseInt(stringBuffer.toString());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberFormatException.getMessage());
                }
                if (n3 == 0 && this.__input._getValue(n7) != '0') {
                    n3 = 65535;
                }
                this.__input._setOffset(n6);
                this.__getNextChar();
                bl2 = true;
                bl3 = true;
            }
        }
        if (!bl2) {
            bl3 = false;
            if (!Perl5Compiler.__isSimpleRepetitionOp(c2)) {
                nArray[0] = nArray2[0];
                return n4;
            }
            this.__getNextChar();
            int n9 = nArray[0] = c2 != '+' ? 4 : 1;
            if (c2 == '*' && (nArray2[0] & 2) != 0) {
                this.__programInsertOperator('\u0010', n4);
                this.__cost += 4;
            } else if (c2 == '*') {
                n2 = 0;
                bl3 = true;
            } else if (c2 == '+' && (nArray2[0] & 2) != 0) {
                this.__programInsertOperator('\u0011', n4);
                this.__cost += 3;
            } else if (c2 == '+') {
                n2 = 1;
                bl3 = true;
            } else if (c2 == '?') {
                n2 = 0;
                n3 = 1;
                bl3 = true;
            }
        }
        if (bl3) {
            if ((nArray2[0] & 2) != 0) {
                this.__cost += (2 + this.__cost) / 2;
                this.__programInsertOperator('\n', n4);
            } else {
                this.__cost += 4 + this.__cost;
                this.__programAddTail(n4, this.__emitNode('\"'));
                this.__programInsertOperator('\u000b', n4);
                this.__programAddTail(n4, this.__emitNode('\u000f'));
            }
            if (n2 > 0) {
                nArray[0] = 1;
            }
            if (n3 != 0 && n3 < n2) {
                throw new MalformedPatternException("Invalid interval {" + n2 + "," + n3 + "}");
            }
            if (this.__program != null) {
                this.__program[n4 + 2] = (char)n2;
                this.__program[n4 + 3] = (char)n3;
            }
        }
        if (this.__input._getValue() == '?') {
            this.__getNextChar();
            this.__programInsertOperator('\u001d', n4);
            this.__programAddTail(n4, n4 + 2);
        }
        if (Perl5Compiler.__isComplexRepetitionOp(this.__input._array, this.__input._getOffset())) {
            throw new MalformedPatternException("Nested repetitions *?+ in expression");
        }
        return n4;
    }

    private int __parseExpression(boolean bl2, int[] nArray) throws MalformedPatternException {
        int n2;
        char c2;
        int[] nArray2;
        int n3;
        int n4;
        block31: {
            block29: {
                block30: {
                    char c3;
                    char[] cArray = new char[]{'\u0000'};
                    char[] cArray2 = new char[]{'\u0000'};
                    n4 = -1;
                    n3 = 0;
                    nArray2 = new int[]{0};
                    String string = "iogmsx-";
                    char[] cArray3 = cArray;
                    nArray[0] = 1;
                    if (!bl2) break block29;
                    c2 = '\u0001';
                    if (this.__input._getValue() != '?') break block30;
                    this.__input._increment();
                    c2 = c3 = this.__input._postIncrement();
                    switch (c3) {
                        case '!': 
                        case ':': 
                        case '=': {
                            break block31;
                        }
                        case '#': {
                            c3 = this.__input._getValue();
                            while (c3 != '\uffff' && c3 != ')') {
                                c3 = this.__input._increment();
                            }
                            if (c3 != ')') {
                                throw new MalformedPatternException("Sequence (?#... not terminated");
                            }
                            this.__getNextChar();
                            nArray[0] = 8;
                            return -1;
                        }
                        default: {
                            this.__input._decrement();
                            c3 = this.__input._getValue();
                            while (c3 != '\uffff' && string.indexOf(c3) != -1) {
                                if (c3 == '-') {
                                    cArray3 = cArray2;
                                } else {
                                    Perl5Compiler.__setModifierFlag(cArray3, c3);
                                }
                                c3 = this.__input._increment();
                            }
                            this.__modifierFlags[0] = (char)(this.__modifierFlags[0] | cArray[0]);
                            this.__modifierFlags[0] = (char)(this.__modifierFlags[0] & ~cArray2[0]);
                            if (c3 != ')') {
                                throw new MalformedPatternException("Sequence (?" + c3 + "...) not recognized");
                            }
                            this.__getNextChar();
                            nArray[0] = 8;
                            return -1;
                        }
                    }
                }
                n3 = this.__numParentheses++;
                n4 = this.__emitArgNode('\u001b', (char)n3);
                break block31;
            }
            c2 = '\u0000';
        }
        int n5 = this.__parseAlternation(nArray2);
        if (n5 == -1) {
            return -1;
        }
        if (n4 != -1) {
            this.__programAddTail(n4, n5);
        } else {
            n4 = n5;
        }
        if ((nArray2[0] & 1) == 0) {
            nArray[0] = nArray[0] & 0xFFFFFFFE;
        }
        nArray[0] = nArray[0] | nArray2[0] & 4;
        while (this.__input._getValue() == '|') {
            this.__getNextChar();
            n5 = this.__parseAlternation(nArray2);
            if (n5 == -1) {
                return -1;
            }
            this.__programAddTail(n4, n5);
            if ((nArray2[0] & 1) == 0) {
                nArray[0] = nArray[0] & 0xFFFFFFFE;
            }
            nArray[0] = nArray[0] | nArray2[0] & 4;
        }
        switch (c2) {
            case ':': {
                n2 = this.__emitNode('\u000f');
                break;
            }
            case '\u0001': {
                n2 = this.__emitArgNode('\u001c', (char)n3);
                break;
            }
            case '!': 
            case '=': {
                n2 = this.__emitNode('!');
                nArray[0] = nArray[0] & 0xFFFFFFFE;
                break;
            }
            default: {
                n2 = this.__emitNode('\u0000');
            }
        }
        this.__programAddTail(n4, n2);
        n5 = n4;
        while (n5 != -1) {
            this.__programAddOperatorTail(n5, n2);
            n5 = OpCode._getNext(this.__program, n5);
        }
        if (c2 == '=') {
            this.__programInsertOperator('\u001f', n4);
            this.__programAddTail(n4, this.__emitNode('\u000f'));
        } else if (c2 == '!') {
            this.__programInsertOperator(' ', n4);
            this.__programAddTail(n4, this.__emitNode('\u000f'));
        }
        if (c2 != '\u0000' && (this.__input._isAtEnd() || this.__getNextChar() != ')')) {
            throw new MalformedPatternException("Unmatched parentheses.");
        }
        if (c2 == '\u0000' && !this.__input._isAtEnd()) {
            if (this.__input._getValue() == ')') {
                throw new MalformedPatternException("Unmatched parentheses.");
            }
            throw new MalformedPatternException("Unreached characters at end of expression.  Please report this bug!");
        }
        return n4;
    }

    public Pattern compile(char[] cArray, int n2) throws MalformedPatternException {
        String string;
        String string2;
        Perl5Pattern perl5Pattern;
        int n3;
        int n4;
        block44: {
            int[] nArray = new int[]{0};
            boolean bl2 = false;
            boolean bl3 = false;
            n4 = 0;
            this.__input = new CharStringPointer(cArray);
            n3 = n2 & 1;
            this.__modifierFlags[0] = (char)n2;
            this.__sawBackreference = false;
            this.__numParentheses = 1;
            this.__programSize = 0;
            this.__cost = 0;
            this.__program = null;
            this.__emitCode('\u0000');
            if (this.__parseExpression(false, nArray) == -1) {
                throw new MalformedPatternException("Unknown compilation error.");
            }
            if (this.__programSize >= 65534) {
                throw new MalformedPatternException("Expression is too large.");
            }
            this.__program = new char[this.__programSize];
            perl5Pattern = new Perl5Pattern();
            perl5Pattern._program = this.__program;
            perl5Pattern._expression = new String(cArray);
            this.__input._setOffset(0);
            this.__numParentheses = 1;
            this.__programSize = 0;
            this.__cost = 0;
            this.__emitCode('\u0000');
            if (this.__parseExpression(false, nArray) == -1) {
                throw new MalformedPatternException("Unknown compilation error.");
            }
            n3 = this.__modifierFlags[0] & '\u0001';
            perl5Pattern._isExpensive = this.__cost >= 10;
            perl5Pattern._startClassOffset = -1;
            perl5Pattern._anchor = 0;
            perl5Pattern._back = -1;
            perl5Pattern._options = n2;
            perl5Pattern._startString = null;
            perl5Pattern._mustString = null;
            string2 = null;
            string = null;
            int n5 = 1;
            if (this.__program[OpCode._getNext(this.__program, n5)] != '\u0000') break block44;
            int n6 = n5 = OpCode._getNextOperator(n5);
            char c2 = this.__program[n6];
            while (true) {
                block46: {
                    block45: {
                        if (c2 != '\u001b') break block45;
                        bl2 = true;
                        if (true) break block46;
                    }
                    if ((c2 != '\f' || this.__program[OpCode._getNext(this.__program, n6)] == '\f') && c2 != '\u0011' && c2 != '\u001d' && (OpCode._opType[c2] != '\n' || OpCode._getArg1(this.__program, n6) <= '\u0000')) break;
                }
                if (c2 == '\u0011') {
                    bl3 = true;
                } else {
                    n6 += OpCode._operandLength[c2];
                }
                n6 = OpCode._getNextOperator(n6);
                c2 = this.__program[n6];
            }
            boolean bl4 = true;
            while (bl4) {
                bl4 = false;
                c2 = this.__program[n6];
                if (c2 == '\u000e') {
                    string = new String(this.__program, OpCode._getOperand(n6 + 1), (int)this.__program[OpCode._getOperand(n6)]);
                    continue;
                }
                if (OpCode._isInArray(c2, OpCode._opLengthOne, 2)) {
                    perl5Pattern._startClassOffset = n6;
                    continue;
                }
                if (c2 == '\u0014' || c2 == '\u0015') {
                    perl5Pattern._startClassOffset = n6;
                    continue;
                }
                if (OpCode._opType[c2] == '\u0001') {
                    perl5Pattern._anchor = c2 == '\u0001' ? 1 : (c2 == '\u0002' ? 2 : 3);
                    n6 = OpCode._getNextOperator(n6);
                    bl4 = true;
                    continue;
                }
                if (c2 != '\u0010' || OpCode._opType[this.__program[OpCode._getNextOperator(n6)]] != '\u0007' || (perl5Pattern._anchor & 3) == 0) continue;
                perl5Pattern._anchor = 11;
                n6 = OpCode._getNextOperator(n6);
                bl4 = true;
            }
            if (!(!bl3 || bl2 && this.__sawBackreference)) {
                perl5Pattern._anchor |= 4;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n7 = 0;
            n4 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n5 > 0 && (c2 = this.__program[n5]) != '\u0000') {
                if (c2 == '\f') {
                    if (this.__program[OpCode._getNext(this.__program, n5)] == '\f') {
                        n8 = -30000;
                        while (this.__program[n5] == '\f') {
                            n5 = OpCode._getNext(this.__program, n5);
                        }
                        continue;
                    }
                    n5 = OpCode._getNextOperator(n5);
                    continue;
                }
                if (c2 == ' ') {
                    n8 = -30000;
                    n5 = OpCode._getNext(this.__program, n5);
                    continue;
                }
                if (c2 == '\u000e') {
                    int n11;
                    n6 = n5;
                    while (this.__program[n11 = OpCode._getNext(this.__program, n5)] == '\u001c') {
                        n5 = n11;
                    }
                    n4 += this.__program[OpCode._getOperand(n6)];
                    n11 = this.__program[OpCode._getOperand(n6)];
                    if (n8 - n9 == n7) {
                        stringBuffer.append(new String(this.__program, OpCode._getOperand(n6) + 1, n11));
                        n7 += n11;
                        n8 += n11;
                        n6 = OpCode._getNext(this.__program, n5);
                    } else if (n11 >= n7 + (n8 >= 0 ? 1 : 0)) {
                        n7 = n11;
                        stringBuffer = new StringBuffer(new String(this.__program, OpCode._getOperand(n6) + 1, n11));
                        n9 = n8;
                        n8 += n7;
                        n6 = OpCode._getNext(this.__program, n5);
                    } else {
                        n8 += n11;
                    }
                } else if (OpCode._isInArray(c2, OpCode._opLengthVaries, 0)) {
                    n8 = -30000;
                    n7 = 0;
                    if (stringBuffer.length() > stringBuffer2.length()) {
                        stringBuffer2 = stringBuffer;
                        n10 = n9;
                    }
                    stringBuffer = new StringBuffer();
                    if (c2 == '\u0011' && OpCode._isInArray(this.__program[OpCode._getNextOperator(n5)], OpCode._opLengthOne, 0)) {
                        ++n4;
                    } else if (OpCode._opType[c2] == '\n' && OpCode._isInArray(this.__program[OpCode._getNextOperator(n5) + 2], OpCode._opLengthOne, 0)) {
                        n4 += OpCode._getArg1(this.__program, n5);
                    }
                } else if (OpCode._isInArray(c2, OpCode._opLengthOne, 0)) {
                    ++n8;
                    ++n4;
                    n7 = 0;
                    if (stringBuffer.length() > stringBuffer2.length()) {
                        stringBuffer2 = stringBuffer;
                        n10 = n9;
                    }
                    stringBuffer = new StringBuffer();
                }
                n5 = OpCode._getNext(this.__program, n5);
            }
            if (stringBuffer.length() + (OpCode._opType[this.__program[n6]] == '\u0004' ? 1 : 0) > stringBuffer2.length()) {
                stringBuffer2 = stringBuffer;
                n10 = n9;
            } else {
                stringBuffer = new StringBuffer();
            }
            if (stringBuffer2.length() > 0 && string == null) {
                string2 = stringBuffer2.toString();
                if (n10 < 0) {
                    n10 = -1;
                }
                perl5Pattern._back = n10;
            } else {
                stringBuffer2 = null;
            }
        }
        perl5Pattern._isCaseInsensitive = (n3 & 1) != 0;
        perl5Pattern._numParentheses = this.__numParentheses - 1;
        perl5Pattern._minLength = n4;
        if (string2 != null) {
            perl5Pattern._mustString = string2.toCharArray();
            perl5Pattern._mustUtility = 100;
        }
        if (string != null) {
            perl5Pattern._startString = string.toCharArray();
        }
        return perl5Pattern;
    }

    public Pattern compile(char[] cArray) throws MalformedPatternException {
        return this.compile(cArray, 0);
    }

    public Pattern compile(String string) throws MalformedPatternException {
        return this.compile(string.toCharArray(), 0);
    }

    public Pattern compile(String string, int n2) throws MalformedPatternException {
        return this.compile(string.toCharArray(), n2);
    }

    static {
        __hashPOSIX.put("alnum", new Character('2'));
        __hashPOSIX.put("word", new Character('\u0012'));
        __hashPOSIX.put("alpha", new Character('&'));
        __hashPOSIX.put("blank", new Character('\''));
        __hashPOSIX.put("cntrl", new Character('('));
        __hashPOSIX.put("digit", new Character('\u0018'));
        __hashPOSIX.put("graph", new Character(')'));
        __hashPOSIX.put("lower", new Character('*'));
        __hashPOSIX.put("print", new Character('+'));
        __hashPOSIX.put("punct", new Character(','));
        __hashPOSIX.put("space", new Character('\u0016'));
        __hashPOSIX.put("upper", new Character('-'));
        __hashPOSIX.put("xdigit", new Character('.'));
        __hashPOSIX.put("ascii", new Character('3'));
    }
}

