/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.msgpack.value.impl;

import com.contrastsecurity.thirdparty.org.msgpack.core.MessagePacker;
import com.contrastsecurity.thirdparty.org.msgpack.core.buffer.MessageBuffer;
import com.contrastsecurity.thirdparty.org.msgpack.value.ExtensionValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableExtensionValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.ImmutableTimestampValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.TimestampValue;
import com.contrastsecurity.thirdparty.org.msgpack.value.Value;
import com.contrastsecurity.thirdparty.org.msgpack.value.ValueType;
import com.contrastsecurity.thirdparty.org.msgpack.value.impl.AbstractImmutableValue;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;

public class ImmutableTimestampValueImpl
extends AbstractImmutableValue
implements ImmutableExtensionValue,
ImmutableTimestampValue {
    private final Instant instant;
    private byte[] data;

    public ImmutableTimestampValueImpl(Instant instant) {
        this.instant = instant;
    }

    @Override
    public boolean isTimestampValue() {
        return true;
    }

    @Override
    public byte getType() {
        return -1;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.EXTENSION;
    }

    @Override
    public ImmutableTimestampValue immutableValue() {
        return this;
    }

    @Override
    public ImmutableExtensionValue asExtensionValue() {
        return this;
    }

    @Override
    public ImmutableTimestampValue asTimestampValue() {
        return this;
    }

    @Override
    public byte[] getData() {
        if (this.data == null) {
            byte[] byArray;
            long l2 = this.getEpochSecond();
            int n2 = this.getNano();
            if (l2 >>> 34 == 0L) {
                long l3 = (long)(n2 << 34) | l2;
                if ((l3 & 0xFFFFFFFF00000000L) == 0L) {
                    byArray = new byte[4];
                    MessageBuffer.wrap(byArray).putInt(0, (int)l2);
                } else {
                    byArray = new byte[8];
                    MessageBuffer.wrap(byArray).putLong(0, l3);
                }
            } else {
                byArray = new byte[12];
                MessageBuffer messageBuffer = MessageBuffer.wrap(byArray);
                messageBuffer.putInt(0, n2);
                messageBuffer.putLong(4, l2);
            }
            this.data = byArray;
        }
        return this.data;
    }

    @Override
    public long getEpochSecond() {
        return this.instant.getEpochSecond();
    }

    @Override
    public int getNano() {
        return this.instant.getNano();
    }

    @Override
    public long toEpochMillis() {
        return this.instant.toEpochMilli();
    }

    @Override
    public Instant toInstant() {
        return this.instant;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packTimestamp(this.instant);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isExtensionValue()) {
            return false;
        }
        ExtensionValue extensionValue = value.asExtensionValue();
        if (extensionValue instanceof TimestampValue) {
            TimestampValue timestampValue = (TimestampValue)extensionValue;
            return this.instant.equals(timestampValue.toInstant());
        }
        return -1 == extensionValue.getType() && Arrays.equals(this.getData(), extensionValue.getData());
    }

    public int hashCode() {
        int n2 = -1;
        n2 *= 31;
        n2 = this.instant.hashCode();
        return n2;
    }

    @Override
    public String toJson() {
        return "\"" + this.toInstant().toString() + "\"";
    }

    public String toString() {
        return this.toInstant().toString();
    }
}

