/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.asm.xml;

import com.contrastsecurity.thirdparty.org.mvel2.asm.AnnotationVisitor;
import com.contrastsecurity.thirdparty.org.mvel2.asm.ClassVisitor;
import com.contrastsecurity.thirdparty.org.mvel2.asm.FieldVisitor;
import com.contrastsecurity.thirdparty.org.mvel2.asm.Handle;
import com.contrastsecurity.thirdparty.org.mvel2.asm.Label;
import com.contrastsecurity.thirdparty.org.mvel2.asm.MethodVisitor;
import com.contrastsecurity.thirdparty.org.mvel2.asm.Opcodes;
import com.contrastsecurity.thirdparty.org.mvel2.asm.Type;
import com.contrastsecurity.thirdparty.org.mvel2.asm.TypePath;
import com.contrastsecurity.thirdparty.org.mvel2.asm.xml.SAXCodeAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ASMContentHandler
extends DefaultHandler
implements Opcodes {
    private final ArrayList<Object> stack = new ArrayList();
    String match = "";
    protected ClassVisitor cv;
    protected Map<Object, Label> labels;
    private static final String BASE = "class";
    private final RuleSet RULES = new RuleSet();
    static final HashMap<String, Opcode> OPCODES = new HashMap();
    static final HashMap<String, Integer> TYPES;

    private static void addOpcode(String string, int n2, int n3) {
        OPCODES.put(string, new Opcode(n2, n3));
    }

    public ASMContentHandler(ClassVisitor classVisitor) {
        this.RULES.add(BASE, new ClassRule());
        this.RULES.add("class/interfaces/interface", new InterfaceRule());
        this.RULES.add("class/interfaces", new InterfacesRule());
        this.RULES.add("class/outerclass", new OuterClassRule());
        this.RULES.add("class/innerclass", new InnerClassRule());
        this.RULES.add("class/source", new SourceRule());
        this.RULES.add("class/field", new FieldRule());
        this.RULES.add("class/method", new MethodRule());
        this.RULES.add("class/method/exceptions/exception", new ExceptionRule());
        this.RULES.add("class/method/exceptions", new ExceptionsRule());
        this.RULES.add("class/method/parameter", new MethodParameterRule());
        this.RULES.add("class/method/annotationDefault", new AnnotationDefaultRule());
        this.RULES.add("class/method/code/*", new OpcodesRule());
        this.RULES.add("class/method/code/frame", new FrameRule());
        this.RULES.add("class/method/code/frame/local", new FrameTypeRule());
        this.RULES.add("class/method/code/frame/stack", new FrameTypeRule());
        this.RULES.add("class/method/code/TABLESWITCH", new TableSwitchRule());
        this.RULES.add("class/method/code/TABLESWITCH/label", new TableSwitchLabelRule());
        this.RULES.add("class/method/code/LOOKUPSWITCH", new LookupSwitchRule());
        this.RULES.add("class/method/code/LOOKUPSWITCH/label", new LookupSwitchLabelRule());
        this.RULES.add("class/method/code/INVOKEDYNAMIC", new InvokeDynamicRule());
        this.RULES.add("class/method/code/INVOKEDYNAMIC/bsmArg", new InvokeDynamicBsmArgumentsRule());
        this.RULES.add("class/method/code/Label", new LabelRule());
        this.RULES.add("class/method/code/TryCatch", new TryCatchRule());
        this.RULES.add("class/method/code/LineNumber", new LineNumberRule());
        this.RULES.add("class/method/code/LocalVar", new LocalVarRule());
        this.RULES.add("class/method/code/Max", new MaxRule());
        this.RULES.add("*/annotation", new AnnotationRule());
        this.RULES.add("*/typeAnnotation", new TypeAnnotationRule());
        this.RULES.add("*/parameterAnnotation", new AnnotationParameterRule());
        this.RULES.add("*/insnAnnotation", new InsnAnnotationRule());
        this.RULES.add("*/tryCatchAnnotation", new TryCatchAnnotationRule());
        this.RULES.add("*/localVariableAnnotation", new LocalVariableAnnotationRule());
        this.RULES.add("*/annotationValue", new AnnotationValueRule());
        this.RULES.add("*/annotationValueAnnotation", new AnnotationValueAnnotationRule());
        this.RULES.add("*/annotationValueEnum", new AnnotationValueEnumRule());
        this.RULES.add("*/annotationValueArray", new AnnotationValueArrayRule());
        this.cv = classVisitor;
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2 == null || string2.length() == 0 ? string3 : string2;
        StringBuffer stringBuffer = new StringBuffer(this.match);
        if (this.match.length() > 0) {
            stringBuffer.append('/');
        }
        stringBuffer.append(string4);
        this.match = stringBuffer.toString();
        Rule rule = (Rule)this.RULES.match(this.match);
        if (rule != null) {
            rule.begin(string4, attributes);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        int n2;
        String string4 = string2 == null || string2.length() == 0 ? string3 : string2;
        Rule rule = (Rule)this.RULES.match(this.match);
        if (rule != null) {
            rule.end(string4);
        }
        this.match = (n2 = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, n2) : "";
    }

    final Object peek() {
        int n2 = this.stack.size();
        return n2 == 0 ? null : this.stack.get(n2 - 1);
    }

    final Object pop() {
        int n2 = this.stack.size();
        return n2 == 0 ? null : this.stack.remove(n2 - 1);
    }

    final void push(Object object) {
        this.stack.add(object);
    }

    static {
        ASMContentHandler.addOpcode("NOP", 0, 0);
        ASMContentHandler.addOpcode("ACONST_NULL", 1, 0);
        ASMContentHandler.addOpcode("ICONST_M1", 2, 0);
        ASMContentHandler.addOpcode("ICONST_0", 3, 0);
        ASMContentHandler.addOpcode("ICONST_1", 4, 0);
        ASMContentHandler.addOpcode("ICONST_2", 5, 0);
        ASMContentHandler.addOpcode("ICONST_3", 6, 0);
        ASMContentHandler.addOpcode("ICONST_4", 7, 0);
        ASMContentHandler.addOpcode("ICONST_5", 8, 0);
        ASMContentHandler.addOpcode("LCONST_0", 9, 0);
        ASMContentHandler.addOpcode("LCONST_1", 10, 0);
        ASMContentHandler.addOpcode("FCONST_0", 11, 0);
        ASMContentHandler.addOpcode("FCONST_1", 12, 0);
        ASMContentHandler.addOpcode("FCONST_2", 13, 0);
        ASMContentHandler.addOpcode("DCONST_0", 14, 0);
        ASMContentHandler.addOpcode("DCONST_1", 15, 0);
        ASMContentHandler.addOpcode("BIPUSH", 16, 1);
        ASMContentHandler.addOpcode("SIPUSH", 17, 1);
        ASMContentHandler.addOpcode("LDC", 18, 7);
        ASMContentHandler.addOpcode("ILOAD", 21, 2);
        ASMContentHandler.addOpcode("LLOAD", 22, 2);
        ASMContentHandler.addOpcode("FLOAD", 23, 2);
        ASMContentHandler.addOpcode("DLOAD", 24, 2);
        ASMContentHandler.addOpcode("ALOAD", 25, 2);
        ASMContentHandler.addOpcode("IALOAD", 46, 0);
        ASMContentHandler.addOpcode("LALOAD", 47, 0);
        ASMContentHandler.addOpcode("FALOAD", 48, 0);
        ASMContentHandler.addOpcode("DALOAD", 49, 0);
        ASMContentHandler.addOpcode("AALOAD", 50, 0);
        ASMContentHandler.addOpcode("BALOAD", 51, 0);
        ASMContentHandler.addOpcode("CALOAD", 52, 0);
        ASMContentHandler.addOpcode("SALOAD", 53, 0);
        ASMContentHandler.addOpcode("ISTORE", 54, 2);
        ASMContentHandler.addOpcode("LSTORE", 55, 2);
        ASMContentHandler.addOpcode("FSTORE", 56, 2);
        ASMContentHandler.addOpcode("DSTORE", 57, 2);
        ASMContentHandler.addOpcode("ASTORE", 58, 2);
        ASMContentHandler.addOpcode("IASTORE", 79, 0);
        ASMContentHandler.addOpcode("LASTORE", 80, 0);
        ASMContentHandler.addOpcode("FASTORE", 81, 0);
        ASMContentHandler.addOpcode("DASTORE", 82, 0);
        ASMContentHandler.addOpcode("AASTORE", 83, 0);
        ASMContentHandler.addOpcode("BASTORE", 84, 0);
        ASMContentHandler.addOpcode("CASTORE", 85, 0);
        ASMContentHandler.addOpcode("SASTORE", 86, 0);
        ASMContentHandler.addOpcode("POP", 87, 0);
        ASMContentHandler.addOpcode("POP2", 88, 0);
        ASMContentHandler.addOpcode("DUP", 89, 0);
        ASMContentHandler.addOpcode("DUP_X1", 90, 0);
        ASMContentHandler.addOpcode("DUP_X2", 91, 0);
        ASMContentHandler.addOpcode("DUP2", 92, 0);
        ASMContentHandler.addOpcode("DUP2_X1", 93, 0);
        ASMContentHandler.addOpcode("DUP2_X2", 94, 0);
        ASMContentHandler.addOpcode("SWAP", 95, 0);
        ASMContentHandler.addOpcode("IADD", 96, 0);
        ASMContentHandler.addOpcode("LADD", 97, 0);
        ASMContentHandler.addOpcode("FADD", 98, 0);
        ASMContentHandler.addOpcode("DADD", 99, 0);
        ASMContentHandler.addOpcode("ISUB", 100, 0);
        ASMContentHandler.addOpcode("LSUB", 101, 0);
        ASMContentHandler.addOpcode("FSUB", 102, 0);
        ASMContentHandler.addOpcode("DSUB", 103, 0);
        ASMContentHandler.addOpcode("IMUL", 104, 0);
        ASMContentHandler.addOpcode("LMUL", 105, 0);
        ASMContentHandler.addOpcode("FMUL", 106, 0);
        ASMContentHandler.addOpcode("DMUL", 107, 0);
        ASMContentHandler.addOpcode("IDIV", 108, 0);
        ASMContentHandler.addOpcode("LDIV", 109, 0);
        ASMContentHandler.addOpcode("FDIV", 110, 0);
        ASMContentHandler.addOpcode("DDIV", 111, 0);
        ASMContentHandler.addOpcode("IREM", 112, 0);
        ASMContentHandler.addOpcode("LREM", 113, 0);
        ASMContentHandler.addOpcode("FREM", 114, 0);
        ASMContentHandler.addOpcode("DREM", 115, 0);
        ASMContentHandler.addOpcode("INEG", 116, 0);
        ASMContentHandler.addOpcode("LNEG", 117, 0);
        ASMContentHandler.addOpcode("FNEG", 118, 0);
        ASMContentHandler.addOpcode("DNEG", 119, 0);
        ASMContentHandler.addOpcode("ISHL", 120, 0);
        ASMContentHandler.addOpcode("LSHL", 121, 0);
        ASMContentHandler.addOpcode("ISHR", 122, 0);
        ASMContentHandler.addOpcode("LSHR", 123, 0);
        ASMContentHandler.addOpcode("IUSHR", 124, 0);
        ASMContentHandler.addOpcode("LUSHR", 125, 0);
        ASMContentHandler.addOpcode("IAND", 126, 0);
        ASMContentHandler.addOpcode("LAND", 127, 0);
        ASMContentHandler.addOpcode("IOR", 128, 0);
        ASMContentHandler.addOpcode("LOR", 129, 0);
        ASMContentHandler.addOpcode("IXOR", 130, 0);
        ASMContentHandler.addOpcode("LXOR", 131, 0);
        ASMContentHandler.addOpcode("IINC", 132, 8);
        ASMContentHandler.addOpcode("I2L", 133, 0);
        ASMContentHandler.addOpcode("I2F", 134, 0);
        ASMContentHandler.addOpcode("I2D", 135, 0);
        ASMContentHandler.addOpcode("L2I", 136, 0);
        ASMContentHandler.addOpcode("L2F", 137, 0);
        ASMContentHandler.addOpcode("L2D", 138, 0);
        ASMContentHandler.addOpcode("F2I", 139, 0);
        ASMContentHandler.addOpcode("F2L", 140, 0);
        ASMContentHandler.addOpcode("F2D", 141, 0);
        ASMContentHandler.addOpcode("D2I", 142, 0);
        ASMContentHandler.addOpcode("D2L", 143, 0);
        ASMContentHandler.addOpcode("D2F", 144, 0);
        ASMContentHandler.addOpcode("I2B", 145, 0);
        ASMContentHandler.addOpcode("I2C", 146, 0);
        ASMContentHandler.addOpcode("I2S", 147, 0);
        ASMContentHandler.addOpcode("LCMP", 148, 0);
        ASMContentHandler.addOpcode("FCMPL", 149, 0);
        ASMContentHandler.addOpcode("FCMPG", 150, 0);
        ASMContentHandler.addOpcode("DCMPL", 151, 0);
        ASMContentHandler.addOpcode("DCMPG", 152, 0);
        ASMContentHandler.addOpcode("IFEQ", 153, 6);
        ASMContentHandler.addOpcode("IFNE", 154, 6);
        ASMContentHandler.addOpcode("IFLT", 155, 6);
        ASMContentHandler.addOpcode("IFGE", 156, 6);
        ASMContentHandler.addOpcode("IFGT", 157, 6);
        ASMContentHandler.addOpcode("IFLE", 158, 6);
        ASMContentHandler.addOpcode("IF_ICMPEQ", 159, 6);
        ASMContentHandler.addOpcode("IF_ICMPNE", 160, 6);
        ASMContentHandler.addOpcode("IF_ICMPLT", 161, 6);
        ASMContentHandler.addOpcode("IF_ICMPGE", 162, 6);
        ASMContentHandler.addOpcode("IF_ICMPGT", 163, 6);
        ASMContentHandler.addOpcode("IF_ICMPLE", 164, 6);
        ASMContentHandler.addOpcode("IF_ACMPEQ", 165, 6);
        ASMContentHandler.addOpcode("IF_ACMPNE", 166, 6);
        ASMContentHandler.addOpcode("GOTO", 167, 6);
        ASMContentHandler.addOpcode("JSR", 168, 6);
        ASMContentHandler.addOpcode("RET", 169, 2);
        ASMContentHandler.addOpcode("IRETURN", 172, 0);
        ASMContentHandler.addOpcode("LRETURN", 173, 0);
        ASMContentHandler.addOpcode("FRETURN", 174, 0);
        ASMContentHandler.addOpcode("DRETURN", 175, 0);
        ASMContentHandler.addOpcode("ARETURN", 176, 0);
        ASMContentHandler.addOpcode("RETURN", 177, 0);
        ASMContentHandler.addOpcode("GETSTATIC", 178, 4);
        ASMContentHandler.addOpcode("PUTSTATIC", 179, 4);
        ASMContentHandler.addOpcode("GETFIELD", 180, 4);
        ASMContentHandler.addOpcode("PUTFIELD", 181, 4);
        ASMContentHandler.addOpcode("INVOKEVIRTUAL", 182, 5);
        ASMContentHandler.addOpcode("INVOKESPECIAL", 183, 5);
        ASMContentHandler.addOpcode("INVOKESTATIC", 184, 5);
        ASMContentHandler.addOpcode("INVOKEINTERFACE", 185, 5);
        ASMContentHandler.addOpcode("NEW", 187, 3);
        ASMContentHandler.addOpcode("NEWARRAY", 188, 1);
        ASMContentHandler.addOpcode("ANEWARRAY", 189, 3);
        ASMContentHandler.addOpcode("ARRAYLENGTH", 190, 0);
        ASMContentHandler.addOpcode("ATHROW", 191, 0);
        ASMContentHandler.addOpcode("CHECKCAST", 192, 3);
        ASMContentHandler.addOpcode("INSTANCEOF", 193, 3);
        ASMContentHandler.addOpcode("MONITORENTER", 194, 0);
        ASMContentHandler.addOpcode("MONITOREXIT", 195, 0);
        ASMContentHandler.addOpcode("MULTIANEWARRAY", 197, 9);
        ASMContentHandler.addOpcode("IFNULL", 198, 6);
        ASMContentHandler.addOpcode("IFNONNULL", 199, 6);
        TYPES = new HashMap();
        String[] stringArray = SAXCodeAdapter.TYPES;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            TYPES.put(stringArray[i2], new Integer(i2));
        }
    }

    static final class Opcode {
        public final int opcode;
        public final int type;

        Opcode(int n2, int n3) {
            this.opcode = n2;
            this.type = n3;
        }
    }

    final class AnnotationDefaultRule
    extends Rule {
        AnnotationDefaultRule() {
        }

        public void begin(String string, Attributes attributes) {
            MethodVisitor methodVisitor = (MethodVisitor)ASMContentHandler.this.peek();
            ASMContentHandler.this.push(methodVisitor == null ? null : methodVisitor.visitAnnotationDefault());
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class AnnotationValueArrayRule
    extends Rule {
        AnnotationValueArrayRule() {
        }

        public void begin(String string, Attributes attributes) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.peek();
            ASMContentHandler.this.push(annotationVisitor == null ? null : annotationVisitor.visitArray(attributes.getValue("name")));
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class AnnotationValueAnnotationRule
    extends Rule {
        AnnotationValueAnnotationRule() {
        }

        public void begin(String string, Attributes attributes) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.peek();
            ASMContentHandler.this.push(annotationVisitor == null ? null : annotationVisitor.visitAnnotation(attributes.getValue("name"), attributes.getValue("desc")));
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class AnnotationValueEnumRule
    extends Rule {
        AnnotationValueEnumRule() {
        }

        public void begin(String string, Attributes attributes) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.peek();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnum(attributes.getValue("name"), attributes.getValue("desc"), attributes.getValue("value"));
            }
        }
    }

    final class AnnotationValueRule
    extends Rule {
        AnnotationValueRule() {
        }

        public void begin(String string, Attributes attributes) throws SAXException {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.peek();
            if (annotationVisitor != null) {
                annotationVisitor.visit(attributes.getValue("name"), this.getValue(attributes.getValue("desc"), attributes.getValue("value")));
            }
        }
    }

    final class LocalVariableAnnotationRule
    extends Rule {
        LocalVariableAnnotationRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("desc");
            boolean bl2 = Boolean.valueOf(attributes.getValue("visible"));
            int n2 = Integer.parseInt(attributes.getValue("typeRef"));
            TypePath typePath = TypePath.fromString(attributes.getValue("typePath"));
            String[] stringArray = attributes.getValue("start").split(" ");
            Label[] labelArray = new Label[stringArray.length];
            for (int i2 = 0; i2 < labelArray.length; ++i2) {
                labelArray[i2] = this.getLabel(stringArray[i2]);
            }
            String[] stringArray2 = attributes.getValue("end").split(" ");
            Label[] labelArray2 = new Label[stringArray2.length];
            for (int i3 = 0; i3 < labelArray2.length; ++i3) {
                labelArray2[i3] = this.getLabel(stringArray2[i3]);
            }
            String[] stringArray3 = attributes.getValue("index").split(" ");
            int[] nArray = new int[stringArray3.length];
            for (int i4 = 0; i4 < nArray.length; ++i4) {
                nArray[i4] = Integer.parseInt(stringArray3[i4]);
            }
            ASMContentHandler.this.push(((MethodVisitor)ASMContentHandler.this.peek()).visitLocalVariableAnnotation(n2, typePath, labelArray, labelArray2, nArray, string2, bl2));
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class TryCatchAnnotationRule
    extends Rule {
        TryCatchAnnotationRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("desc");
            boolean bl2 = Boolean.valueOf(attributes.getValue("visible"));
            int n2 = Integer.parseInt(attributes.getValue("typeRef"));
            TypePath typePath = TypePath.fromString(attributes.getValue("typePath"));
            ASMContentHandler.this.push(((MethodVisitor)ASMContentHandler.this.peek()).visitTryCatchAnnotation(n2, typePath, string2, bl2));
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class InsnAnnotationRule
    extends Rule {
        InsnAnnotationRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("desc");
            boolean bl2 = Boolean.valueOf(attributes.getValue("visible"));
            int n2 = Integer.parseInt(attributes.getValue("typeRef"));
            TypePath typePath = TypePath.fromString(attributes.getValue("typePath"));
            ASMContentHandler.this.push(((MethodVisitor)ASMContentHandler.this.peek()).visitInsnAnnotation(n2, typePath, string2, bl2));
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class AnnotationParameterRule
    extends Rule {
        AnnotationParameterRule() {
        }

        public void begin(String string, Attributes attributes) {
            int n2 = Integer.parseInt(attributes.getValue("parameter"));
            String string2 = attributes.getValue("desc");
            boolean bl2 = Boolean.valueOf(attributes.getValue("visible"));
            ASMContentHandler.this.push(((MethodVisitor)ASMContentHandler.this.peek()).visitParameterAnnotation(n2, string2, bl2));
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class TypeAnnotationRule
    extends Rule {
        TypeAnnotationRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("desc");
            boolean bl2 = Boolean.valueOf(attributes.getValue("visible"));
            int n2 = Integer.parseInt(attributes.getValue("typeRef"));
            TypePath typePath = TypePath.fromString(attributes.getValue("typePath"));
            Object object = ASMContentHandler.this.peek();
            if (object instanceof ClassVisitor) {
                ASMContentHandler.this.push(((ClassVisitor)object).visitTypeAnnotation(n2, typePath, string2, bl2));
            } else if (object instanceof FieldVisitor) {
                ASMContentHandler.this.push(((FieldVisitor)object).visitTypeAnnotation(n2, typePath, string2, bl2));
            } else if (object instanceof MethodVisitor) {
                ASMContentHandler.this.push(((MethodVisitor)object).visitTypeAnnotation(n2, typePath, string2, bl2));
            }
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class AnnotationRule
    extends Rule {
        AnnotationRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("desc");
            boolean bl2 = Boolean.valueOf(attributes.getValue("visible"));
            Object object = ASMContentHandler.this.peek();
            if (object instanceof ClassVisitor) {
                ASMContentHandler.this.push(((ClassVisitor)object).visitAnnotation(string2, bl2));
            } else if (object instanceof FieldVisitor) {
                ASMContentHandler.this.push(((FieldVisitor)object).visitAnnotation(string2, bl2));
            } else if (object instanceof MethodVisitor) {
                ASMContentHandler.this.push(((MethodVisitor)object).visitAnnotation(string2, bl2));
            }
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class MaxRule
    extends Rule {
        MaxRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n2 = Integer.parseInt(attributes.getValue("maxStack"));
            int n3 = Integer.parseInt(attributes.getValue("maxLocals"));
            this.getCodeVisitor().visitMaxs(n2, n3);
        }
    }

    final class OpcodesRule
    extends Rule {
        OpcodesRule() {
        }

        public final void begin(String string, Attributes attributes) throws SAXException {
            Opcode opcode = OPCODES.get(string);
            if (opcode == null) {
                throw new SAXException("Invalid element: " + string + " at " + ASMContentHandler.this.match);
            }
            switch (opcode.type) {
                case 0: {
                    this.getCodeVisitor().visitInsn(opcode.opcode);
                    break;
                }
                case 4: {
                    this.getCodeVisitor().visitFieldInsn(opcode.opcode, attributes.getValue("owner"), attributes.getValue("name"), attributes.getValue("desc"));
                    break;
                }
                case 1: {
                    this.getCodeVisitor().visitIntInsn(opcode.opcode, Integer.parseInt(attributes.getValue("value")));
                    break;
                }
                case 6: {
                    this.getCodeVisitor().visitJumpInsn(opcode.opcode, this.getLabel(attributes.getValue("label")));
                    break;
                }
                case 5: {
                    this.getCodeVisitor().visitMethodInsn(opcode.opcode, attributes.getValue("owner"), attributes.getValue("name"), attributes.getValue("desc"), attributes.getValue("itf").equals("true"));
                    break;
                }
                case 3: {
                    this.getCodeVisitor().visitTypeInsn(opcode.opcode, attributes.getValue("desc"));
                    break;
                }
                case 2: {
                    this.getCodeVisitor().visitVarInsn(opcode.opcode, Integer.parseInt(attributes.getValue("var")));
                    break;
                }
                case 8: {
                    this.getCodeVisitor().visitIincInsn(Integer.parseInt(attributes.getValue("var")), Integer.parseInt(attributes.getValue("inc")));
                    break;
                }
                case 7: {
                    this.getCodeVisitor().visitLdcInsn(this.getValue(attributes.getValue("desc"), attributes.getValue("cst")));
                    break;
                }
                case 9: {
                    this.getCodeVisitor().visitMultiANewArrayInsn(attributes.getValue("desc"), Integer.parseInt(attributes.getValue("dims")));
                    break;
                }
                default: {
                    throw new Error("Internal error");
                }
            }
        }
    }

    final class InvokeDynamicBsmArgumentsRule
    extends Rule {
        InvokeDynamicBsmArgumentsRule() {
        }

        public final void begin(String string, Attributes attributes) throws SAXException {
            ArrayList arrayList = (ArrayList)ASMContentHandler.this.peek();
            arrayList.add(this.getValue(attributes.getValue("desc"), attributes.getValue("cst")));
        }
    }

    final class InvokeDynamicRule
    extends Rule {
        InvokeDynamicRule() {
        }

        public final void begin(String string, Attributes attributes) throws SAXException {
            ASMContentHandler.this.push(attributes.getValue("name"));
            ASMContentHandler.this.push(attributes.getValue("desc"));
            ASMContentHandler.this.push(this.decodeHandle(attributes.getValue("bsm")));
            ASMContentHandler.this.push(new ArrayList());
        }

        public final void end(String string) {
            ArrayList arrayList = (ArrayList)ASMContentHandler.this.pop();
            Handle handle = (Handle)ASMContentHandler.this.pop();
            String string2 = (String)ASMContentHandler.this.pop();
            String string3 = (String)ASMContentHandler.this.pop();
            this.getCodeVisitor().visitInvokeDynamicInsn(string3, string2, handle, arrayList.toArray());
        }
    }

    final class LocalVarRule
    extends Rule {
        LocalVarRule() {
        }

        public final void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("desc");
            String string4 = attributes.getValue("signature");
            Label label = this.getLabel(attributes.getValue("start"));
            Label label2 = this.getLabel(attributes.getValue("end"));
            int n2 = Integer.parseInt(attributes.getValue("var"));
            this.getCodeVisitor().visitLocalVariable(string2, string3, string4, label, label2, n2);
        }
    }

    final class LineNumberRule
    extends Rule {
        LineNumberRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n2 = Integer.parseInt(attributes.getValue("line"));
            Label label = this.getLabel(attributes.getValue("start"));
            this.getCodeVisitor().visitLineNumber(n2, label);
        }
    }

    final class TryCatchRule
    extends Rule {
        TryCatchRule() {
        }

        public final void begin(String string, Attributes attributes) {
            Label label = this.getLabel(attributes.getValue("start"));
            Label label2 = this.getLabel(attributes.getValue("end"));
            Label label3 = this.getLabel(attributes.getValue("handler"));
            String string2 = attributes.getValue("type");
            this.getCodeVisitor().visitTryCatchBlock(label, label2, label3, string2);
        }
    }

    final class LabelRule
    extends Rule {
        LabelRule() {
        }

        public final void begin(String string, Attributes attributes) {
            this.getCodeVisitor().visitLabel(this.getLabel(attributes.getValue("name")));
        }
    }

    final class FrameTypeRule
    extends Rule {
        FrameTypeRule() {
        }

        public void begin(String string, Attributes attributes) {
            ArrayList arrayList = (ArrayList)((HashMap)ASMContentHandler.this.peek()).get(string);
            String string2 = attributes.getValue("type");
            if ("uninitialized".equals(string2)) {
                arrayList.add(this.getLabel(attributes.getValue("label")));
            } else {
                Integer n2 = TYPES.get(string2);
                if (n2 == null) {
                    arrayList.add(string2);
                } else {
                    arrayList.add(n2);
                }
            }
        }
    }

    final class FrameRule
    extends Rule {
        FrameRule() {
        }

        public void begin(String string, Attributes attributes) {
            HashMap hashMap = new HashMap();
            hashMap.put("local", new ArrayList());
            hashMap.put("stack", new ArrayList());
            ASMContentHandler.this.push(attributes.getValue("type"));
            ASMContentHandler.this.push(attributes.getValue("count") == null ? "0" : attributes.getValue("count"));
            ASMContentHandler.this.push(hashMap);
        }

        public void end(String string) {
            HashMap hashMap = (HashMap)ASMContentHandler.this.pop();
            ArrayList arrayList = (ArrayList)hashMap.get("local");
            int n2 = arrayList.size();
            Object[] objectArray = arrayList.toArray();
            ArrayList arrayList2 = (ArrayList)hashMap.get("stack");
            int n3 = arrayList2.size();
            Object[] objectArray2 = arrayList2.toArray();
            String string2 = (String)ASMContentHandler.this.pop();
            String string3 = (String)ASMContentHandler.this.pop();
            if ("NEW".equals(string3)) {
                this.getCodeVisitor().visitFrame(-1, n2, objectArray, n3, objectArray2);
            } else if ("FULL".equals(string3)) {
                this.getCodeVisitor().visitFrame(0, n2, objectArray, n3, objectArray2);
            } else if ("APPEND".equals(string3)) {
                this.getCodeVisitor().visitFrame(1, n2, objectArray, 0, null);
            } else if ("CHOP".equals(string3)) {
                this.getCodeVisitor().visitFrame(2, Integer.parseInt(string2), null, 0, null);
            } else if ("SAME".equals(string3)) {
                this.getCodeVisitor().visitFrame(3, 0, null, 0, null);
            } else if ("SAME1".equals(string3)) {
                this.getCodeVisitor().visitFrame(4, 0, null, n3, objectArray2);
            }
        }
    }

    final class LookupSwitchLabelRule
    extends Rule {
        LookupSwitchLabelRule() {
        }

        public final void begin(String string, Attributes attributes) {
            HashMap hashMap = (HashMap)ASMContentHandler.this.peek();
            ((ArrayList)hashMap.get("labels")).add(this.getLabel(attributes.getValue("name")));
            ((ArrayList)hashMap.get("keys")).add(attributes.getValue("key"));
        }
    }

    final class LookupSwitchRule
    extends Rule {
        LookupSwitchRule() {
        }

        public final void begin(String string, Attributes attributes) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("dflt", attributes.getValue("dflt"));
            hashMap.put("labels", new ArrayList());
            hashMap.put("keys", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }

        public final void end(String string) {
            HashMap hashMap = (HashMap)ASMContentHandler.this.pop();
            Label label = this.getLabel(hashMap.get("dflt"));
            ArrayList arrayList = (ArrayList)hashMap.get("keys");
            ArrayList arrayList2 = (ArrayList)hashMap.get("labels");
            Label[] labelArray = arrayList2.toArray(new Label[arrayList2.size()]);
            int[] nArray = new int[arrayList.size()];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = Integer.parseInt((String)arrayList.get(i2));
            }
            this.getCodeVisitor().visitLookupSwitchInsn(label, nArray, labelArray);
        }
    }

    final class TableSwitchLabelRule
    extends Rule {
        TableSwitchLabelRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ((ArrayList)((HashMap)ASMContentHandler.this.peek()).get("labels")).add(this.getLabel(attributes.getValue("name")));
        }
    }

    final class TableSwitchRule
    extends Rule {
        TableSwitchRule() {
        }

        public final void begin(String string, Attributes attributes) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("min", attributes.getValue("min"));
            hashMap.put("max", attributes.getValue("max"));
            hashMap.put("dflt", attributes.getValue("dflt"));
            hashMap.put("labels", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }

        public final void end(String string) {
            HashMap hashMap = (HashMap)ASMContentHandler.this.pop();
            int n2 = Integer.parseInt((String)hashMap.get("min"));
            int n3 = Integer.parseInt((String)hashMap.get("max"));
            Label label = this.getLabel(hashMap.get("dflt"));
            ArrayList arrayList = (ArrayList)hashMap.get("labels");
            Label[] labelArray = arrayList.toArray(new Label[arrayList.size()]);
            this.getCodeVisitor().visitTableSwitchInsn(n2, n3, label, labelArray);
        }
    }

    final class MethodParameterRule
    extends Rule {
        MethodParameterRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("name");
            int n2 = this.getAccess(attributes.getValue("access"));
            this.getCodeVisitor().visitParameter(string2, n2);
        }
    }

    final class ExceptionsRule
    extends Rule {
        ExceptionsRule() {
        }

        public final void end(String string) {
            HashMap hashMap = (HashMap)ASMContentHandler.this.pop();
            int n2 = this.getAccess((String)hashMap.get("access"));
            String string2 = (String)hashMap.get("name");
            String string3 = (String)hashMap.get("desc");
            String string4 = (String)hashMap.get("signature");
            ArrayList arrayList = (ArrayList)hashMap.get("exceptions");
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            ASMContentHandler.this.push(ASMContentHandler.this.cv.visitMethod(n2, string2, string3, string4, stringArray));
        }
    }

    final class ExceptionRule
    extends Rule {
        ExceptionRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ((ArrayList)((HashMap)ASMContentHandler.this.peek()).get("exceptions")).add(attributes.getValue("name"));
        }
    }

    final class MethodRule
    extends Rule {
        MethodRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ASMContentHandler.this.labels = new HashMap<Object, Label>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("access", attributes.getValue("access"));
            hashMap.put("name", attributes.getValue("name"));
            hashMap.put("desc", attributes.getValue("desc"));
            hashMap.put("signature", attributes.getValue("signature"));
            hashMap.put("exceptions", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }

        public final void end(String string) {
            ((MethodVisitor)ASMContentHandler.this.pop()).visitEnd();
            ASMContentHandler.this.labels = null;
        }
    }

    final class FieldRule
    extends Rule {
        FieldRule() {
        }

        public final void begin(String string, Attributes attributes) throws SAXException {
            int n2 = this.getAccess(attributes.getValue("access"));
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("signature");
            String string4 = attributes.getValue("desc");
            Object object = this.getValue(string4, attributes.getValue("value"));
            ASMContentHandler.this.push(ASMContentHandler.this.cv.visitField(n2, string2, string4, string3, object));
        }

        public void end(String string) {
            ((FieldVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    final class InnerClassRule
    extends Rule {
        InnerClassRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n2 = this.getAccess(attributes.getValue("access"));
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("outerName");
            String string4 = attributes.getValue("innerName");
            ASMContentHandler.this.cv.visitInnerClass(string2, string3, string4, n2);
        }
    }

    final class OuterClassRule
    extends Rule {
        OuterClassRule() {
        }

        public final void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("owner");
            String string3 = attributes.getValue("name");
            String string4 = attributes.getValue("desc");
            ASMContentHandler.this.cv.visitOuterClass(string2, string3, string4);
        }
    }

    final class InterfacesRule
    extends Rule {
        InterfacesRule() {
        }

        public final void end(String string) {
            HashMap hashMap = (HashMap)ASMContentHandler.this.pop();
            int n2 = (Integer)hashMap.get("version");
            int n3 = this.getAccess((String)hashMap.get("access"));
            String string2 = (String)hashMap.get("name");
            String string3 = (String)hashMap.get("signature");
            String string4 = (String)hashMap.get("parent");
            ArrayList arrayList = (ArrayList)hashMap.get("interfaces");
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            ASMContentHandler.this.cv.visit(n2, n3, string2, string3, string4, stringArray);
            ASMContentHandler.this.push(ASMContentHandler.this.cv);
        }
    }

    final class InterfaceRule
    extends Rule {
        InterfaceRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ((ArrayList)((HashMap)ASMContentHandler.this.peek()).get("interfaces")).add(attributes.getValue("name"));
        }
    }

    final class SourceRule
    extends Rule {
        SourceRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("file");
            String string3 = attributes.getValue("debug");
            ASMContentHandler.this.cv.visitSource(string2, string3);
        }
    }

    final class ClassRule
    extends Rule {
        ClassRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n2 = Integer.parseInt(attributes.getValue("major"));
            int n3 = Integer.parseInt(attributes.getValue("minor"));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("version", new Integer(n3 << 16 | n2));
            hashMap.put("access", attributes.getValue("access"));
            hashMap.put("name", attributes.getValue("name"));
            hashMap.put("parent", attributes.getValue("parent"));
            hashMap.put("source", attributes.getValue("source"));
            hashMap.put("signature", attributes.getValue("signature"));
            hashMap.put("interfaces", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }
    }

    protected abstract class Rule {
        protected Rule() {
        }

        public void begin(String string, Attributes attributes) throws SAXException {
        }

        public void end(String string) {
        }

        protected final Object getValue(String string, String string2) throws SAXException {
            Object object = null;
            if (string2 != null) {
                if ("Ljava/lang/String;".equals(string)) {
                    object = this.decode(string2);
                } else if ("Ljava/lang/Integer;".equals(string) || "I".equals(string) || "S".equals(string) || "B".equals(string) || "C".equals(string) || "Z".equals(string)) {
                    object = new Integer(string2);
                } else if ("Ljava/lang/Short;".equals(string)) {
                    object = new Short(string2);
                } else if ("Ljava/lang/Byte;".equals(string)) {
                    object = new Byte(string2);
                } else if ("Ljava/lang/Character;".equals(string)) {
                    object = new Character(this.decode(string2).charAt(0));
                } else if ("Ljava/lang/Boolean;".equals(string)) {
                    object = Boolean.valueOf(string2);
                } else if ("Ljava/lang/Long;".equals(string) || "J".equals(string)) {
                    object = new Long(string2);
                } else if ("Ljava/lang/Float;".equals(string) || "F".equals(string)) {
                    object = new Float(string2);
                } else if ("Ljava/lang/Double;".equals(string) || "D".equals(string)) {
                    object = new Double(string2);
                } else if (Type.getDescriptor(Type.class).equals(string)) {
                    object = Type.getType(string2);
                } else if (Type.getDescriptor(Handle.class).equals(string)) {
                    object = this.decodeHandle(string2);
                } else {
                    throw new SAXException("Invalid value:" + string2 + " desc:" + string + " ctx:" + this);
                }
            }
            return object;
        }

        Handle decodeHandle(String string) throws SAXException {
            try {
                int n2 = string.indexOf(46);
                int n3 = string.indexOf(40, n2 + 1);
                int n4 = string.lastIndexOf(40);
                int n5 = Integer.parseInt(string.substring(n4 + 1, string.length() - 1));
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1, n3);
                String string4 = string.substring(n3, n4 - 1);
                return new Handle(n5, string2, string3, string4);
            }
            catch (RuntimeException runtimeException) {
                throw new SAXException("Malformed handle " + string, runtimeException);
            }
        }

        private final String decode(String string) throws SAXException {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            try {
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c2 = string.charAt(i2);
                    if (c2 == '\\') {
                        if ((c2 = string.charAt(++i2)) == '\\') {
                            stringBuffer.append('\\');
                            continue;
                        }
                        stringBuffer.append((char)Integer.parseInt(string.substring(++i2, i2 + 4), 16));
                        i2 += 3;
                        continue;
                    }
                    stringBuffer.append(c2);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new SAXException(runtimeException);
            }
            return stringBuffer.toString();
        }

        protected final Label getLabel(Object object) {
            Label label = ASMContentHandler.this.labels.get(object);
            if (label == null) {
                label = new Label();
                ASMContentHandler.this.labels.put(object, label);
            }
            return label;
        }

        protected final MethodVisitor getCodeVisitor() {
            return (MethodVisitor)ASMContentHandler.this.peek();
        }

        protected final int getAccess(String string) {
            int n2 = 0;
            if (string.indexOf("public") != -1) {
                n2 |= 1;
            }
            if (string.indexOf("private") != -1) {
                n2 |= 2;
            }
            if (string.indexOf("protected") != -1) {
                n2 |= 4;
            }
            if (string.indexOf("static") != -1) {
                n2 |= 8;
            }
            if (string.indexOf("final") != -1) {
                n2 |= 0x10;
            }
            if (string.indexOf("super") != -1) {
                n2 |= 0x20;
            }
            if (string.indexOf("synchronized") != -1) {
                n2 |= 0x20;
            }
            if (string.indexOf("volatile") != -1) {
                n2 |= 0x40;
            }
            if (string.indexOf("bridge") != -1) {
                n2 |= 0x40;
            }
            if (string.indexOf("varargs") != -1) {
                n2 |= 0x80;
            }
            if (string.indexOf("transient") != -1) {
                n2 |= 0x80;
            }
            if (string.indexOf("native") != -1) {
                n2 |= 0x100;
            }
            if (string.indexOf("interface") != -1) {
                n2 |= 0x200;
            }
            if (string.indexOf("abstract") != -1) {
                n2 |= 0x400;
            }
            if (string.indexOf("strict") != -1) {
                n2 |= 0x800;
            }
            if (string.indexOf("synthetic") != -1) {
                n2 |= 0x1000;
            }
            if (string.indexOf("annotation") != -1) {
                n2 |= 0x2000;
            }
            if (string.indexOf("enum") != -1) {
                n2 |= 0x4000;
            }
            if (string.indexOf("deprecated") != -1) {
                n2 |= 0x20000;
            }
            if (string.indexOf("mandated") != -1) {
                n2 |= 0x8000;
            }
            return n2;
        }
    }

    static final class RuleSet {
        private final HashMap<String, Object> rules = new HashMap();
        private final ArrayList<String> lpatterns = new ArrayList();
        private final ArrayList<String> rpatterns = new ArrayList();

        RuleSet() {
        }

        public void add(String string, Object object) {
            String string2 = string;
            if (string.startsWith("*/")) {
                string2 = string.substring(1);
                this.lpatterns.add(string2);
            } else if (string.endsWith("/*")) {
                string2 = string.substring(0, string.length() - 1);
                this.rpatterns.add(string2);
            }
            this.rules.put(string2, object);
        }

        public Object match(String string) {
            if (this.rules.containsKey(string)) {
                return this.rules.get(string);
            }
            int n2 = string.lastIndexOf(47);
            for (String string2 : this.lpatterns) {
                if (!string.substring(n2).endsWith(string2)) continue;
                return this.rules.get(string2);
            }
            for (String string2 : this.rpatterns) {
                if (!string.startsWith(string2)) continue;
                return this.rules.get(string2);
            }
            return null;
        }
    }

    private static interface OpcodeGroup {
        public static final int INSN = 0;
        public static final int INSN_INT = 1;
        public static final int INSN_VAR = 2;
        public static final int INSN_TYPE = 3;
        public static final int INSN_FIELD = 4;
        public static final int INSN_METHOD = 5;
        public static final int INSN_JUMP = 6;
        public static final int INSN_LDC = 7;
        public static final int INSN_IINC = 8;
        public static final int INSN_MULTIANEWARRAY = 9;
    }
}

