/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.asm.xml;

import com.contrastsecurity.thirdparty.org.mvel2.asm.ClassReader;
import com.contrastsecurity.thirdparty.org.mvel2.asm.ClassWriter;
import com.contrastsecurity.thirdparty.org.mvel2.asm.xml.ASMContentHandler;
import com.contrastsecurity.thirdparty.org.mvel2.asm.xml.SAXClassAdapter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Processor {
    public static final int BYTECODE = 1;
    public static final int MULTI_XML = 2;
    public static final int SINGLE_XML = 3;
    private static final String SINGLE_XML_NAME = "classes.xml";
    private final int inRepresentation;
    private final int outRepresentation;
    private final InputStream input;
    private final OutputStream output;
    private final Source xslt;
    private int n = 0;

    public Processor(int n2, int n3, InputStream inputStream, OutputStream outputStream, Source source) {
        this.inRepresentation = n2;
        this.outRepresentation = n3;
        this.input = inputStream;
        this.output = outputStream;
        this.xslt = source;
    }

    public int process() throws TransformerException, IOException, SAXException {
        ZipEntry zipEntry;
        Object object;
        ZipInputStream zipInputStream = new ZipInputStream(this.input);
        ZipOutputStream zipOutputStream = new ZipOutputStream(this.output);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(zipOutputStream);
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") || !transformerFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            return 0;
        }
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
        Templates templates = null;
        if (this.xslt != null) {
            templates = sAXTransformerFactory.newTemplates(this.xslt);
        }
        EntryElement entryElement = this.getEntryElement(zipOutputStream);
        Object object2 = null;
        switch (this.outRepresentation) {
            case 1: {
                object2 = new OutputSlicingHandler(new ASMContentHandlerFactory(zipOutputStream), entryElement, false);
                break;
            }
            case 2: {
                object2 = new OutputSlicingHandler(new SAXWriterFactory(outputStreamWriter, true), entryElement, true);
                break;
            }
            case 3: {
                object = new ZipEntry(SINGLE_XML_NAME);
                zipOutputStream.putNextEntry((ZipEntry)object);
                object2 = new SAXWriter(outputStreamWriter, false);
            }
        }
        object = templates == null ? object2 : new InputSlicingHandler("class", (ContentHandler)object2, new TransformerHandlerFactory(sAXTransformerFactory, templates, (ContentHandler)object2));
        SubdocumentHandlerFactory subdocumentHandlerFactory = new SubdocumentHandlerFactory((ContentHandler)object);
        if (object != null && this.inRepresentation != 3) {
            object.startDocument();
            object.startElement("", "classes", "classes", new AttributesImpl());
        }
        int n2 = 0;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            this.update(zipEntry.getName(), this.n++);
            if (this.isClassEntry(zipEntry)) {
                this.processEntry(zipInputStream, zipEntry, subdocumentHandlerFactory);
            } else {
                OutputStream outputStream = entryElement.openEntry(this.getName(zipEntry));
                this.copyEntry(zipInputStream, outputStream);
                entryElement.closeEntry();
            }
            ++n2;
        }
        if (object != null && this.inRepresentation != 3) {
            object.endElement("", "classes", "classes");
            object.endDocument();
        }
        if (this.outRepresentation == 3) {
            zipOutputStream.closeEntry();
        }
        zipOutputStream.flush();
        zipOutputStream.close();
        return n2;
    }

    private void copyEntry(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        if (this.outRepresentation == 3) {
            return;
        }
        byte[] byArray = new byte[2048];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    private boolean isClassEntry(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        return this.inRepresentation == 3 && string.equals(SINGLE_XML_NAME) || string.endsWith(".class") || string.endsWith(".class.xml");
    }

    private void processEntry(ZipInputStream zipInputStream, ZipEntry zipEntry, ContentHandlerFactory contentHandlerFactory) {
        ContentHandler contentHandler = contentHandlerFactory.createContentHandler();
        try {
            boolean bl2;
            boolean bl3 = bl2 = this.inRepresentation == 3;
            if (this.inRepresentation == 1) {
                ClassReader classReader = new ClassReader(Processor.readEntry(zipInputStream, zipEntry));
                classReader.accept(new SAXClassAdapter(contentHandler, bl2), 0);
            } else {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setContentHandler(contentHandler);
                xMLReader.parse(new InputSource(bl2 ? new ProtectedInputStream(zipInputStream) : new ByteArrayInputStream(Processor.readEntry(zipInputStream, zipEntry))));
            }
        }
        catch (Exception exception) {
            this.update(zipEntry.getName(), 0);
            this.update(exception, 0);
        }
    }

    private EntryElement getEntryElement(ZipOutputStream zipOutputStream) {
        if (this.outRepresentation == 3) {
            return new SingleDocElement(zipOutputStream);
        }
        return new ZipEntryElement(zipOutputStream);
    }

    private String getName(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        if (this.isClassEntry(zipEntry)) {
            if (this.inRepresentation != 1 && this.outRepresentation == 1) {
                string = string.substring(0, string.length() - 4);
            } else if (this.inRepresentation == 1 && this.outRepresentation != 1) {
                string = string + ".xml";
            }
        }
        return string;
    }

    private static byte[] readEntry(InputStream inputStream, ZipEntry zipEntry) throws IOException {
        int n2;
        long l2 = zipEntry.getSize();
        if (l2 > -1L) {
            int n3;
            byte[] byArray = new byte[(int)l2];
            int n4 = 0;
            while ((n3 = inputStream.read(byArray, n4, byArray.length - n4)) > 0) {
                n4 += n3;
            }
            return byArray;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void update(Object object, int n2) {
        if (object instanceof Throwable) {
            ((Throwable)object).printStackTrace();
        } else if (n2 % 100 == 0) {
            System.err.println(n2 + " " + object);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            Processor.showUsage();
            return;
        }
        int n2 = Processor.getRepresentation(stringArray[0]);
        int n3 = Processor.getRepresentation(stringArray[1]);
        InputStream inputStream = System.in;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(System.out);
        StreamSource streamSource = null;
        for (int i2 = 2; i2 < stringArray.length; ++i2) {
            if ("-in".equals(stringArray[i2])) {
                inputStream = new FileInputStream(stringArray[++i2]);
                continue;
            }
            if ("-out".equals(stringArray[i2])) {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(stringArray[++i2]));
                continue;
            }
            if ("-xslt".equals(stringArray[i2])) {
                streamSource = new StreamSource(new FileInputStream(stringArray[++i2]));
                continue;
            }
            Processor.showUsage();
            return;
        }
        if (n2 == 0 || n3 == 0) {
            Processor.showUsage();
            return;
        }
        Processor processor = new Processor(n2, n3, inputStream, bufferedOutputStream, streamSource);
        long l2 = System.currentTimeMillis();
        int n4 = processor.process();
        long l3 = System.currentTimeMillis();
        System.err.println(n4);
        System.err.println(l3 - l2 + "ms  " + 1000.0f * (float)n4 / (float)(l3 - l2) + " resources/sec");
    }

    private static int getRepresentation(String string) {
        if ("code".equals(string)) {
            return 1;
        }
        if ("xml".equals(string)) {
            return 2;
        }
        if ("singlexml".equals(string)) {
            return 3;
        }
        return 0;
    }

    private static void showUsage() {
        System.err.println("Usage: Main <in format> <out format> [-in <input jar>] [-out <output jar>] [-xslt <xslt fiel>]");
        System.err.println("  when -in or -out is omitted sysin and sysout would be used");
        System.err.println("  <in format> and <out format> - code | xml | singlexml");
    }

    private static final class ZipEntryElement
    implements EntryElement {
        private ZipOutputStream zos;

        ZipEntryElement(ZipOutputStream zipOutputStream) {
            this.zos = zipOutputStream;
        }

        public OutputStream openEntry(String string) throws IOException {
            ZipEntry zipEntry = new ZipEntry(string);
            this.zos.putNextEntry(zipEntry);
            return this.zos;
        }

        public void closeEntry() throws IOException {
            this.zos.flush();
            this.zos.closeEntry();
        }
    }

    private static final class SingleDocElement
    implements EntryElement {
        private final OutputStream os;

        SingleDocElement(OutputStream outputStream) {
            this.os = outputStream;
        }

        public OutputStream openEntry(String string) throws IOException {
            return this.os;
        }

        public void closeEntry() throws IOException {
            this.os.flush();
        }
    }

    private static interface EntryElement {
        public OutputStream openEntry(String var1) throws IOException;

        public void closeEntry() throws IOException;
    }

    private static final class OutputSlicingHandler
    extends DefaultHandler {
        private final String subdocumentRoot;
        private ContentHandlerFactory subdocumentHandlerFactory;
        private final EntryElement entryElement;
        private boolean isXml;
        private boolean subdocument = false;
        private ContentHandler subdocumentHandler;

        OutputSlicingHandler(ContentHandlerFactory contentHandlerFactory, EntryElement entryElement, boolean bl2) {
            this.subdocumentRoot = "class";
            this.subdocumentHandlerFactory = contentHandlerFactory;
            this.entryElement = entryElement;
            this.isXml = bl2;
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.startElement(string, string2, string3, attributes);
            } else if (string2.equals(this.subdocumentRoot)) {
                String string4 = attributes.getValue("name");
                if (string4 == null || string4.length() == 0) {
                    throw new SAXException("Class element without name attribute.");
                }
                try {
                    this.entryElement.openEntry(this.isXml ? string4 + ".class.xml" : string4 + ".class");
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException.toString(), iOException);
                }
                this.subdocumentHandler = this.subdocumentHandlerFactory.createContentHandler();
                this.subdocumentHandler.startDocument();
                this.subdocumentHandler.startElement(string, string2, string3, attributes);
                this.subdocument = true;
            }
        }

        public final void endElement(String string, String string2, String string3) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.endElement(string, string2, string3);
                if (string2.equals(this.subdocumentRoot)) {
                    this.subdocumentHandler.endDocument();
                    this.subdocument = false;
                    try {
                        this.entryElement.closeEntry();
                    }
                    catch (IOException iOException) {
                        throw new SAXException(iOException.toString(), iOException);
                    }
                }
            }
        }

        public final void startDocument() throws SAXException {
        }

        public final void endDocument() throws SAXException {
        }

        public final void characters(char[] cArray, int n2, int n3) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.characters(cArray, n2, n3);
            }
        }
    }

    private static final class InputSlicingHandler
    extends DefaultHandler {
        private String subdocumentRoot;
        private final ContentHandler rootHandler;
        private ContentHandlerFactory subdocumentHandlerFactory;
        private boolean subdocument = false;
        private ContentHandler subdocumentHandler;

        InputSlicingHandler(String string, ContentHandler contentHandler, ContentHandlerFactory contentHandlerFactory) {
            this.subdocumentRoot = string;
            this.rootHandler = contentHandler;
            this.subdocumentHandlerFactory = contentHandlerFactory;
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.startElement(string, string2, string3, attributes);
            } else if (string2.equals(this.subdocumentRoot)) {
                this.subdocumentHandler = this.subdocumentHandlerFactory.createContentHandler();
                this.subdocumentHandler.startDocument();
                this.subdocumentHandler.startElement(string, string2, string3, attributes);
                this.subdocument = true;
            } else if (this.rootHandler != null) {
                this.rootHandler.startElement(string, string2, string3, attributes);
            }
        }

        public final void endElement(String string, String string2, String string3) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.endElement(string, string2, string3);
                if (string2.equals(this.subdocumentRoot)) {
                    this.subdocumentHandler.endDocument();
                    this.subdocument = false;
                }
            } else if (this.rootHandler != null) {
                this.rootHandler.endElement(string, string2, string3);
            }
        }

        public final void startDocument() throws SAXException {
            if (this.rootHandler != null) {
                this.rootHandler.startDocument();
            }
        }

        public final void endDocument() throws SAXException {
            if (this.rootHandler != null) {
                this.rootHandler.endDocument();
            }
        }

        public final void characters(char[] cArray, int n2, int n3) throws SAXException {
            if (this.subdocument) {
                this.subdocumentHandler.characters(cArray, n2, n3);
            } else if (this.rootHandler != null) {
                this.rootHandler.characters(cArray, n2, n3);
            }
        }
    }

    private static final class SAXWriter
    extends DefaultHandler
    implements LexicalHandler {
        private static final char[] OFF = "                                                                                                        ".toCharArray();
        private Writer w;
        private final boolean optimizeEmptyElements;
        private boolean openElement = false;
        private int ident = 0;

        SAXWriter(Writer writer, boolean bl2) {
            this.w = writer;
            this.optimizeEmptyElements = bl2;
        }

        public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                this.closeElement();
                this.writeIdent();
                this.w.write('<' + string3);
                if (attributes != null && attributes.getLength() > 0) {
                    this.writeAttributes(attributes);
                }
                if (this.optimizeEmptyElements) {
                    this.openElement = true;
                } else {
                    this.w.write(">\n");
                }
                this.ident += 2;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void endElement(String string, String string2, String string3) throws SAXException {
            this.ident -= 2;
            try {
                if (this.openElement) {
                    this.w.write("/>\n");
                    this.openElement = false;
                } else {
                    this.writeIdent();
                    this.w.write("</" + string3 + ">\n");
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void endDocument() throws SAXException {
            try {
                this.w.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void comment(char[] cArray, int n2, int n3) throws SAXException {
            try {
                this.closeElement();
                this.writeIdent();
                this.w.write("<!-- ");
                this.w.write(cArray, n2, n3);
                this.w.write(" -->\n");
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public final void startDTD(String string, String string2, String string3) throws SAXException {
        }

        public final void endDTD() throws SAXException {
        }

        public final void startEntity(String string) throws SAXException {
        }

        public final void endEntity(String string) throws SAXException {
        }

        public final void startCDATA() throws SAXException {
        }

        public final void endCDATA() throws SAXException {
        }

        private final void writeAttributes(Attributes attributes) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = attributes.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append(' ').append(attributes.getLocalName(i2)).append("=\"").append(SAXWriter.esc(attributes.getValue(i2))).append('\"');
            }
            this.w.write(stringBuffer.toString());
        }

        private static final String esc(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            block6: for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                switch (c2) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block6;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        continue block6;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block6;
                    }
                    default: {
                        if (c2 > '\u007f') {
                            stringBuffer.append("&#").append(Integer.toString(c2)).append(';');
                            continue block6;
                        }
                        stringBuffer.append(c2);
                    }
                }
            }
            return stringBuffer.toString();
        }

        private final void writeIdent() throws IOException {
            int n2 = this.ident;
            while (n2 > 0) {
                if (n2 > OFF.length) {
                    this.w.write(OFF);
                    n2 -= OFF.length;
                    continue;
                }
                this.w.write(OFF, 0, n2);
                n2 = 0;
            }
        }

        private final void closeElement() throws IOException {
            if (this.openElement) {
                this.w.write(">\n");
            }
            this.openElement = false;
        }
    }

    private static final class SubdocumentHandlerFactory
    implements ContentHandlerFactory {
        private final ContentHandler subdocumentHandler;

        SubdocumentHandlerFactory(ContentHandler contentHandler) {
            this.subdocumentHandler = contentHandler;
        }

        public final ContentHandler createContentHandler() {
            return this.subdocumentHandler;
        }
    }

    private static final class TransformerHandlerFactory
    implements ContentHandlerFactory {
        private SAXTransformerFactory saxtf;
        private final Templates templates;
        private ContentHandler outputHandler;

        TransformerHandlerFactory(SAXTransformerFactory sAXTransformerFactory, Templates templates, ContentHandler contentHandler) {
            this.saxtf = sAXTransformerFactory;
            this.templates = templates;
            this.outputHandler = contentHandler;
        }

        public final ContentHandler createContentHandler() {
            try {
                TransformerHandler transformerHandler = this.saxtf.newTransformerHandler(this.templates);
                transformerHandler.setResult(new SAXResult(this.outputHandler));
                return transformerHandler;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new RuntimeException(transformerConfigurationException.toString());
            }
        }
    }

    private static final class ASMContentHandlerFactory
    implements ContentHandlerFactory {
        final OutputStream os;

        ASMContentHandlerFactory(OutputStream outputStream) {
            this.os = outputStream;
        }

        public final ContentHandler createContentHandler() {
            final ClassWriter classWriter = new ClassWriter(1);
            return new ASMContentHandler(classWriter){

                public void endDocument() throws SAXException {
                    try {
                        ASMContentHandlerFactory.this.os.write(classWriter.toByteArray());
                    }
                    catch (IOException iOException) {
                        throw new SAXException(iOException);
                    }
                }
            };
        }
    }

    private static final class SAXWriterFactory
    implements ContentHandlerFactory {
        private final Writer w;
        private final boolean optimizeEmptyElements;

        SAXWriterFactory(Writer writer, boolean bl2) {
            this.w = writer;
            this.optimizeEmptyElements = bl2;
        }

        public final ContentHandler createContentHandler() {
            return new SAXWriter(this.w, this.optimizeEmptyElements);
        }
    }

    private static interface ContentHandlerFactory {
        public ContentHandler createContentHandler();
    }

    private static final class ProtectedInputStream
    extends InputStream {
        private final InputStream is;

        ProtectedInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        public final void close() throws IOException {
        }

        public final int read() throws IOException {
            return this.is.read();
        }

        public final int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.is.read(byArray, n2, n3);
        }

        public final int available() throws IOException {
            return this.is.available();
        }
    }
}

