/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.compiler;

import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.DataConversion;
import com.contrastsecurity.thirdparty.org.mvel2.ErrorDetail;
import com.contrastsecurity.thirdparty.org.mvel2.MVEL;
import com.contrastsecurity.thirdparty.org.mvel2.Operator;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ASTNode;
import com.contrastsecurity.thirdparty.org.mvel2.ast.Assignment;
import com.contrastsecurity.thirdparty.org.mvel2.ast.LiteralNode;
import com.contrastsecurity.thirdparty.org.mvel2.ast.NewObjectNode;
import com.contrastsecurity.thirdparty.org.mvel2.ast.OperatorNode;
import com.contrastsecurity.thirdparty.org.mvel2.ast.Substatement;
import com.contrastsecurity.thirdparty.org.mvel2.ast.Union;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.AbstractParser;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.CompiledExpression;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableLiteral;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.PropertyVerifier;
import com.contrastsecurity.thirdparty.org.mvel2.util.ASTLinkedList;
import com.contrastsecurity.thirdparty.org.mvel2.util.CompilerTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.ErrorUtil;
import com.contrastsecurity.thirdparty.org.mvel2.util.ExecutionStack;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.StringAppender;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExpressionCompiler
extends AbstractParser {
    private Class returnType;
    private boolean verifyOnly = false;
    private boolean verifying = true;
    private boolean secondPassOptimization = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledExpression compile() {
        CompiledExpression compiledExpression;
        block7: {
            Iterator<ErrorDetail> iterator;
            StringAppender stringAppender;
            try {
                this.debugSymbols = this.pCtx.isDebugSymbols();
                compiledExpression = this._compile();
                Object var3_2 = null;
                if (!this.pCtx.isFatalError()) break block7;
                stringAppender = new StringAppender();
                iterator = this.pCtx.getErrorList().iterator();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.pCtx.isFatalError()) {
                    StringAppender stringAppender2 = new StringAppender();
                    Iterator<ErrorDetail> iterator2 = this.pCtx.getErrorList().iterator();
                    while (iterator2.hasNext()) {
                        ErrorDetail errorDetail = iterator2.next();
                        if ((errorDetail = ErrorUtil.rewriteIfNeeded(errorDetail, this.expr, this.cursor)).getExpr() != this.expr) {
                            iterator2.remove();
                            continue;
                        }
                        stringAppender2.append("\n - ").append("(").append(errorDetail.getLineNumber()).append(",").append(errorDetail.getColumn()).append(")").append(" ").append(errorDetail.getMessage());
                    }
                    throw new CompileException("Failed to compileShared: " + this.pCtx.getErrorList().size() + " compilation error(s): " + stringAppender2.toString(), this.pCtx.getErrorList(), this.expr, this.cursor, this.pCtx);
                }
                throw throwable;
            }
            while (iterator.hasNext()) {
                ErrorDetail errorDetail = iterator.next();
                if ((errorDetail = ErrorUtil.rewriteIfNeeded(errorDetail, this.expr, this.cursor)).getExpr() != this.expr) {
                    iterator.remove();
                    continue;
                }
                stringAppender.append("\n - ").append("(").append(errorDetail.getLineNumber()).append(",").append(errorDetail.getColumn()).append(")").append(" ").append(errorDetail.getMessage());
            }
            throw new CompileException("Failed to compileShared: " + this.pCtx.getErrorList().size() + " compilation error(s): " + stringAppender.toString(), this.pCtx.getErrorList(), this.expr, this.cursor, this.pCtx);
        }
        return compiledExpression;
    }

    public CompiledExpression _compile() {
        int n2 = -1;
        this.cursor = this.start;
        ASTLinkedList aSTLinkedList = new ASTLinkedList();
        this.stk = new ExecutionStack();
        this.dStack = new ExecutionStack();
        this.compileMode = true;
        try {
            ASTNode aSTNode;
            if (this.verifying) {
                this.pCtx.initializeTables();
            }
            this.fields |= 0x10;
            while ((aSTNode = this.nextToken()) != null) {
                if (aSTNode.fields == -1) {
                    aSTLinkedList.addTokenNode(aSTNode);
                    continue;
                }
                this.returnType = aSTNode.getEgressType();
                if (aSTNode instanceof Substatement) {
                    String string = new String(this.expr, aSTNode.getStart(), aSTNode.getOffset());
                    Map<String, CompiledExpression> map = this.pCtx.getCompiledExpressionCache();
                    Map<String, Class> map2 = this.pCtx.getReturnTypeCache();
                    CompiledExpression compiledExpression = map.get(string);
                    Class clazz = map2.get(string);
                    if (compiledExpression == null) {
                        ExpressionCompiler expressionCompiler = new ExpressionCompiler(this.expr, aSTNode.getStart(), aSTNode.getOffset(), this.pCtx);
                        compiledExpression = expressionCompiler._compile();
                        clazz = expressionCompiler.getReturnType();
                        map.put(string, compiledExpression);
                        map2.put(string, clazz);
                    }
                    aSTNode.setAccessor(compiledExpression);
                    this.returnType = clazz;
                }
                if (!this.verifyOnly && aSTNode.isLiteral()) {
                    ASTNode aSTNode2;
                    if (this.literalOnly == -1) {
                        this.literalOnly = 1;
                    }
                    if ((aSTNode2 = this.nextTokenSkipSymbols()) != null && aSTNode2.isOperator() && !aSTNode2.isOperator(29) && !aSTNode2.isOperator(30)) {
                        ASTNode aSTNode3 = this.nextTokenSkipSymbols();
                        if (aSTNode3 != null && aSTNode3.isLiteral() && aSTNode2.getOperator() < 34 && (n2 == -1 || n2 < Operator.PTABLE.length && Operator.PTABLE[n2] < Operator.PTABLE[aSTNode2.getOperator()])) {
                            ASTNode aSTNode4;
                            int n3 = aSTNode2.getOperator();
                            this.stk.push(aSTNode.getLiteralValue(), aSTNode3.getLiteralValue(), n3);
                            if (ExpressionCompiler.isArithmeticOperator(n3)) {
                                if (!this.compileReduce(n3, aSTLinkedList)) {
                                    continue;
                                }
                            } else {
                                this.reduce();
                            }
                            boolean bl2 = true;
                            while ((aSTNode4 = this.nextTokenSkipSymbols()) != null) {
                                if (ExpressionCompiler.isBooleanOperator(aSTNode4.getOperator())) {
                                    aSTLinkedList.addTokenNode(new LiteralNode(this.stk.pop(), this.pCtx), this.verify(this.pCtx, aSTNode4));
                                    break;
                                }
                                ASTNode aSTNode5 = this.nextTokenSkipSymbols();
                                if (aSTNode5 != null) {
                                    if (aSTNode5.isLiteral()) {
                                        n3 = aSTNode4.getOperator();
                                        this.stk.push(aSTNode5.getLiteralValue(), n3);
                                        if (ExpressionCompiler.isArithmeticOperator(n3)) {
                                            this.compileReduce(n3, aSTLinkedList);
                                        } else {
                                            this.reduce();
                                        }
                                    } else {
                                        if (!this.stk.isEmpty()) {
                                            aSTLinkedList.addTokenNode(new LiteralNode(this.getStackValueResult(), this.pCtx));
                                        }
                                        aSTLinkedList.addTokenNode(new OperatorNode(aSTNode4.getOperator(), this.expr, this.st, this.pCtx), this.verify(this.pCtx, aSTNode5));
                                        break;
                                    }
                                    bl2 = false;
                                    this.literalOnly = 0;
                                    continue;
                                }
                                if (bl2) {
                                    aSTLinkedList.addTokenNode(new LiteralNode(this.getStackValueResult(), this.pCtx));
                                    break;
                                }
                                aSTLinkedList.addTokenNode(new LiteralNode(this.getStackValueResult(), this.pCtx), aSTNode4);
                                if (aSTNode5 == null) break;
                                aSTLinkedList.addTokenNode(this.verify(this.pCtx, aSTNode5));
                                break;
                            }
                            if (this.stk.isEmpty()) continue;
                            aSTLinkedList.addTokenNode(new LiteralNode(this.getStackValueResult(), this.pCtx));
                            continue;
                        }
                        aSTLinkedList.addTokenNode(this.verify(this.pCtx, aSTNode), this.verify(this.pCtx, aSTNode2));
                        if (aSTNode3 == null) continue;
                        aSTLinkedList.addTokenNode(this.verify(this.pCtx, aSTNode3));
                        continue;
                    }
                    if (aSTNode2 != null && !aSTNode2.isOperator() && !(aSTNode.getLiteralValue() instanceof Class)) {
                        throw new CompileException("unexpected token: " + aSTNode2.getName(), this.expr, aSTNode2.getStart());
                    }
                    this.literalOnly = 0;
                    aSTLinkedList.addTokenNode(this.verify(this.pCtx, aSTNode));
                    if (aSTNode2 == null) continue;
                    aSTLinkedList.addTokenNode(this.verify(this.pCtx, aSTNode2));
                    continue;
                }
                if (aSTNode.isOperator()) {
                    n2 = aSTNode.getOperator();
                } else {
                    this.literalOnly = 0;
                }
                aSTLinkedList.addTokenNode(this.verify(this.pCtx, aSTNode));
            }
            aSTLinkedList.finish();
            if (this.verifying && !this.verifyOnly) {
                this.pCtx.processTables();
            }
            if (!this.stk.isEmpty()) {
                throw new CompileException("COMPILE ERROR: non-empty stack after compileShared.", this.expr, this.cursor);
            }
            if (!this.verifyOnly) {
                return new CompiledExpression(CompilerTools.finalizePayload(aSTLinkedList, this.secondPassOptimization, this.pCtx), this.pCtx.getSourceFile(), this.returnType, this.pCtx.getParserConfiguration(), this.literalOnly == 1);
            }
            try {
                this.returnType = CompilerTools.getReturnType(aSTLinkedList, this.pCtx.isStrongTyping());
            }
            catch (RuntimeException runtimeException) {
                throw new CompileException(runtimeException.getMessage(), this.expr, this.st, runtimeException);
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            throw new CompileException("not a statement, or badly formed structure", this.expr, this.st, nullPointerException);
        }
        catch (CompileException compileException) {
            throw ErrorUtil.rewriteIfNeeded(compileException, this.expr, this.st);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new CompileException(throwable.getMessage(), this.expr, this.st, throwable);
        }
    }

    private Object getStackValueResult() {
        return (this.fields & 0x80000) == 0 ? this.stk.pop() : CompilerTools.signNumber(this.stk.pop());
    }

    private boolean compileReduce(int n2, ASTLinkedList aSTLinkedList) {
        switch (this.arithmeticFunctionReduction(n2)) {
            case -1: {
                this.stk.xswap_op();
                aSTLinkedList.addTokenNode(new LiteralNode(this.stk.pop(), this.pCtx));
                aSTLinkedList.addTokenNode((OperatorNode)this.splitAccumulator.pop(), this.verify(this.pCtx, (ASTNode)this.splitAccumulator.pop()));
                return false;
            }
            case -2: {
                LiteralNode literalNode = new LiteralNode(this.stk.pop(), this.pCtx);
                OperatorNode operatorNode = new OperatorNode((Integer)this.stk.pop(), this.expr, this.st, this.pCtx);
                aSTLinkedList.addTokenNode(new LiteralNode(this.stk.pop(), this.pCtx), operatorNode);
                aSTLinkedList.addTokenNode(literalNode, (OperatorNode)this.splitAccumulator.pop());
                aSTLinkedList.addTokenNode(this.verify(this.pCtx, (ASTNode)this.splitAccumulator.pop()));
            }
        }
        return true;
    }

    private static boolean isBooleanOperator(int n2) {
        return n2 == 21 || n2 == 22 || n2 == 29 || n2 == 30;
    }

    protected ASTNode verify(ParserContext parserContext, ASTNode aSTNode) {
        if (aSTNode.isOperator() && (aSTNode.getOperator().equals(21) || aSTNode.getOperator().equals(22))) {
            this.secondPassOptimization = true;
        }
        if (aSTNode.isDiscard() || aSTNode.isOperator()) {
            return aSTNode;
        }
        if (aSTNode.isLiteral()) {
            if ((this.fields & 0x10) != 0 && aSTNode.getClass() == ASTNode.class) {
                return new LiteralNode(aSTNode.getLiteralValue(), parserContext);
            }
            return aSTNode;
        }
        if (this.verifying) {
            if (aSTNode.isIdentifier()) {
                PropertyVerifier propertyVerifier = new PropertyVerifier(this.expr, aSTNode.getStart(), aSTNode.getOffset(), parserContext);
                if (aSTNode instanceof Union) {
                    propertyVerifier.setCtx(((Union)aSTNode).getLeftEgressType());
                    this.returnType = propertyVerifier.analyze();
                    aSTNode.setEgressType(this.returnType);
                } else {
                    this.returnType = propertyVerifier.analyze();
                    aSTNode.setEgressType(this.returnType);
                    if (propertyVerifier.isFqcn()) {
                        aSTNode.setAsFQCNReference();
                    }
                    if (propertyVerifier.isClassLiteral()) {
                        return new LiteralNode(this.returnType, parserContext);
                    }
                    if (propertyVerifier.isInput()) {
                        parserContext.addInput(aSTNode.getAbsoluteName(), propertyVerifier.isDeepProperty() ? Object.class : this.returnType);
                    }
                    if (!(propertyVerifier.isMethodCall() || this.returnType.isEnum() || parserContext.isOptimizerNotified() || !parserContext.isStrongTyping() || parserContext.isVariableVisible(aSTNode.getAbsoluteName()) || aSTNode.isFQCN())) {
                        throw new CompileException("no such identifier: " + aSTNode.getAbsoluteName(), this.expr, aSTNode.getStart());
                    }
                }
            } else if (aSTNode.isAssignment()) {
                Assignment assignment = (Assignment)((Object)aSTNode);
                if (assignment.getAssignmentVar() != null) {
                    PropertyVerifier propertyVerifier = new PropertyVerifier(assignment.getAssignmentVar(), parserContext);
                    this.returnType = propertyVerifier.analyze();
                    aSTNode.setEgressType(this.returnType);
                    if (!assignment.isNewDeclaration() && propertyVerifier.isResolvedExternally()) {
                        parserContext.addInput(aSTNode.getAbsoluteName(), this.returnType);
                    }
                    ExecutableStatement executableStatement = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, aSTNode.getStart(), aSTNode.getOffset(), parserContext);
                    if (parserContext.isStrictTypeEnforcement() && !this.returnType.isAssignableFrom(executableStatement.getKnownEgressType()) && executableStatement.isLiteralOnly()) {
                        if (DataConversion.canConvert(executableStatement.getKnownEgressType(), this.returnType)) {
                            try {
                                assignment.setValueStatement(new ExecutableLiteral(DataConversion.convert(executableStatement.getValue(null, null), this.returnType)));
                                return aSTNode;
                            }
                            catch (Exception exception) {}
                        } else if (this.returnType.isPrimitive() && ParseTools.unboxPrimitive(executableStatement.getKnownEgressType()).equals(this.returnType)) {
                            return aSTNode;
                        }
                        throw new CompileException("cannot assign type " + executableStatement.getKnownEgressType().getName() + " to " + this.returnType.getName(), this.expr, this.st);
                    }
                }
            } else if (aSTNode instanceof NewObjectNode) {
                NewObjectNode newObjectNode = (NewObjectNode)aSTNode;
                List<char[]> list = ParseTools.parseMethodOrConstructor(aSTNode.getNameAsArray());
                if (list != null) {
                    for (char[] cArray : list) {
                        MVEL.analyze(cArray, parserContext);
                    }
                }
            }
            this.returnType = aSTNode.getEgressType();
        }
        if (!aSTNode.isLiteral() && aSTNode.getClass() == ASTNode.class && (aSTNode.getFields() & 0x4000000) == 0) {
            if (parserContext.isStrongTyping()) {
                aSTNode.strongTyping();
            }
            aSTNode.storePctx();
            aSTNode.storeInLiteralRegister(parserContext);
        }
        return aSTNode;
    }

    public ExpressionCompiler(String string) {
        this.setExpression(string);
    }

    public ExpressionCompiler(String string, boolean bl2) {
        this.setExpression(string);
        this.verifying = bl2;
    }

    public ExpressionCompiler(char[] cArray) {
        this.setExpression(cArray);
    }

    public ExpressionCompiler(String string, ParserContext parserContext) {
        this.setExpression(string);
        this.pCtx = parserContext;
    }

    public ExpressionCompiler(char[] cArray, int n2, int n3) {
        this.expr = cArray;
        this.start = n2;
        this.end = n2 + n3;
        this.end = this.trimLeft(this.end);
        this.length = this.end - n2;
    }

    public ExpressionCompiler(String string, int n2, int n3, ParserContext parserContext) {
        this.expr = string.toCharArray();
        this.start = n2;
        this.end = n2 + n3;
        this.end = this.trimLeft(this.end);
        this.length = this.end - n2;
        this.pCtx = parserContext;
    }

    public ExpressionCompiler(char[] cArray, int n2, int n3, ParserContext parserContext) {
        this.expr = cArray;
        this.start = n2;
        this.end = n2 + n3;
        this.end = this.trimLeft(this.end);
        this.length = this.end - n2;
        this.pCtx = parserContext;
    }

    public ExpressionCompiler(char[] cArray, ParserContext parserContext) {
        this.setExpression(cArray);
        this.pCtx = parserContext;
    }

    public boolean isVerifying() {
        return this.verifying;
    }

    public void setVerifying(boolean bl2) {
        this.verifying = bl2;
    }

    public boolean isVerifyOnly() {
        return this.verifyOnly;
    }

    public void setVerifyOnly(boolean bl2) {
        this.verifyOnly = bl2;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class clazz) {
        this.returnType = clazz;
    }

    public ParserContext getParserContextState() {
        return this.pCtx;
    }

    public boolean isLiteralOnly() {
        return this.literalOnly == 1;
    }
}

