/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.util;

import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.DataConversion;
import com.contrastsecurity.thirdparty.org.mvel2.MVEL;
import com.contrastsecurity.thirdparty.org.mvel2.OptimizationFailure;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ASTNode;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.AbstractParser;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.BlankLiteral;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.CompiledExpression;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableAccessor;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableAccessorSafe;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableLiteral;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExpressionCompiler;
import com.contrastsecurity.thirdparty.org.mvel2.integration.ResolverTools;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.ClassImportResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.math.MathProcessor;
import com.contrastsecurity.thirdparty.org.mvel2.util.NullType;
import com.contrastsecurity.thirdparty.org.mvel2.util.StringAppender;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTools {
    public static final Object[] EMPTY_OBJ_ARR = new Object[0];
    public static final Class[] EMPTY_CLS_ARR = new Class[0];
    private static final Map<Constructor, WeakReference<Class[]>> CONSTRUCTOR_PARMS_CACHE = Collections.synchronizedMap(new WeakHashMap(10));
    private static final Map<ClassLoader, Map<String, WeakReference<Class>>> CLASS_RESOLVER_CACHE = Collections.synchronizedMap(new WeakHashMap(1, 1.0f));
    private static final Map<Class, WeakReference<Constructor[]>> CLASS_CONSTRUCTOR_CACHE = Collections.synchronizedMap(new WeakHashMap(10));
    private static final HashMap<Class, Integer> typeResolveMap;
    private static final Map<Class, Integer> typeCodes;

    public static List<char[]> parseMethodOrConstructor(char[] cArray) {
        int n2 = -1;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != '(') continue;
            n2 = ++i2;
            break;
        }
        if (n2 != -1) {
            return ParseTools.parseParameterList(cArray, --n2 + 1, ParseTools.balancedCapture(cArray, n2, '(') - n2 - 1);
        }
        return Collections.emptyList();
    }

    public static String[] parseParameterDefList(char[] cArray, int n2, int n3) {
        String string;
        int n4;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (n3 == -1) {
            n3 = cArray.length;
        }
        int n5 = n2;
        int n6 = n4 + n3;
        block6: for (n4 = n2; n4 < n6; ++n4) {
            switch (cArray[n4]) {
                case '(': 
                case '[': 
                case '{': {
                    n4 = ParseTools.balancedCapture(cArray, n4, cArray[n4]);
                    continue block6;
                }
                case '\'': {
                    n4 = ParseTools.captureStringLiteral('\'', cArray, n4, cArray.length);
                    continue block6;
                }
                case '\"': {
                    n4 = ParseTools.captureStringLiteral('\"', cArray, n4, cArray.length);
                    continue block6;
                }
                case ',': {
                    if (n4 > n5) {
                        while (ParseTools.isWhitespace(cArray[n5])) {
                            ++n5;
                        }
                        string = new String(cArray, n5, n4 - n5);
                        ParseTools.checkNameSafety(string);
                        linkedList.add(string);
                    }
                    while (ParseTools.isWhitespace(cArray[n4])) {
                        ++n4;
                    }
                    n5 = n4 + 1;
                    continue block6;
                }
                default: {
                    if (ParseTools.isWhitespace(cArray[n4]) || ParseTools.isIdentifierPart(cArray[n4])) continue block6;
                    throw new CompileException("expected parameter", cArray, n5);
                }
            }
        }
        if (n5 < n3 + n2 && n4 > n5) {
            string = ParseTools.createStringTrimmed(cArray, n5, n4 - n5);
            if (string.length() > 0) {
                ParseTools.checkNameSafety(string);
                linkedList.add(string);
            }
        } else if (linkedList.size() == 0 && (string = ParseTools.createStringTrimmed(cArray, n5, n3)).length() > 0) {
            ParseTools.checkNameSafety(string);
            linkedList.add(string);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static List<char[]> parseParameterList(char[] cArray, int n2, int n3) {
        char[] cArray2;
        int n4;
        ArrayList<char[]> arrayList = new ArrayList<char[]>();
        if (n3 == -1) {
            n3 = cArray.length;
        }
        int n5 = n2;
        int n6 = n4 + n3;
        block6: for (n4 = n2; n4 < n6; ++n4) {
            switch (cArray[n4]) {
                case '(': 
                case '[': 
                case '{': {
                    n4 = ParseTools.balancedCapture(cArray, n4, cArray[n4]);
                    continue block6;
                }
                case '\'': {
                    n4 = ParseTools.captureStringLiteral('\'', cArray, n4, cArray.length);
                    continue block6;
                }
                case '\"': {
                    n4 = ParseTools.captureStringLiteral('\"', cArray, n4, cArray.length);
                    continue block6;
                }
                case ',': {
                    if (n4 > n5) {
                        while (ParseTools.isWhitespace(cArray[n5])) {
                            ++n5;
                        }
                        arrayList.add(ParseTools.subsetTrimmed(cArray, n5, n4 - n5));
                    }
                    while (ParseTools.isWhitespace(cArray[n4])) {
                        ++n4;
                    }
                    n5 = n4 + 1;
                }
            }
        }
        if (n5 < n3 + n2 && n4 > n5) {
            char[] cArray3 = ParseTools.subsetTrimmed(cArray, n5, n4 - n5);
            if (cArray3.length > 0) {
                arrayList.add(cArray3);
            }
        } else if (arrayList.size() == 0 && (cArray2 = ParseTools.subsetTrimmed(cArray, n5, n3)).length > 0) {
            arrayList.add(cArray2);
        }
        return arrayList;
    }

    public static Method getBestCandidate(Object[] objectArray, String string, Class clazz, Method[] methodArray, boolean bl2) {
        Class[] classArray = new Class[objectArray.length];
        for (int i2 = 0; i2 != objectArray.length; ++i2) {
            classArray[i2] = objectArray[i2] != null ? objectArray[i2].getClass() : null;
        }
        return ParseTools.getBestCandidate(classArray, string, clazz, methodArray, bl2);
    }

    public static Method getBestCandidate(Class[] classArray, String string, Class clazz, Method[] methodArray, boolean bl2) {
        return ParseTools.getBestCandidate(classArray, string, clazz, methodArray, bl2, false);
    }

    public static Method getBestCandidate(Class[] classArray, String string, Class clazz, Method[] methodArray, boolean bl2, boolean bl3) {
        if (methodArray.length == 0) {
            return null;
        }
        Method method = null;
        int n2 = -1;
        boolean bl4 = false;
        while (true) {
            int n3;
            for (Method method2 : methodArray) {
                int n4;
                if (bl3 && !Modifier.isStatic(method2.getModifiers()) || !string.equals(method2.getName())) continue;
                Class<?>[] classArray2 = method2.getParameterTypes();
                if (classArray2.length == 0 && classArray.length == 0) {
                    if (method != null && !ParseTools.isMoreSpecialized(method2, method)) continue;
                    method = method2;
                    continue;
                }
                boolean bl5 = method2.isVarArgs();
                if (classArray2.length != classArray.length && !bl5 || (n4 = ParseTools.getMethodScore(classArray, bl2, classArray2, bl5)) == 0) continue;
                if (n4 > n2) {
                    method = method2;
                    n2 = n4;
                    continue;
                }
                if (n4 != n2 || !ParseTools.isMoreSpecialized(method2, method) || bl5) continue;
                method = method2;
            }
            if (method != null || bl4 || !clazz.isInterface()) break;
            Method[] methodArray2 = Object.class.getMethods();
            Method[] methodArray3 = new Method[methodArray.length + methodArray2.length];
            for (n3 = 0; n3 < methodArray.length; ++n3) {
                methodArray3[n3] = methodArray[n3];
            }
            for (n3 = 0; n3 < methodArray2.length; ++n3) {
                methodArray3[n3 + methodArray.length] = methodArray2[n3];
            }
            methodArray = methodArray3;
            bl4 = true;
        }
        return method;
    }

    private static boolean isMoreSpecialized(Method method, Method method2) {
        return method2.getReturnType().isAssignableFrom(method.getReturnType()) && method2.getDeclaringClass().isAssignableFrom(method.getDeclaringClass());
    }

    private static int getMethodScore(Class[] classArray, boolean bl2, Class<?>[] classArray2, boolean bl3) {
        int n2 = 0;
        for (int i2 = 0; i2 != classArray.length; ++i2) {
            Class<?> clazz = bl3 && i2 >= classArray2.length - 1 ? classArray2[classArray2.length - 1].getComponentType() : classArray2[i2];
            if (classArray[i2] == null) {
                if (!clazz.isPrimitive()) {
                    n2 += 6;
                    continue;
                }
                n2 = 0;
                break;
            }
            if (clazz == classArray[i2]) {
                n2 += 7;
                continue;
            }
            if (clazz.isPrimitive() && ParseTools.boxPrimitive(clazz) == classArray[i2]) {
                n2 += 6;
                continue;
            }
            if (classArray[i2].isPrimitive() && ParseTools.unboxPrimitive(classArray[i2]) == clazz) {
                n2 += 6;
                continue;
            }
            if (clazz.isAssignableFrom(classArray[i2])) {
                n2 += 5;
                continue;
            }
            if (ParseTools.isNumericallyCoercible(classArray[i2], clazz)) {
                n2 += 4;
                continue;
            }
            if (ParseTools.boxPrimitive(clazz).isAssignableFrom(ParseTools.boxPrimitive(classArray[i2])) && Object.class != classArray[i2]) {
                n2 += 3 + ParseTools.scoreInterface(clazz, classArray[i2]);
                continue;
            }
            if (!bl2 && DataConversion.canConvert(clazz, classArray[i2])) {
                if (clazz.isArray() && classArray[i2].isArray()) {
                    ++n2;
                } else if (clazz == Character.TYPE && classArray[i2] == String.class) {
                    ++n2;
                }
                ++n2;
                continue;
            }
            if (clazz == Object.class || classArray[i2] == NullType.class) {
                ++n2;
                continue;
            }
            n2 = 0;
            break;
        }
        if (n2 == 0 && bl3 && classArray2.length - 1 == classArray.length) {
            n2 += 3;
        }
        return n2;
    }

    public static int scoreInterface(Class<?> clazz, Class<?> clazz2) {
        Class<?>[] classArray;
        if (clazz.isInterface() && (classArray = clazz2.getInterfaces()) != null) {
            for (Class<?> clazz3 : classArray) {
                if (clazz3 == clazz) {
                    return 1;
                }
                if (!clazz.isAssignableFrom(clazz3)) continue;
                return ParseTools.scoreInterface(clazz, clazz2.getSuperclass());
            }
        }
        return 0;
    }

    public static Method getExactMatch(String string, Class[] classArray, Class clazz, Class clazz2) {
        block0: for (Method method : clazz2.getMethods()) {
            Class<?>[] classArray2;
            if (!string.equals(method.getName()) || clazz != method.getReturnType() || (classArray2 = method.getParameterTypes()).length != classArray.length) continue;
            for (int i2 = 0; i2 < classArray2.length; ++i2) {
                if (classArray2[i2] != classArray[i2]) continue block0;
            }
            return method;
        }
        return null;
    }

    public static Method getWidenedTarget(Method method) {
        return ParseTools.getWidenedTarget(method.getDeclaringClass(), method);
    }

    public static Method getWidenedTarget(Class clazz, Method method) {
        Class clazz2;
        if (Modifier.isStatic(method.getModifiers())) {
            return method;
        }
        Method method2 = method;
        Method method3 = method;
        Class[] classArray = method.getParameterTypes();
        String string = method.getName();
        Class<?> clazz3 = method2.getReturnType();
        for (clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            for (Class<?> clazz4 : clazz2.getInterfaces()) {
                method2 = ParseTools.getExactMatch(string, classArray, clazz3, clazz4);
                if (method2 == null) continue;
                method3 = method2;
            }
        }
        if (method3 != method) {
            return method3;
        }
        for (clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            method2 = ParseTools.getExactMatch(string, classArray, clazz3, clazz2);
            if (method2 == null) continue;
            method3 = method2;
        }
        return method3;
    }

    private static Class[] getConstructors(Constructor constructor) {
        Class[] classArray;
        WeakReference<Class[]> weakReference = CONSTRUCTOR_PARMS_CACHE.get(constructor);
        if (weakReference != null && (classArray = (Class[])weakReference.get()) != null) {
            return classArray;
        }
        classArray = constructor.getParameterTypes();
        CONSTRUCTOR_PARMS_CACHE.put(constructor, new WeakReference<Class<?>[]>(classArray));
        return classArray;
    }

    public static Constructor getBestConstructorCandidate(Object[] objectArray, Class clazz, boolean bl2) {
        Class[] classArray = new Class[objectArray.length];
        for (int i2 = 0; i2 != objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            classArray[i2] = objectArray[i2].getClass();
        }
        return ParseTools.getBestConstructorCandidate(classArray, clazz, bl2);
    }

    public static Constructor getBestConstructorCandidate(Class[] classArray, Class clazz, boolean bl2) {
        Constructor constructor = null;
        int n2 = 0;
        for (Constructor constructor2 : ParseTools.getConstructors(clazz)) {
            boolean bl3 = constructor2.isVarArgs();
            Class[] classArray2 = ParseTools.getConstructors(constructor2);
            if (classArray2.length != classArray.length && !constructor2.isVarArgs()) continue;
            if (classArray.length == 0 && classArray2.length == 0) {
                return constructor2;
            }
            int n3 = ParseTools.getMethodScore(classArray, bl2, classArray2, bl3);
            if (n3 == 0 || n3 <= n2) continue;
            constructor = constructor2;
            n2 = n3;
        }
        return constructor;
    }

    public static Class createClass(String string, ParserContext parserContext) throws ClassNotFoundException {
        Class<?> clazz;
        WeakReference<Class> weakReference;
        ClassLoader classLoader = parserContext != null ? parserContext.getClassLoader() : Thread.currentThread().getContextClassLoader();
        Map<String, WeakReference<Class<Object>>> map = CLASS_RESOLVER_CACHE.get(classLoader);
        if (map == null) {
            map = Collections.synchronizedMap(new WeakHashMap(10));
            CLASS_RESOLVER_CACHE.put(classLoader, map);
        }
        if ((weakReference = map.get(string)) != null && (clazz = (Class<?>)weakReference.get()) != null) {
            return clazz;
        }
        try {
            clazz = Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classLoader != Thread.currentThread().getContextClassLoader()) {
                clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            throw classNotFoundException;
        }
        map.put(string, new WeakReference(clazz));
        return clazz;
    }

    public static Constructor[] getConstructors(Class clazz) {
        Constructor[] constructorArray;
        WeakReference<Constructor[]> weakReference = CLASS_CONSTRUCTOR_CACHE.get(clazz);
        if (weakReference != null && (constructorArray = (Constructor[])weakReference.get()) != null) {
            return constructorArray;
        }
        constructorArray = clazz.getConstructors();
        CLASS_CONSTRUCTOR_CACHE.put(clazz, new WeakReference<Constructor<?>[]>(constructorArray));
        return constructorArray;
    }

    public static String[] captureContructorAndResidual(char[] cArray, int n2, int n3) {
        int n4 = 0;
        int n5 = n2 + n3;
        boolean bl2 = false;
        block5: for (int i2 = n2; i2 < n5; ++i2) {
            switch (cArray[i2]) {
                case '\"': {
                    bl2 = !bl2;
                    continue block5;
                }
                case '(': {
                    ++n4;
                    continue block5;
                }
                case ')': {
                    if (bl2 || 1 != n4--) continue block5;
                    return new String[]{ParseTools.createStringTrimmed(cArray, n2, ++i2 - n2), ParseTools.createStringTrimmed(cArray, i2, n5 - i2)};
                }
            }
        }
        return new String[]{new String(cArray, n2, n3)};
    }

    public static Class<?> boxPrimitive(Class clazz) {
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer.class;
        }
        if (clazz == int[].class || clazz == Integer[].class) {
            return Integer[].class;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.class;
        }
        if (clazz == char[].class || clazz == Character[].class) {
            return Character[].class;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return Long.class;
        }
        if (clazz == long[].class || clazz == Long[].class) {
            return Long[].class;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return Short.class;
        }
        if (clazz == short[].class || clazz == Short[].class) {
            return Short[].class;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double.class;
        }
        if (clazz == double[].class || clazz == Double[].class) {
            return Double[].class;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.class;
        }
        if (clazz == float[].class || clazz == Float[].class) {
            return Float[].class;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return Boolean.class;
        }
        if (clazz == boolean[].class || clazz == Boolean[].class) {
            return Boolean[].class;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return Byte.class;
        }
        if (clazz == byte[].class || clazz == Byte[].class) {
            return Byte[].class;
        }
        return clazz;
    }

    public static Class unboxPrimitive(Class clazz) {
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (clazz == Integer[].class || clazz == int[].class) {
            return int[].class;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Long.TYPE;
        }
        if (clazz == Long[].class || clazz == long[].class) {
            return long[].class;
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return Character.TYPE;
        }
        if (clazz == Character[].class || clazz == char[].class) {
            return char[].class;
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return Short.TYPE;
        }
        if (clazz == Short[].class || clazz == short[].class) {
            return short[].class;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return Double.TYPE;
        }
        if (clazz == Double[].class || clazz == double[].class) {
            return double[].class;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.TYPE;
        }
        if (clazz == Float[].class || clazz == float[].class) {
            return float[].class;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        if (clazz == Boolean[].class || clazz == boolean[].class) {
            return boolean[].class;
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return Byte.TYPE;
        }
        if (clazz == Byte[].class || clazz == byte[].class) {
            return byte[].class;
        }
        return clazz;
    }

    public static boolean containsCheck(Object object, Object object2) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            return ((String)object).contains(String.valueOf(object2));
        }
        if (object instanceof Collection) {
            return ((Collection)object).contains(object2);
        }
        if (object instanceof Map) {
            return ((Map)object).containsKey(object2);
        }
        if (object.getClass().isArray()) {
            if (object.getClass().getComponentType().isPrimitive()) {
                return ParseTools.containsCheckOnPrimitveArray(object, object2);
            }
            for (Object object3 : (Object[])object) {
                if (object2 == null && object3 == null) {
                    return true;
                }
                if (!((Boolean)MathProcessor.doOperations(object3, 18, object2)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsCheckOnPrimitveArray(Object object, Object object2) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Boolean.TYPE) {
            return object2 instanceof Boolean && ParseTools.containsCheckOnBooleanArray((boolean[])object, (Boolean)object2);
        }
        if (clazz == Integer.TYPE) {
            return object2 instanceof Integer && ParseTools.containsCheckOnIntArray((int[])object, (Integer)object2);
        }
        if (clazz == Long.TYPE) {
            return object2 instanceof Long && ParseTools.containsCheckOnLongArray((long[])object, (Long)object2);
        }
        if (clazz == Double.TYPE) {
            return object2 instanceof Double && ParseTools.containsCheckOnDoubleArray((double[])object, (Double)object2);
        }
        if (clazz == Float.TYPE) {
            return object2 instanceof Float && ParseTools.containsCheckOnFloatArray((float[])object, (Float)object2);
        }
        if (clazz == Character.TYPE) {
            return object2 instanceof Character && ParseTools.containsCheckOnCharArray((char[])object, (Character)object2);
        }
        if (clazz == Short.TYPE) {
            return object2 instanceof Short && ParseTools.containsCheckOnShortArray((short[])object, (Short)object2);
        }
        if (clazz == Byte.TYPE) {
            return object2 instanceof Byte && ParseTools.containsCheckOnByteArray((byte[])object, (Byte)object2);
        }
        return false;
    }

    private static boolean containsCheckOnBooleanArray(boolean[] blArray, Boolean bl2) {
        boolean bl3 = bl2;
        for (boolean bl4 : blArray) {
            if (bl4 != bl3) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnIntArray(int[] nArray, Integer n2) {
        int n3 = n2;
        for (int n4 : nArray) {
            if (n4 != n3) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnLongArray(long[] lArray, Long l2) {
        long l3 = l2;
        for (long l4 : lArray) {
            if (l4 != l3) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnDoubleArray(double[] dArray, Double d2) {
        double d3 = d2;
        for (double d4 : dArray) {
            if (d4 != d3) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnFloatArray(float[] fArray, Float f2) {
        float f3 = f2.floatValue();
        for (float f4 : fArray) {
            if (f4 != f3) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnCharArray(char[] cArray, Character c2) {
        char c3 = c2.charValue();
        for (char c4 : cArray) {
            if (c4 != c3) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnShortArray(short[] sArray, Short s2) {
        short s3 = s2;
        for (short s4 : sArray) {
            if (s4 != s3) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCheckOnByteArray(byte[] byArray, Byte by2) {
        byte by3 = by2;
        for (byte by4 : byArray) {
            if (by4 != by3) continue;
            return true;
        }
        return false;
    }

    public static int handleEscapeSequence(char[] cArray, int n2) {
        cArray[n2 - 1] = '\u0000';
        switch (cArray[n2]) {
            case '\\': {
                cArray[n2] = 92;
                return 1;
            }
            case 'b': {
                cArray[n2] = 8;
                return 1;
            }
            case 'f': {
                cArray[n2] = 12;
                return 1;
            }
            case 't': {
                cArray[n2] = 9;
                return 1;
            }
            case 'r': {
                cArray[n2] = 13;
                return 1;
            }
            case 'n': {
                cArray[n2] = 10;
                return 1;
            }
            case '\'': {
                cArray[n2] = 39;
                return 1;
            }
            case '\"': {
                cArray[n2] = 34;
                return 1;
            }
            case 'u': {
                int n3 = n2;
                if (n3 + 4 > cArray.length) {
                    throw new CompileException("illegal unicode escape sequence", cArray, n2);
                }
                while (++n2 - n3 != 5) {
                    if (cArray[n2] > '/' && cArray[n2] < ':' || cArray[n2] > '@' && cArray[n2] < 'G') continue;
                    throw new CompileException("illegal unicode escape sequence", cArray, n2);
                }
                cArray[n3 - 1] = (char)Integer.decode("0x" + new String(cArray, n3 + 1, 4)).intValue();
                cArray[n3] = '\u0000';
                cArray[n3 + 1] = '\u0000';
                cArray[n3 + 2] = '\u0000';
                cArray[n3 + 3] = '\u0000';
                cArray[n3 + 4] = '\u0000';
                return 5;
            }
        }
        int n4 = n2;
        while (cArray[n2] >= '0' && cArray[n2] < '8') {
            if (n2 != n4 && cArray[n4] > '3') {
                cArray[n4 - 1] = (char)Integer.decode("0" + new String(cArray, n4, n2 - n4 + 1)).intValue();
                cArray[n4] = '\u0000';
                cArray[n4 + 1] = '\u0000';
                return 2;
            }
            if (n2 - n4 == 2) {
                cArray[n4 - 1] = (char)Integer.decode("0" + new String(cArray, n4, n2 - n4 + 1)).intValue();
                cArray[n4] = '\u0000';
                cArray[n4 + 1] = '\u0000';
                cArray[n4 + 2] = '\u0000';
                return 3;
            }
            if (n2 + 1 == cArray.length || cArray[n2] < '0' || cArray[n2] > '7') {
                cArray[n4 - 1] = (char)Integer.decode("0" + new String(cArray, n4, n2 - n4 + 1)).intValue();
                cArray[n4] = '\u0000';
                return 1;
            }
            ++n2;
        }
        throw new CompileException("illegal escape sequence: " + cArray[n2], cArray, n2);
    }

    public static char[] createShortFormOperativeAssignment(String string, char[] cArray, int n2, int n3, int n4) {
        if (n4 == -1) {
            return cArray;
        }
        int n5 = 0;
        switch (n4) {
            case 0: {
                n5 = 43;
                break;
            }
            case 20: {
                n5 = 35;
                break;
            }
            case 1: {
                n5 = 45;
                break;
            }
            case 2: {
                n5 = 42;
                break;
            }
            case 4: {
                n5 = 37;
                break;
            }
            case 3: {
                n5 = 47;
                break;
            }
            case 6: {
                n5 = 38;
                break;
            }
            case 7: {
                n5 = 124;
                break;
            }
            case 10: {
                n5 = 171;
                break;
            }
            case 9: {
                n5 = 187;
                break;
            }
            case 11: {
                n5 = 172;
            }
        }
        char[] cArray2 = new char[string.length() + n3 + 1];
        System.arraycopy(string.toCharArray(), 0, cArray2, 0, string.length());
        cArray2[string.length()] = n5;
        System.arraycopy(cArray, n2, cArray2, string.length() + 1, n3);
        return cArray2;
    }

    public static ClassImportResolverFactory findClassImportResolverFactory(VariableResolverFactory variableResolverFactory, ParserContext parserContext) {
        if (variableResolverFactory == null) {
            throw new OptimizationFailure("unable to import classes.  no variable resolver factory available.");
        }
        for (VariableResolverFactory variableResolverFactory2 = variableResolverFactory; variableResolverFactory2 != null; variableResolverFactory2 = variableResolverFactory2.getNextFactory()) {
            if (!(variableResolverFactory2 instanceof ClassImportResolverFactory)) continue;
            return (ClassImportResolverFactory)variableResolverFactory2;
        }
        return ResolverTools.appendFactory(variableResolverFactory, new ClassImportResolverFactory(null, null, false));
    }

    public static Class findClass(VariableResolverFactory variableResolverFactory, String string, ParserContext parserContext) throws ClassNotFoundException {
        try {
            if (AbstractParser.LITERALS.containsKey(string)) {
                return (Class)AbstractParser.LITERALS.get(string);
            }
            if (variableResolverFactory != null && variableResolverFactory.isResolveable(string)) {
                return (Class)variableResolverFactory.getVariableResolver(string).getValue();
            }
            if (parserContext != null && parserContext.hasImport(string)) {
                return parserContext.getImport(string);
            }
            return ParseTools.createClass(string, parserContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            throw new RuntimeException("class not found: " + string, exception);
        }
    }

    public static char[] subsetTrimmed(char[] cArray, int n2, int n3) {
        int n4;
        if (n3 <= 0) {
            return new char[0];
        }
        for (n4 = n2 + n3; n4 > 0 && ParseTools.isWhitespace(cArray[n4 - 1]); --n4) {
        }
        while (ParseTools.isWhitespace(cArray[n2]) && n2 < n4) {
            ++n2;
        }
        n3 = n4 - n2;
        if (n3 == 0) {
            return new char[0];
        }
        return ParseTools.subset(cArray, n2, n3);
    }

    public static char[] subset(char[] cArray, int n2, int n3) {
        char[] cArray2 = new char[n3];
        for (int i2 = 0; i2 < cArray2.length; ++i2) {
            cArray2[i2] = cArray[i2 + n2];
        }
        return cArray2;
    }

    public static char[] subset(char[] cArray, int n2) {
        char[] cArray2 = new char[cArray.length - n2];
        for (int i2 = 0; i2 < cArray2.length; ++i2) {
            cArray2[i2] = cArray[i2 + n2];
        }
        return cArray2;
    }

    public static int resolveType(Object object) {
        if (object == null) {
            return 0;
        }
        return ParseTools.__resolveType(object.getClass());
    }

    public static int __resolveType(Class clazz) {
        Integer n2 = typeCodes.get(clazz);
        if (n2 == null) {
            if (clazz != null && Collection.class.isAssignableFrom(clazz)) {
                return 50;
            }
            return 0;
        }
        return n2;
    }

    public static boolean isNumericallyCoercible(Class clazz, Class clazz2) {
        Class<?> clazz3;
        Class<?> clazz4 = clazz3 = clazz.isPrimitive() ? ParseTools.boxPrimitive(clazz) : clazz;
        if (clazz3 != null && Number.class.isAssignableFrom(clazz) && (clazz3 = clazz2.isPrimitive() ? ParseTools.boxPrimitive(clazz2) : clazz2) != null) {
            return Number.class.isAssignableFrom(clazz3);
        }
        return false;
    }

    public static Object narrowType(BigDecimal bigDecimal, int n2) {
        if (n2 == 109 || bigDecimal.scale() > 0) {
            return bigDecimal.doubleValue();
        }
        if (n2 == 107 || bigDecimal.longValue() > Integer.MAX_VALUE) {
            return bigDecimal.longValue();
        }
        return bigDecimal.intValue();
    }

    public static Method determineActualTargetMethod(Method method) {
        return ParseTools.determineActualTargetMethod(method.getDeclaringClass(), method);
    }

    private static Method determineActualTargetMethod(Class clazz, Method method) {
        String string = method.getName();
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            for (Method method2 : clazz2.getMethods()) {
                if (method2.getParameterTypes().length != 0 || !string.equals(method2.getName())) continue;
                return method2;
            }
        }
        return clazz.getSuperclass() != null ? ParseTools.determineActualTargetMethod(clazz.getSuperclass(), method) : null;
    }

    public static int captureToNextTokenJunction(char[] cArray, int n2, int n3, ParserContext parserContext) {
        block4: while (n2 != cArray.length) {
            switch (cArray[n2]) {
                case '(': 
                case '{': {
                    return n2;
                }
                case '[': {
                    n2 = ParseTools.balancedCaptureWithLineAccounting(cArray, n2, n3, '[', parserContext) + 1;
                    continue block4;
                }
            }
            if (ParseTools.isWhitespace(cArray[n2])) {
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    public static int nextNonBlank(char[] cArray, int n2) {
        int n3;
        if (n2 + 1 >= cArray.length) {
            throw new CompileException("unexpected end of statement", cArray, n2);
        }
        for (n3 = n2; n3 != cArray.length && ParseTools.isWhitespace(cArray[n3]); ++n3) {
        }
        return n3;
    }

    public static int skipWhitespace(char[] cArray, int n2) {
        block8: while (n2 != cArray.length) {
            switch (cArray[n2]) {
                case '\n': 
                case '\r': {
                    ++n2;
                    continue block8;
                }
                case '/': {
                    if (n2 + 1 != cArray.length) {
                        switch (cArray[n2 + 1]) {
                            case '/': {
                                cArray[n2++] = 32;
                                while (n2 != cArray.length && cArray[n2] != '\n') {
                                    cArray[n2++] = 32;
                                }
                                if (n2 == cArray.length) continue block8;
                                cArray[n2++] = 32;
                                continue block8;
                            }
                            case '*': {
                                int n3 = cArray.length - 1;
                                cArray[n2++] = 32;
                                while (n2 != n3 && (cArray[n2] != '*' || cArray[n2 + 1] != '/')) {
                                    cArray[n2++] = 32;
                                }
                                if (n2 == n3) continue block8;
                                int n4 = n2++;
                                cArray[n2++] = 32;
                                cArray[n4] = 32;
                                continue block8;
                            }
                        }
                        break block8;
                    }
                }
                default: {
                    if (!ParseTools.isWhitespace(cArray[n2])) break block8;
                    ++n2;
                    continue block8;
                }
            }
        }
        return n2;
    }

    public static boolean isStatementNotManuallyTerminated(char[] cArray, int n2) {
        int n3;
        if (n2 >= cArray.length) {
            return false;
        }
        for (n3 = n2; n3 != cArray.length && ParseTools.isWhitespace(cArray[n3]); ++n3) {
        }
        return n3 == cArray.length || cArray[n3] != ';';
    }

    public static int captureToEOS(char[] cArray, int n2, int n3, ParserContext parserContext) {
        while (n2 != cArray.length) {
            switch (cArray[n2]) {
                case '(': 
                case '[': 
                case '{': {
                    n2 = ParseTools.balancedCaptureWithLineAccounting(cArray, n2, n3, cArray[n2], parserContext);
                    if (n2 < cArray.length) break;
                    return n2;
                }
                case '\"': 
                case '\'': {
                    n2 = ParseTools.captureStringLiteral(cArray[n2], cArray, n2, cArray.length);
                    break;
                }
                case ',': 
                case ';': 
                case '}': {
                    return n2;
                }
            }
            ++n2;
        }
        return n2;
    }

    public static int trimLeft(char[] cArray, int n2, int n3) {
        if (n3 > cArray.length) {
            n3 = cArray.length;
        }
        while (n3 != 0 && n3 >= n2 && ParseTools.isWhitespace(cArray[n3 - 1])) {
            --n3;
        }
        return n3;
    }

    public static int trimRight(char[] cArray, int n2) {
        while (n2 != cArray.length && ParseTools.isWhitespace(cArray[n2])) {
            ++n2;
        }
        return n2;
    }

    public static char[] subArray(char[] cArray, int n2, int n3) {
        if (n2 >= n3) {
            return new char[0];
        }
        char[] cArray2 = new char[n3 - n2];
        for (int i2 = 0; i2 != cArray2.length; ++i2) {
            cArray2[i2] = cArray[i2 + n2];
        }
        return cArray2;
    }

    public static int balancedCapture(char[] cArray, int n2, char c2) {
        return ParseTools.balancedCapture(cArray, n2, cArray.length, c2);
    }

    public static int balancedCapture(char[] cArray, int n2, int n3, char c2) {
        int n4 = 1;
        char c3 = c2;
        switch (c2) {
            case '[': {
                c3 = ']';
                break;
            }
            case '{': {
                c3 = '}';
                break;
            }
            case '(': {
                c3 = ')';
            }
        }
        if (c2 == c3) {
            ++n2;
            while (n2 < n3) {
                if (cArray[n2] == c2) {
                    return n2;
                }
                ++n2;
            }
        } else {
            ++n2;
            while (n2 < n3) {
                block32: {
                    if (n2 < n3 && cArray[n2] == '/') {
                        if (n2 + 1 == n3) {
                            return n2;
                        }
                        if (cArray[n2 + 1] == '/') {
                            ++n2;
                            while (n2 < n3 && cArray[n2] != '\n') {
                                ++n2;
                            }
                        } else if (cArray[n2 + 1] == '*') {
                            n2 += 2;
                            block16: while (n2 < n3) {
                                switch (cArray[n2]) {
                                    case '*': {
                                        if (n2 + 1 < n3 && cArray[n2 + 1] == '/') break block32;
                                    }
                                    default: {
                                        ++n2;
                                        continue block16;
                                    }
                                }
                            }
                        }
                    }
                }
                if (n2 == n3) {
                    return n2;
                }
                if (cArray[n2] == '\'' || cArray[n2] == '\"') {
                    n2 = ParseTools.captureStringLiteral(cArray[n2], cArray, n2, n3);
                } else if (cArray[n2] == c2) {
                    ++n4;
                } else if (cArray[n2] == c3 && --n4 == 0) {
                    return n2;
                }
                ++n2;
            }
        }
        switch (c2) {
            case '[': {
                throw new CompileException("unbalanced braces [ ... ]", cArray, n2);
            }
            case '{': {
                throw new CompileException("unbalanced braces { ... }", cArray, n2);
            }
            case '(': {
                throw new CompileException("unbalanced braces ( ... )", cArray, n2);
            }
        }
        throw new CompileException("unterminated string literal", cArray, n2);
    }

    public static int balancedCaptureWithLineAccounting(char[] cArray, int n2, int n3, char c2, ParserContext parserContext) {
        int n4;
        block40: {
            char c3;
            int n5;
            block39: {
                n5 = 1;
                n4 = n2;
                c3 = c2;
                switch (c2) {
                    case '[': {
                        c3 = ']';
                        break;
                    }
                    case '{': {
                        c3 = '}';
                        break;
                    }
                    case '(': {
                        c3 = ')';
                    }
                }
                if (c2 != c3) break block39;
                ++n2;
                while (n2 != n3) {
                    if (cArray[n2] == c2) {
                        return n2;
                    }
                    ++n2;
                }
                break block40;
            }
            int n6 = 0;
            ++n2;
            while (n2 < n3) {
                block42: {
                    block38: {
                        block41: {
                            if (!ParseTools.isWhitespace(cArray[n2])) break block41;
                            switch (cArray[n2]) {
                                case '\r': {
                                    break block42;
                                }
                                case '\n': {
                                    if (parserContext != null) {
                                        parserContext.setLineOffset((short)n2);
                                    }
                                    ++n6;
                                }
                            }
                            break block38;
                        }
                        if (n2 < n3 && cArray[n2] == '/') {
                            if (n2 + 1 == n3) {
                                return n2;
                            }
                            if (cArray[n2 + 1] == '/') {
                                ++n2;
                                while (n2 < n3 && cArray[n2] != '\n') {
                                    ++n2;
                                }
                            } else if (cArray[n2 + 1] == '*') {
                                n2 += 2;
                                block21: while (n2 != n3) {
                                    switch (cArray[n2]) {
                                        case '*': {
                                            if (n2 + 1 < n3 && cArray[n2 + 1] == '/') break block38;
                                        }
                                        case '\n': 
                                        case '\r': {
                                            if (parserContext != null) {
                                                parserContext.setLineOffset((short)n2);
                                            }
                                            ++n6;
                                        }
                                        default: {
                                            ++n2;
                                            continue block21;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (n2 == n3) {
                        return n2;
                    }
                    if (cArray[n2] == '\'' || cArray[n2] == '\"') {
                        n2 = ParseTools.captureStringLiteral(cArray[n2], cArray, n2, n3);
                    } else if (cArray[n2] == c2) {
                        ++n5;
                    } else if (cArray[n2] == c3 && --n5 == 0) {
                        if (parserContext != null) {
                            parserContext.incrementLineCount(n6);
                        }
                        return n2;
                    }
                }
                ++n2;
            }
        }
        switch (c2) {
            case '[': {
                throw new CompileException("unbalanced braces [ ... ]", cArray, n4);
            }
            case '{': {
                throw new CompileException("unbalanced braces { ... }", cArray, n4);
            }
            case '(': {
                throw new CompileException("unbalanced braces ( ... )", cArray, n4);
            }
        }
        throw new CompileException("unterminated string literal", cArray, n4);
    }

    public static String handleStringEscapes(char[] cArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != '\\') continue;
            n2 += ParseTools.handleEscapeSequence(cArray, ++i2);
        }
        if (n2 == 0) {
            return new String(cArray);
        }
        char[] cArray2 = new char[cArray.length - n2];
        int n3 = 0;
        for (char c2 : cArray) {
            if (c2 == '\u0000') continue;
            cArray2[n3++] = c2;
        }
        return new String(cArray2);
    }

    public static int captureStringLiteral(char c2, char[] cArray, int n2, int n3) {
        while (++n2 < n3 && cArray[n2] != c2) {
            if (cArray[n2] != '\\') continue;
            ++n2;
        }
        if (n2 >= n3 || cArray[n2] != c2) {
            throw new CompileException("unterminated string literal", cArray, n2);
        }
        return n2;
    }

    public static void parseWithExpressions(String string, char[] cArray, int n2, int n3, Object object, VariableResolverFactory variableResolverFactory) {
        int n4 = n2;
        int n5 = -1;
        int n6 = n2 + n3;
        int n7 = -1;
        String string2 = "";
        block13: for (int i2 = n2; i2 < n6; ++i2) {
            switch (cArray[i2]) {
                case '\"': 
                case '\'': 
                case '(': 
                case '[': 
                case '{': {
                    i2 = ParseTools.balancedCapture(cArray, i2, n6, cArray[i2]);
                    continue block13;
                }
                case '/': {
                    if (i2 < n6 && cArray[i2 + 1] == '/') {
                        while (i2 < n6 && cArray[i2] != '\n') {
                            cArray[i2++] = 32;
                        }
                        if (string2 != null) continue block13;
                        n4 = i2;
                        continue block13;
                    }
                    if (i2 < n6 && cArray[i2 + 1] == '*') {
                        int n8 = n6 - 1;
                        while (i2 < n8 && (cArray[i2] != '*' || cArray[i2 + 1] != '/')) {
                            cArray[i2++] = 32;
                        }
                        cArray[i2++] = 32;
                        cArray[i2++] = 32;
                        if (string2 != null) continue block13;
                        n4 = i2;
                        continue block13;
                    }
                    if (i2 >= n6 || cArray[i2 + 1] != '=') continue block13;
                    n7 = 3;
                    continue block13;
                }
                case '%': 
                case '*': 
                case '+': 
                case '-': {
                    if (i2 + 1 >= n6 || cArray[i2 + 1] != '=') continue block13;
                    n7 = ParseTools.opLookup(cArray[i2]);
                    continue block13;
                }
                case '=': {
                    string2 = new String(cArray, n4, i2 - n4 - (n7 != -1 ? 1 : 0)).trim();
                    n4 = i2 + 1;
                    continue block13;
                }
                case ',': {
                    if (n5 == -1) {
                        n5 = i2;
                    }
                    if (string2 == null) {
                        try {
                            if (string == null) {
                                MVEL.eval(new String(cArray, n4, n5 - n4), object, variableResolverFactory);
                            } else {
                                MVEL.eval(new StringBuilder(string).append('.').append(cArray, n4, n5 - n4).toString(), object, variableResolverFactory);
                            }
                        }
                        catch (CompileException compileException) {
                            compileException.setCursor(n4 + (compileException.getCursor() - (compileException.getExpr().length - n3)));
                            compileException.setExpr(cArray);
                            throw compileException;
                        }
                        n7 = -1;
                        n4 = ++i2;
                    } else {
                        try {
                            if (n7 != -1) {
                                if (string == null) {
                                    throw new CompileException("operative assignment not possible here", cArray, n2);
                                }
                                String string3 = new String(ParseTools.createShortFormOperativeAssignment(string + "." + string2, cArray, n4, n5 - n4, n7));
                                MVEL.setProperty(object, string2, MVEL.eval(string3, object, variableResolverFactory));
                            } else {
                                MVEL.setProperty(object, string2, MVEL.eval(cArray, n4, n5 - n4, object, variableResolverFactory));
                            }
                        }
                        catch (CompileException compileException) {
                            compileException.setCursor(n4 + (compileException.getCursor() - (compileException.getExpr().length - n3)));
                            compileException.setExpr(cArray);
                            throw compileException;
                        }
                        string2 = null;
                        n7 = -1;
                        n4 = ++i2;
                    }
                    n5 = -1;
                }
            }
        }
        n5 = n6;
        if (n4 != n5) {
            try {
                if (string2 == null || "".equals(string2)) {
                    if (string == null) {
                        MVEL.eval(new String(cArray, n4, n5 - n4), object, variableResolverFactory);
                    } else {
                        MVEL.eval(new StringAppender(string).append('.').append(cArray, n4, n5 - n4).toString(), object, variableResolverFactory);
                    }
                } else if (n7 != -1) {
                    if (string == null) {
                        throw new CompileException("operative assignment not possible here", cArray, n2);
                    }
                    MVEL.setProperty(object, string2, MVEL.eval(new String(ParseTools.createShortFormOperativeAssignment(string + "." + string2, cArray, n4, n5 - n4, n7)), object, variableResolverFactory));
                } else {
                    MVEL.setProperty(object, string2, MVEL.eval(cArray, n4, n6 - n4, object, variableResolverFactory));
                }
            }
            catch (CompileException compileException) {
                compileException.setCursor(n4 + (compileException.getCursor() - (compileException.getExpr().length - n3)));
                compileException.setExpr(cArray);
                throw compileException;
            }
        }
    }

    public static Object handleNumericConversion(char[] cArray, int n2, int n3) {
        if (n3 != 1 && cArray[n2] == '0' && cArray[n2 + 1] != '.') {
            if (!ParseTools.isDigit(cArray[n2 + n3 - 1])) {
                switch (cArray[n2 + n3 - 1]) {
                    case 'L': 
                    case 'l': {
                        return Long.decode(new String(cArray, n2, n3 - 1));
                    }
                    case 'I': {
                        return new BigInteger(new String(cArray, n2, n3 - 1));
                    }
                    case 'B': {
                        return new BigDecimal(new String(cArray, n2, n3 - 1));
                    }
                }
            }
            return Integer.decode(new String(cArray, n2, n3));
        }
        if (!ParseTools.isDigit(cArray[n2 + n3 - 1])) {
            switch (cArray[n2 + n3 - 1]) {
                case 'L': 
                case 'l': {
                    return Long.parseLong(new String(cArray, n2, n3 - 1));
                }
                case '.': 
                case 'D': 
                case 'd': {
                    return Double.parseDouble(new String(cArray, n2, n3 - 1));
                }
                case 'F': 
                case 'f': {
                    return Float.valueOf(Float.parseFloat(new String(cArray, n2, n3 - 1)));
                }
                case 'I': {
                    return new BigInteger(new String(cArray, n2, n3 - 1));
                }
                case 'B': {
                    return new BigDecimal(new String(cArray, n2, n3 - 1));
                }
            }
            throw new CompileException("unrecognized numeric literal", cArray, n2);
        }
        switch (ParseTools.numericTest(cArray, n2, n3)) {
            case 104: {
                return Float.valueOf(Float.parseFloat(new String(cArray, n2, n3)));
            }
            case 101: {
                return Integer.parseInt(new String(cArray, n2, n3));
            }
            case 102: {
                return Long.parseLong(new String(cArray, n2, n3));
            }
            case 103: {
                return Double.parseDouble(new String(cArray, n2, n3));
            }
            case 110: {
                return new BigDecimal(cArray, MathContext.DECIMAL128);
            }
        }
        return new String(cArray, n2, n3);
    }

    public static boolean isNumeric(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        return clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Short.TYPE || clazz == Double.TYPE || clazz == Float.TYPE || Number.class.isAssignableFrom(clazz);
    }

    public static int numericTest(char[] cArray, int n2, int n3) {
        boolean bl2 = false;
        int n4 = n2;
        if (n3 > 1) {
            if (cArray[n2] == '-') {
                ++n4;
            } else if (cArray[n2] == '~') {
                ++n4;
                if (cArray[n2 + 1] == '-') {
                    ++n4;
                }
            }
        }
        int n5 = n2 + n3;
        while (n4 < n5) {
            char c2 = cArray[n4];
            if (!ParseTools.isDigit(c2)) {
                switch (c2) {
                    case '.': {
                        bl2 = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        bl2 = true;
                        if (n4++ >= n5 || cArray[n4] != '-') break;
                        ++n4;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
            }
            ++n4;
        }
        if (n3 != 0) {
            if (bl2) {
                return 103;
            }
            if (n3 > 9) {
                return 102;
            }
            return 101;
        }
        return -1;
    }

    public static boolean isNumber(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            return ParseTools.isNumber((String)object);
        }
        if (object instanceof char[]) {
            return ParseTools.isNumber(new String((char[])object));
        }
        return object instanceof Integer || object instanceof BigDecimal || object instanceof BigInteger || object instanceof Float || object instanceof Double || object instanceof Long || object instanceof Short || object instanceof Character;
    }

    public static boolean isNumber(String string) {
        int n2 = string.length();
        boolean bl2 = true;
        int n3 = 0;
        if (n2 > 1) {
            if (string.charAt(0) == '-') {
                ++n3;
            } else if (string.charAt(0) == '~') {
                ++n3;
                if (string.charAt(1) == '-') {
                    ++n3;
                }
            }
        }
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (!ParseTools.isDigit(c2)) {
                if (c2 == '.' && bl2) {
                    bl2 = false;
                } else {
                    return false;
                }
            }
            ++n3;
        }
        return n2 > 0;
    }

    public static boolean isNumber(char[] cArray, int n2, int n3) {
        boolean bl2 = true;
        int n4 = n2;
        int n5 = n2 + n3;
        if (n3 > 1) {
            switch (cArray[n2]) {
                case '-': {
                    if (cArray[n2 + 1] == '-') {
                        ++n4;
                    }
                }
                case '~': {
                    ++n4;
                }
            }
        }
        while (n4 < n5) {
            char c2 = cArray[n4];
            if (!ParseTools.isDigit(c2)) {
                if (bl2 && c2 == '.') {
                    bl2 = false;
                } else {
                    if (n3 != 1 && n4 == n2 + n3 - 1) {
                        switch (c2) {
                            case 'B': 
                            case 'D': 
                            case 'F': 
                            case 'I': 
                            case 'L': 
                            case 'd': 
                            case 'f': 
                            case 'l': {
                                return true;
                            }
                            case '.': {
                                throw new CompileException("invalid number literal: " + new String(cArray), cArray, n2);
                            }
                        }
                        return false;
                    }
                    if (n4 == n2 + 1 && c2 == 'x' && cArray[n2] == '0') {
                        ++n4;
                        while (n4 < n5) {
                            c2 = cArray[n4];
                            if (!(ParseTools.isDigit(c2) || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f')) {
                                if (n4 == n3 - 1) {
                                    switch (c2) {
                                        case 'B': 
                                        case 'I': 
                                        case 'L': 
                                        case 'l': {
                                            return true;
                                        }
                                    }
                                }
                                return false;
                            }
                            ++n4;
                        }
                        return n3 - 2 > 0;
                    }
                    if (n4 != n2 && n4 + 1 < n5 && (c2 == 'E' || c2 == 'e')) {
                        if (cArray[++n4] == '-' || cArray[n4] == '+') {
                            ++n4;
                        }
                    } else {
                        if (n4 != n2) {
                            throw new CompileException("invalid number literal: " + new String(cArray, n2, n3), cArray, n2);
                        }
                        return false;
                    }
                }
            }
            ++n4;
        }
        return n5 > n2;
    }

    public static int find(char[] cArray, int n2, int n3, char c2) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            if (cArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public static int findLast(char[] cArray, int n2, int n3, char c2) {
        for (int i2 = n2 + n3; i2 >= n2; --i2) {
            if (cArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public static String createStringTrimmed(char[] cArray) {
        int n2;
        int n3 = cArray.length;
        for (n2 = 0; n2 != n3 && cArray[n2] < '!'; ++n2) {
        }
        while (n3 != n2 && cArray[n3 - 1] < '!') {
            --n3;
        }
        return new String(cArray, n2, n3 - n2);
    }

    public static String createStringTrimmed(char[] cArray, int n2, int n3) {
        if ((n3 = n2 + n3) > cArray.length) {
            return new String(cArray);
        }
        while (n2 != n3 && cArray[n2] < '!') {
            ++n2;
        }
        while (n3 != n2 && cArray[n3 - 1] < '!') {
            --n3;
        }
        return new String(cArray, n2, n3 - n2);
    }

    public static boolean endsWith(char[] cArray, int n2, int n3, char[] cArray2) {
        if (cArray2.length > cArray.length) {
            return false;
        }
        int n4 = cArray2.length - 1;
        int n5 = n2 + n3 - 1;
        while (n4 >= 0) {
            if (cArray[n5--] == cArray2[n4--]) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifierPart(int n2) {
        return n2 > 96 && n2 < 123 || n2 > 64 && n2 < 91 || n2 > 47 && n2 < 58 || n2 == 95 || n2 == 36 || Character.isJavaIdentifierPart(n2);
    }

    public static boolean isDigit(int n2) {
        return n2 > 47 && n2 < 58;
    }

    public static float similarity(String string, String string2) {
        char[] cArray;
        char[] cArray2;
        float f2;
        if (string == null || string2 == null) {
            return string == null && string2 == null ? 1.0f : 0.0f;
        }
        char[] cArray3 = string.toCharArray();
        char[] cArray4 = string2.toCharArray();
        float f3 = 0.0f;
        int n2 = 0;
        if (cArray3.length > cArray4.length) {
            f2 = cArray3.length;
            cArray2 = cArray3;
            cArray = cArray4;
        } else {
            f2 = cArray4.length;
            cArray2 = cArray4;
            cArray = cArray3;
        }
        while (n2 < cArray2.length && n2 < cArray.length) {
            if (cArray2[n2] == cArray[n2]) {
                f3 += 1.0f;
            }
            ++n2;
        }
        return f3 / f2;
    }

    public static int findAbsoluteLast(char[] cArray) {
        int n2 = 0;
        for (int i2 = cArray.length - 1; i2 >= 0; --i2) {
            if (cArray[i2] == ']') {
                ++n2;
            }
            if (cArray[i2] == '[') {
                --n2;
            }
            if ((n2 != 0 || cArray[i2] != '.') && cArray[i2] != '[') continue;
            return i2;
        }
        return -1;
    }

    public static Class getBaseComponentType(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static Class getSubComponentType(Class clazz) {
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static boolean isJunct(char c2) {
        switch (c2) {
            case '(': 
            case '[': {
                return true;
            }
        }
        return ParseTools.isWhitespace(c2);
    }

    public static int opLookup(char c2) {
        switch (c2) {
            case '|': {
                return 7;
            }
            case '&': {
                return 6;
            }
            case '^': {
                return 8;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 3;
            }
            case '+': {
                return 0;
            }
            case '%': {
                return 4;
            }
            case '\u00ab': {
                return 10;
            }
            case '\u00bb': {
                return 9;
            }
            case '\u00ac': {
                return 11;
            }
        }
        return -1;
    }

    public static boolean isReservedWord(String string) {
        return AbstractParser.LITERALS.containsKey(string) || AbstractParser.OPERATORS.containsKey(string);
    }

    public static boolean isNotValidNameorLabel(String string) {
        for (char c2 : string.toCharArray()) {
            if (c2 == '.') {
                return true;
            }
            if (ParseTools.isIdentifierPart(c2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyOnly(char[] cArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (ParseTools.isIdentifierPart(cArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isArrayType(char[] cArray, int n2, int n3) {
        return n3 > n2 + 2 && ParseTools.isPropertyOnly(cArray, n2, n3 - 2) && cArray[n3 - 2] == '[' && cArray[n3 - 1] == ']';
    }

    public static void checkNameSafety(String string) {
        if (ParseTools.isReservedWord(string)) {
            throw new RuntimeException("illegal use of reserved word: " + string);
        }
        if (ParseTools.isDigit(string.charAt(0))) {
            throw new RuntimeException("not an identifier: " + string);
        }
    }

    public static FileWriter getDebugFileWriter() throws IOException {
        return new FileWriter(new File(MVEL.getDebuggingOutputFileName()), true);
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        return clazz == Integer.class || clazz == Boolean.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Short.class || clazz == Byte.class;
    }

    public static Serializable subCompileExpression(char[] cArray) {
        return ParseTools._optimizeTree(new ExpressionCompiler(cArray)._compile());
    }

    public static Serializable subCompileExpression(char[] cArray, ParserContext parserContext) {
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(cArray, parserContext);
        return ParseTools._optimizeTree(expressionCompiler._compile());
    }

    public static Serializable subCompileExpression(char[] cArray, int n2, int n3, ParserContext parserContext) {
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(cArray, n2, n3, parserContext);
        return ParseTools._optimizeTree(expressionCompiler._compile());
    }

    public static Serializable subCompileExpression(String string, ParserContext parserContext) {
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(string, parserContext);
        return ParseTools._optimizeTree(expressionCompiler._compile());
    }

    public static Serializable optimizeTree(CompiledExpression compiledExpression) {
        if (!compiledExpression.isImportInjectionRequired() && compiledExpression.getParserConfiguration().isAllowBootstrapBypass() && compiledExpression.isSingleNode()) {
            return ParseTools._optimizeTree(compiledExpression);
        }
        return compiledExpression;
    }

    private static Serializable _optimizeTree(CompiledExpression compiledExpression) {
        if (compiledExpression.isSingleNode()) {
            ASTNode aSTNode = compiledExpression.getFirstNode();
            if (aSTNode.isLiteral() && !aSTNode.isThisVal()) {
                return new ExecutableLiteral(aSTNode.getLiteralValue());
            }
            return aSTNode.canSerializeAccessor() ? new ExecutableAccessorSafe(aSTNode, compiledExpression.getKnownEgressType()) : new ExecutableAccessor(aSTNode, compiledExpression.getKnownEgressType());
        }
        return compiledExpression;
    }

    public static boolean isWhitespace(char c2) {
        return c2 < '!';
    }

    public static String repeatChar(char c2, int n2) {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = c2;
        }
        return new String(cArray);
    }

    public static char[] loadFromFile(File file) throws IOException {
        return ParseTools.loadFromFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] loadFromFile(File file, String string) throws IOException {
        if (!file.exists()) {
            throw new RuntimeException("cannot find file: " + file.getName());
        }
        FileInputStream fileInputStream = null;
        FileChannel fileChannel = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(10);
            StringAppender stringAppender = new StringAppender((int)file.length(), string);
            int n2 = 0;
            while (n2 >= 0) {
                byteBuffer.rewind();
                byteBuffer.rewind();
                for (n2 = fileChannel.read(byteBuffer); n2 > 0; --n2) {
                    stringAppender.append(byteBuffer.get());
                }
            }
            char[] cArray = stringAppender.toChars();
            return cArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileChannel != null) {
                fileChannel.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readIn(InputStream inputStream, String string) throws IOException {
        try {
            int n2;
            byte[] byArray = new byte[10];
            StringAppender stringAppender = new StringAppender(10, string);
            while ((n2 = inputStream.read(byArray)) > 0) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringAppender.append(byArray[i2]);
                }
            }
            char[] cArray = stringAppender.toChars();
            return cArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static Class forNameWithInner(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return ParseTools.findInnerClass(string, classLoader, classNotFoundException);
        }
    }

    public static Class findInnerClass(String string, ClassLoader classLoader, ClassNotFoundException classNotFoundException) throws ClassNotFoundException {
        int n2 = string.lastIndexOf(46);
        while (n2 > 0) {
            string = string.substring(0, n2) + "$" + string.substring(n2 + 1);
            try {
                return Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                n2 = string.lastIndexOf(46);
            }
        }
        throw classNotFoundException;
    }

    static {
        HashMap<Class, Integer> hashMap = typeResolveMap = new HashMap();
        hashMap.put(BigDecimal.class, 110);
        hashMap.put(BigInteger.class, 111);
        hashMap.put(String.class, 1);
        hashMap.put(Integer.TYPE, 101);
        hashMap.put(Integer.class, 106);
        hashMap.put(Short.TYPE, 100);
        hashMap.put(Short.class, 105);
        hashMap.put(Float.TYPE, 104);
        hashMap.put(Float.class, 108);
        hashMap.put(Double.TYPE, 103);
        hashMap.put(Double.class, 109);
        hashMap.put(Long.TYPE, 102);
        hashMap.put(Long.class, 107);
        hashMap.put(Boolean.TYPE, 7);
        hashMap.put(Boolean.class, 15);
        hashMap.put(Byte.TYPE, 9);
        hashMap.put(Byte.class, 113);
        hashMap.put(Character.TYPE, 8);
        hashMap.put(Character.class, 112);
        hashMap.put(BlankLiteral.class, 200);
        typeCodes = new HashMap<Class, Integer>(30, 0.5f);
        typeCodes.put(Integer.class, 106);
        typeCodes.put(Double.class, 109);
        typeCodes.put(Boolean.class, 15);
        typeCodes.put(String.class, 1);
        typeCodes.put(Long.class, 107);
        typeCodes.put(Short.class, 105);
        typeCodes.put(Float.class, 108);
        typeCodes.put(Byte.class, 113);
        typeCodes.put(Character.class, 112);
        typeCodes.put(BigDecimal.class, 110);
        typeCodes.put(BigInteger.class, 111);
        typeCodes.put(Integer.TYPE, 101);
        typeCodes.put(Double.TYPE, 103);
        typeCodes.put(Boolean.TYPE, 7);
        typeCodes.put(Long.TYPE, 102);
        typeCodes.put(Short.TYPE, 100);
        typeCodes.put(Float.TYPE, 104);
        typeCodes.put(Byte.TYPE, 9);
        typeCodes.put(Character.TYPE, 8);
        typeCodes.put(BlankLiteral.class, 200);
    }
}

