/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps.exclusions;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.exclusions.c;
import com.contrastsecurity.agent.apps.exclusions.g;
import com.contrastsecurity.agent.apps.exclusions.j;
import com.contrastsecurity.agent.apps.exclusions.m;
import com.contrastsecurity.agent.apps.exclusions.q;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.k.a;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.messages.app.settings.IInputExclusion;
import com.contrastsecurity.agent.messages.app.settings.IQueueExclusion;
import com.contrastsecurity.agent.messages.app.settings.IUrlExclusion;
import com.contrastsecurity.agent.messages.app.settings.InputExceptionDTM;
import com.contrastsecurity.agent.messages.app.settings.QueueExclusionDTM;
import com.contrastsecurity.agent.messages.app.settings.RuleExceptionDTM;
import com.contrastsecurity.agent.messages.app.settings.UrlExceptionDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Set;

@DontObfuscate
public class DefaultExclusionProcessor
implements g {
    private final j inputExclusionManager = new j();
    private final q urlExclusionManager = new q();
    private final m queueExclusionManager = new m();
    private static final Logger logger = LoggerFactory.getLogger(DefaultExclusionProcessor.class);

    DefaultExclusionProcessor(List<? extends IInputExclusion> list, List<? extends IUrlExclusion> list2, List<? extends IQueueExclusion> list3) {
        this.parseInputExclusions(list);
        this.parseUrlExclusions(list2);
        this.parseQueueExclusions(list3);
    }

    public DefaultExclusionProcessor() {
    }

    @Override
    @o
    public void addRuleExceptionDTM(RuleExceptionDTM ruleExceptionDTM) {
        if (ruleExceptionDTM instanceof InputExceptionDTM) {
            this.inputExclusionManager.a((InputExceptionDTM)ruleExceptionDTM);
        } else if (ruleExceptionDTM instanceof UrlExceptionDTM) {
            this.urlExclusionManager.a((UrlExceptionDTM)ruleExceptionDTM);
        } else if (ruleExceptionDTM instanceof QueueExclusionDTM) {
            this.queueExclusionManager.a((QueueExclusionDTM)ruleExceptionDTM);
        }
    }

    @Override
    public boolean hasQuerystringExclusions(c.a a2) {
        return this.inputExclusionManager.a(a2);
    }

    @Override
    public boolean hasParameterExclusions(c.a a2) {
        return this.inputExclusionManager.b(a2);
    }

    @Override
    public boolean hasHeaderExclusions(c.a a2) {
        return this.inputExclusionManager.c(a2);
    }

    @Override
    public boolean hasCookieExclusions(c.a a2) {
        return this.inputExclusionManager.d(a2);
    }

    @Override
    public boolean hasUrlExclusions(c.a a2) {
        return this.urlExclusionManager.a(a2);
    }

    @Override
    public boolean isInputExclusion(c.a a2, String string, String string2, ExceptionInputTypeDTM exceptionInputTypeDTM) {
        return this.isInputExclusion(a2, string, string2, exceptionInputTypeDTM, null);
    }

    @Override
    public boolean isInputExclusion(c.a a2, String string, String string2, ExceptionInputTypeDTM exceptionInputTypeDTM, String string3) {
        a a3 = new a();
        switch (exceptionInputTypeDTM) {
            case BODY: {
                return this.inputExclusionManager.b(a3, a2, string, string2);
            }
            case COOKIE: {
                return this.inputExclusionManager.c(a3, a2, string, string2, string3);
            }
            case HEADER: {
                return this.inputExclusionManager.b(a3, a2, string, string2, string3);
            }
            case PARAMETER: {
                return this.inputExclusionManager.a(a3, a2, string, string2, string3);
            }
            case QUERYSTRING: {
                return this.inputExclusionManager.a(a3, a2, string, string2);
            }
        }
        logger.error("Unknown input type asked for in input exception: {}", (Object)exceptionInputTypeDTM);
        return false;
    }

    @Override
    public boolean isDisabledByUrl(c.a a2, String string, String string2) {
        return this.urlExclusionManager.a(new a(), a2, string, string2);
    }

    @Override
    public boolean isQueueExclusion(c.a a2, String string, String string2) {
        return this.queueExclusionManager.a(new a(), a2, string, string2);
    }

    @Override
    public Set<String> rulesDisabledByUrl(c.a a2, String string) {
        return this.urlExclusionManager.a(new a(), a2, string);
    }

    private void parseUrlExclusions(List<? extends IUrlExclusion> list) {
        if (list == null) {
            return;
        }
        for (IUrlExclusion iUrlExclusion : list) {
            try {
                this.urlExclusionManager.a(UrlExceptionDTM.fromExclusion(iUrlExclusion));
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Problem processing url exclusion {}", (Object)iUrlExclusion.getName(), (Object)throwable2);
            }
        }
    }

    private void parseInputExclusions(List<? extends IInputExclusion> list) {
        if (list == null) {
            return;
        }
        for (IInputExclusion iInputExclusion : list) {
            try {
                this.inputExclusionManager.a(InputExceptionDTM.fromExclusion(iInputExclusion));
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Problem processing input exclusion {}", (Object)iInputExclusion.getName(), (Object)throwable2);
            }
        }
    }

    private void parseQueueExclusions(List<? extends IQueueExclusion> list) {
        if (list == null) {
            return;
        }
        for (IQueueExclusion iQueueExclusion : list) {
            try {
                this.queueExclusionManager.a(QueueExclusionDTM.fromExclusion(iQueueExclusion));
            }
            catch (Throwable throwable) {
                Throwables.throwIfCritical(throwable);
                Throwable throwable2 = throwable;
                logger.error("Problem processing queue exclusion {}", (Object)iQueueExclusion.getName(), (Object)throwable2);
            }
        }
    }
}

