/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.commons;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.EmptyNavigableSet;
import com.contrastsecurity.agent.commons.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.stream.Collector;

@DontObfuscate
public final class Sets {
    public static <T> Collector<Collection<? extends T>, ?, Set<T>> flattenToSet() {
        return Collector.of(HashSet::new, Set::addAll, (set, set2) -> {
            set.addAll(set2);
            return set;
        }, Collections::unmodifiableSet, new Collector.Characteristics[0]);
    }

    public static <T> Set<T> copy(Collection<T> collection) {
        return !collection.isEmpty() ? Collections.unmodifiableSet(new HashSet<T>(collection)) : Collections.emptySet();
    }

    public static <T> HashSet<T> newHashSet(Collection<? extends T> collection) {
        return new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(T t2, T t3) {
        HashSet<T> hashSet = new HashSet<T>(2);
        hashSet.add(t2);
        hashSet.add(t3);
        return hashSet;
    }

    public static <T> HashSet<T> newHashSet(T t2, T t3, T t4) {
        HashSet<T> hashSet = new HashSet<T>(3);
        hashSet.add(t2);
        hashSet.add(t3);
        hashSet.add(t4);
        return hashSet;
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T t2, T t3, T t4, T ... TArray) {
        HashSet<T> hashSet = new HashSet<T>(TArray.length + 3);
        hashSet.add(t2);
        hashSet.add(t3);
        hashSet.add(t4);
        hashSet.addAll(Arrays.asList(TArray));
        return hashSet;
    }

    public static <T> Set<T> of() {
        return Collections.emptySet();
    }

    public static <T> Set<T> of(T t2) {
        return Collections.singleton(t2);
    }

    public static <T> Set<T> of(T t2, T t3) {
        return Collections.unmodifiableSet(Sets.newHashSet(t2, t3));
    }

    public static <T> Set<T> of(T t2, T t3, T t4) {
        return Collections.unmodifiableSet(Sets.newHashSet(t2, t3, t4));
    }

    @SafeVarargs
    public static <T> Set<T> of(T t2, T t3, T t4, T ... TArray) {
        return Collections.unmodifiableSet(Sets.newHashSet(t2, t3, t4, TArray));
    }

    public static <T> Set<T> of(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptySet();
        }
        HashSet<T> hashSet = new HashSet<T>();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> NavigableSet<T> emptyNavigableSet() {
        return EmptyNavigableSet.INSTANCE;
    }

    private Sets() {
    }

    @DontObfuscate
    public static final class Builder<T> {
        private Set<T> set = new HashSet<T>();

        private Builder() {
        }

        public Builder<T> add(T t2) {
            Preconditions.check(this.set != null, "This one-time-use set builder has already built a set.");
            this.set.add(t2);
            return this;
        }

        public Builder<T> addAll(Collection<T> collection) {
            Preconditions.check(this.set != null, "This one-time-use set builder has already built a set.");
            this.set.addAll(collection);
            return this;
        }

        public Set<T> build() {
            Preconditions.check(this.set != null, "This one-time-use set builder has already built a set.");
            Set<T> set = this.set;
            this.set = null;
            return Collections.unmodifiableSet(set);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }
    }
}

