/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.context;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.ApplicationContext;
import com.contrastsecurity.agent.commons.b;
import com.contrastsecurity.agent.http.HttpContext;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.observe.RootSpan;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.scope.ScopeProviderAssess;
import com.contrastsecurity.agent.scope.ScopeProviderAssessImpl;
import com.contrastsecurity.agent.scope.ScopeProviderImpl;

@DontObfuscate
public class ContrastContext
implements b<ContrastContext> {
    private final HttpContext http;
    private final ApplicationContext application;
    private final ScopeProvider scopeProvider;
    private final ScopeProviderAssess scopeProviderAssess;
    protected static ThreadLocal<ContrastContext> CONTEXT;
    private AssessmentContext assessment;
    private ProtectContext protect;
    private RootSpan observe;

    public static void enableThreadLocal() {
        CONTEXT = ThreadLocal.withInitial(ContrastContext::new);
    }

    protected ContrastContext() {
        this.http = new HttpContext();
        this.application = new ApplicationContext();
        this.scopeProvider = new ScopeProviderImpl();
        this.scopeProviderAssess = new ScopeProviderAssessImpl(this.scopeProvider);
    }

    protected ContrastContext(ContrastContext contrastContext) {
        this.http = contrastContext.http().copy();
        this.application = contrastContext.application().copy();
        this.assessment = contrastContext.assessment();
        this.protect = contrastContext.protect();
        this.observe = contrastContext.observe();
        this.scopeProvider = new ScopeProviderImpl();
        this.scopeProviderAssess = new ScopeProviderAssessImpl(this.scopeProvider);
    }

    public static void initialize() {
        ApplicationContext.class.getName();
        AssessmentContext.class.getName();
        HttpContext.class.getName();
        ProtectContext.class.getName();
        RootSpan.class.getName();
        ScopeProvider.class.getName();
        ScopeProviderAssess.class.getName();
        ScopeProviderAssessImpl.class.getName();
        ScopeProviderImpl.class.getName();
    }

    public void clear() {
        this.assessment = null;
        this.protect = null;
        this.observe = null;
        this.application.clear();
        this.http.clear();
    }

    @o
    public void resetForTesting() {
        this.clear();
        while (this.scopeProvider.inScope()) {
            this.scopeProvider.leaveScope();
        }
    }

    public ApplicationContext application() {
        return this.application;
    }

    public AssessmentContext assessment() {
        if (this.assessment != null) {
            this.assessment.updateLastAccess();
        }
        return this.assessment;
    }

    public AssessmentContext assessment(AssessmentContext assessmentContext) {
        this.assessment = assessmentContext;
        return assessmentContext;
    }

    public HttpContext http() {
        return this.http;
    }

    public RootSpan observe() {
        return this.observe;
    }

    public RootSpan observe(RootSpan rootSpan) {
        this.observe = rootSpan;
        return rootSpan;
    }

    public ProtectContext protect() {
        if (this.protect == null) {
            this.protect = new ProtectContext();
        }
        return this.protect;
    }

    public ProtectContext protect(ProtectContext protectContext) {
        this.protect = protectContext;
        return protectContext;
    }

    public ScopeProvider scopeProvider() {
        return this.scopeProvider;
    }

    public ScopeProviderAssess scopeProviderAssess() {
        return this.scopeProviderAssess;
    }

    @Override
    public ContrastContext copy() {
        return new ContrastContext(this);
    }

    public String toString() {
        return "ContrastContext{application=" + this.application + ", http=" + this.http + ", scopeProvider=" + this.scopeProvider + ", scopeProviderAssess=" + this.scopeProviderAssess + ", assessment=" + this.assessment + ", protect=" + this.protect + ", observe=" + this.observe + '}';
    }

    public static ContrastContext current() {
        return CONTEXT.get();
    }
}

