/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.contrastapi_v1_0.inventory;

import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.contrastapi_v1_0.inventory.RoutingFrameworkDTM;
import com.contrastsecurity.agent.messages.routes.DiscoveredRoute;
import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class ApplicationInventoryDTM {
    @SerializedName(value="session_id")
    private final String sessionId;
    @SerializedName(value="routing_frameworks")
    private final RoutingFrameworkDTM routingFrameworks;
    @SerializedName(value="routes")
    private final Set<DiscoveredRoute> discoveredRoutes;

    public static ApplicationInventoryDTM of(String string, Set<DiscoveredRoute> set) {
        return new ApplicationInventoryDTM(string, new RoutingFrameworkDTM(false, Collections.emptySet()), set);
    }

    public static Collector<ApplicationInventoryDTM, ?, Set<ApplicationInventoryDTM>> combineApplicationInventoryDTMs() {
        return Collectors.collectingAndThen(Collectors.groupingBy(ApplicationInventoryDTM::sessionId, Collectors.mapping(ApplicationInventoryDTM::discoveredRoutes, Sets.flattenToSet())), map -> map.entrySet().stream().map(entry -> ApplicationInventoryDTM.of((String)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toSet()));
    }

    private ApplicationInventoryDTM(String string, RoutingFrameworkDTM routingFrameworkDTM, Set<DiscoveredRoute> set) {
        this.sessionId = Objects.requireNonNull(string);
        this.routingFrameworks = Objects.requireNonNull(routingFrameworkDTM);
        this.discoveredRoutes = Objects.requireNonNull(set);
    }

    public String sessionId() {
        return this.sessionId;
    }

    public Collection<DiscoveredRoute> discoveredRoutes() {
        return this.discoveredRoutes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ApplicationInventoryDTM applicationInventoryDTM = (ApplicationInventoryDTM)object;
        if (!this.sessionId.equals(applicationInventoryDTM.sessionId)) {
            return false;
        }
        return this.discoveredRoutes.equals(applicationInventoryDTM.discoveredRoutes);
    }

    public int hashCode() {
        int n2 = this.sessionId.hashCode();
        n2 = 31 * n2 + this.discoveredRoutes.hashCode();
        return n2;
    }

    public String toString() {
        return "ApplicationInventoryDTM{sessionId='" + this.sessionId + '\'' + ", routingFrameworks='" + this.routingFrameworks + '\'' + ", discoveredRoutes=" + this.discoveredRoutes + '}';
    }
}

