/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.c;
import com.contrastsecurity.agent.c.a;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.commons.SystemClock;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.ConfigUpdatable;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.core.ContrastVersion;
import com.contrastsecurity.agent.core.b;
import com.contrastsecurity.agent.f;
import com.contrastsecurity.agent.f.k;
import com.contrastsecurity.agent.g;
import com.contrastsecurity.agent.l;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.i;
import com.contrastsecurity.agent.s.D;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeModule;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.e;
import com.contrastsecurity.agent.startup.w;
import com.contrastsecurity.agent.telemetry.h;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.util.H;
import com.contrastsecurity.agent.util.I;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@DontObfuscate
public class ContrastAgent {
    private static final String DELAYED_BOOT_STRATEGY = "boot";
    private static final String DELAYED_ACTIVATION_STRATEGY = "activation";
    private static final String ERROR_PROBABILISTIC_VALUE = "Unable to process probabilistic startup value";

    public static void setup(String string, Instrumentation instrumentation, File file, StartupTiming startupTiming) {
        Objects.requireNonNull(instrumentation);
        ContrastContext.enableThreadLocal();
        ContrastAgent.scopedSetup(string, instrumentation, file, startupTiming);
    }

    @ScopedSensor
    public static void scopedSetup(String string, Instrumentation instrumentation, File file, StartupTiming startupTiming) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            ConfigUpdatable configUpdatable;
            com.contrastsecurity.agent.r.a.a(file);
            H h2 = I.b();
            ContrastAgent.patchLiferayLocaleErrors();
            e e2 = new e();
            try {
                configUpdatable = e2.a(string);
            }
            catch (com.contrastsecurity.agent.config.c.c c2) {
                PreConfigUtil.err("Couldn't initialize Contrast. Invalid configuration: " + c2.getMessage());
                c2.printStackTrace(System.err);
                ContrastAgent.logStartingWithoutContrast();
                scopeAggregator.leaveScope();
                return;
            }
            com.contrastsecurity.agent.config.g.a(configUpdatable);
            h2.b();
            startupTiming.configLoadTimeNs(h2.e());
            boolean bl2 = configUpdatable.getBoolean(ConfigProperty.SUPPRESS_STDOUT);
            if (bl2) {
                PreConfigUtil.quiet();
            }
            if (ContrastAgent.isAgentStartupDisabled(configUpdatable)) {
                scopeAggregator.leaveScope();
                return;
            }
            int n2 = ContrastAgent.getStartupDelay(configUpdatable);
            if (n2 > 0) {
                ContrastAgent.delayedStartup(instrumentation, configUpdatable, file, n2, startupTiming);
            } else {
                ContrastEngine contrastEngine = ContrastAgent.startup(instrumentation, configUpdatable, file, startupTiming);
                if (contrastEngine != null) {
                    contrastEngine.activatePlugins();
                }
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @o
    static boolean isAgentStartupDisabled(com.contrastsecurity.agent.config.e e2) {
        if (!e2.getBoolean(ConfigProperty.ENABLED)) {
            return true;
        }
        try {
            a a2 = ContrastAgent.probabilisticStartupCheck(e2);
            return a2 != null && !a2.a();
        }
        catch (FatalStartupException fatalStartupException) {
            return true;
        }
    }

    private static a probabilisticStartupCheck(com.contrastsecurity.agent.config.e e2) throws FatalStartupException {
        int n2;
        try {
            n2 = e2.getInt(ConfigProperty.PROBABILISTIC_STARTUP);
        }
        catch (com.contrastsecurity.agent.config.c.c c2) {
            ContrastAgent.logProbabilisticStartupConfigError("Probabilistic startup was specified but with non-numeric value");
            throw new FatalStartupException(ERROR_PROBABILISTIC_VALUE);
        }
        if (n2 != -1) {
            try {
                return new a(n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ContrastAgent.logProbabilisticStartupConfigError("Probabilistic startup was specified but with an invalid value: " + n2);
                throw new FatalStartupException(ERROR_PROBABILISTIC_VALUE);
            }
        }
        return null;
    }

    private static void logProbabilisticStartupConfigError(String string) {
        PreConfigUtil.err(string);
        PreConfigUtil.err("Please specify a number between 1 and 99 (percentage)");
        ContrastAgent.logStartingWithoutContrast();
    }

    private static void logStartingWithoutContrast() {
        PreConfigUtil.err("Continuing without Contrast...");
    }

    private static void delayedStartup(Instrumentation instrumentation, ConfigUpdatable configUpdatable, File file, int n2, StartupTiming startupTiming) {
        String string = configUpdatable.getOrNull(ConfigProperty.DELAYED_STARTUP_STRATEGY);
        if (string == null || DELAYED_ACTIVATION_STRATEGY.equalsIgnoreCase(string)) {
            ContrastEngine contrastEngine = ContrastAgent.startup(instrumentation, configUpdatable, file, startupTiming);
            f f2 = new f(contrastEngine, n2, contrastEngine.getErrorEmitter());
            f2.setDaemon(true);
            f2.start();
        } else if (DELAYED_BOOT_STRATEGY.equalsIgnoreCase(string)) {
            g g2 = new g(n2, instrumentation, configUpdatable, file, startupTiming);
            g2.setDaemon(true);
            g2.start();
        } else {
            PreConfigUtil.err("Invalid delayed startup strategy (" + string + ")");
        }
    }

    static int getStartupDelay(com.contrastsecurity.agent.config.e e2) {
        int n2 = 0;
        try {
            n2 = e2.getInt(ConfigProperty.DELAYED_STARTUP);
        }
        catch (com.contrastsecurity.agent.config.c.c c2) {
            // empty catch block
        }
        return Math.max(n2, 0);
    }

    public static ContrastEngine startup(Instrumentation instrumentation, ConfigUpdatable configUpdatable, File file, StartupTiming startupTiming) {
        H h2 = I.b();
        PreConfigUtil.out("Starting Contrast (build " + ContrastVersion.VERSION + ") Pat. 8,458,789 B2");
        com.contrastsecurity.agent.services.b b2 = new com.contrastsecurity.agent.services.b();
        D d2 = D.a((com.contrastsecurity.agent.config.e)configUpdatable, file);
        com.contrastsecurity.agent.logging.c c2 = com.contrastsecurity.agent.logging.log4j2.f.a(configUpdatable, d2, b2);
        Logger logger = LoggerFactory.getLogger(ContrastAgent.class);
        try {
            k k2 = new k();
            ObjectShare.initGson(configUpdatable, k2);
            SystemClock systemClock = new SystemClock();
            h h3 = h.a((com.contrastsecurity.agent.config.e)configUpdatable, d2, systemClock);
            TelemetryMetrics telemetryMetrics = h3.d();
            c2.a(b2, telemetryMetrics);
            com.contrastsecurity.agent.telemetry.metrics.c.g.a(telemetryMetrics, systemClock);
            com.contrastsecurity.agent.telemetry.c c3 = new com.contrastsecurity.agent.telemetry.c(telemetryMetrics.isEnabled());
            com.contrastsecurity.agent.o.b b3 = com.contrastsecurity.agent.o.b.a();
            ContrastEngine contrastEngine = ContrastAgent.createContrastEngine(instrumentation, configUpdatable, new com.contrastsecurity.agent.plugins.apps.g(), c2, startupTiming, d2, b2, systemClock, h3, c3, b3, k2);
            h2.b();
            String string = "JVM uptime time before agent: " + startupTiming.getJvmUptimeAtPremainMs() + "ms";
            PerfUtil.printStartupTimingMessage(string);
            long l2 = TimeUnit.NANOSECONDS.toMillis(startupTiming.getTimeForJarTmpInjectionNs());
            PerfUtil.printStartupTimingMessage(PerfUtil.a.a, "jar-injection", l2);
            c3.a(PerfUtil.a.a, "load-config", startupTiming.configLoadMs());
            c3.a(PerfUtil.a.a, "primordial", h2);
            contrastEngine.start(startupTiming);
            return contrastEngine;
        }
        catch (FatalStartupException fatalStartupException) {
            PreConfigUtil.err("Couldn't initialize Contrast. See log for details.");
            logger.error("Unexpected error starting up. Continuing without Contrast", fatalStartupException);
            return null;
        }
    }

    @o
    static void patchLiferayLocaleErrors() {
        String string = l.b("java.locale.providers");
        if (string == null || string.isEmpty()) {
            return;
        }
        String string2 = string.toUpperCase(Locale.ROOT);
        if (!string2.contains("COMPAT")) {
            return;
        }
        String[] stringArray = string2.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (string3.trim().equals("COMPAT")) {
                stringBuilder.append("JRE");
                continue;
            }
            stringBuilder.append(string3.trim());
        }
        l.a("java.locale.providers", stringBuilder.toString());
    }

    @o
    static ContrastEngine createContrastEngine(Instrumentation instrumentation, ConfigUpdatable configUpdatable, com.contrastsecurity.agent.plugins.apps.g g2, com.contrastsecurity.agent.logging.c c2, StartupTiming startupTiming, D d2, com.contrastsecurity.agent.services.b b2, Clock clock, h h2, com.contrastsecurity.agent.telemetry.c c3, com.contrastsecurity.agent.o.b b3, k k2) throws FatalStartupException {
        WorkingDirectories workingDirectories;
        try {
            workingDirectories = WorkingDirectories.fromConfig(configUpdatable);
        }
        catch (IOException iOException) {
            throw new c("Unable to create references to working directories", iOException);
        }
        b b4 = new b(g2, b3, clock, configUpdatable, b2, instrumentation, c2, k2, d2, startupTiming, c3, h2, workingDirectories);
        com.contrastsecurity.agent.l.a a2 = b4.j();
        i i2 = b4.e();
        com.contrastsecurity.agent.telemetry.errors.o o2 = h2.g();
        g2.addListener(configUpdatable);
        List<com.contrastsecurity.agent.services.a> list = b4.m();
        com.contrastsecurity.agent.services.ngreporting.f f2 = b4.l();
        List<w> list2 = b4.n();
        return new ContrastEngine(instrumentation, d2, configUpdatable, list2, clock, list, i2, f2, ScopeModule.scopeProvider(), workingDirectories, h2.d(), o2, a2.d(), c2, b2, c3, b4.k(), b4.o());
    }
}

