/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.o;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpRequestFactory;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MemoryBuffer;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.a;
import com.contrastsecurity.agent.http.g;
import com.contrastsecurity.agent.http.h;
import com.contrastsecurity.agent.http.i;
import com.contrastsecurity.agent.http.k;
import com.contrastsecurity.agent.http.l;
import com.contrastsecurity.agent.http.n;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.n.c;
import com.contrastsecurity.agent.plugins.protect.rules.f.d;
import com.contrastsecurity.agent.pool.ObjectPool;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.telemetry.metrics.Counter;
import com.contrastsecurity.agent.telemetry.metrics.DistributionSummary;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@DontObfuscate
@m
public class HttpManager
implements a {
    private final com.contrastsecurity.agent.plugins.i pluginManager;
    private final AtomicBoolean isFirstRequest;
    private final g firstRequestEndListener;
    private final c eventBus;
    private final ObjectPool<MemoryBuffer> memoryBufferPool;
    private final DistributionSummary contentLengthDistributionSummary;
    private final DistributionSummary memoryBufferDistributionSummary;
    private final Counter multipartContentTypeCounter;
    private final DistributionSummary multipartContentLengthDistributionSummary;
    private final boolean featureSamplingEnabled;
    private final int featureSamplingFrequency;
    private static final String[] ALLOWED_CONTENT_TYPES = new String[]{"text/html", "text/plain", "application/xhtml", "application/xml"};
    private static final Logger logger = LoggerFactory.getLogger(HttpManager.class);

    public HttpManager(e e2, com.contrastsecurity.agent.plugins.i i2, g g2, c c2, Clock clock, TelemetryMetrics telemetryMetrics) {
        this.pluginManager = i2;
        this.firstRequestEndListener = g2;
        this.isFirstRequest = new AtomicBoolean(true);
        this.eventBus = c2;
        this.featureSamplingEnabled = e2.getBoolean(ConfigProperty.FEATURE_REQUEST_SAMPLING_ENABLED);
        this.featureSamplingFrequency = e2.getInt(ConfigProperty.FEATURE_REQUEST_SAMPLING_FREQUENCY);
        this.memoryBufferPool = new MemoryBuffer.MemoryBufferPool(clock, e2);
        this.contentLengthDistributionSummary = telemetryMetrics.newDistributionSummary("requestContentLengthExpanded", TelemetryMetrics.TelemetryCategory.MEMORY_BUFFER).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("The Content-Length of requests as defined by the content-length header").withBucketBoundaries(d.j).withBaseUnit("bytes").register();
        this.memoryBufferDistributionSummary = telemetryMetrics.newDistributionSummary("memoryBufferTotalCountExpanded", TelemetryMetrics.TelemetryCategory.MEMORY_BUFFER).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("Number of Objects Currently Being Managed by MemoryBufferPool").withBucketBoundaries(d.j).withBaseUnit("count").register();
        this.multipartContentTypeCounter = telemetryMetrics.newCounter("multipartContentTypeCount", TelemetryMetrics.TelemetryCategory.GENERAL).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("The number of requests seen with a Multipart Content-Type").register();
        this.multipartContentLengthDistributionSummary = telemetryMetrics.newDistributionSummary("multipartContentLengths", TelemetryMetrics.TelemetryCategory.GENERAL).withExpiration(LocalDate.of(2025, Month.APRIL, 1)).withDescription("The Content-Length of Multipart requests as defined by the content-length header").withBucketBoundaries(d.j).withBaseUnit("bytes").register();
    }

    public ObjectPool<MemoryBuffer> getMemoryBufferPool() {
        return this.memoryBufferPool;
    }

    public HttpRequest onRequestStart(ContrastContext contrastContext, HttpRequestFactory httpRequestFactory) {
        if (contrastContext == null) {
            logger.debug("ContrastContext was null, cannot continue");
            return null;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Application is null, cannot continue");
            return null;
        }
        if (httpRequestFactory == null) {
            logger.debug("HttpRequestFactory is null, cannot continue");
            return null;
        }
        HttpRequest httpRequest = httpRequestFactory.newInstance();
        if (httpRequest == null) {
            logger.debug("HttpRequest was null, cannot continue");
            return null;
        }
        contrastContext.http().setRequest(httpRequest);
        this.preCalculateUrlExclusions(application, httpRequest);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<l> list = contrastPlugin.getRequestLifecycleListeners();
            for (l l2 : list) {
                l2.a(httpRequest, application);
            }
            if (!contrastPlugin.requiresHttpRequestBodyBuffering(httpRequest)) {
                return;
            }
            httpRequest.enableCapturing();
            atomicInteger.set(Math.max(atomicInteger.get(), contrastPlugin.limitRequestBodySizeCapturing()));
            contrastContext.http().addRequestBodyListeners(contrastPlugin.getRequestBodyListeners());
        });
        if (atomicInteger.get() > 0) {
            httpRequest.maxBufferSize(Math.min(atomicInteger.get(), httpRequest.getContentLength()));
        }
        this.pluginManager.forEachDisabled(application, httpRequest, contrastPlugin -> {
            List<l> list = contrastPlugin.getRequestLifecycleListeners();
            for (l l2 : list) {
                l2.a();
            }
        });
        return httpRequest;
    }

    @ScopedSensor
    public void onByteRead(ContrastContext contrastContext, int n2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            HttpRequest httpRequest = contrastContext.http().getRequest();
            if (httpRequest != null && n2 > -1 && httpRequest.writeToBuffer(this.memoryBufferPool, n2)) {
                HttpManager.notifyListenersOnRequestBodyRead(contrastContext);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onBytesRead(ContrastContext contrastContext, byte[] byArray, int n2) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            this.onBytesRead(contrastContext, n2, byArray, 0, n2);
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    @ScopedSensor
    public void onBytesRead(ContrastContext contrastContext, int n2, byte[] byArray, int n3, int n4) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            HttpRequest httpRequest = contrastContext.http().getRequest();
            if (httpRequest != null && httpRequest.writeToBuffer(this.memoryBufferPool, byArray, n3, n4, n2)) {
                HttpManager.notifyListenersOnRequestBodyRead(contrastContext);
            }
            scopeAggregator.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    public void onResponseStart(ContrastContext contrastContext, HttpResponse httpResponse) {
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Current HTTPRequest was null");
            return;
        }
        if (httpResponse == null) {
            logger.debug("HttpResponse was null");
            return;
        }
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application was null");
            return;
        }
        contrastContext.http().setResponse(httpResponse);
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            if (contrastPlugin.requiresHttpResponseBuffering(httpRequest)) {
                httpResponse.enableCapturing();
                logger.debug("Capturing response to memory");
            }
        });
    }

    public void onResponseHeaderSet(ContrastContext contrastContext, String string, String string2) {
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            logger.debug("Header name or value was blank, header: {}, headerVal: {}", (Object)string, (Object)string2);
            return;
        }
        HttpContext httpContext = contrastContext.http();
        HttpResponse httpResponse = httpContext.getResponse();
        if (httpContext.getRequest() == null) {
            logger.debug("Request was null");
            return;
        }
        if (httpResponse == null) {
            logger.debug("Response was null");
            return;
        }
        boolean bl2 = false;
        h h2 = h.a(string);
        if (h2 == n.k && string2.contains("attachment")) {
            bl2 = true;
        } else if (h2 == n.t && !StringUtils.startsWithAny(string2.toLowerCase(), ALLOWED_CONTENT_TYPES)) {
            bl2 = true;
        }
        Map<String, List<String>> map = httpResponse.getHeaders();
        List list = map.getOrDefault(h2.headerName(), new ArrayList());
        list.add(string2);
        map.put(h2.headerName(), list);
        if (bl2) {
            httpResponse.disableCapturing();
            logger.debug("Disabling saving response to memory:{}: {}, {}", string, string2, contrastContext.http().getRequest().getUri());
        }
        this.pluginManager.forEachEnabled(contrastContext.application().current(), httpContext.getRequest(), contrastPlugin -> {
            List<l> list = contrastPlugin.getRequestLifecycleListeners();
            for (l l2 : list) {
                l2.a(httpContext.getRequest(), httpContext.getResponse(), string, string2);
            }
        });
    }

    public void onRequestEnd(ContrastContext contrastContext) {
        Object object;
        HttpContext httpContext = contrastContext.http();
        HttpRequest httpRequest = httpContext.getRequest();
        if (httpRequest == null || !httpRequest.endRequest()) {
            return;
        }
        HttpResponse httpResponse = httpContext.getResponse();
        if (httpResponse != null) {
            this.eventBus.a(httpRequest, httpResponse);
        }
        if (logger.isDebugEnabled()) {
            object = httpResponse != null ? httpResponse.getOutputMechanism() : null;
            logger.debug("Request ending for {} - response is {} and output mechanism is {}", httpRequest.getUri(), JVMUtils.getSafeToString(httpResponse, true), httpResponse != null ? JVMUtils.getSafeToString(object, true) : "response-null");
            if (httpResponse != null && httpResponse.getOutputMechanism() != null) {
                Object object2 = httpResponse.getOutputMechanism();
                logger.debug("De-assigning output mechanism {}", (Object)JVMUtils.getSafeToString(object2, true));
            }
        }
        this.analyzeResponseContents(httpRequest, httpResponse);
        if (logger.isDebugEnabled() && httpResponse == null) {
            this.logCrumbData(httpRequest);
        }
        object = contrastContext.application().current();
        this.pluginManager.forEachEnabled((Application)object, httpRequest, contrastPlugin -> {
            List<l> list = contrastPlugin.getRequestLifecycleListeners();
            for (l l2 : list) {
                try {
                    l2.onRequestEnd(httpRequest, httpResponse);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.warn("Problem ending request watching with {}", (Object)l2, (Object)throwable2);
                }
            }
        });
        this.pluginManager.forEachDisabled((Application)object, httpRequest, contrastPlugin -> {
            List<l> list = contrastPlugin.getRequestLifecycleListeners();
            for (l l2 : list) {
                try {
                    l2.b();
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.warn("Problem ending request watching with {}", (Object)l2, (Object)throwable2);
                }
            }
        });
        this.contentLengthDistributionSummary.record(httpRequest.getContentLength());
        this.memoryBufferDistributionSummary.record(this.getMemoryBufferPool().getTotalObjectCount());
        if (httpRequest.getContentType().h()) {
            this.multipartContentTypeCounter.increment();
            this.multipartContentLengthDistributionSummary.record(httpRequest.getContentLength());
        }
        httpRequest.closeBuffer();
        if (httpResponse != null) {
            httpResponse.closeBuffer();
        }
        httpContext.setRequest(null);
        httpContext.setResponse(null);
        contrastContext.application().current(null);
        long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - httpRequest.startTimeNs());
        httpRequest.getJfrEvent().a(httpRequest, httpResponse);
        if (logger.isDebugEnabled()) {
            logger.debug("{}{}|RequestEnded|uri={}&elapsed={}", "!LM!", "RequestTime", httpRequest.getNormalizedUri(), l2);
        }
        if (this.isFirstRequest.get() && this.isFirstRequest.getAndSet(false)) {
            this.firstRequestEndListener.onFirstRequestEnd(l2);
        }
    }

    public void onMultipartHeaderRead(ContrastContext contrastContext, MultipartItem multipartItem) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application is null");
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Current request is null");
            return;
        }
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<l> list = contrastPlugin.getRequestLifecycleListeners();
            for (l l2 : list) {
                l2.a(httpRequest, multipartItem);
            }
        });
    }

    public void onParametersResolved(ContrastContext contrastContext) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application is null");
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Current request is null");
            return;
        }
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<l> list = contrastPlugin.getRequestLifecycleListeners();
            for (l l2 : list) {
                l2.a(httpRequest);
            }
        });
    }

    public void onMoreParametersResolved(ContrastContext contrastContext, Map<String, String[]> map) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application is null");
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Current request is null");
            return;
        }
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<l> list = contrastPlugin.getRequestLifecycleListeners();
            for (l l2 : list) {
                l2.a(httpRequest, map);
            }
        });
    }

    @Override
    public void onBodyInputReceived(ContrastContext contrastContext, com.contrastsecurity.agent.plugins.protect.d.i i2, String string, String string2) {
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application is null");
            return;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            logger.debug("Current request is null");
            return;
        }
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<l> list = contrastPlugin.getRequestLifecycleListeners();
            for (l l2 : list) {
                l2.a(string, string2, i2);
            }
        });
    }

    public boolean isSamplingCurrentRequest(ContrastContext contrastContext, i i2) {
        if (!this.featureSamplingEnabled) {
            return false;
        }
        HttpRequest httpRequest = contrastContext.http().getRequest();
        return httpRequest != null && httpRequest.isSampling(i2, this::initialIsSamplingValue);
    }

    private void analyzeResponseContents(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpRequest == null || httpResponse == null || !httpResponse.isCapturingEnabled()) {
            return;
        }
        String string = httpRequest.getUri();
        if (httpResponse.isBufferEmpty()) {
            logger.debug("Response was empty for URI {}", (Object)string);
            return;
        }
        String string2 = httpResponse.getBufferAsString();
        logger.debug("Scanning {} response text with length {}/charset {}", string, string2.length(), httpResponse.getCharset());
        Application application = ContrastContext.current().application().current();
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<l> list = contrastPlugin.getRequestLifecycleListeners();
            for (l l2 : list) {
                try {
                    l2.a(httpRequest, httpResponse, string2);
                }
                catch (Throwable throwable) {
                    Throwables.throwIfCritical(throwable);
                    Throwable throwable2 = throwable;
                    logger.warn("Problem ending request watching with {}", (Object)l2, (Object)throwable2);
                }
            }
        });
    }

    private void logCrumbData(HttpRequest httpRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < Math.min(10, stackTraceElementArray.length); ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder.append("\t\t").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")\n");
        }
        logger.debug("Unexpected null response for request=[{}], CRUMB:\n{}", (Object)httpRequest, (Object)stringBuilder);
    }

    private boolean initialIsSamplingValue(i i2) {
        return ThreadLocalRandom.current().nextInt(1, this.featureSamplingFrequency + 1) == 1;
    }

    private void preCalculateUrlExclusions(Application application, HttpRequest httpRequest) {
        o o2 = o.a(httpRequest.getUri(), application.getExclusionProcessor());
        httpRequest.context().put(o.b, o2);
    }

    private static void notifyListenersOnRequestBodyRead(ContrastContext contrastContext) {
        HttpContext httpContext = contrastContext.http();
        for (k k2 : httpContext.getRequestBodyListeners()) {
            k2.a(httpContext);
        }
    }
}

