/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.architecture;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.messages.app.activity.inventory.ArchitectureComponentDTM;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@DontObfuscate
public final class ApplicationArchitecture {
    private final Set<ArchitectureComponent> components = new HashSet<ArchitectureComponent>();
    @o
    static int MAX_SIZE_COMPONENTS = 500;

    public static ApplicationArchitecture create() {
        return new ApplicationArchitecture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addComponent(ArchitectureComponent architectureComponent) {
        if (architectureComponent != null && !this.components.contains(architectureComponent) && this.components.size() < MAX_SIZE_COMPONENTS) {
            Set<ArchitectureComponent> set = this.components;
            synchronized (set) {
                if (this.components.size() < MAX_SIZE_COMPONENTS) {
                    return this.components.add(architectureComponent);
                }
            }
        }
        return false;
    }

    @o
    public Collection<ArchitectureComponentDTM> getComponentDTMCollection() {
        return this.getComponentDTMCollection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ArchitectureComponentDTM> getComponentDTMCollection(boolean bl2) {
        Set<ArchitectureComponent> set = this.components;
        synchronized (set) {
            List<ArchitectureComponentDTM> list = Collections.unmodifiableList(this.components.stream().map(ArchitectureComponent::toDTM).collect(Collectors.toList()));
            if (bl2) {
                this.components.clear();
            }
            return list;
        }
    }

    @o
    public Collection<ArchitectureComponentDTM> prepareComponentsForReporting() {
        return this.getComponentDTMCollection(true);
    }

    private ApplicationArchitecture() {
    }
}

