/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.debugging;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.util.n;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.ArrayUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.management.MBeanServer;

@DontObfuscate
public final class DebugUtils {
    public static void printThreadDump(PrintStream printStream) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(true, true);
        FullStackTracePrinter fullStackTracePrinter = new FullStackTracePrinter();
        long[] lArray = threadMXBean.findMonitorDeadlockedThreads();
        long[] lArray2 = threadMXBean.findDeadlockedThreads();
        printStream.println("Begin Printing Thread Dump...");
        for (ThreadInfo threadInfo : threadInfoArray) {
            if (ArrayUtils.contains(lArray, threadInfo.getThreadId())) {
                printStream.println("Monitor deadlock in thread with id: " + threadInfo.getThreadId());
            } else if (ArrayUtils.contains(lArray2, threadInfo.getThreadId())) {
                printStream.println("Deadlock in thread with id: " + threadInfo.getThreadId());
            }
            printStream.print(threadInfo);
            fullStackTracePrinter.setStackTrace(threadInfo.getStackTrace());
            fullStackTracePrinter.printStackTrace(printStream);
            printStream.println("\n");
        }
        printStream.println("Finished Printing Thread Dump.");
    }

    @ScopedSensor
    public static boolean dumpHeap(File file) {
        ScopeAggregator scopeAggregator = ContrastContext.current().scopeProvider().enterScope();
        try {
            if (!file.isDirectory() || !n.b(file)) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " must be a valid, accessible directory.");
            }
            try {
                File file2;
                Object object;
                try {
                    object = (String)Class.forName("com.ibm.jvm.Dump").getMethod("heapDumpToFile", new Class[0]).invoke(null, new Object[0]);
                    file2 = new File((String)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                    Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                    Object obj = ManagementFactory.newPlatformMXBeanProxy(mBeanServer, "com.sun.management:type=HotSpotDiagnostic", clazz);
                    file2 = new File("heapdump." + System.currentTimeMillis() + ".hprof");
                    clazz.getMethod("dumpHeap", String.class, Boolean.TYPE).invoke(obj, file2.getName(), true);
                    System.err.println("Dumped heap to: " + file2.getAbsolutePath());
                }
                object = new File(file, file2.getName());
                Files.move(file2.toPath(), ((File)object).toPath(), StandardCopyOption.REPLACE_EXISTING);
                System.err.println("Moved heap dump to: " + ((File)object).getAbsolutePath());
                scopeAggregator.leaveScope();
                return true;
            }
            catch (IOException | ReflectiveOperationException exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                System.err.println("Failed to capture heap dump.");
                exception2.printStackTrace(System.err);
                scopeAggregator.leaveScope();
                return false;
            }
        }
        catch (Throwable throwable) {
            scopeAggregator.leaveScope();
            throw throwable;
        }
    }

    private DebugUtils() {
    }

    @DontObfuscate
    public static final class FullStackTracePrinter
    extends Throwable {
    }
}

