/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.j2ee;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MemoryBuffer;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.J2EEClassCache;
import com.contrastsecurity.agent.pool.ObjectPool;
import com.contrastsecurity.agent.reflection.a;
import com.contrastsecurity.thirdparty.org.apache.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

@DontObfuscate
public class J2EEHttpResponse
extends HttpResponse
implements ContrastHttpServletResponseModel {
    private Object output = null;
    private final WeakReference<Object> response;
    private final J2EEClassCache classCache;
    private static boolean HONORS_SOS_ENCODING;
    private static boolean HONORS_LINE_SEPARATOR_IN_PRINTWRITER;
    private static boolean HONORS_LINE_SEPARATOR_IN_SERVLETOUTPUTSTREAM;
    private static final Logger logger;

    public J2EEHttpResponse(String string, J2EEClassCache j2EEClassCache, Object object, ObjectPool<MemoryBuffer> objectPool) {
        super(objectPool);
        this.response = new WeakReference<Object>(object);
        this.classCache = j2EEClassCache;
        if (!StringUtils.isEmpty(string)) {
            try {
                logger.debug("Detected server version to be: {}", (Object)string);
                boolean bl2 = this.isTomcat4Through6(string);
                HONORS_LINE_SEPARATOR_IN_PRINTWRITER = this.honorsLineSeparatorInPrintWriter(string, bl2);
                HONORS_LINE_SEPARATOR_IN_SERVLETOUTPUTSTREAM = this.honorsLineSeparatorInOutputStream(string, bl2);
                HONORS_SOS_ENCODING = this.honorsServletOutputStreamEncoding(string);
            }
            catch (RuntimeException runtimeException) {
                Throwables.throwIfCritical(runtimeException);
                RuntimeException runtimeException2 = runtimeException;
                logger.debug("Problem analyzing server version for traints", runtimeException2);
            }
            if (!HONORS_LINE_SEPARATOR_IN_PRINTWRITER) {
                logger.debug("Container doesn't respect line separator - forcing to \\r\\n");
            } else {
                logger.debug("Container respects line separators");
            }
            if (!HONORS_SOS_ENCODING) {
                logger.debug("Container doesn't respect ServletResponse.setCharacterEncoding() on ServletOutputStream - autocorrecting.");
            } else {
                logger.debug("Container respects ServletResponse.setCharacterEncoding() on ServletOutputStream.");
            }
        }
    }

    @Override
    public Object getOutputMechanism() {
        return this.output;
    }

    public void setOutput(Object object) {
        this.output = object;
    }

    @Override
    public int getStatus() {
        return J2EEHttpResponse.reflectStatus(this.response.get(), this.classCache);
    }

    @Override
    public String frameworkContentType() {
        return J2EEHttpResponse.reflectContentType(this.response.get());
    }

    @Override
    public String frameworkCharacterEncoding() {
        return J2EEHttpResponse.reflectCharacterEncoding(this.response.get(), this.classCache);
    }

    @Override
    public ContrastReplacedResponseChunkModel println() {
        if (this.output == null) {
            return super.println();
        }
        if (this.output instanceof PrintWriter) {
            if (HONORS_LINE_SEPARATOR_IN_PRINTWRITER) {
                return super.println();
            }
            return super.print("\r\n");
        }
        if (HONORS_LINE_SEPARATOR_IN_SERVLETOUTPUTSTREAM) {
            return super.println();
        }
        return super.print("\r\n");
    }

    @Override
    public ContrastReplacedResponseChunkModel print(String string) {
        if (this.output == null) {
            return super.print(string);
        }
        if (this.output instanceof PrintWriter || HONORS_SOS_ENCODING) {
            return super.print(string);
        }
        if (string != null) {
            return this.write(string.getBytes());
        }
        return null;
    }

    private boolean honorsLineSeparatorInPrintWriter(String string, boolean bl2) {
        return !bl2 && !this.isJBossWeb(string) && !this.isWebLogic10or11(string);
    }

    private boolean isWebLogic10or11(String string) {
        return string.startsWith("WebLogic Server 10.3") || string.startsWith("WebLogic Server 11");
    }

    private boolean honorsLineSeparatorInOutputStream(String string, boolean bl2) {
        return !bl2 && !this.isJBossWeb(string);
    }

    private boolean honorsServletOutputStreamEncoding(String string) {
        return this.isJetty9(string) || this.isTomcat5(string) || this.isWebLogic(string);
    }

    private boolean isWebLogic(String string) {
        return string.startsWith("WebLogic");
    }

    private boolean isJetty9(String string) {
        return string.startsWith("jetty/9");
    }

    private boolean isJBossWeb(String string) {
        return string.startsWith("JBoss Web") || string.startsWith("JBossWeb");
    }

    private boolean isTomcat5(String string) {
        return string.startsWith("Apache Tomcat/5");
    }

    private boolean isTomcat4Through6(String string) {
        if (!string.startsWith("Apache Tomcat/")) {
            return false;
        }
        try {
            String string2 = string.substring(string.indexOf(47) + 1);
            return string2.startsWith("4.") || string2.startsWith("5.") || string2.startsWith("6.");
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem looking at HTTP version {}", (Object)string);
            return false;
        }
    }

    @Override
    public void enterWritingScope(Object object) {
        if (this.isOutputWriter(object)) {
            super.enterWritingScope(object);
        }
    }

    @Override
    public void leaveWritingScope(Object object) {
        if (this.isOutputWriter(object)) {
            super.leaveWritingScope(object);
        }
    }

    public boolean isOutputWriter(Object object) {
        return this.output == object;
    }

    private static String reflectCharacterEncoding(Object object, J2EEClassCache j2EEClassCache) {
        Method method;
        if (object == null || j2EEClassCache == null) {
            return null;
        }
        try {
            method = j2EEClassCache.getCharacterEncodingMethod(object.getClass());
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.debug("Problem reading response character encoding", exception2);
            return null;
        }
        if (method == null) {
            logger.debug("getCharacterEncoding not found");
            return null;
        }
        Object object2 = a.a(method, object, Empty.OBJ_ARRAY);
        if (!(object2 instanceof String)) {
            return null;
        }
        return (String)object2;
    }

    private static String reflectContentType(Object object) {
        if (object == null) {
            return null;
        }
        Method method = a.a(object.getClass(), "getContentType", new Class[0]);
        if (method == null) {
            logger.debug("getContentType method not found");
            return null;
        }
        Object object2 = a.a(method, object, Empty.OBJ_ARRAY);
        if (!(object2 instanceof String)) {
            return null;
        }
        return (String)object2;
    }

    private static int reflectStatus(Object object, J2EEClassCache j2EEClassCache) {
        if (object == null || j2EEClassCache == null) {
            return -1;
        }
        int n2 = -1;
        try {
            Method method = j2EEClassCache.getStatusMethod(object.getClass());
            if (method != null) {
                n2 = (Integer)method.invoke(object, Empty.OBJ_ARRAY);
                if (n2 == 0) {
                    n2 = 200;
                }
            } else {
                n2 = j2EEClassCache.getWrappedStatus(object);
            }
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            logger.error("Problem reading response status code", exception2);
        }
        return n2;
    }

    static {
        HONORS_LINE_SEPARATOR_IN_PRINTWRITER = true;
        HONORS_LINE_SEPARATOR_IN_SERVLETOUTPUTSTREAM = true;
        logger = LoggerFactory.getLogger(J2EEHttpResponse.class);
    }
}

