/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.sql;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Lists;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.e;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.plugins.architecture.controller.ArchitectureComponentReporter;
import com.contrastsecurity.agent.plugins.architecture.controller.a;
import com.contrastsecurity.agent.plugins.architecture.controller.b;
import com.contrastsecurity.agent.plugins.architecture.controller.c;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.plugins.frameworks.sql.DbInfo;
import com.contrastsecurity.agent.plugins.frameworks.sql.SqlDatabaseInfoCache;
import com.contrastsecurity.agent.plugins.i;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;

@DontObfuscate
@m
public final class ContrastSqlDispatcherImpl
implements ContrastSqlDispatcher {
    private final List<c> statementListeners;
    private final ScopeProvider scopeProvider;
    private final ArchitectureComponentReporter reporter;
    private final e config;
    private final SqlDatabaseInfoCache sqlDatabaseInfoCache;
    private static final Logger logger = LoggerFactory.getLogger(ContrastSqlDispatcherImpl.class);

    ContrastSqlDispatcherImpl(i i2, ScopeProvider scopeProvider, ArchitectureComponentReporter architectureComponentReporter, e e2, SqlDatabaseInfoCache sqlDatabaseInfoCache) {
        this.statementListeners = Lists.of(new a(e2), new b(i2));
        this.scopeProvider = scopeProvider;
        this.reporter = architectureComponentReporter;
        this.config = e2;
        this.sqlDatabaseInfoCache = sqlDatabaseInfoCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSqlStatementExecuting(Object object, Class<?> clazz, Object[] objectArray) {
        Application application = ContrastContext.current().application().current();
        if (application == null) {
            return;
        }
        this.reportArchitectureComponent(application, object);
        ScopeAggregator scopeAggregator = this.scopeProvider.enterScope();
        try {
            for (c c2 : this.statementListeners) {
                c2.a(application, clazz, objectArray);
            }
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            logger.error("Problem issuing SQL event to listener", throwable2);
        }
        finally {
            scopeAggregator.leaveScope();
        }
    }

    private void reportArchitectureComponent(Application application, Object object) {
        Connection connection;
        if (!com.contrastsecurity.agent.apps.e.a(this.config, ConfigProperty.DBINSPECTION) || !(object instanceof Statement)) {
            return;
        }
        try {
            connection = ((Statement)object).getConnection();
        }
        catch (SQLException sQLException) {
            logger.debug("Failed to extract SQL connection from Statement", sQLException);
            return;
        }
        catch (RuntimeException runtimeException) {
            Throwables.throwIfCritical(runtimeException);
            RuntimeException runtimeException2 = runtimeException;
            logger.debug("Failed to extract SQL connection from Statement", runtimeException2);
            return;
        }
        if (connection == null) {
            logger.debug("Obtained a null connection from java.sql.Statement of type {}", (Object)object.getClass());
            return;
        }
        DbInfo dbInfo = this.sqlDatabaseInfoCache.get(connection);
        if (dbInfo == null) {
            logger.debug("Found undetected DB connection of type {} in use", (Object)connection.getClass());
            return;
        }
        String string = dbInfo.host();
        string = string == null && "mem".equals(dbInfo.subtype()) ? "In Memory (alias): " + dbInfo.name() : "In Memory (alias): localhost";
        String string2 = dbInfo.port() == null ? "(unknown)" : String.valueOf(dbInfo.port());
        String string3 = dbInfo.url();
        ArchitectureComponent architectureComponent = ArchitectureComponent.databaseFrom(string3, string, string2);
        if (architectureComponent == null) {
            logger.debug("Cannot profile the database because we were unable to identify the architecture component: {}", (Object)string3);
            return;
        }
        this.reporter.report(application, architectureComponent);
    }

    public void connect(Object object, String string, Object object2) {
        if (com.contrastsecurity.agent.apps.e.a(this.config, ConfigProperty.DBINSPECTION) || this.config.getBoolean(ConfigProperty.OBSERVE_ENABLE)) {
            Properties properties = object2 instanceof Properties ? (Properties)object2 : null;
            this.sqlDatabaseInfoCache.computeIfAbsent((Connection)object, string, properties);
        }
    }
}

